/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.surfaces;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.util.ArrayList;
import org.opensha.commons.data.Container2DImpl;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.Surface3D;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.surfaces.FaultSectionActorList;
import org.scec.vtk.commons.opensha.surfaces.GeometryGenerator;
import vtk.vtkActor;

public class PolygonSurfaceGenerator
extends GeometryGenerator
implements ParameterChangeListener {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "Polygons";
    ParameterList faultDisplayParams = new ParameterList();
    public static final String OPACITY_PARAM_NAME = "Surface Opacity";
    private static final double OPACITY_DEFAULT = 1.0;
    private static final double OPACITY_MIN = 0.0;
    private static final double OPACITY_MAX = 1.0;
    private DoubleParameter opacityParam = new DoubleParameter("Surface Opacity", 0.0, 1.0);

    public PolygonSurfaceGenerator() {
        super(NAME);
        this.opacityParam.setDefaultValue((Object)1.0);
        this.opacityParam.setValue(1.0);
        this.opacityParam.addParameterChangeListener((ParameterChangeListener)this);
        this.faultDisplayParams.addParameter((Parameter)this.opacityParam);
    }

    public void setOpacity(double opacity) {
        this.opacityParam.setValue(opacity);
    }

    @Override
    public FaultSectionActorList createFaultActors(Surface3D surface, Color color, AbstractFaultSection fault) {
        if (surface instanceof CompoundSurface) {
            return this.handleCompound((CompoundSurface)surface, color, fault);
        }
        if (surface instanceof EvenlyGriddedSurface) {
            return this.createFaultActors((EvenlyGriddedSurface)surface, color, fault);
        }
        LocationList outline = surface.getPerimeter();
        ArrayList<GeometryGenerator.PointArray> polygons = new ArrayList<GeometryGenerator.PointArray>();
        double[][] points = new double[outline.size()][];
        for (int i = 0; i < outline.size(); ++i) {
            Location loc = (Location)outline.get(i);
            points[i] = PolygonSurfaceGenerator.getPointForLoc(loc);
        }
        polygons.add(new GeometryGenerator.PointArray(points));
        return this.createFaultActors(GeometryGenerator.GeometryType.POLYGON, polygons, color, (Double)this.opacityParam.getValue(), fault);
    }

    public vtkActor buildSimplePolygon(LocationList outline, Color color) {
        FaultSectionActorList list = this.buildSimplePolygon(outline, color, null);
        Preconditions.checkState((list.size() == 1 ? 1 : 0) != 0, (String)"unexpected size: %s", (int)list.size());
        return (vtkActor)list.get(0);
    }

    public FaultSectionActorList buildSimplePolygon(LocationList outline, Color color, AbstractFaultSection sect) {
        ArrayList<GeometryGenerator.PointArray> polygons = new ArrayList<GeometryGenerator.PointArray>();
        double[][] points = new double[outline.size()][];
        for (int i = 0; i < outline.size(); ++i) {
            Location loc = (Location)outline.get(i);
            points[i] = PolygonSurfaceGenerator.getPointForLoc(loc);
        }
        polygons.add(new GeometryGenerator.PointArray(points));
        FaultSectionActorList actors = this.createFaultActors(GeometryGenerator.GeometryType.POLYGON, polygons, color, (Double)this.opacityParam.getValue(), sect);
        return actors;
    }

    public FaultSectionActorList createFaultActors(EvenlyGriddedSurface surface, Color color, AbstractFaultSection fault) {
        int cols = surface.getNumCols();
        int rows = surface.getNumRows();
        Container2DImpl<double[]> pointSurface = PolygonSurfaceGenerator.cacheSurfacePoints(surface);
        ArrayList<GeometryGenerator.PointArray> polygons = new ArrayList<GeometryGenerator.PointArray>();
        for (int row = 0; row < rows - 1; ++row) {
            for (int col = 0; col < cols - 1; ++col) {
                double[] pt0 = (double[])pointSurface.get(row, col);
                double[] pt1 = (double[])pointSurface.get(row + 1, col);
                double[] pt2 = (double[])pointSurface.get(row + 1, col + 1);
                double[] pt3 = (double[])pointSurface.get(row, col + 1);
                GeometryGenerator.PointArray polygon = new GeometryGenerator.PointArray(pt0, pt3, pt2, pt1);
                polygons.add(polygon);
            }
        }
        return this.createFaultActors(GeometryGenerator.GeometryType.POLYGON, polygons, color, (Double)this.opacityParam.getValue(), fault);
    }

    @Override
    public ParameterList getDisplayParams() {
        return this.faultDisplayParams;
    }

    public void parameterChange(ParameterChangeEvent event) {
        if (event.getSource() == this.opacityParam) {
            this.firePlotSettingsChangeEvent();
        }
    }
}

