/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.surfaces.params;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.editor.AbstractParameterEditor;
import org.scec.vtk.commons.opensha.surfaces.params.ColorParameter;
import org.scec.vtk.plugins.utils.components.ColorWellButton;
import org.scec.vtk.plugins.utils.components.SingleColorChooser;

public class ColorParameterEditor
extends AbstractParameterEditor<Color>
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private ColorWellButton colorButton;
    private SingleColorChooser colorChooser;

    public ColorParameterEditor(ColorParameter colorParam) {
        super((Parameter)colorParam);
        this.getColorButton();
        this.colorButton.addActionListener(this);
    }

    private ColorWellButton getColorButton() {
        if (this.colorButton == null) {
            this.colorButton = new ColorWellButton(Color.GRAY, 80, 20);
        }
        return this.colorButton;
    }

    public void setEnabled(boolean isEnabled) {
        this.colorButton.setEnabled(isEnabled);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.colorButton) {
            Color newColor;
            if (this.colorChooser == null) {
                this.colorChooser = new SingleColorChooser((Component)((Object)this));
            }
            if ((newColor = this.colorChooser.getColor()) != null) {
                this.setValue(newColor);
                this.colorButton.setColor(newColor);
            }
        }
    }

    public boolean isParameterSupported(Parameter<Color> param) {
        return param != null;
    }

    protected JComponent buildWidget() {
        ColorWellButton button = this.getColorButton();
        button.setColor((Color)this.getParameter().getValue());
        return this.getColorButton();
    }

    protected JComponent updateWidget() {
        return this.buildWidget();
    }
}

