/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.tree;

import java.awt.Color;
import java.util.Objects;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.tree.AbstractFaultNode;
import org.scec.vtk.commons.opensha.tree.events.ColorChangeListener;
import org.scec.vtk.commons.opensha.tree.events.VisibilityChangeListener;

public class FaultSectionNode
extends AbstractFaultNode {
    private ColorChangeListener colorChangeListener;
    private VisibilityChangeListener visibilityChangeListener;
    private static final long serialVersionUID = 1L;
    private AbstractFaultSection fault;

    public FaultSectionNode(AbstractFaultSection fault) {
        super(fault);
        this.fault = fault;
    }

    public String getName() {
        return this.fault.getName();
    }

    @Override
    public String getInfo() {
        return this.fault.getInfoHTML();
    }

    public AbstractFaultSection getFault() {
        return this.fault;
    }

    public void setColorChangeListener(ColorChangeListener colorChangeListener) {
        this.colorChangeListener = colorChangeListener;
    }

    public void setVisibilityChangeListener(VisibilityChangeListener visibilityChangeListener) {
        this.visibilityChangeListener = visibilityChangeListener;
    }

    @Override
    public void setColor(Color color) {
        super.setColor(color);
        if (this.colorChangeListener != null && Objects.equals(color, this.getColor())) {
            this.colorChangeListener.colorChanged(this.fault, color);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        boolean changed = visible != this.isVisible();
        super.setVisible(visible);
        if (this.visibilityChangeListener != null && changed) {
            this.visibilityChangeListener.visibilityChanged(this.fault, visible);
        }
    }
}

