/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.tree.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.netbeans.swing.outline.RowModel;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.tree.AbstractFaultNode;
import org.scec.vtk.commons.opensha.tree.FaultSectionNode;
import org.scec.vtk.commons.opensha.tree.builders.FaultSectionInfoViewier;
import org.scec.vtk.commons.opensha.tree.events.CustomColorSelectionListener;
import org.scec.vtk.commons.opensha.tree.gui.FaultTreeTable;
import org.scec.vtk.plugins.utils.components.SingleColorChooser;

public class FaultTableRowModel
implements RowModel,
MouseListener {
    private static final String[] colNames = new String[]{"Color", "Visible"};
    private static final Class<?>[] colClasses = new Class[]{Color.class, Boolean.class};
    private CustomColorSelectionListener customColorListener;
    private FaultTreeTable table;
    private JFrame infoFrame;
    private FaultSectionInfoViewier infoViewer;

    public FaultTableRowModel(FaultTreeTable table) {
        this(table, null);
    }

    public FaultTableRowModel(FaultTreeTable table, FaultSectionInfoViewier infoViewer) {
        this.table = table;
        this.infoViewer = infoViewer;
    }

    public Class<?> getColumnClass(int col) {
        return colClasses[col];
    }

    public int getColumnCount() {
        return colNames.length;
    }

    public String getColumnName(int col) {
        return colNames[col];
    }

    public void setCustomColorListener(CustomColorSelectionListener customColorListener) {
        this.customColorListener = customColorListener;
    }

    public Object getValueFor(Object node, int col) {
        AbstractFaultNode fnode = AbstractFaultNode.checkCast(node);
        switch (col) {
            case 0: {
                return fnode.getColor();
            }
            case 1: {
                return fnode.isVisible();
            }
        }
        return null;
    }

    public boolean isCellEditable(Object node, int col) {
        return true;
    }

    public void setValueFor(Object node, int col, Object value) {
        AbstractFaultNode fnode = AbstractFaultNode.checkCast(node);
        if (value instanceof Boolean) {
            fnode.setVisible((Boolean)value);
        } else if (value instanceof Color) {
            fnode.setColor((Color)value);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseevent) {
        int col = this.table.columnAtPoint(mouseevent.getPoint());
        if (this.infoViewer != null && col == 0 && mouseevent.getClickCount() == 2) {
            AbstractFaultSection fault;
            JPanel panel;
            int row = this.table.rowAtPoint(mouseevent.getPoint());
            AbstractFaultNode node = this.table.nodeForRow(row);
            if (node instanceof FaultSectionNode && (panel = this.infoViewer.getInfoPanel(fault = ((FaultSectionNode)node).getFault())) != null) {
                if (this.infoFrame == null) {
                    this.infoFrame = new JFrame();
                    this.infoFrame.getContentPane().setLayout(new BorderLayout());
                }
                this.infoFrame.getContentPane().removeAll();
                this.infoFrame.getContentPane().add((Component)panel, "Center");
                this.infoFrame.pack();
                this.infoFrame.validate();
                this.infoFrame.setVisible(true);
                this.infoFrame.toFront();
            }
        } else if (col == 1) {
            int LastRow = this.table.rowAtPoint(mouseevent.getPoint());
            int rowCount = this.table.getSelectedRowCount();
            int selectedRow = this.table.getSelectedRow();
            SingleColorChooser chooser = new SingleColorChooser((Component)((Object)this.table));
            Color newColor = chooser.getColor();
            if (newColor != null) {
                for (int i = selectedRow; i <= LastRow; ++i) {
                    AbstractFaultNode node = this.table.nodeForRow(i);
                    this.fireCustomColorSelectedEvent();
                    this.table.setValueAt(newColor, i, col);
                    node.setVisible(true);
                }
            }
        }
    }

    private void fireCustomColorSelectedEvent() {
        if (this.customColorListener != null) {
            this.customColorListener.customColorSelected();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseevent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseevent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseevent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseevent) {
    }
}

