/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.tree.gui;

import java.awt.Color;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.netbeans.swing.outline.DefaultOutlineModel;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.OutlineModel;
import org.netbeans.swing.outline.RenderDataProvider;
import org.netbeans.swing.outline.RowModel;
import org.scec.vtk.commons.opensha.tree.AbstractFaultNode;
import org.scec.vtk.commons.opensha.tree.builders.FaultSectionInfoViewier;
import org.scec.vtk.commons.opensha.tree.builders.FaultTreeBuilder;
import org.scec.vtk.commons.opensha.tree.events.TreeChangeListener;
import org.scec.vtk.commons.opensha.tree.gui.ColorIconRenderer;
import org.scec.vtk.commons.opensha.tree.gui.FaultRenderDataProvider;
import org.scec.vtk.commons.opensha.tree.gui.FaultTableRowModel;

public class FaultTreeTable
extends Outline
implements TreeChangeListener {
    private static final long serialVersionUID = 1L;
    private FaultTreeBuilder builder;
    private DefaultTreeModel treeModel;
    private OutlineModel outlineModel;
    private FaultTableRowModel rowModel;
    private ArrayList<TreeChangeListener> treeChangeListeners = new ArrayList();
    private static int colWidth = 50;

    public FaultTreeTable(FaultTreeBuilder builder, FaultSectionInfoViewier infoViewer) {
        this.setRootVisible(false);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        this.builder = builder;
        builder.setTreeChangeListener(this);
        builder.buildTree(root);
        super.setColumnHidingAllowed(false);
        super.setRowSorter(null);
        super.setAutoCreateRowSorter(false);
        super.setRowSelectionAllowed(false);
        super.setColumnSelectionAllowed(false);
        this.treeModel = new DefaultTreeModel(root);
        this.rowModel = new FaultTableRowModel(this, infoViewer);
        boolean isLargeModel = true;
        this.outlineModel = DefaultOutlineModel.createOutlineModel((TreeModel)this.treeModel, (RowModel)this.rowModel, (boolean)isLargeModel);
        super.setModel((TableModel)this.outlineModel);
        super.setDefaultRenderer(Color.class, (TableCellRenderer)new ColorIconRenderer());
        this.getColumnModel().getColumn(1).setPreferredWidth(colWidth);
        this.getColumnModel().getColumn(1).setWidth(colWidth);
        this.getColumnModel().getColumn(1).setMaxWidth(colWidth);
        this.getColumnModel().getColumn(2).setPreferredWidth(colWidth);
        this.getColumnModel().getColumn(2).setWidth(colWidth);
        this.getColumnModel().getColumn(2).setMaxWidth(colWidth);
        super.setRenderDataProvider((RenderDataProvider)new FaultRenderDataProvider());
        super.addMouseListener((MouseListener)this.rowModel);
    }

    public void addTreeChangeListener(TreeChangeListener l) {
        this.treeChangeListeners.add(l);
    }

    public boolean removeTreeChangeListener(TreeChangeListener l) {
        return this.treeChangeListeners.remove(l);
    }

    private void fireTreeChangeEvent(TreeNode root) {
        for (TreeChangeListener l : this.treeChangeListeners) {
            l.treeChanged(root);
        }
    }

    public void rebuildTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        this.fireTreeChangeEvent(root);
        this.treeModel.setRoot(root);
        System.gc();
        this.builder.buildTree(root);
        this.treeModel.setRoot(root);
        this.fireTreeChangeEvent(root);
    }

    public void refreshTreeView() {
        this.treeModel.reload((TreeNode)this.treeModel.getRoot());
    }

    public FaultTableRowModel getRowModel() {
        return this.rowModel;
    }

    public DefaultMutableTreeNode getTreeRoot() {
        return (DefaultMutableTreeNode)this.treeModel.getRoot();
    }

    protected AbstractFaultNode nodeForRow(int row) {
        return AbstractFaultNode.checkCast(this.getModel().getValueAt(row, 0));
    }

    public void toggleSelectedVisibility() {
        int[] indices;
        for (int row : indices = this.getSelectedRows()) {
            this.outlineModel.setValueAt((Object)((Boolean)this.outlineModel.getValueAt(row, 2) == false ? 1 : 0), row, 2);
        }
    }

    public void setColorForSelected(Color color) {
        int[] indices;
        for (int row : indices = this.getSelectedRows()) {
            this.outlineModel.setValueAt((Object)color, row, 1);
        }
    }

    public static void main(String[] args) throws IOException {
    }

    @Override
    public void treeChanged(TreeNode newRoot) {
        this.rebuildTree();
    }
}

