/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.shapes;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.geo.Location;
import org.scec.vtk.tools.Transform;
import vtk.vtkActor;
import vtk.vtkCell;
import vtk.vtkCellArray;
import vtk.vtkLine;
import vtk.vtkMapper;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;

public class Boundary {
    private vtkActor actor;
    private vtkPoints pts;
    private vtkCellArray lines;
    private vtkPolyData polyData;
    private Color color;
    private String name;
    private double lineWidth;
    private double opacity;

    public Boundary() {
        this("", Color.WHITE, 1.0);
    }

    public Boundary(String name, Color color, double lineWidth) {
        this(name, color, null, lineWidth);
    }

    public Boundary(String name, Color color, List<Location> locs, double lineWidth) {
        this.name = name;
        this.color = color;
        this.lineWidth = lineWidth;
        this.opacity = 1.0;
        this.actor = new vtkActor();
        this.pts = new vtkPoints();
        this.lines = new vtkCellArray();
        this.polyData = new vtkPolyData();
        this.polyData.SetPoints(this.pts);
        this.polyData.SetLines(this.lines);
        if (locs != null && !locs.isEmpty()) {
            this.addSegment(locs);
        }
        vtkPolyDataMapper mapper = new vtkPolyDataMapper();
        mapper.SetInputData(this.polyData);
        this.actor.SetMapper((vtkMapper)mapper);
        this.actor.GetProperty().SetColor(Boundary.getColorDoubleArray(color));
        this.actor.GetProperty().SetLineWidth((float)lineWidth);
        this.actor.GetProperty().SetOpacity(this.opacity);
        this.actor.Modified();
    }

    private static double[] getColorDoubleArray(Color color) {
        return new double[]{(double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0};
    }

    public void addSegment(List<Location> locs) {
        this.addSegment(locs, false);
    }

    public void addSegment(List<Location> locs, boolean close) {
        Preconditions.checkArgument((locs.size() > 1 ? 1 : 0) != 0);
        int startIndex = (int)this.pts.GetNumberOfPoints();
        if (close && !locs.get(0).equals((Object)locs.get(locs.size() - 1))) {
            locs = new ArrayList<Location>(locs);
            locs.add(locs.get(0));
        }
        vtkLine line = new vtkLine();
        for (int i = 0; i < locs.size(); ++i) {
            Location loc = locs.get(i);
            double[] pt = Transform.transformLatLonHeight(loc.getLatitude(), loc.getLongitude(), -loc.getDepth());
            this.pts.InsertNextPoint(pt);
            line.GetPointIds().SetId((long)i, (long)(startIndex + i));
        }
        Preconditions.checkState((this.pts.GetNumberOfPoints() - (long)startIndex == (long)locs.size() ? 1 : 0) != 0);
        this.lines.InsertNextCell((vtkCell)line);
        this.lines.Modified();
        this.pts.Modified();
        this.polyData.Modified();
        this.actor.Modified();
    }

    public void setWidth(double width) {
        this.actor.GetProperty().SetLineWidth((float)width);
        this.lineWidth = width;
        this.actor.Modified();
    }

    public double getWidth() {
        return this.lineWidth;
    }

    public void setOpacity(double opacity) {
        this.actor.GetProperty().SetOpacity(opacity);
        this.opacity = opacity;
        this.actor.Modified();
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setColor(Color color) {
        this.actor.GetProperty().SetColor(Boundary.getColorDoubleArray(color));
        this.color = color;
        this.actor.Modified();
    }

    public Color getColor() {
        return this.color;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public vtkActor getActor() {
        return this.actor;
    }
}

