/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.drawingTools;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DisplayAttributes
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -1L;
    protected JPanel textPanel = new JPanel();
    protected JLabel textSizeLabel = new JLabel("Label font Size: ");
    protected JLabel latText = new JLabel("Latitude: ");
    protected JLabel lonText = new JLabel("Longitude: ");
    protected JLabel altText = new JLabel("Altitude: ");
    protected JLabel coneSizeText = new JLabel("Cone pin height: ");
    protected JLabel coneBaseRadiusText = new JLabel("Cone pin base radius: ");
    protected JFormattedTextField fontSizeField;
    protected JFormattedTextField coneHeightField;
    protected JFormattedTextField coneBaseRadiusField;
    protected JFormattedTextField latField;
    protected JFormattedTextField lonField;
    protected JFormattedTextField altField;

    public DisplayAttributes() {
        DecimalFormat formatInt = new DecimalFormat();
        formatInt.setMinimumIntegerDigits(1);
        formatInt.setMaximumFractionDigits(0);
        formatInt.setGroupingUsed(false);
        this.fontSizeField = new JFormattedTextField(formatInt);
        this.fontSizeField.setText("21");
        DecimalFormat formatConeHeight = new DecimalFormat();
        formatConeHeight.setGroupingUsed(false);
        formatConeHeight.setMinimumIntegerDigits(1);
        formatConeHeight.setMaximumIntegerDigits(10);
        this.coneHeightField = new JFormattedTextField(formatConeHeight);
        this.coneHeightField.setText("10");
        DecimalFormat formatConeRadius = new DecimalFormat();
        formatConeRadius.setGroupingUsed(false);
        formatConeRadius.setMinimumIntegerDigits(1);
        formatConeRadius.setMaximumIntegerDigits(10);
        this.coneBaseRadiusField = new JFormattedTextField(formatConeRadius);
        this.coneBaseRadiusField.setText("5");
        DecimalFormat lat = new DecimalFormat();
        lat.setGroupingUsed(false);
        lat.setMinimumIntegerDigits(1);
        lat.setMaximumIntegerDigits(10);
        this.latField = new JFormattedTextField(lat);
        this.latField.setText("37");
        DecimalFormat lon = new DecimalFormat();
        lon.setGroupingUsed(false);
        lon.setMinimumIntegerDigits(1);
        lon.setMaximumIntegerDigits(10);
        this.lonField = new JFormattedTextField(lon);
        this.lonField.setText("-120");
        DecimalFormat alt = new DecimalFormat();
        alt.setGroupingUsed(false);
        alt.setMinimumIntegerDigits(1);
        alt.setMaximumIntegerDigits(10);
        this.altField = new JFormattedTextField(alt);
        this.altField.setText("0");
        this.coneBaseRadiusField.setEnabled(false);
        this.coneHeightField.setEnabled(false);
        this.latField.setEnabled(false);
        this.lonField.setEnabled(false);
        this.altField.setEnabled(false);
        this.fontSizeField.setEnabled(false);
        this.setLayout(new BoxLayout(this, 1));
        JPanel enableLabelPanel = new JPanel();
        enableLabelPanel.setLayout(new BoxLayout(enableLabelPanel, 1));
        JPanel translatePanel = new JPanel();
        translatePanel.setLayout(new BoxLayout(translatePanel, 0));
        translatePanel.add(this.latText);
        translatePanel.add(this.latField);
        translatePanel.add(Box.createHorizontalGlue());
        translatePanel.add(this.lonText);
        translatePanel.add(this.lonField);
        translatePanel.add(Box.createHorizontalGlue());
        translatePanel.add(this.altText);
        translatePanel.add(this.altField);
        translatePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Translate"), BorderFactory.createEmptyBorder(15, 15, 15, 15))));
        JPanel rotatePanel = new JPanel();
        rotatePanel.setLayout(new BoxLayout(rotatePanel, 0));
        rotatePanel.add(Box.createHorizontalGlue());
        rotatePanel.add(this.coneSizeText);
        rotatePanel.add(this.coneHeightField);
        rotatePanel.add(Box.createHorizontalGlue());
        rotatePanel.add(this.coneBaseRadiusText);
        rotatePanel.add(this.coneBaseRadiusField);
        rotatePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Cone properties"), BorderFactory.createEmptyBorder(15, 15, 15, 15))));
        JPanel textSettingPanel = new JPanel();
        textSettingPanel.setLayout(new BoxLayout(textSettingPanel, 0));
        textSettingPanel.add(Box.createHorizontalGlue());
        textSettingPanel.add(this.textSizeLabel);
        textSettingPanel.add(this.fontSizeField);
        textSettingPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Label properties"), BorderFactory.createEmptyBorder(15, 15, 15, 15))));
        JPanel labelPropertiesPanel = new JPanel();
        labelPropertiesPanel.setLayout(new BoxLayout(labelPropertiesPanel, 1));
        labelPropertiesPanel.add(translatePanel);
        labelPropertiesPanel.add(rotatePanel);
        labelPropertiesPanel.add(textSettingPanel);
        this.add(enableLabelPanel);
        this.add(labelPropertiesPanel);
        this.fontSizeField.setPreferredSize(new Dimension(40, 20));
        this.fontSizeField.setMaximumSize(new Dimension(40, 20));
        this.latField.setPreferredSize(new Dimension(40, 20));
        this.latField.setMaximumSize(new Dimension(40, 20));
        this.lonField.setPreferredSize(new Dimension(40, 20));
        this.lonField.setMaximumSize(new Dimension(40, 20));
        this.altField.setPreferredSize(new Dimension(40, 20));
        this.altField.setMaximumSize(new Dimension(40, 20));
        this.coneHeightField.setPreferredSize(new Dimension(40, 20));
        this.coneHeightField.setMaximumSize(new Dimension(40, 20));
        this.coneBaseRadiusField.setPreferredSize(new Dimension(40, 20));
        this.coneBaseRadiusField.setMaximumSize(new Dimension(40, 20));
    }

    public String getTextSize() {
        String fontSize;
        try {
            int fontTempSize = Integer.parseInt(this.fontSizeField.getText());
            if (fontTempSize <= 0) {
                throw new NumberFormatException();
            }
            fontSize = this.fontSizeField.getText();
        }
        catch (NumberFormatException nfe) {
            this.fontSizeField.setText("21");
            fontSize = "21";
        }
        return fontSize;
    }

    public void setTextSize(String fontSize) {
        this.fontSizeField.setText(fontSize);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
    }
}

