/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.drawingTools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.scec.vtk.drawingTools.DisplayAttributes;
import org.scec.vtk.drawingTools.DrawingTool;
import org.scec.vtk.drawingTools.DrawingToolsTable;
import org.scec.vtk.drawingTools.DrawingToolsTableModel;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.PluginActors;
import org.scec.vtk.plugins.utils.components.AddButton;
import org.scec.vtk.plugins.utils.components.ColorButton;
import org.scec.vtk.plugins.utils.components.EditButton;
import org.scec.vtk.plugins.utils.components.RemoveButton;
import org.scec.vtk.plugins.utils.components.ShowButton;
import org.scec.vtk.plugins.utils.components.SingleColorChooser;
import org.scec.vtk.tools.Prefs;
import org.scec.vtk.tools.Transform;
import org.scec.vtk.tools.actors.AppendActors;
import vtk.vtkAbstractArray;
import vtk.vtkActor;
import vtk.vtkActor2D;
import vtk.vtkConeSource;
import vtk.vtkDataObject;
import vtk.vtkGlyph3D;
import vtk.vtkLabelPlacementMapper;
import vtk.vtkMapper;
import vtk.vtkMapper2D;
import vtk.vtkPointSetToLabelHierarchy;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;
import vtk.vtkStringArray;

public class DrawingToolsGUI
extends JPanel
implements ActionListener,
ListSelectionListener,
TableModelListener {
    private static final long serialVersionUID = 1L;
    private JPanel drawingToolSubPanelLower;
    private ShowButton showDrawingToolsButton;
    private ColorButton colorDrawingToolsButton;
    private SingleColorChooser colorChooser;
    private AddButton addDrawingToolsButton;
    private RemoveButton remDrawingToolsButton;
    private DrawingToolsTable drawingToolTable;
    private DrawingToolsTable highwayToolTable;
    private EditButton editDrawingToolsButton;
    private DisplayAttributes displayAttributes;
    private JPanel drawingToolSubPanelLowest;
    AppendActors appendActors = new AppendActors();
    private int numText = 0;
    private Vector<DrawingTool> drawingToolsArray;

    public DrawingToolsGUI(PluginActors pluginActors) {
        pluginActors.addActor((vtkProp)this.appendActors.getAppendedActor());
        this.setLayout(new BoxLayout(this, 3));
        this.setPreferredSize(new Dimension(Prefs.getPluginWidth(), Prefs.getPluginHeight()));
        this.setName("Drawing Tools");
        this.drawingToolTable = new DrawingToolsTable(this);
        this.highwayToolTable = new DrawingToolsTable(this);
        JScrollPane drawingToolSubPanelUpper = new JScrollPane();
        drawingToolSubPanelUpper.setHorizontalScrollBarPolicy(31);
        drawingToolSubPanelUpper.setVerticalScrollBarPolicy(22);
        drawingToolSubPanelUpper.setPreferredSize(new Dimension(200, 100));
        this.displayAttributes = new DisplayAttributes();
        this.displayAttributes.latField.addActionListener(this);
        this.displayAttributes.lonField.addActionListener(this);
        this.displayAttributes.altField.addActionListener(this);
        this.displayAttributes.coneHeightField.addActionListener(this);
        this.displayAttributes.coneBaseRadiusField.addActionListener(this);
        this.displayAttributes.fontSizeField.addActionListener(this);
        JPanel displayPanel = new JPanel();
        displayPanel.setLayout(new BoxLayout(displayPanel, 1));
        displayPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.drawingToolSubPanelLowest = new JPanel(new BorderLayout(0, 0));
        this.drawingToolSubPanelLowest.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.drawingToolSubPanelLowest.add(this.displayAttributes);
        displayPanel.add(this.getDrawingToolLibraryPanel());
        displayPanel.add(this.drawingToolSubPanelLowest);
        this.add(displayPanel);
        this.drawingToolsArray = new Vector();
        this.drawingToolTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DrawingTool dr;
                int i;
                DrawingToolsTable target;
                if (e.getClickCount() == 1) {
                    target = (DrawingToolsTable)e.getSource();
                    i = target.getSelectedRow();
                    dr = DrawingToolsGUI.this.drawingToolsArray.get(i);
                    DrawingToolsGUI.this.displayAttributes.latField.setText(dr.getAttributes().get("Lat"));
                    DrawingToolsGUI.this.displayAttributes.lonField.setText(dr.getAttributes().get("Lon"));
                    DrawingToolsGUI.this.displayAttributes.altField.setText(dr.getAttributes().get("Alt"));
                    DrawingToolsGUI.this.displayAttributes.coneHeightField.setText(dr.getAttributes().get("pinH"));
                    DrawingToolsGUI.this.displayAttributes.coneBaseRadiusField.setText(dr.getAttributes().get("pinR"));
                    DrawingToolsGUI.this.displayAttributes.fontSizeField.setText(dr.getAttributes().get("fontSize"));
                }
                if (e.getClickCount() == 2) {
                    target = (DrawingToolsTable)e.getSource();
                    i = target.getSelectedRow();
                    dr = DrawingToolsGUI.this.drawingToolsArray.get(i);
                    vtkProp actor = dr.getActorText();
                    vtkProp actorPin = dr.getActorPin();
                    double[] rbg = ((vtkActor)actorPin).GetProperty().GetColor();
                    if (actor != null) {
                        if (rbg[0] == 1.0 && rbg[1] == 1.0 && rbg[2] == 0.0) {
                            ((vtkActor)actorPin).GetProperty().SetColor(1.0, 1.0, 1.0);
                            ((vtkPointSetToLabelHierarchy)((vtkActor2D)actor).GetMapper().GetInputAlgorithm()).GetTextProperty().SetColor(1.0, 1.0, 1.0);
                        } else {
                            ((vtkActor)actorPin).GetProperty().SetColor(1.0, 1.0, 0.0);
                            ((vtkPointSetToLabelHierarchy)((vtkActor2D)actor).GetMapper().GetInputAlgorithm()).GetTextProperty().SetColor(1.0, 1.0, 0.0);
                        }
                    }
                    MainGUI.updateRenderWindow();
                }
                if (e.getClickCount() == 3) {
                    DrawingToolsGUI.this.runObjectInfoDialog();
                }
            }
        });
    }

    public DrawingToolsTable getDrawingToolTable() {
        return this.drawingToolTable;
    }

    public AppendActors getDrawingToolActors() {
        return this.appendActors;
    }

    public Vector<DrawingTool> getDrawingToolArray() {
        return this.drawingToolsArray;
    }

    private JPanel getDrawingToolLibraryPanel() {
        this.drawingToolSubPanelLower = new JPanel();
        this.drawingToolSubPanelLower.setLayout(new BoxLayout(this.drawingToolSubPanelLower, 3));
        this.drawingToolSubPanelLower.setName("Library");
        this.drawingToolSubPanelLower.setOpaque(false);
        JScrollPane scroller = new JScrollPane();
        scroller.setHorizontalScrollBarPolicy(31);
        scroller.setVerticalScrollBarPolicy(22);
        scroller.setPreferredSize(new Dimension(Prefs.getPluginWidth() - 10, 200));
        scroller.setViewportView(this.drawingToolTable);
        scroller.getViewport().setBackground(this.drawingToolTable.getBackground());
        this.drawingToolSubPanelLower.add(new JLabel("Drawings"));
        this.drawingToolSubPanelLower.add(scroller);
        this.drawingToolSubPanelLower.add((Component)this.getDrawingToolLibraryBar(), "Last");
        return this.drawingToolSubPanelLower;
    }

    private JPanel getDrawingToolLibraryBar() {
        this.showDrawingToolsButton = new ShowButton(this, "Toggle visibility of selected Text");
        this.colorDrawingToolsButton = new ColorButton(this, "Change color of selected Text");
        this.editDrawingToolsButton = new EditButton(this, "Edit Text");
        this.addDrawingToolsButton = new AddButton(this, "Add new Text");
        this.remDrawingToolsButton = new RemoveButton(this, "Remove selected Text");
        JPanel bar = new JPanel();
        bar.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        bar.setLayout(new BoxLayout(bar, 2));
        bar.setOpaque(true);
        int buttonSpace = 3;
        bar.add(this.showDrawingToolsButton);
        bar.add(Box.createHorizontalStrut(buttonSpace));
        bar.add(this.colorDrawingToolsButton);
        bar.add(Box.createHorizontalStrut(buttonSpace));
        bar.add(this.editDrawingToolsButton);
        bar.add(Box.createHorizontalGlue());
        bar.add(Box.createHorizontalStrut(buttonSpace));
        bar.add(Box.createHorizontalGlue());
        bar.add(this.addDrawingToolsButton);
        bar.add(Box.createHorizontalStrut(buttonSpace));
        bar.add(this.remDrawingToolsButton);
        return bar;
    }

    public DrawingTool addDrawingTool(DrawingTool drawingTool, String text) {
        double[] pt = new double[]{Transform.calcRadius(37.0), 37.0, -120.0};
        if (drawingTool.getTextString() != null) {
            text = drawingTool.getTextString();
            drawingTool.setDisplayName(drawingTool.getTextString());
            pt[0] = pt[0] + drawingTool.getaltitude();
            pt[1] = drawingTool.getLatitude();
            pt[2] = drawingTool.getLongitude();
        }
        vtkStringArray labels = new vtkStringArray();
        labels.SetName("labels");
        labels.SetNumberOfValues(1L);
        labels.SetValue(0L, text);
        vtkPoints labelPoints = new vtkPoints();
        labelPoints.InsertNextPoint(Transform.customTransform(pt));
        vtkPolyData pinPolydata = new vtkPolyData();
        pinPolydata.SetPoints(labelPoints);
        vtkConeSource conePin = new vtkConeSource();
        conePin.SetRadius(5.0);
        conePin.SetHeight(10.0);
        conePin.SetDirection(-Transform.customTransform(pt)[0], -Transform.customTransform(pt)[1], -Transform.customTransform(pt)[2]);
        conePin.SetResolution(10);
        vtkGlyph3D glyphPoints = new vtkGlyph3D();
        glyphPoints.SetInputData((vtkDataObject)pinPolydata);
        glyphPoints.SetSourceConnection(conePin.GetOutputPort());
        vtkPolyDataMapper pm = new vtkPolyDataMapper();
        pm.SetInputConnection(glyphPoints.GetOutputPort());
        vtkPolyData temp = new vtkPolyData();
        temp.SetPoints(labelPoints);
        temp.GetPointData().AddArray((vtkAbstractArray)labels);
        vtkPointSetToLabelHierarchy pointSetToLabelHierarchyFilter = new vtkPointSetToLabelHierarchy();
        pointSetToLabelHierarchyFilter.SetInputData((vtkDataObject)temp);
        pointSetToLabelHierarchyFilter.GetTextProperty().SetJustificationToLeft();
        pointSetToLabelHierarchyFilter.SetLabelArrayName("labels");
        pointSetToLabelHierarchyFilter.Update();
        pointSetToLabelHierarchyFilter.GetTextProperty().SetFontSize(21);
        vtkLabelPlacementMapper cellMapper = new vtkLabelPlacementMapper();
        cellMapper.SetInputConnection(pointSetToLabelHierarchyFilter.GetOutputPort());
        vtkActor2D actor = new vtkActor2D();
        actor.SetMapper((vtkMapper2D)cellMapper);
        vtkActor actorPin = new vtkActor();
        actorPin.SetMapper((vtkMapper)pm);
        if (drawingTool.getTextString() == null) {
            drawingTool = new DrawingTool(pt[1], pt[2], pt[0], text, null, Color.white, actorPin, actor);
            drawingTool.setDisplayName(text + " (" + this.numText++ + ")");
        } else {
            drawingTool.setActors(actorPin, actor);
        }
        this.appendActors.addToAppendedPolyData((vtkProp)actorPin);
        this.appendActors.addToAppendedPolyData((vtkProp)actor);
        this.appendActors.getAppendedActor().Modified();
        HashMap<String, String> locData = new HashMap<String, String>();
        locData.put("Lat", String.format("%.1f", pt[1]));
        locData.put("Lon", String.format("%.1f", pt[2]));
        locData.put("Alt", "0");
        locData.put("pinH", "10");
        locData.put("pinR", "5");
        locData.put("fontSize", "21");
        drawingTool.setAttributes(locData);
        this.drawingToolsArray.add(drawingTool);
        return drawingTool;
    }

    public void setVisibility(DrawingTool dr, Integer visible) {
        vtkActor2D actor = (vtkActor2D)dr.getActorText();
        vtkActor actorPin = (vtkActor)dr.getActorPin();
        if (actor != null && actorPin != null) {
            actor.SetVisibility(visible.intValue());
            actorPin.SetVisibility(visible.intValue());
        } else if (actorPin != null && actor == null) {
            actorPin.SetVisibility(visible.intValue());
        }
    }

    public void setColor(DrawingTool dr, Color newColor) {
        vtkActor2D actor = (vtkActor2D)dr.getActorText();
        vtkActor actorPin = (vtkActor)dr.getActorPin();
        double[] color = new double[]{(double)newColor.getRed() / 255.0, (double)newColor.getGreen() / 255.0, (double)newColor.getBlue() / 255.0};
        if (actor != null && actorPin != null) {
            ((vtkPointSetToLabelHierarchy)actor.GetMapper().GetInputAlgorithm()).GetTextProperty().SetColor(color);
            actorPin.GetProperty().SetColor(color);
        } else if (actorPin != null && actor == null) {
            actorPin.GetProperty().SetColor(color);
        }
    }

    public void setLatLon(DrawingTool dr) {
        vtkActor2D actor = (vtkActor2D)dr.getActorText();
        vtkActor actorPin = (vtkActor)dr.getActorPin();
        if (actor != null && actorPin != null) {
            vtkPoints labelPoints = new vtkPoints();
            labelPoints.InsertNextPoint(Transform.transformLatLonHeight(Double.parseDouble(this.displayAttributes.latField.getText()), Double.parseDouble(this.displayAttributes.lonField.getText()), Double.parseDouble(this.displayAttributes.altField.getText())));
            vtkPolyData temp = new vtkPolyData();
            temp = (vtkPolyData)((vtkPointSetToLabelHierarchy)actor.GetMapper().GetInputAlgorithm()).GetInput();
            temp.SetPoints(labelPoints);
            vtkGlyph3D glyphPoints = new vtkGlyph3D();
            glyphPoints = (vtkGlyph3D)actorPin.GetMapper().GetInputAlgorithm();
            glyphPoints.SetInputData((vtkDataObject)temp);
        }
    }

    public void setConeHtRadius(DrawingTool dr) {
        vtkActor2D actor = (vtkActor2D)dr.getActorText();
        vtkActor actorPin = (vtkActor)dr.getActorPin();
        if (actor != null && actorPin != null) {
            double coneHeight = Double.parseDouble(this.displayAttributes.coneHeightField.getText()) == 0.0 ? 1.0 : Double.parseDouble(this.displayAttributes.coneHeightField.getText());
            double coneRadius = Double.parseDouble(this.displayAttributes.coneBaseRadiusField.getText()) == 0.0 ? 1.0 : Double.parseDouble(this.displayAttributes.coneBaseRadiusField.getText());
            vtkGlyph3D glyphPoints = new vtkGlyph3D();
            glyphPoints = (vtkGlyph3D)actorPin.GetMapper().GetInputAlgorithm();
            vtkPolyData temp = new vtkPolyData();
            temp = (vtkPolyData)glyphPoints.GetInput();
            vtkConeSource conePin = new vtkConeSource();
            conePin.SetRadius(coneRadius);
            conePin.SetHeight(coneHeight);
            conePin.SetDirection(-temp.GetPoint(0L)[0], -temp.GetPoint(0L)[1], -temp.GetPoint(0L)[2]);
            conePin.SetResolution(10);
            glyphPoints.SetSourceConnection(conePin.GetOutputPort());
        }
    }

    public void setFontSize(DrawingTool dr) {
        vtkActor2D actor = (vtkActor2D)dr.getActorText();
        if (actor != null) {
            ((vtkPointSetToLabelHierarchy)actor.GetMapper().GetInputAlgorithm()).GetTextProperty().SetFontSize(Integer.parseInt(this.displayAttributes.fontSizeField.getText()));
        }
    }

    public void setAttributes(DrawingTool dr, HashMap<String, String> attributes) {
        this.displayAttributes.latField.setText(attributes.get("Lat"));
        this.displayAttributes.lonField.setText(attributes.get("Lon"));
        this.displayAttributes.altField.setText(attributes.get("Alt"));
        this.displayAttributes.coneBaseRadiusField.setText(attributes.get("pinR"));
        this.displayAttributes.coneHeightField.setText(attributes.get("pinH"));
        this.displayAttributes.fontSizeField.setText(attributes.get("fontSize"));
        this.setLatLon(dr);
        this.setConeHtRadius(dr);
        this.setFontSize(dr);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DrawingTool dr;
        int i;
        ListSelectionModel model;
        Object src = e.getSource();
        this.drawingToolTable.getLibraryModel();
        if (src == this.showDrawingToolsButton) {
            model = this.drawingToolTable.getSelectionModel();
            vtkActor actorPin = null;
            if (!model.isSelectionEmpty()) {
                for (i = model.getMinSelectionIndex(); i <= model.getMaxSelectionIndex(); ++i) {
                    dr = this.drawingToolsArray.get(i);
                    vtkActor2D actor = null;
                    actor = (vtkActor2D)dr.getActorText();
                    actorPin = (vtkActor)dr.getActorPin();
                    if (actor == null || actorPin == null) continue;
                    if (actor.GetVisibility() == 1 && actorPin.GetVisibility() == 1) {
                        this.setVisibility(dr, 0);
                        continue;
                    }
                    this.setVisibility(dr, 1);
                }
            }
            Info.getMainGUI();
            MainGUI.updateRenderWindow();
        } else if (src == this.editDrawingToolsButton) {
            this.runObjectInfoDialog();
        } else if (src == this.addDrawingToolsButton) {
            DrawingTool drawingToolObj = this.addDrawingTool(new DrawingTool(), "Text");
            this.drawingToolTable.addDrawingTool(drawingToolObj);
            MainGUI.updateRenderWindow();
        }
        if (src == this.remDrawingToolsButton) {
            this.removeTextActors();
        }
        if (src == this.displayAttributes.latField || src == this.displayAttributes.lonField || src == this.displayAttributes.altField) {
            model = this.drawingToolTable.getSelectionModel();
            for (int i2 = model.getMinSelectionIndex(); i2 <= model.getMaxSelectionIndex(); ++i2) {
                DrawingTool dr2 = this.drawingToolsArray.get(i2);
                if ((vtkActor)dr2.getActorPin() == null) continue;
                this.setLatLon(dr2);
                dr2.getAttributes().put("Lat", this.displayAttributes.latField.getText());
                dr2.getAttributes().put("Lon", this.displayAttributes.lonField.getText());
                dr2.getAttributes().put("Alt", this.displayAttributes.altField.getText());
            }
            MainGUI.updateRenderWindow();
        }
        if (src == this.displayAttributes.coneHeightField || src == this.displayAttributes.coneBaseRadiusField) {
            model = this.drawingToolTable.getSelectionModel();
            for (int i3 = model.getMinSelectionIndex(); i3 <= model.getMaxSelectionIndex(); ++i3) {
                DrawingTool dr3 = this.drawingToolsArray.get(i3);
                vtkActor actorPin = (vtkActor)dr3.getActorPin();
                if (actorPin == null) continue;
                this.setConeHtRadius(dr3);
                dr3.getAttributes().put("pinH", this.displayAttributes.coneHeightField.getText());
                dr3.getAttributes().put("pinR", this.displayAttributes.coneBaseRadiusField.getText());
            }
            MainGUI.updateRenderWindow();
        }
        if (src == this.displayAttributes.fontSizeField) {
            model = this.drawingToolTable.getSelectionModel();
            for (int i4 = model.getMinSelectionIndex(); i4 <= model.getMaxSelectionIndex(); ++i4) {
                DrawingTool dr4 = this.drawingToolsArray.get(i4);
                if ((vtkActor)dr4.getActorPin() != null) {
                    this.setFontSize(dr4);
                }
                dr4.getAttributes().put("fontSize", this.displayAttributes.fontSizeField.getText());
            }
            MainGUI.updateRenderWindow();
        }
        if (src == this.colorDrawingToolsButton) {
            ListSelectionModel model2;
            Color newColor;
            if (this.colorChooser == null) {
                this.colorChooser = new SingleColorChooser(this);
            }
            if ((newColor = this.colorChooser.getColor()) != null && !(model2 = this.drawingToolTable.getSelectionModel()).isSelectionEmpty()) {
                for (i = model2.getMinSelectionIndex(); i <= model2.getMaxSelectionIndex(); ++i) {
                    dr = this.drawingToolsArray.get(i);
                    dr.setColor(newColor);
                    this.setColor(dr, newColor);
                    Info.getMainGUI();
                    MainGUI.updateRenderWindow();
                }
            }
            MainGUI.updateRenderWindow();
        }
    }

    public void removeTextActors() {
        DrawingToolsTableModel drawingTooltablemodel = this.drawingToolTable.getLibraryModel();
        ListSelectionModel model = this.drawingToolTable.getSelectionModel();
        while (model.getMinSelectionIndex() >= 0) {
            int row = model.getMinSelectionIndex();
            DrawingTool dr = this.drawingToolsArray.get(row);
            this.appendActors.getAppendedActor().RemovePart(dr.getActorPin());
            this.appendActors.getAppendedActor().RemovePart(dr.getActorText());
            drawingTooltablemodel.removeRow(row);
            this.drawingToolsArray.remove(row);
        }
        this.enablePropertyEditButtons(false);
        Info.getMainGUI();
        MainGUI.updateRenderWindow();
    }

    public void clearTable() {
        DrawingToolsTableModel drawingTooltablemodel = this.drawingToolTable.getLibraryModel();
        int rowIndex = this.drawingToolTable.getRowCount();
        System.out.println("rowIndex = " + rowIndex);
        while (--rowIndex >= 0) {
            DrawingTool dr = this.drawingToolsArray.get(rowIndex);
            this.appendActors.getAppendedActor().RemovePart(dr.getActorPin());
            this.appendActors.getAppendedActor().RemovePart(dr.getActorText());
            drawingTooltablemodel.removeRow(rowIndex);
            this.drawingToolsArray.remove(rowIndex);
        }
    }

    private void runObjectInfoDialog() {
        String displayTextInput = JOptionPane.showInputDialog(this.drawingToolTable, "Change text:", "Set Drawing Text", 3);
        if (displayTextInput == null) {
            return;
        }
        ListSelectionModel model = this.drawingToolTable.getSelectionModel();
        for (int i = model.getMinSelectionIndex(); i <= model.getMaxSelectionIndex(); ++i) {
            DrawingTool dr = this.drawingToolsArray.get(i);
            if ((vtkActor)dr.getActorPin() == null) continue;
            this.setText(dr, displayTextInput);
            this.drawingToolTable.setValueAt(displayTextInput, i, 0);
            MainGUI.updateRenderWindow();
        }
    }

    public void setText(DrawingTool dr, String displayTextInput) {
        vtkProp actor = dr.getActorText();
        dr.setTextString(displayTextInput);
        vtkStringArray labels = new vtkStringArray();
        labels.SetName("labels");
        labels.SetNumberOfValues(1L);
        labels.SetValue(0L, displayTextInput);
        labels.Modified();
        vtkPolyData temp = new vtkPolyData();
        temp = (vtkPolyData)((vtkPointSetToLabelHierarchy)((vtkActor2D)actor).GetMapper().GetInputAlgorithm()).GetInput();
        temp.GetPointData().AddArray((vtkAbstractArray)labels);
        ((vtkPointSetToLabelHierarchy)((vtkActor2D)actor).GetMapper().GetInputAlgorithm()).SetLabelArrayName("labels");
        ((vtkPointSetToLabelHierarchy)((vtkActor2D)actor).GetMapper().GetInputAlgorithm()).Update();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object src = e.getSource();
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (src == this.drawingToolTable.getSelectionModel()) {
            this.processTableSelectionChange(this.drawingToolTable.getSelectedRows());
            this.enablePropertyEditButtons(true);
        }
    }

    public void processTableSelectionChange(int[] selectedRows) {
        if (selectedRows.length > 0) {
            this.remDrawingToolsButton.setEnabled(true);
            this.colorDrawingToolsButton.setEnabled(true);
            this.showDrawingToolsButton.setEnabled(true);
        } else {
            this.enablePropertyEditButtons(false);
            this.remDrawingToolsButton.setEnabled(false);
            this.showDrawingToolsButton.setEnabled(false);
            this.colorDrawingToolsButton.setEnabled(false);
        }
    }

    private void enablePropertyEditButtons(boolean enable) {
        this.editDrawingToolsButton.setEnabled(enable);
        this.displayAttributes.coneBaseRadiusField.setEnabled(enable);
        this.displayAttributes.coneHeightField.setEnabled(enable);
        this.displayAttributes.latField.setEnabled(enable);
        this.displayAttributes.lonField.setEnabled(enable);
        this.displayAttributes.altField.setEnabled(enable);
        this.displayAttributes.fontSizeField.setEnabled(enable);
    }
}

