/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.drawingTools;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.dom4j.Element;
import org.scec.vtk.drawingTools.DrawingTool;
import org.scec.vtk.drawingTools.DrawingToolsGUI;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.PluginState;

public class DrawingToolsPluginState
implements PluginState {
    private DrawingToolsGUI parent;
    private ArrayList<DrawingTool> drawingTools;
    private ArrayList<Color> color1;
    ArrayList<Integer> visibility;
    private ArrayList<String> textString;
    private ArrayList<HashMap<String, String>> attributes;
    private ArrayList<String> dispName;

    DrawingToolsPluginState(DrawingToolsGUI parent) {
        this.parent = parent;
        this.drawingTools = new ArrayList();
        this.textString = new ArrayList();
        this.dispName = new ArrayList();
        this.color1 = new ArrayList();
        this.visibility = new ArrayList();
        this.attributes = new ArrayList();
    }

    private void copyLatestDetials() {
        this.drawingTools.clear();
        this.textString.clear();
        this.dispName.clear();
        this.color1.clear();
        this.visibility.clear();
        this.attributes.clear();
        for (int row = 0; row < this.parent.getDrawingToolTable().getRowCount(); ++row) {
            DrawingTool dt = this.parent.getDrawingToolArray().get(row);
            this.drawingTools.add(dt);
            this.dispName.add(dt.getDisplayName());
            this.textString.add(dt.getTextString());
            System.out.println(dt.getTextString());
            this.color1.add(dt.getColor());
            System.out.println(dt.getTextString());
            HashMap<String, String> locData = new HashMap<String, String>();
            locData.put("Lat", dt.getAttributes().get("Lat"));
            locData.put("Lon", dt.getAttributes().get("Lon"));
            locData.put("Alt", dt.getAttributes().get("Alt"));
            locData.put("pinH", dt.getAttributes().get("pinH"));
            locData.put("pinR", dt.getAttributes().get("pinR"));
            locData.put("fontSize", dt.getAttributes().get("fontSize"));
            this.attributes.add(locData);
            System.out.println((String)locData.get("Lon"));
            this.visibility.add(dt.getActorPin().GetVisibility());
            System.out.println(this.visibility.get(row));
        }
    }

    @Override
    public void load() {
        int i = 0;
        for (DrawingTool dr : this.drawingTools) {
            dr.setDisplayName(this.dispName.get(i));
            this.parent.setText(dr, this.textString.get(i));
            dr.setAttributes(this.attributes.get(i));
            this.parent.setAttributes(dr, this.attributes.get(i));
            this.parent.setColor(dr, this.color1.get(i));
            this.parent.setVisibility(dr, this.visibility.get(i));
            ++i;
        }
        Info.getMainGUI();
        MainGUI.updateRenderWindow();
    }

    private void createElement(Element stateEl) {
        int i = 0;
        for (DrawingTool eqc : this.drawingTools) {
            Element propertyEl = stateEl.addElement("DrawingTool");
            propertyEl.addElement("dispName").addText(this.dispName.get(i));
            propertyEl.addElement("textString").addText(this.textString.get(i));
            propertyEl.addElement("type").addText("Text");
            propertyEl.addElement("color1").addText(Integer.toString(this.color1.get(i).getRGB()));
            propertyEl.addElement("Lat").addText(this.attributes.get(i).get("Lat"));
            propertyEl.addElement("Lon").addText(this.attributes.get(i).get("Lon"));
            propertyEl.addElement("Alt").addText(this.attributes.get(i).get("Alt"));
            propertyEl.addElement("pinH").addText(this.attributes.get(i).get("pinH"));
            propertyEl.addElement("pinR").addText(this.attributes.get(i).get("pinR"));
            propertyEl.addElement("fontSize").addText(this.attributes.get(i).get("fontSize"));
            propertyEl.addElement("visibility").addText(this.visibility.get(i).toString());
            ++i;
        }
    }

    @Override
    public void toXML(Element stateEl) {
        this.copyLatestDetials();
        this.createElement(stateEl);
    }

    @Override
    public void fromXML(Element stateEl) {
        this.drawingTools.clear();
        this.dispName.clear();
        this.textString.clear();
        this.color1.clear();
        this.visibility.clear();
        this.attributes.clear();
        Iterator i = stateEl.elementIterator("DrawingTool");
        while (i.hasNext()) {
            Element e = (Element)i.next();
            if (!e.elementText("type").contains("Text")) continue;
            this.dispName.add(e.elementText("dispName"));
            this.textString.add(e.elementText("textString"));
            this.color1.add(Color.decode(e.elementText("color1")));
            this.visibility.add(Integer.parseInt(e.elementText("visibility")));
            HashMap<String, String> locData = new HashMap<String, String>();
            locData.put("Lat", e.elementText("Lat"));
            locData.put("Lon", e.elementText("Lon"));
            locData.put("Alt", e.elementText("Alt"));
            locData.put("pinH", e.elementText("pinH"));
            locData.put("pinR", e.elementText("pinR"));
            locData.put("fontSize", e.elementText("fontSize"));
            this.attributes.add(locData);
            System.out.println(e.elementText("type"));
            boolean found = false;
            for (int k = 0; k < this.parent.getDrawingToolArray().size(); ++k) {
                if (!this.parent.getDrawingToolArray().get(k).getDisplayName().equalsIgnoreCase(e.elementText("dispName"))) continue;
                found = true;
                this.drawingTools.add(this.parent.getDrawingToolArray().get(k));
            }
            if (found) continue;
            DrawingTool drawingToolObj = this.parent.addDrawingTool(new DrawingTool(), e.elementText("textString"));
            this.parent.getDrawingToolTable().addDrawingTool(drawingToolObj);
            this.drawingTools.add(drawingToolObj);
        }
    }

    @Override
    public PluginState deepCopy() {
        DrawingToolsPluginState state = new DrawingToolsPluginState(this.parent);
        state.copyLatestDetials();
        return state;
    }
}

