/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.grid;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.scec.vtk.plugins.utils.components.ColorWellButton;
import org.scec.vtk.plugins.utils.components.SingleColorChooser;

public class DisplayAttributes
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -1L;
    private Color textColor = Color.WHITE;
    private Color coneColor = Color.WHITE;
    protected JPanel textPanel = new JPanel();
    protected JLabel showConeLabel = new JLabel("Show Cone:");
    protected JLabel showTextLabel = new JLabel("Show Label:");
    protected JLabel flattenTextLabel = new JLabel("Flatten Text:");
    protected JLabel coneColorLabel = new JLabel("Cone Color:");
    protected JLabel textColorLabel = new JLabel("Font Color:");
    protected JLabel textSizeLabel = new JLabel("Font Size:");
    protected JLabel strikeAngleText = new JLabel("Strike Angle:");
    protected JLabel rollAngleText = new JLabel("Roll Angle:");
    protected JCheckBox showConeCheckbox = new JCheckBox();
    protected JCheckBox showTextCheckbox = new JCheckBox();
    protected JCheckBox flattenTextCheckbox = new JCheckBox();
    protected ColorWellButton coneColorButton = new ColorWellButton(Color.WHITE, 16, 16);
    protected ColorWellButton textColorButton = new ColorWellButton(Color.WHITE, 16, 16);
    protected JFormattedTextField fontSizeField;
    protected JFormattedTextField strikeAngleField;
    protected JFormattedTextField rollAngleField;

    public DisplayAttributes() {
        DecimalFormat formatInt = new DecimalFormat();
        formatInt.setMinimumIntegerDigits(1);
        formatInt.setMaximumFractionDigits(0);
        formatInt.setGroupingUsed(false);
        this.fontSizeField = new JFormattedTextField(formatInt);
        this.fontSizeField.setText("18");
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setGroupingUsed(false);
        decimalFormat.setMinimumIntegerDigits(1);
        decimalFormat.setMaximumIntegerDigits(10);
        this.strikeAngleField = new JFormattedTextField(decimalFormat);
        this.strikeAngleField.setText("90");
        DecimalFormat decimalFormat2 = new DecimalFormat();
        decimalFormat2.setGroupingUsed(false);
        decimalFormat2.setMinimumIntegerDigits(1);
        decimalFormat2.setMaximumIntegerDigits(10);
        this.rollAngleField = new JFormattedTextField(decimalFormat2);
        this.rollAngleField.setText("0");
        this.setLayout(new BoxLayout(this, 0));
        JPanel enableLabelPanel = new JPanel();
        enableLabelPanel.setLayout(new BoxLayout(enableLabelPanel, 1));
        enableLabelPanel.add(this.showTextLabel);
        enableLabelPanel.add(Box.createVerticalStrut(5));
        enableLabelPanel.add(this.showConeLabel);
        enableLabelPanel.add(Box.createVerticalStrut(5));
        enableLabelPanel.add(this.flattenTextLabel);
        JPanel enableCheckboxPanel = new JPanel();
        enableCheckboxPanel.setLayout(new BoxLayout(enableCheckboxPanel, 1));
        enableCheckboxPanel.add(this.showTextCheckbox);
        enableCheckboxPanel.add(this.showConeCheckbox);
        enableCheckboxPanel.add(this.flattenTextCheckbox);
        JPanel anglePanel = new JPanel();
        anglePanel.setLayout(new BoxLayout(anglePanel, 0));
        anglePanel.add(this.strikeAngleText);
        anglePanel.add(this.strikeAngleField);
        anglePanel.add(Box.createHorizontalGlue());
        anglePanel.add(this.rollAngleText);
        anglePanel.add(this.rollAngleField);
        JPanel textSettingPanel = new JPanel();
        textSettingPanel.setLayout(new BoxLayout(textSettingPanel, 0));
        textSettingPanel.add(this.coneColorLabel);
        textSettingPanel.add(this.coneColorButton);
        textSettingPanel.add(Box.createHorizontalGlue());
        textSettingPanel.add(this.textColorLabel);
        textSettingPanel.add(this.textColorButton);
        textSettingPanel.add(Box.createHorizontalGlue());
        textSettingPanel.add(this.textSizeLabel);
        textSettingPanel.add(this.fontSizeField);
        JPanel labelPropertiesPanel = new JPanel();
        labelPropertiesPanel.setLayout(new BoxLayout(labelPropertiesPanel, 1));
        labelPropertiesPanel.add(textSettingPanel);
        textSettingPanel.add(Box.createVerticalGlue());
        labelPropertiesPanel.add(anglePanel);
        this.add(enableLabelPanel);
        this.add(enableCheckboxPanel);
        this.add(Box.createHorizontalGlue());
        this.add(labelPropertiesPanel);
        this.strikeAngleField.setPreferredSize(new Dimension(40, 20));
        this.strikeAngleField.setMaximumSize(new Dimension(40, 20));
        this.rollAngleField.setPreferredSize(new Dimension(40, 20));
        this.rollAngleField.setMaximumSize(new Dimension(40, 20));
        this.fontSizeField.setPreferredSize(new Dimension(40, 20));
        this.fontSizeField.setMaximumSize(new Dimension(40, 20));
        this.showTextCheckbox.setSelected(true);
        this.showConeCheckbox.setSelected(true);
        this.flattenTextCheckbox.setSelected(false);
        this.strikeAngleField.setEnabled(this.flattenTextCheckbox.isSelected());
        this.rollAngleField.setEnabled(this.flattenTextCheckbox.isSelected());
        this.showTextCheckbox.addActionListener(this);
        this.showConeCheckbox.addActionListener(this);
        this.textColorButton.addActionListener(this);
        this.coneColorButton.addActionListener(this);
        this.flattenTextCheckbox.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.textColorButton) {
            SingleColorChooser colorChooser = new SingleColorChooser(null);
            Color color = colorChooser.getColor();
            if (color != null) {
                this.textColor = color;
                this.textColorButton.setColor(color);
            }
        } else if (src == this.coneColorButton) {
            SingleColorChooser colorChooser = new SingleColorChooser(null);
            Color color = colorChooser.getColor();
            if (color != null) {
                this.coneColor = color;
                this.coneColorButton.setColor(this.coneColor);
            }
        } else if (src == this.showConeCheckbox) {
            this.coneColorLabel.setEnabled(this.showConeCheckbox.isSelected());
            this.coneColorButton.setEnabled(this.showConeCheckbox.isSelected());
        } else if (src == this.showTextCheckbox) {
            this.textColorLabel.setEnabled(this.showTextCheckbox.isSelected());
            this.textColorButton.setEnabled(this.showTextCheckbox.isSelected());
        } else if (src == this.flattenTextCheckbox) {
            this.strikeAngleField.setEnabled(this.flattenTextCheckbox.isSelected());
            this.rollAngleField.setEnabled(this.flattenTextCheckbox.isSelected());
        }
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public Color getConeColor() {
        return this.coneColor;
    }

    public boolean isConeEnabled() {
        return this.showConeCheckbox.isSelected();
    }

    public void setConeEnabled(boolean cone) {
        this.showConeCheckbox.setSelected(cone);
    }

    public boolean isTextEnabled() {
        return this.showTextCheckbox.isSelected();
    }

    public void setTextEnabled(boolean cone) {
        this.showTextCheckbox.setSelected(cone);
    }

    public boolean isFlattened() {
        return this.flattenTextCheckbox.isSelected();
    }

    public void setFlatten(boolean flatten) {
        this.flattenTextCheckbox.setSelected(flatten);
    }

    public String getTextSize() {
        String fontSize;
        try {
            int fontTempSize = Integer.parseInt(this.fontSizeField.getText());
            if (fontTempSize <= 0) {
                throw new NumberFormatException();
            }
            fontSize = this.fontSizeField.getText();
        }
        catch (NumberFormatException e2) {
            this.fontSizeField.setText("18");
            fontSize = "18";
        }
        return fontSize;
    }

    public double getRollAngle() {
        double roll;
        try {
            String strikeAngle = this.rollAngleField.getText();
            roll = Double.parseDouble(strikeAngle);
        }
        catch (NumberFormatException e2) {
            this.rollAngleField.setText("0");
            roll = 0.0;
        }
        return roll;
    }

    public double getStrikeAngle() {
        double strike;
        try {
            String strikeAngle = this.strikeAngleField.getText();
            strike = Double.parseDouble(strikeAngle);
        }
        catch (NumberFormatException e2) {
            this.strikeAngleField.setText("90");
            strike = 90.0;
        }
        return strike;
    }

    public void setTestSize(String fontSize) {
        this.fontSizeField.setText(fontSize);
    }
}

