/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.grid;

import java.awt.Color;
import java.util.ArrayList;
import org.scec.vtk.grid.GlobeLayout;
import org.scec.vtk.tools.Transform;
import vtk.vtkCell;
import vtk.vtkCellArray;
import vtk.vtkDataObject;
import vtk.vtkLabelPlacementMapper;
import vtk.vtkMapper;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkPolyLine;

public class GlobeBox {
    private GlobeLayout layout;
    static double PiBy2 = 1.5707963267948966;
    public vtkMapper globeScene;
    private Color lineColor = null;
    boolean bLatTexts;
    boolean bLonTexts;
    boolean bLatHashes;
    boolean bLonHashes;
    private boolean showLabels;
    public vtkLabelPlacementMapper labelMapperLat;
    public vtkPolyDataMapper ptMapper;

    public GlobeLayout getLayout() {
        return this.layout;
    }

    public void setLineColor(Color c) {
        this.lineColor = c;
    }

    public GlobeBox(GlobeLayout layout, Color color, boolean showTextLabels) {
        this.layout = layout;
        this.lineColor = color;
        this.showLabels = showTextLabels;
        this.globeScene = new vtkMapper();
    }

    public void drawGlobe() {
        ArrayList<vtkPoints> points = this.getPoints();
        this.globeScene = this.drawLonData(points);
    }

    private vtkPolyDataMapper drawLonData(ArrayList<vtkPoints> points) {
        vtkPoints allPoints = new vtkPoints();
        for (int i = 0; i < points.size(); ++i) {
            vtkPoints temp = points.get(i);
            int j = 0;
            while ((long)j < temp.GetNumberOfPoints()) {
                allPoints.InsertNextPoint(temp.GetPoint((long)j));
                double[] pts = temp.GetPoint((long)j);
                System.out.println(pts[0]);
                System.out.println(pts[1]);
                System.out.println(pts[2]);
                ++j;
            }
        }
        ArrayList<vtkPolyLine> polyLine = this.drawLonLinesFromPoints(points);
        vtkCellArray cellsPolyLine = new vtkCellArray();
        for (int i = 0; i < polyLine.size(); ++i) {
            cellsPolyLine.InsertNextCell((vtkCell)polyLine.get(i));
        }
        vtkPolyData linesPolyData = new vtkPolyData();
        vtkPolyDataMapper globeMapper = new vtkPolyDataMapper();
        linesPolyData.SetPoints(allPoints);
        linesPolyData.SetLines(cellsPolyLine);
        globeMapper.SetInputDataObject((vtkDataObject)linesPolyData);
        return globeMapper;
    }

    private vtkPolyDataMapper drawLatData(ArrayList<vtkPoints> points) {
        vtkPoints allPoints = new vtkPoints();
        for (int i = 0; i < points.size(); ++i) {
            vtkPoints temp = points.get(i);
            int j = 0;
            while ((long)j < temp.GetNumberOfPoints()) {
                allPoints.InsertNextPoint(temp.GetPoint((long)j));
                double[] pts = temp.GetPoint((long)j);
                System.out.println(pts[0]);
                System.out.println(pts[1]);
                System.out.println(pts[2]);
                ++j;
            }
        }
        ArrayList<vtkPolyLine> polyLine = this.drawLatLinesFromPoints(points);
        vtkCellArray cellsPolyLine = new vtkCellArray();
        for (int i = 0; i < polyLine.size(); ++i) {
            cellsPolyLine.InsertNextCell((vtkCell)polyLine.get(i));
        }
        vtkPolyData linesPolyData = new vtkPolyData();
        vtkPolyDataMapper globeMapper = new vtkPolyDataMapper();
        linesPolyData.SetPoints(allPoints);
        linesPolyData.SetLines(cellsPolyLine);
        globeMapper.SetInputDataObject((vtkDataObject)linesPolyData);
        return globeMapper;
    }

    public ArrayList<vtkPoints> getPoints() {
        ArrayList<vtkPoints> points = new ArrayList<vtkPoints>();
        int count = 0;
        double lat = this.layout.topLat;
        while (lat >= this.layout.botLat) {
            points.add(count, this.getPointsOnLatLine(Transform.calcRadius(lat), lat));
            lat -= this.layout.latDegreeSpacing;
            ++count;
        }
        return points;
    }

    public ArrayList<vtkPoints> getInnerPoints() {
        ArrayList<vtkPoints> points = new ArrayList<vtkPoints>();
        int count = 0;
        double lat = this.layout.topLat;
        while (lat >= this.layout.botLat) {
            points.add(count, this.getPointsOnLatLine(Transform.calcRadius(lat) - this.layout.maxDepth, lat));
            lat -= this.layout.latDegreeSpacing;
            ++count;
        }
        return points;
    }

    public ArrayList<vtkPolyLine> drawLatLinesFromPoints(ArrayList<vtkPoints> points) {
        ArrayList<vtkPolyLine> latLines = new ArrayList<vtkPolyLine>();
        int resolution = this.layout.numLonLinesWithSpacing + 1;
        int length = resolution + 1;
        for (int latcount = 0; latcount < points.size(); ++latcount) {
            vtkPoints pts = points.get(latcount);
            vtkPolyLine plyline = new vtkPolyLine();
            plyline.GetPointIds().SetNumberOfIds(pts.GetNumberOfPoints());
            int loncount = 0;
            while ((long)loncount < pts.GetNumberOfPoints()) {
                plyline.GetPointIds().SetId((long)loncount, (long)loncount);
                ++loncount;
            }
            latLines.add(plyline);
        }
        return latLines;
    }

    public ArrayList<vtkPolyLine> drawLonLinesFromPoints(ArrayList<vtkPoints> points) {
        ArrayList<vtkPolyLine> lonLines = new ArrayList<vtkPolyLine>();
        int resolution = this.layout.numLatLinesWithSpacing + 1;
        int length = resolution + 1;
        for (int loncount = 0; loncount < points.size(); ++loncount) {
            vtkPoints pts = points.get(loncount);
            vtkPolyLine plyline = new vtkPolyLine();
            plyline.GetPointIds().SetNumberOfIds(pts.GetNumberOfPoints());
            int latcount = 0;
            while ((long)latcount < pts.GetNumberOfPoints()) {
                plyline.GetPointIds().SetId((long)latcount, (long)latcount);
                ++latcount;
            }
            lonLines.add(plyline);
        }
        return lonLines;
    }

    private vtkPoints getPointsOnLatLine(double radius, double lat) {
        double rCosPhi = radius * Math.cos(PiBy2 - Math.toRadians(lat));
        double rSinPhi = radius * Math.sin(PiBy2 - Math.toRadians(lat));
        double leftLon = -1.0 * this.layout.rightLon;
        double rightLon = -1.0 * this.layout.leftLon;
        int resolution = this.layout.numLonLinesWithSpacing + 1;
        vtkPoints returnme = new vtkPoints();
        int count = 0;
        double[] pt = new double[3];
        double i = leftLon;
        while (-1.0E-6 <= rightLon - i) {
            pt[0] = rSinPhi * Math.cos(Math.toRadians(i));
            pt[1] = rCosPhi;
            pt[2] = rSinPhi * Math.sin(Math.toRadians(i));
            returnme.InsertNextPoint(pt);
            i += this.layout.lonDegreeSpacing;
            ++count;
        }
        return returnme;
    }

    private void init() {
    }

    public Color getLineColor() {
        return this.lineColor;
    }
}

