/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.grid;

import org.scec.vtk.grid.ViewRange;

public class GlobeLayout {
    protected double re = 6378.14;
    protected double rp = 6356.755;
    protected double topLat;
    protected double botLat;
    protected double leftLon;
    protected double rightLon;
    protected double maxDepth;
    protected int numLatLinesWithSpacing;
    protected int numLonLinesWithSpacing;
    protected double latDegreeSpacing;
    protected double lonDegreeSpacing;
    protected int labelFontSize = 25;
    protected int[] centerOfEarth = new int[]{0, 0, 0};
    protected String[] latTexts;
    protected String[] lonTexts;

    public double getTopLat() {
        return this.topLat;
    }

    public double getBotLat() {
        return this.botLat;
    }

    public double getLeftLon() {
        return this.leftLon;
    }

    public double getRightLon() {
        return this.rightLon;
    }

    public GlobeLayout() {
        this.topLat = 36.0;
        this.botLat = 32.0;
        this.leftLon = -122.0;
        this.rightLon = -114.0;
        this.maxDepth = 40.0;
        this.latDegreeSpacing = 1.0;
        this.lonDegreeSpacing = 1.0;
        this.commonSetup();
    }

    public GlobeLayout(int topLat, int botLat, int leftLon, int rightLon, double degreeSpacing) {
        this.topLat = topLat;
        this.botLat = botLat;
        this.leftLon = leftLon;
        this.rightLon = rightLon;
        this.maxDepth = 40.0;
        this.latDegreeSpacing = degreeSpacing;
        this.lonDegreeSpacing = degreeSpacing;
        this.commonSetup();
    }

    public GlobeLayout(ViewRange viewRange, double degreeSpacing) {
        this(viewRange.getUpperLatitude(), viewRange.getLowerLatitude(), viewRange.getLeftLongitude(), viewRange.getRightLongitude(), degreeSpacing);
    }

    private void commonSetup() {
        double lat = this.topLat;
        this.numLatLinesWithSpacing = 0;
        while (lat > this.botLat) {
            lat -= this.latDegreeSpacing;
            ++this.numLatLinesWithSpacing;
        }
        this.botLat = lat;
        double lon = this.leftLon;
        this.numLonLinesWithSpacing = 0;
        while (lon < this.rightLon) {
            lon += this.lonDegreeSpacing;
            ++this.numLonLinesWithSpacing;
        }
        this.rightLon = lon;
        this.labelFontSize = (int)(this.latDegreeSpacing * 25.0);
        this.latTexts = new String[(int)Math.abs(this.topLat - this.botLat)];
        this.lonTexts = new String[(int)Math.abs(this.rightLon - this.leftLon)];
        this.populateStringArray(true, this.topLat);
        this.populateStringArray(false, this.leftLon);
    }

    private void populateStringArray(boolean lat, double startValue) {
        double curValue = startValue;
        if (lat) {
            for (int i = 0; i < this.latTexts.length; ++i) {
                double d = curValue;
                curValue = d - 1.0;
                this.latTexts[i] = Double.toString(d);
            }
        } else {
            for (int i = 0; i < this.lonTexts.length; ++i) {
                double d = curValue;
                curValue = d + 1.0;
                this.lonTexts[i] = Double.toString(d);
            }
        }
    }
}

