/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.grid;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.scec.vtk.grid.DisplayAttributes;
import org.scec.vtk.grid.GlobeBox;
import org.scec.vtk.grid.GlobeLayout;
import org.scec.vtk.grid.GraticulePreset;
import org.scec.vtk.grid.GraticulePresetModel;
import org.scec.vtk.grid.ViewRange;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.PluginActors;
import org.scec.vtk.plugins.utils.components.ColorWellButton;
import org.scec.vtk.plugins.utils.components.IntegerTextField;
import org.scec.vtk.plugins.utils.components.SingleColorChooser;
import org.scec.vtk.tools.Prefs;
import org.scec.vtk.tools.Transform;
import vtk.vtkAbstractArray;
import vtk.vtkActor;
import vtk.vtkActor2D;
import vtk.vtkCell;
import vtk.vtkCellArray;
import vtk.vtkDataObject;
import vtk.vtkDoubleArray;
import vtk.vtkIntArray;
import vtk.vtkLabelPlacementMapper;
import vtk.vtkLine;
import vtk.vtkMapper;
import vtk.vtkMapper2D;
import vtk.vtkPointSetToLabelHierarchy;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;
import vtk.vtkStringArray;

public class GraticuleGUI
extends JPanel
implements ActionListener {
    protected DisplayAttributes displayAttributes;
    protected JCheckBox showCompass;
    protected JPanel compassPanel;
    protected JFormattedTextField latField;
    protected JFormattedTextField lonField;
    private static final long serialVersionUID = 1L;
    private JPanel displayPanel;
    public static final JLabel status = new JLabel("Status");
    private ButtonGroup displayButtons;
    protected JRadioButton firstsceneRadioButton;
    protected JRadioButton secondsceneRadioButton;
    protected JRadioButton noneRadioButton;
    protected JRadioButton customRadioButton;
    protected JTextField customTextBox;
    private JComboBox presetsComboBox;
    private boolean labelsOn = true;
    private JCheckBox latLonLabelsCheckBox = new JCheckBox("Display latitude and longitude labels.", this.labelsOn);
    private GlobeBox gb1;
    private GlobeBox gb2;
    private GlobeBox gb3;
    private GlobeBox gb4;
    private JPanel gridDimensionsPanel;
    private JPanel NorthPanel;
    private JPanel EWPanel;
    private JPanel SouthPanel;
    private JPanel buttonPanel;
    protected JButton graticuleappsProp_apply;
    private ColorWellButton colorChooser;
    private ColorWellButton bckgroundColorChooser;
    private Color gridColor = Color.DARK_GRAY;
    private Color backgroundColor = Color.BLACK;
    private boolean firstTime = true;
    private vtkStringArray labels;
    private int labelLatCt = 0;
    protected int lowerLatitude = 0;
    protected int upperLatitude = 0;
    protected int lowerLongitude = 0;
    protected int upperLongitude = 0;
    protected double gridWidth = 1.0;
    private Color curColor = Color.DARK_GRAY;
    private GraticulePresetModel presetModel;
    private ArrayList<GlobeBox> grids;
    private IntegerTextField relIntensityProp_extentsNval1 = new IntegerTextField(2, false, 3);
    private IntegerTextField relIntensityProp_extentsWval1 = new IntegerTextField(3, false, 3);
    private IntegerTextField relIntensityProp_extentsEval1 = new IntegerTextField(3, false, 3);
    private IntegerTextField relIntensityProp_extentsSval1 = new IntegerTextField(2, false, 3);
    public int upperLat;
    public int lowerLat;
    public int upperLon;
    public int lowerLon;
    private vtkActor tempGlobeScene = new vtkActor();
    private vtkActor pointActor = new vtkActor();
    vtkActor2D labelActor = new vtkActor2D();
    private boolean gridDisplay = true;
    PluginActors pluginActors = new PluginActors();

    public static GraticulePreset getGraticlePreset() {
        Info.getMainGUI();
        String calGridPath = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + "Grid" + File.separator + "California.grat";
        System.out.println(calGridPath);
        File calGrid = new File(calGridPath);
        return new GraticulePreset(calGrid);
    }

    public void makeGrids(ArrayList<GlobeBox> gbs, boolean labelsOn) {
        vtkPolyDataMapper tempMapper = (vtkPolyDataMapper)gbs.get((int)0).globeScene;
        this.tempGlobeScene.SetMapper((vtkMapper)tempMapper);
        if (gbs.get(0).getLineColor() != null) {
            this.tempGlobeScene.GetProperty().SetColor(Info.convertColor(gbs.get(0).getLineColor()));
        } else {
            this.tempGlobeScene.GetProperty().SetColor(1.0, 1.0, 1.0);
        }
        this.tempGlobeScene.Modified();
        tempMapper.GetInput();
        this.pointActor.SetMapper((vtkMapper)gbs.get((int)0).ptMapper);
        this.pointActor.Modified();
        if (labelsOn) {
            this.labelActor.SetMapper((vtkMapper2D)gbs.get((int)0).labelMapperLat);
        } else {
            this.labelActor.SetMapper(null);
        }
        this.labelActor.Modified();
        this.pluginActors.addActor((vtkProp)this.tempGlobeScene);
        this.pluginActors.addActor((vtkProp)this.pointActor);
        this.pluginActors.addActor((vtkProp)this.labelActor);
        Info.getMainGUI();
        MainGUI.getRenderWindow().getRenderer().ResetCamera(this.tempGlobeScene.GetBounds());
    }

    public void toggleGridDisplay() {
        if (!this.gridDisplay) {
            this.tempGlobeScene.VisibilityOn();
            this.gridDisplay = true;
        } else {
            this.tempGlobeScene.VisibilityOff();
            this.gridDisplay = false;
        }
    }

    public boolean getGridDisplayBool() {
        return this.gridDisplay;
    }

    public vtkActor getGrid() {
        return this.tempGlobeScene;
    }

    public ArrayList<GlobeBox> getGlobeBox(GraticulePreset graticule, double spacing) {
        this.upperLat = graticule.getUpperLatitude();
        this.lowerLat = graticule.getLowerLatitude();
        this.upperLon = graticule.getLeftLongitude();
        this.lowerLon = graticule.getRightLongitude();
        ArrayList<GlobeBox> gbs = this.makeNewGrid(this.upperLat, this.lowerLat, this.upperLon, this.lowerLon, spacing);
        return gbs;
    }

    private ArrayList<GlobeBox> makeGrids(int upperLat, int lowerLat, int leftLong, int rightLong, double spacing) {
        double k;
        double[] pt;
        this.labels = new vtkStringArray();
        this.labels.SetName("labels");
        vtkIntArray sizes = new vtkIntArray();
        sizes.SetName("sizes");
        vtkPolyData temp = new vtkPolyData();
        vtkPoints allPoints = new vtkPoints();
        vtkPoints labelPoints = new vtkPoints();
        int countPts = 0;
        vtkCellArray lines = new vtkCellArray();
        vtkPolyData linesPolyData = new vtkPolyData();
        vtkDoubleArray lat = new vtkDoubleArray();
        vtkDoubleArray lon = new vtkDoubleArray();
        lat.SetName("latitude");
        lon.SetName("longitude");
        vtkLine line0 = new vtkLine();
        double leftLon = 1 * rightLong;
        double rightLon = 1 * leftLong;
        if (upperLat < lowerLat) {
            upperLat = lowerLat;
            System.out.println("Invalid Latitude Range");
        }
        if (leftLon < rightLon) {
            leftLon = rightLon;
            System.out.println("Invalid Longitude Range");
        }
        int numOfLat = (int)(Math.ceil((double)(upperLat - lowerLat) / spacing) + 1.0);
        this.labels.SetNumberOfValues((long)((numOfLat += (int)(Math.ceil((leftLon - rightLon) / spacing) + 1.0)) + 1));
        sizes.SetNumberOfValues((long)numOfLat);
        this.labelLatCt = 0;
        boolean maxDepth = false;
        double j = upperLat;
        while (j >= (double)lowerLat) {
            pt = new double[]{Transform.calcRadius(j), j, leftLon};
            allPoints.InsertNextPoint(Transform.customTransform(pt));
            for (k = leftLon - spacing; k >= rightLon; k -= spacing) {
                pt[2] = k;
                allPoints.InsertNextPoint(Transform.customTransform(pt));
                line0.GetPointIds().SetId(0L, (long)countPts);
                line0.GetPointIds().SetId(1L, (long)(countPts + 1));
                ++countPts;
                lines.InsertNextCell((vtkCell)line0);
            }
            ++countPts;
            pt[2] = rightLon;
            if (this.labelsOn) {
                this.labels.SetValue((long)this.labelLatCt, new DecimalFormat("#.######").format(j));
            }
            labelPoints.InsertNextPoint(Transform.customTransform(pt));
            j -= spacing;
            ++this.labelLatCt;
        }
        j = leftLon;
        while (j >= rightLon) {
            pt = new double[]{Transform.calcRadius(upperLat), upperLat, j};
            allPoints.InsertNextPoint(Transform.customTransform(pt));
            if (this.labelsOn) {
                this.labels.SetValue((long)this.labelLatCt, new DecimalFormat("#.######").format(j));
            }
            labelPoints.InsertNextPoint(Transform.customTransform(pt));
            for (k = (double)upperLat - spacing; k >= (double)lowerLat; k -= spacing) {
                pt[0] = Transform.calcRadius(k);
                pt[1] = k;
                allPoints.InsertNextPoint(Transform.customTransform(pt));
                line0.GetPointIds().SetId(0L, (long)countPts);
                line0.GetPointIds().SetId(1L, (long)(countPts + 1));
                ++countPts;
                lines.InsertNextCell((vtkCell)line0);
            }
            ++countPts;
            j -= spacing;
            ++this.labelLatCt;
        }
        linesPolyData.SetPoints(allPoints);
        linesPolyData.SetLines(lines);
        temp.SetPoints(labelPoints);
        temp.GetPointData().AddArray((vtkAbstractArray)this.labels);
        vtkPointSetToLabelHierarchy pointSetToLabelHierarchyFilter = new vtkPointSetToLabelHierarchy();
        pointSetToLabelHierarchyFilter.SetInputData((vtkDataObject)temp);
        pointSetToLabelHierarchyFilter.SetLabelArrayName("labels");
        pointSetToLabelHierarchyFilter.Update();
        vtkPolyDataMapper globeMapper = new vtkPolyDataMapper();
        globeMapper.SetInputData(linesPolyData);
        vtkPolyDataMapper pointMapper = new vtkPolyDataMapper();
        pointMapper.SetInputData(temp);
        vtkLabelPlacementMapper cellMapper = new vtkLabelPlacementMapper();
        cellMapper.SetInputConnection(pointSetToLabelHierarchyFilter.GetOutputPort());
        ArrayList<GlobeBox> gbs = new ArrayList<GlobeBox>(4);
        Color tempColor3f = new Color(102, 102, 102);
        GlobeLayout gl = new GlobeLayout(upperLat, lowerLat, leftLong, rightLong, spacing);
        gbs.add(new GlobeBox(gl, tempColor3f, true));
        ((GlobeBox)gbs.get((int)0)).globeScene = globeMapper;
        ((GlobeBox)gbs.get((int)0)).labelMapperLat = cellMapper;
        ((GlobeBox)gbs.get((int)0)).ptMapper = pointMapper;
        return gbs;
    }

    public ArrayList<GlobeBox> makeNewGrid(int upperLat, int lowerLat, int leftLong, int rightLong, double spacing) {
        ArrayList<GlobeBox> gbs = this.makeGrids(upperLat, lowerLat, leftLong, rightLong, spacing);
        return gbs;
    }

    public ArrayList<GlobeBox> makeNewGrid(double spacing) {
        ArrayList<GlobeBox> gbs = this.makeGrids(Integer.parseInt(this.relIntensityProp_extentsNval1.getText()), Integer.parseInt(this.relIntensityProp_extentsSval1.getText()), Integer.parseInt(this.relIntensityProp_extentsWval1.getText()), Integer.parseInt(this.relIntensityProp_extentsEval1.getText()), spacing);
        if (this.curColor != null) {
            gbs.get(0).setLineColor(this.curColor);
        }
        return gbs;
    }

    public GraticuleGUI(PluginActors pluginActors) {
        this.pluginActors = pluginActors;
        this.setLayout(new BoxLayout(this, 3));
        this.setPreferredSize(new Dimension(Prefs.getPluginWidth(), Prefs.getPluginHeight()));
        this.makeGridDimensionsPanel();
        JPanel midPanel = new JPanel();
        midPanel.setLayout(new BorderLayout());
        midPanel.add((Component)this.gridDimensionsPanel, "Center");
        midPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Grid Dimensions"), BorderFactory.createEmptyBorder(10, 10, 10, 10))));
        midPanel.setMaximumSize(new Dimension(400, 200));
        this.add(this.getGridSettingsPanel());
        this.add(midPanel);
        this.add(Box.createVerticalGlue());
        this.add(this.makebuttonPanel());
    }

    private JPanel getGridSettingsPanel() {
        this.displayPanel = new JPanel(new GridLayout(0, 1, 5, 5));
        this.displayPanel.setName("Display Type");
        this.displayPanel.setOpaque(false);
        this.displayButtons = new ButtonGroup();
        this.firstsceneRadioButton = new JRadioButton("1.0 degrees");
        this.secondsceneRadioButton = new JRadioButton("0.1 degrees");
        this.noneRadioButton = new JRadioButton("No Grid");
        this.customRadioButton = new JRadioButton("Custom (degrees)");
        this.customTextBox = new JTextField(10);
        this.customTextBox.setEnabled(false);
        this.firstsceneRadioButton.addActionListener(this);
        this.secondsceneRadioButton.addActionListener(this);
        this.noneRadioButton.addActionListener(this);
        this.customRadioButton.addActionListener(this);
        this.displayButtons.add(this.noneRadioButton);
        this.displayButtons.add(this.firstsceneRadioButton);
        this.displayButtons.add(this.secondsceneRadioButton);
        this.displayButtons.add(this.customRadioButton);
        this.displayPanel.add(this.noneRadioButton);
        this.displayPanel.add(this.firstsceneRadioButton);
        this.displayPanel.add(this.secondsceneRadioButton);
        this.colorChooser = new ColorWellButton(Color.GREEN, 16, 16);
        this.colorChooser.setEnabled(true);
        this.colorChooser.addActionListener(this);
        this.colorChooser.setColor(Color.GRAY);
        this.bckgroundColorChooser = new ColorWellButton(Color.BLACK, 16, 16);
        this.bckgroundColorChooser.setEnabled(true);
        this.bckgroundColorChooser.addActionListener(this);
        this.displayPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Grid Settings"), BorderFactory.createEmptyBorder(15, 15, 15, 15))));
        Box bx = new Box(0);
        bx.add(this.customRadioButton);
        bx.add(this.customTextBox);
        this.displayPanel.add(bx);
        JLabel userInstructions = new JLabel("Select Grid Color   ");
        Box bx2 = new Box(0);
        bx2.add(userInstructions);
        bx2.add(this.colorChooser);
        this.displayPanel.add(bx2);
        JLabel bckColorUserInstructions = new JLabel("Select Background Color   ");
        Box bx3 = new Box(0);
        bx3.add(bckColorUserInstructions);
        bx3.add(this.bckgroundColorChooser);
        this.displayPanel.add(bx3);
        this.firstsceneRadioButton.setSelected(true);
        this.presetModel = new GraticulePresetModel();
        this.presetsComboBox = new JComboBox<String>(this.presetModel.getAllNames());
        this.presetsComboBox.addActionListener(this);
        this.displayPanel.add(this.presetsComboBox);
        this.displayPanel.add(this.latLonLabelsCheckBox);
        this.displayPanel.setMinimumSize(new Dimension(400, 120));
        this.displayPanel.setMaximumSize(new Dimension(400, 120));
        return this.displayPanel;
    }

    public void makeCompassPanel() {
        this.compassPanel = new JPanel();
        this.showCompass = new JCheckBox("Show Compass");
        this.showCompass.addActionListener(this);
        this.displayAttributes = new DisplayAttributes();
        if (Prefs.getOS() != 1) {
            this.compassPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Compass Settings"), BorderFactory.createEmptyBorder(0, 16, 16, 16))));
        }
        this.compassPanel.add(this.displayAttributes);
        this.compassPanel.add(this.showCompass);
        this.compassPanel.add(Box.createHorizontalStrut(2));
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setGroupingUsed(false);
        decimalFormat.setMinimumIntegerDigits(1);
        decimalFormat.setMaximumIntegerDigits(10);
        this.latField = new JFormattedTextField(decimalFormat);
        this.latField.setText("34.113");
        this.latField.addActionListener(this);
        DecimalFormat decimalFormat2 = new DecimalFormat();
        decimalFormat2.setGroupingUsed(false);
        decimalFormat2.setMinimumIntegerDigits(1);
        decimalFormat2.setMaximumIntegerDigits(10);
        this.lonField = new JFormattedTextField(decimalFormat2);
        this.lonField.setText("-118.2");
        this.lonField.addActionListener(this);
        this.compassPanel.add(new JLabel("Lat"));
        this.compassPanel.add(this.latField);
        this.compassPanel.add(Box.createHorizontalStrut(2));
        this.compassPanel.add(new JLabel("Lon"));
        this.compassPanel.add(this.lonField);
    }

    private void makeGridDimensionsPanel() {
        this.gridDimensionsPanel = new JPanel();
        ViewRange vr = Info.getMainGUI().getViewRange();
        this.populateFields(vr);
        JLabel relIntensityProp_extentsLat = new JLabel("Lat:");
        JLabel relIntensityProp_extentsLon = new JLabel("Lon:");
        JLabel relIntensityProp_extentsMax = new JLabel("(min)");
        JLabel relIntensityProp_extentsMax2 = new JLabel("(max)");
        relIntensityProp_extentsMax.setForeground(Color.GRAY);
        relIntensityProp_extentsMax2.setForeground(Color.GRAY);
        JLabel relIntensityProp_extentsMin = new JLabel("(min)");
        JLabel relIntensityProp_extentsMin2 = new JLabel("(max)");
        relIntensityProp_extentsMin.setForeground(Color.GRAY);
        relIntensityProp_extentsMin2.setForeground(Color.GRAY);
        JLabel relIntensityProp_Extents_to = new JLabel("to");
        this.NorthPanel = new JPanel();
        this.NorthPanel.setLayout(new BoxLayout(this.NorthPanel, 2));
        this.NorthPanel.add(new JLabel("Lat:"));
        this.NorthPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        this.NorthPanel.add(this.relIntensityProp_extentsNval1);
        this.NorthPanel.add(relIntensityProp_extentsMax2);
        this.NorthPanel.setMaximumSize(new Dimension(100, 22));
        this.EWPanel = new JPanel();
        this.EWPanel.setLayout(new BoxLayout(this.EWPanel, 2));
        this.EWPanel.add(new JLabel("Lon:"));
        this.EWPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        this.EWPanel.add(this.relIntensityProp_extentsWval1);
        this.EWPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        this.EWPanel.add(relIntensityProp_extentsMax);
        this.EWPanel.add(Box.createRigidArea(new Dimension(40, 0)));
        this.EWPanel.add(relIntensityProp_Extents_to);
        this.EWPanel.add(Box.createRigidArea(new Dimension(40, 0)));
        this.EWPanel.add(relIntensityProp_extentsLon);
        this.EWPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        this.EWPanel.add(this.relIntensityProp_extentsEval1);
        this.EWPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        this.EWPanel.add(relIntensityProp_extentsMin2);
        this.EWPanel.setMaximumSize(new Dimension(300, 22));
        this.SouthPanel = new JPanel();
        this.SouthPanel.setLayout(new BoxLayout(this.SouthPanel, 2));
        this.SouthPanel.add(relIntensityProp_extentsLat);
        this.SouthPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        this.SouthPanel.add(this.relIntensityProp_extentsSval1);
        this.SouthPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        this.SouthPanel.add(relIntensityProp_extentsMin);
        this.SouthPanel.setMaximumSize(new Dimension(100, 22));
        this.gridDimensionsPanel.setLayout(new BoxLayout(this.gridDimensionsPanel, 3));
        this.gridDimensionsPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.gridDimensionsPanel.add(this.NorthPanel);
        this.NorthPanel.setAlignmentX(0.5f);
        this.gridDimensionsPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        this.gridDimensionsPanel.add(this.EWPanel);
        this.EWPanel.setAlignmentX(0.5f);
        this.gridDimensionsPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        this.gridDimensionsPanel.add(this.SouthPanel);
        this.SouthPanel.setAlignmentX(0.5f);
        this.gridDimensionsPanel.add(Box.createRigidArea(new Dimension(0, 10)));
    }

    private JPanel makebuttonPanel() {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setAlignmentX(0.5f);
        this.graticuleappsProp_apply = new JButton("Apply");
        this.graticuleappsProp_apply.addActionListener(this);
        this.graticuleappsProp_apply.setActionCommand("apply");
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 2));
        this.buttonPanel.add(this.graticuleappsProp_apply);
        return this.buttonPanel;
    }

    public void apply() {
        if (this.latLonLabelsCheckBox.isSelected() != this.labelsOn) {
            this.labelsOn = this.latLonLabelsCheckBox.isSelected();
        }
        if (!this.getGridDisplayBool()) {
            this.toggleGridDisplay();
        }
        if (this.firstsceneRadioButton.isSelected()) {
            this.gridWidth = 1.0;
            this.makeGrids(this.makeNewGrid(this.gridWidth), this.labelsOn);
            Info.getMainGUI();
            MainGUI.updateRenderWindow();
        } else if (this.secondsceneRadioButton.isSelected()) {
            this.gridWidth = 0.1;
            this.makeGrids(this.makeNewGrid(this.gridWidth), this.labelsOn);
            Info.getMainGUI();
            MainGUI.updateRenderWindow();
        } else if (this.noneRadioButton.isSelected()) {
            if (this.getGridDisplayBool()) {
                this.makeGrids(this.makeNewGrid(this.gridWidth), this.labelsOn);
                this.toggleGridDisplay();
            }
            System.out.println("No grid selected");
            Info.getMainGUI();
            MainGUI.updateRenderWindow();
        } else if (this.customRadioButton.isSelected()) {
            double customGrid = 0.0;
            try {
                customGrid = Double.parseDouble(this.customTextBox.getText());
                if (!(customGrid >= 0.05)) {
                    throw new NumberFormatException();
                }
                this.gridWidth = customGrid;
                this.makeGrids(this.makeNewGrid(this.gridWidth), this.labelsOn);
                Info.getMainGUI();
                MainGUI.updateRenderWindow();
            }
            catch (NumberFormatException nfe) {
                this.customTextBox.setText("Please enter a number greater than .05");
                this.customTextBox.setSelectionStart(0);
                this.customTextBox.setSelectionEnd(this.customTextBox.getText().length());
                this.customTextBox.requestFocus();
            }
        }
        if (this.latLonLabelsCheckBox.isSelected() != this.labelsOn) {
            this.labelsOn = this.latLonLabelsCheckBox.isSelected();
            this.makeGrids(this.makeNewGrid(this.gridWidth), this.labelsOn);
            Info.getMainGUI();
            MainGUI.updateRenderWindow();
            System.out.println("Checkbox switched from " + !this.labelsOn + " to " + this.labelsOn);
        }
    }

    public void setGridColor(Color color) {
        this.curColor = color;
        this.colorChooser.setColor(color);
    }

    public void setLabelsDisplayed(boolean displayed) {
        this.latLonLabelsCheckBox.setSelected(displayed);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.customTextBox.setEnabled(this.customRadioButton.isSelected());
        if (arg0.getActionCommand() == "apply") {
            this.apply();
        } else if (arg0.getSource() == this.colorChooser) {
            SingleColorChooser colorChooser = new SingleColorChooser(null);
            Color tempColor = colorChooser.getColor();
            if (tempColor != null) {
                this.setGridColor(tempColor);
                this.gridColor = tempColor;
                this.getGrid().GetProperty().SetColor(Info.convertColor(tempColor));
                Info.getMainGUI();
                MainGUI.updateRenderWindow();
            }
        } else if (arg0.getSource() == this.bckgroundColorChooser) {
            SingleColorChooser colorChooser = new SingleColorChooser(null);
            Color tempColor = colorChooser.getColor();
            if (tempColor != null) {
                this.bckgroundColorChooser.setColor(tempColor);
                this.backgroundColor = tempColor;
                Info.getMainGUI();
                MainGUI.getRenderWindow().getRenderer().SetBackground(Info.convertColor(tempColor));
                Info.getMainGUI();
                MainGUI.updateRenderWindow();
            }
        } else if (arg0.getSource() == this.presetsComboBox) {
            GraticulePreset preset = this.presetModel.getPreset(this.presetsComboBox.getSelectedIndex());
            Info.getMainGUI();
            MainGUI.updateRenderWindow();
            this.relIntensityProp_extentsNval1.setText("" + preset.getUpperLatitude());
            this.relIntensityProp_extentsSval1.setText("" + preset.getLowerLatitude());
            this.relIntensityProp_extentsEval1.setText("" + preset.getRightLongitude());
            this.relIntensityProp_extentsWval1.setText("" + preset.getLeftLongitude());
        }
    }

    protected void populateFields(ViewRange range) {
        this.relIntensityProp_extentsNval1.setText(range.getUpperLatitudeAsString());
        this.relIntensityProp_extentsSval1.setText(range.getLowerLatitudeAsString());
        this.relIntensityProp_extentsEval1.setText(range.getRightLongitudeAsString());
        this.relIntensityProp_extentsWval1.setText(range.getLeftLongitudeAsString());
        if (this.firstTime) {
            this.upperLatitude = range.getUpperLatitude();
            this.lowerLatitude = range.getLowerLatitude();
            this.upperLongitude = range.getRightLongitude();
            this.lowerLongitude = range.getLeftLongitude();
            this.firstTime = false;
        }
    }

    public double getGridWidth() {
        return this.gridWidth;
    }

    public void setGridWidth(double w) {
        this.gridWidth = w;
    }

    public GraticulePreset getGraticuleData() {
        return new GraticulePreset(this.lowerLatitude, this.upperLatitude, this.lowerLongitude, this.upperLongitude);
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor2(Color c) {
        this.gridColor = c;
        this.getGrid().GetProperty().SetColor(Info.convertColor(this.gridColor));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color c) {
        this.backgroundColor = c;
        Info.getMainGUI();
        MainGUI.getRenderWindow().getRenderer().SetBackground(Info.convertColor(this.backgroundColor));
    }

    public int getMaxLat() {
        return this.relIntensityProp_extentsNval1.getIntegerValue();
    }

    public void setMaxLatField(int lat) {
        this.relIntensityProp_extentsNval1.setText(Integer.toString(lat));
    }

    public int getMinLat() {
        return this.relIntensityProp_extentsSval1.getIntegerValue();
    }

    public void setMinLatField(int lat) {
        this.relIntensityProp_extentsSval1.setText(Integer.toString(lat));
    }

    public int getMaxLon() {
        return this.relIntensityProp_extentsEval1.getIntegerValue();
    }

    public void setMaxLonField(int lon) {
        this.relIntensityProp_extentsEval1.setText(Integer.toString(lon));
    }

    public int getMinLon() {
        return this.relIntensityProp_extentsWval1.getIntegerValue();
    }

    public void setMinLonField(int lon) {
        this.relIntensityProp_extentsWval1.setText(Integer.toString(lon));
    }

    public boolean isLabelsOn() {
        return this.latLonLabelsCheckBox.isSelected();
    }

    public ButtonGroup getDisplayButtons() {
        return this.displayButtons;
    }

    public JRadioButton getFirstSceneRadioButton() {
        return this.firstsceneRadioButton;
    }

    public JRadioButton getSecondSceneRadioButton() {
        return this.secondsceneRadioButton;
    }

    public JRadioButton getNoneRadioButton() {
        return this.noneRadioButton;
    }

    public JRadioButton getCustomRadioButton() {
        return this.customRadioButton;
    }

    public JTextField getCustomTextField() {
        return this.customTextBox;
    }

    public void graphVisibilityOn() {
        this.tempGlobeScene.VisibilityOn();
        this.gridDisplay = true;
    }

    public void graphVisibilityOff() {
        this.tempGlobeScene.VisibilityOff();
        this.gridDisplay = false;
    }
}

