/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.grid;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import org.dom4j.Element;
import org.scec.vtk.grid.GlobeBox;
import org.scec.vtk.grid.GraticuleGUI;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.PluginState;

public class GraticulePluginState
implements PluginState {
    private GraticuleGUI parent;
    private String buttonSelection = "";
    private double gridWidth = 0.0;
    private Color gridColor = Color.DARK_GRAY;
    private Color backgroundColor = Color.BLACK;
    private boolean gridDisplay = true;
    private int lowerLatitude = 0;
    private int upperLatitude = 0;
    private int lowerLongitude = 0;
    private int upperLongitude = 0;
    private boolean latLongLabelDisplay = true;

    GraticulePluginState(GraticuleGUI parent) {
        this.parent = parent;
    }

    void copyLatestCatalogDetails() {
        this.buttonSelection = this.parent.getFirstSceneRadioButton().isSelected() ? "1.0 degrees" : (this.parent.getSecondSceneRadioButton().isSelected() ? "0.1 degrees" : (this.parent.getNoneRadioButton().isSelected() ? "No Grid" : "Custom (degrees)"));
        this.gridWidth = this.parent.getGridWidth();
        this.latLongLabelDisplay = this.parent.isLabelsOn();
        this.gridDisplay = this.parent.getGridDisplayBool();
        this.gridColor = this.parent.getGridColor();
        this.backgroundColor = this.parent.getBackgroundColor();
        this.lowerLatitude = this.parent.getMinLat();
        this.upperLatitude = this.parent.getMaxLat();
        this.lowerLongitude = this.parent.getMinLon();
        this.upperLongitude = this.parent.getMaxLon();
    }

    @Override
    public void load() {
        this.showGrid(this.buttonSelection, this.gridWidth, this.latLongLabelDisplay, this.gridDisplay, this.gridColor, this.backgroundColor, this.lowerLatitude, this.upperLatitude, this.lowerLongitude, this.upperLongitude);
    }

    private void createElement(Element stateEl) {
        Element propertyEl = stateEl.addElement("GraticuleGrid");
        propertyEl.addElement("gridChoice").addText(this.buttonSelection);
        propertyEl.addElement("gridWidth").addText(Double.toString(this.gridWidth));
        propertyEl.addElement("labels").addText(Boolean.toString(this.latLongLabelDisplay));
        propertyEl.addElement("display").addText(Boolean.toString(this.gridDisplay));
        propertyEl.addElement("gridColor").addText(Integer.toString(this.gridColor.getRGB()));
        propertyEl.addElement("backgroundColor").addText(Integer.toString(this.backgroundColor.getRGB()));
        propertyEl.addElement("lowLat").addText(Integer.toString(this.lowerLatitude));
        propertyEl.addElement("upLat").addText(Integer.toString(this.upperLatitude));
        propertyEl.addElement("lowLon").addText(Integer.toString(this.lowerLongitude));
        propertyEl.addElement("upLon").addText(Integer.toString(this.upperLongitude));
    }

    public void showGrid(String buttonSelection, double gridWidth, boolean labelDisplay, boolean gridDisplay, Color gridColor, Color backgroundColor, int lowerLatitude, int upperLatitude, int lowerLongitude, int upperLongitude) {
        ArrayList<GlobeBox> gb = this.parent.makeNewGrid(upperLatitude, lowerLatitude, lowerLongitude, upperLongitude, gridWidth);
        this.parent.makeGrids(gb, labelDisplay);
        this.parent.setGridColor2(gridColor);
        this.parent.setBackgroundColor(backgroundColor);
        this.parent.graphVisibilityOn();
        if (!gridDisplay) {
            this.parent.graphVisibilityOff();
        }
        this.parent.getCustomTextField().setEnabled(false);
        if (buttonSelection.equals("1.0 degrees")) {
            this.parent.getFirstSceneRadioButton().setSelected(true);
        } else if (buttonSelection.equals("0.1 degrees")) {
            this.parent.getSecondSceneRadioButton().setSelected(true);
        } else if (buttonSelection.equals("No Grid")) {
            this.parent.getNoneRadioButton().setSelected(true);
        } else {
            this.parent.getCustomRadioButton().setSelected(true);
            this.parent.getCustomTextField().setEnabled(true);
            this.parent.getCustomTextField().setText(Double.toString(gridWidth));
        }
        this.parent.setMaxLatField(upperLatitude);
        this.parent.setMinLatField(lowerLatitude);
        this.parent.setMaxLonField(upperLongitude);
        this.parent.setMinLonField(lowerLongitude);
        this.parent.setLabelsDisplayed(labelDisplay);
        this.parent.setGridWidth(gridWidth);
        Info.getMainGUI();
        MainGUI.updateRenderWindow();
    }

    @Override
    public void toXML(Element stateEl) {
        this.copyLatestCatalogDetails();
        this.createElement(stateEl);
    }

    @Override
    public void fromXML(Element stateEl) {
        Iterator i = stateEl.elementIterator("GraticuleGrid");
        while (i.hasNext()) {
            Element e = (Element)i.next();
            this.buttonSelection = e.elementText("gridChoice");
            this.gridWidth = Double.parseDouble(e.elementText("gridWidth"));
            this.latLongLabelDisplay = Boolean.parseBoolean(e.elementText("labels"));
            this.gridDisplay = Boolean.parseBoolean(e.elementText("display"));
            this.gridColor = new Color(Integer.parseInt(e.elementText("gridColor")));
            this.backgroundColor = new Color(Integer.parseInt(e.elementText("backgroundColor")));
            this.lowerLatitude = Integer.parseInt(e.elementText("lowLat"));
            this.upperLatitude = Integer.parseInt(e.elementText("upLat"));
            this.lowerLongitude = Integer.parseInt(e.elementText("lowLon"));
            this.upperLongitude = Integer.parseInt(e.elementText("upLon"));
        }
    }

    @Override
    public PluginState deepCopy() {
        GraticulePluginState state = new GraticulePluginState(this.parent);
        state.copyLatestCatalogDetails();
        return state;
    }
}

