/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.grid;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class GraticulePreset {
    private String name;
    private int lowerLatitude;
    private int upperLatitude;
    private int rightLongitude;
    private int leftLongitude;

    public GraticulePreset(int lowerLatitude, int upperLatitude, int lowerLongitude, int upperLongitude) {
        this.lowerLatitude = lowerLatitude;
        this.upperLatitude = upperLatitude;
        this.rightLongitude = lowerLongitude;
        this.leftLongitude = upperLongitude;
    }

    public GraticulePreset(File file) {
        this.load(file);
    }

    public GraticulePreset() {
    }

    public void load(File file) {
        try {
            this.name = file.getName().replace(".grat", "");
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while (reader.ready()) {
                StringTokenizer tokens;
                String line = reader.readLine();
                if (line.contains("upper-latitude")) {
                    tokens = new StringTokenizer(line, "=");
                    tokens.nextToken();
                    this.upperLatitude = Integer.valueOf(tokens.nextToken().trim());
                    continue;
                }
                if (line.contains("lower-latitude")) {
                    tokens = new StringTokenizer(line, "=");
                    tokens.nextToken();
                    this.lowerLatitude = Integer.valueOf(tokens.nextToken().trim());
                    continue;
                }
                if (line.contains("right-longitude")) {
                    tokens = new StringTokenizer(line, "=");
                    tokens.nextToken();
                    this.rightLongitude = Integer.valueOf(tokens.nextToken().trim());
                    continue;
                }
                if (!line.contains("left-longitude")) continue;
                tokens = new StringTokenizer(line, "=");
                tokens.nextToken();
                this.leftLongitude = Integer.valueOf(tokens.nextToken().trim());
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    public int getUpperLatitude() {
        return this.upperLatitude;
    }

    public int getLowerLatitude() {
        return this.lowerLatitude;
    }

    public int getRightLongitude() {
        return this.rightLongitude;
    }

    public int getLeftLongitude() {
        return this.leftLongitude;
    }

    public String getName() {
        return this.name;
    }
}

