/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.landmarks;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.DBFReaderJGeom;
import oracle.spatial.util.ShapefileReaderJGeom;
import org.scec.vtk.drawingTools.DisplayAttributes;
import org.scec.vtk.drawingTools.DrawingTool;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.PluginActors;
import org.scec.vtk.plugins.utils.components.CheckAllTable;
import org.scec.vtk.tools.Prefs;
import org.scec.vtk.tools.Transform;
import org.scec.vtk.tools.actors.AppendActors;
import vtk.vtkAbstractArray;
import vtk.vtkActor;
import vtk.vtkActor2D;
import vtk.vtkConeSource;
import vtk.vtkDataObject;
import vtk.vtkGlyph3D;
import vtk.vtkLabelPlacementMapper;
import vtk.vtkMapper;
import vtk.vtkMapper2D;
import vtk.vtkPointSetToLabelHierarchy;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;
import vtk.vtkStringArray;

public class LandmarksGUI {
    private static String dataPath;
    ArrayList<PresetLocationGroup> presetLocationGroups = new ArrayList();
    private String selectedInputFile;
    private DisplayAttributes displayAttributes;
    ArrayList<String> citypop = new ArrayList();
    ArrayList<String> landmarkNames;
    CheckAllTable landmarkGroupsTable;
    CheckAllTable landmarkTable;
    private JPanel landmarksMainPanel;
    Dimension dMainPanel;
    AppendActors appendActors = new AppendActors();
    MouseAdapter mouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            JTable target = (JTable)e.getSource();
            int row = target.getSelectedRow();
            int col = target.columnAtPoint(e.getPoint());
            if (e.getClickCount() == 2 || col == 2) {
                String string = (String)target.getValueAt(row, 1);
            }
        }
    };

    public LandmarksGUI(PluginActors pluginActors) {
        pluginActors.addActor((vtkProp)this.appendActors.getAppendedActor());
        this.landmarkNames = new ArrayList();
        this.landmarksMainPanel = new JPanel(new GridLayout(0, 1));
        this.parseTitles(dataPath);
        this.landmarkGroupsTable = new CheckAllTable(this.landmarkNames, "Landmarks");
        this.landmarksMainPanel.add(this.landmarkGroupsTable);
        this.dMainPanel = new Dimension(Prefs.getPluginWidth(), Prefs.getPluginHeight());
        this.landmarksMainPanel.setPreferredSize(this.dMainPanel);
    }

    public JPanel loadLandmarks() {
        return this.landmarksMainPanel;
    }

    private void parseTitles(String dataPath) {
        File dataDirectory = new File(dataPath);
        if (dataDirectory.isDirectory()) {
            File[] files = dataDirectory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if ((!files[i].isFile() || !files[i].getName().endsWith(".shp")) && (!files[i].getName().endsWith(".txt") || files[i].getName().equals("CA_Counties.txt") || files[i].getName().contains("popdensity.txt") || files[i].getName().contains("CA_Cities"))) continue;
                PresetLocationGroup group = new PresetLocationGroup();
                group.file = files[i];
                String tempName = files[i].getName();
                tempName = tempName.substring(0, tempName.lastIndexOf("."));
                group.name = tempName = tempName.replace('_', ' ');
                this.presetLocationGroups.add(group);
                this.landmarkNames.add(tempName);
            }
        }
    }

    public DrawingTool addDrawingTool(DrawingTool drawingTool, String text) {
        double[] pt = new double[]{Transform.calcRadius(37.0), 37.0, -120.0};
        if (drawingTool.getTextString() != null) {
            text = drawingTool.getTextString();
            drawingTool.setDisplayName(drawingTool.getTextString());
            pt[0] = pt[0] + drawingTool.getaltitude();
            pt[1] = drawingTool.getLatitude();
            pt[2] = drawingTool.getLongitude();
        }
        vtkStringArray labels = new vtkStringArray();
        labels.SetName("labels");
        labels.SetNumberOfValues(1L);
        labels.SetValue(0L, text);
        vtkPoints labelPoints = new vtkPoints();
        labelPoints.InsertNextPoint(Transform.customTransform(pt));
        vtkPolyData pinPolydata = new vtkPolyData();
        pinPolydata.SetPoints(labelPoints);
        vtkConeSource conePin = new vtkConeSource();
        conePin.SetRadius(3.0);
        conePin.SetHeight(10.0);
        conePin.SetDirection(-Transform.customTransform(pt)[0], -Transform.customTransform(pt)[1], -Transform.customTransform(pt)[2]);
        conePin.SetResolution(10);
        vtkGlyph3D glyphPoints = new vtkGlyph3D();
        glyphPoints.SetInputData((vtkDataObject)pinPolydata);
        glyphPoints.SetSourceConnection(conePin.GetOutputPort());
        vtkPolyDataMapper pm = new vtkPolyDataMapper();
        pm.SetInputConnection(glyphPoints.GetOutputPort());
        vtkPolyData temp = new vtkPolyData();
        temp.SetPoints(labelPoints);
        temp.GetPointData().AddArray((vtkAbstractArray)labels);
        vtkPointSetToLabelHierarchy pointSetToLabelHierarchyFilter = new vtkPointSetToLabelHierarchy();
        pointSetToLabelHierarchyFilter.SetInputData((vtkDataObject)temp);
        pointSetToLabelHierarchyFilter.GetTextProperty().SetJustificationToLeft();
        pointSetToLabelHierarchyFilter.SetLabelArrayName("labels");
        pointSetToLabelHierarchyFilter.Update();
        pointSetToLabelHierarchyFilter.GetTextProperty().SetFontSize(21);
        vtkLabelPlacementMapper cellMapper = new vtkLabelPlacementMapper();
        cellMapper.SetInputConnection(pointSetToLabelHierarchyFilter.GetOutputPort());
        vtkActor2D actor = new vtkActor2D();
        actor.SetMapper((vtkMapper2D)cellMapper);
        vtkActor actorPin = new vtkActor();
        actorPin.SetMapper((vtkMapper)pm);
        if (drawingTool.getTextString() == null) {
            drawingTool = new DrawingTool(pt[1], pt[2], pt[0], text, null, Color.white, actorPin, actor);
            drawingTool.setDisplayName(text + " -");
        } else {
            drawingTool.setActors(actorPin, actor);
        }
        this.appendActors.addToAppendedPolyData((vtkProp)actorPin);
        this.appendActors.addToAppendedPolyData((vtkProp)actor);
        this.appendActors.getAppendedActor().Modified();
        HashMap<String, String> locData = new HashMap<String, String>();
        locData.put("Lat", String.format("%.1f", pt[1]));
        locData.put("Lon", String.format("%.1f", pt[2]));
        locData.put("Alt", "0");
        locData.put("pinH", "10");
        locData.put("pinR", "3");
        locData.put("fontSize", "21");
        drawingTool.setAttributes(locData);
        return drawingTool;
    }

    private void addBuiltInFiles(Vector<DrawingTool> locations) {
        for (int i = 0; i < locations.size(); ++i) {
            DrawingTool tempLocation = locations.get(i);
            this.addDrawingTool(tempLocation, "Text");
        }
        Info.getMainGUI();
        MainGUI.updateRenderWindow();
    }

    private Vector<DrawingTool> loadBuiltInFiles(String selectedInputFile) {
        String selectedDbfFile = selectedInputFile.replace(".shp", ".dbf");
        File dbf = new File(selectedDbfFile);
        if (dbf.exists()) {
            Vector<DrawingTool> locations = new Vector<DrawingTool>();
            try {
                DBFReaderJGeom dbfFile = new DBFReaderJGeom(selectedDbfFile);
                int nameColumn = 0;
                int fieldsCount = dbfFile.numFields();
                for (int i = 0; i < fieldsCount; ++i) {
                    String fieldName = dbfFile.getFieldName(i);
                    if (!fieldName.equalsIgnoreCase("Name_1") && !fieldName.equalsIgnoreCase("NameLSAD") && !fieldName.equalsIgnoreCase("FULLNAME")) continue;
                    nameColumn = i;
                }
                ShapefileReaderJGeom shpFile = new ShapefileReaderJGeom(selectedInputFile);
                int pointCount = shpFile.numRecords();
                for (int index = 0; index < pointCount; ++index) {
                    byte[] geometryBytes = shpFile.getGeometryBytes(index);
                    JGeometry point = ShapefileReaderJGeom.getGeometry((byte[])geometryBytes, (int)index);
                    double[] coordinates = point.getPoint();
                    byte[] record = dbfFile.getRecord(index);
                    String textStr = dbfFile.getFieldData(nameColumn, record);
                    DrawingTool tempLocation = new DrawingTool(coordinates[1], coordinates[0], 0.0, textStr, this.displayAttributes, Color.white, null, null);
                    locations.addElement(tempLocation);
                    tempLocation.setSourceFile(selectedInputFile);
                }
                return locations;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Vector<DrawingTool> locations = new Vector<DrawingTool>();
            try {
                ShapefileReaderJGeom shpFile = new ShapefileReaderJGeom(selectedInputFile);
                int pointCount = shpFile.numRecords();
                for (int index = 0; index < pointCount; ++index) {
                    byte[] geometryBytes = shpFile.getGeometryBytes(index);
                    JGeometry point = ShapefileReaderJGeom.getGeometry((byte[])geometryBytes, (int)index);
                    double[] coordinates = point.getPoint();
                    DrawingTool tempLocation = new DrawingTool(coordinates[1], coordinates[0], 0.0, "", this.displayAttributes, Color.white, null, null);
                    locations.addElement(tempLocation);
                    tempLocation.setSourceFile(selectedInputFile);
                }
                return locations;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static {
        Info.getMainGUI();
        dataPath = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + "GISLocationPlugin" + File.separator;
    }

    private class PresetLocationGroup {
        public Vector<DrawingTool> locations = null;
        public String name = null;
        public File file = null;
        public JCheckBox checkbox = null;

        private PresetLocationGroup() {
        }
    }
}

