/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.main;

import com.google.common.base.Preconditions;
import com.jogamp.opengl.awt.GLJPanel;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.apache.log4j.Logger;
import org.scec.vtk.commons.legend.LegendItem;
import org.scec.vtk.grid.ViewRange;
import org.scec.vtk.main.Help;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainMenu;
import org.scec.vtk.main.Wizard;
import org.scec.vtk.plugins.Plugin;
import org.scec.vtk.plugins.PluginActors;
import org.scec.vtk.plugins.PluginActorsChangeListener;
import org.scec.vtk.plugins.PluginInfo;
import org.scec.vtk.politicalBoundaries.PoliticalBoundariesGUI;
import org.scec.vtk.timeline.Timeline;
import org.scec.vtk.timeline.gui.TimelineGUI;
import org.scec.vtk.tools.Prefs;
import org.scec.vtk.tools.picking.PickEnabledActor;
import org.scec.vtk.tools.plugins.Plugins;
import vtk.rendering.jogl.vtkJoglPanelComponent;
import vtk.vtkActor;
import vtk.vtkCamera;
import vtk.vtkCellPicker;
import vtk.vtkMapper;
import vtk.vtkNativeLibrary;
import vtk.vtkObject;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;
import vtk.vtkSphereSource;

public class MainGUI
extends JFrame
implements ChangeListener,
PluginActorsChangeListener {
    private final int BORDER_SIZE = 10;
    private static vtkJoglPanelComponent renderWindow;
    public static JTabbedPane pluginTabPane;
    public JPanel mainPanel;
    public JFrame wizFrame;
    public JFrame helpFrame;
    private Dimension canvasSize = new Dimension();
    private int xCenter = 5;
    private int yCenter = 5;
    private ViewRange viewRange;
    private static final Logger log;
    public Map<String, String> tabMap = new HashMap<String, String>();
    private static File getCWD;
    public MainMenu mainMenu;
    private JPanel pluginGUIPanel;
    private JPanel helpPanel;
    private JScrollPane pluginGUIScrollPane;
    private JSplitPane pluginSplitPane;
    private int xeBorder = 0;
    private int ysBorder = 0;
    private vtkActor tempGlobeScene = new vtkActor();
    private boolean gridDisplay = true;
    public Timeline timeline;
    private TimelineGUI timelineGUI;
    private JTextField searchBar;
    private JPanel searchBarGUI;
    private JToolBar toolBar;
    private JPanel toolBarGUI;
    static double[] camCord;
    private vtkActor focalPointActor = new vtkActor();
    private ArrayList<PluginActorsChangeListener> actorsChangeListeners = new ArrayList();
    vtkCamera cam = new vtkCamera();
    final Color selectedTabColor = new Color(239, 239, 239);
    final Color tabBackgroundColor = Color.LIGHT_GRAY;
    final Color tabBorderColor = Color.LIGHT_GRAY;
    BasicTabbedPaneUI tabbedPaneUI = new BasicTabbedPaneUI(){
        private final Insets borderInsets = new Insets(-5, 0, 0, 0);

        @Override
        protected Insets getContentBorderInsets(int tabPlacement) {
            return this.borderInsets;
        }

        @Override
        protected Insets getTabInsets(int tabPlacement, int tabIndex) {
            return new Insets(3, 6, 3, 6);
        }

        @Override
        protected Insets getTabAreaInsets(int tabPlacement) {
            return new Insets(5, 5, 5, 5);
        }

        @Override
        protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        }

        @Override
        protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        }

        @Override
        protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        }

        @Override
        protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
            super.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
            Rectangle selRect = this.getTabBounds(selectedIndex, this.calcRect);
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setColor(Color.cyan);
            g2.drawLine(selRect.x - 2, y, selRect.x + selRect.width + 2, y);
            g2.dispose();
        }

        @Override
        protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int a = isSelected ? 0 : 1;
            GeneralPath shape = new GeneralPath();
            shape.moveTo(x - 3, y + h);
            shape.lineTo(x + 3, y + a);
            shape.lineTo(x + w - 3, y + a);
            shape.lineTo(x + w + 3, y + h);
            shape.closePath();
            g2.setColor(isSelected ? MainGUI.this.selectedTabColor : MainGUI.this.tabBackgroundColor);
            g2.fill(shape);
            GeneralPath border = new GeneralPath();
            if (isSelected || tabIndex == 0) {
                border.moveTo(x - 3, y + h - 1);
            } else {
                border.moveTo(x + 3, y + h - 1);
                border.lineTo(x, (y + h - 1) / 2);
            }
            border.lineTo(x + 3, y + a);
            border.lineTo(x + w - 3, y + a);
            border.lineTo(x + w + 3, y + h - 1);
            g2.setColor(MainGUI.this.tabBorderColor);
            g2.draw(border);
            g2.dispose();
        }
    };
    private MenuShiftDetector shiftDetector = new MenuShiftDetector();
    private Dimension targetDims;

    public MainGUI() {
        Prefs.init();
        renderWindow = new vtkJoglPanelComponent();
        this.mainPanel = new JPanel(new BorderLayout());
        renderWindow.getRenderer().SetBackground(0.0, 0.0, 0.0);
        this.mainMenu = new MainMenu();
        this.pluginGUIPanel = new JPanel(new BorderLayout());
        this.helpPanel = new JPanel();
        this.helpPanel.setBorder(new EmptyBorder(10, 30, 10, 30));
        this.helpPanel.setLayout(new FlowLayout());
        JButton helpButton = new JButton();
        try {
            helpButton.setToolTipText("Help");
            File file = new File("resources/question3.png");
            Image img = ImageIO.read(file);
            img = img.getScaledInstance(32, 32, 4);
            helpButton.setIcon(new ImageIcon(img));
        }
        catch (IOException ex) {
            System.out.println("help: " + String.valueOf(ex));
        }
        helpButton.setBackground(Color.black);
        helpButton.setOpaque(false);
        this.helpPanel.add(helpButton);
        this.helpPanel.setOpaque(false);
        this.pluginGUIPanel.add((Component)this.helpPanel, "Last");
        this.pluginGUIPanel.setBorder(BorderFactory.createEmptyBorder());
        this.mainPanel.setOpaque(true);
        this.mainPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.pluginGUIPanel.setOpaque(true);
        this.pluginGUIPanel.setBorder(new EmptyBorder(2, 0, 0, 0));
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Help help = new Help();
            }
        });
        pluginTabPane = new JTabbedPane();
        pluginTabPane.setUI(this.tabbedPaneUI);
        Info.setMainGUI(this);
        this.setUpPluginTabs();
        this.setUpToolBar();
        this.pluginSplitPane = new JSplitPane(1, false, this.mainPanel, this.pluginGUIScrollPane);
        this.pluginSplitPane.setOneTouchExpandable(false);
        this.pluginSplitPane.setBorder(BorderFactory.createEmptyBorder());
        this.pluginSplitPane.setResizeWeight(1.0);
        this.pluginSplitPane.setDividerLocation(0.5);
        Dimension d = new Dimension(Prefs.getPluginWidth(), Prefs.getPluginHeight());
        this.pluginGUIScrollPane.setMinimumSize(d);
        this.pluginGUIScrollPane.setPreferredSize(d);
        pluginTabPane.setOpaque(true);
        Dimension minimumSize = new Dimension(100, 50);
        this.mainPanel.setMinimumSize(minimumSize);
        ((GLJPanel)renderWindow.getComponent()).setMinimumSize(new Dimension(Prefs.getMainWidth(), Prefs.getMainHeight()));
        this.timeline = new Timeline();
        this.timelineGUI = new TimelineGUI(this.timeline);
        this.mainMenu.setupTimeline(this.timeline, this.timelineGUI);
        this.cam.SetPosition(camCord[0], camCord[1], camCord[2]);
        this.cam.SetFocalPoint(camCord[3], camCord[4], camCord[5]);
        this.cam.SetViewUp(camCord[6], camCord[7], camCord[8]);
        vtkSphereSource focalPoint = new vtkSphereSource();
        focalPoint.SetRadius(20.0);
        vtkPolyDataMapper focalPointMapper = new vtkPolyDataMapper();
        focalPointMapper.SetInputConnection(focalPoint.GetOutputPort());
        this.focalPointActor.SetMapper((vtkMapper)focalPointMapper);
        renderWindow.getRenderer().AddActor((vtkProp)this.focalPointActor);
        this.focalPointActor.VisibilityOff();
        renderWindow.getRenderer().SetActiveCamera(this.cam);
        renderWindow.getRenderer().ResetCameraClippingRange();
        this.focalPointActor.SetPosition(renderWindow.getRenderer().GetActiveCamera().GetFocalPoint());
        this.focalPointActor.Modified();
        ((GLJPanel)renderWindow.getComponent()).setFocusable(true);
        ((GLJPanel)renderWindow.getComponent()).addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                renderWindow.getRenderer().Render();
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27 && renderWindow.getRenderer().GetViewProps().IsItemPresent((vtkObject)PoliticalBoundariesGUI.mainFocusReginActor) != 0) {
                    renderWindow.getRenderer().GetActiveCamera().SetPosition(camCord[0], camCord[1], camCord[2]);
                    renderWindow.getRenderer().GetActiveCamera().SetFocalPoint(camCord[3], camCord[4], camCord[5]);
                    renderWindow.getRenderer().GetActiveCamera().SetViewUp(camCord[6], camCord[7], camCord[8]);
                    renderWindow.getRenderer().ResetCameraClippingRange();
                    ((GLJPanel)renderWindow.getComponent()).repaint();
                }
            }
        });
        JLabel label = new JLabel(" ", 4);
        final vtkCellPicker cellPicker = new vtkCellPicker();
        cellPicker.SetTolerance(0.001);
        boolean clickDebug = false;
        ((GLJPanel)renderWindow.getComponent()).addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (MainGUI.this.focalPointActor.GetVisibility() == 1) {
                    MainGUI.this.updateFocalPointLocation();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ((GLJPanel)renderWindow.getComponent()).requestFocus();
                int[] clickPos = renderWindow.getRenderWindowInteractor().GetEventPosition();
                int height = ((GLJPanel)renderWindow.getComponent()).getHeight();
                int calcY = height - e.getY() - 1;
                int x = clickPos[0];
                int y = clickPos[1];
                cellPicker.Pick((double)x, (double)y, 0.0, renderWindow.getRenderer());
                if (cellPicker.GetActor() instanceof PickEnabledActor) {
                    PickEnabledActor actor = (PickEnabledActor)cellPicker.GetActor();
                    actor.picked(cellPicker, e);
                }
            }
        });
        this.mainPanel.add(renderWindow.getComponent(), "Center");
        try {
            this.mainMenu.availablePlugins = Plugins.getAvailablePlugins();
            this.mainMenu.setupPluginMenus();
            this.addDefaultActors();
            this.setMainFrame();
            this.pluginSplitPane.setDividerLocation(this.getWidth() - MainGUI.pluginTabPane.getPreferredSize().width - 60);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to get available plugins", ioe);
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (MainGUI.this.targetDims != null) {
                    System.out.println("Resized! " + MainGUI.this.getWidth() + "x" + MainGUI.this.getHeight());
                    if (MainGUI.this.targetDims.getWidth() != (double)MainGUI.this.getWidth() || MainGUI.this.targetDims.getHeight() != (double)MainGUI.this.getHeight()) {
                        JOptionPane.showMessageDialog(Info.getMainGUI(), "Screen is not large enough for selected resolution. Select a lower resolution and try agin.\nYou can still render movies larger than screen resolution using the render settings dialog.", "Coundn't Resize Window", 0);
                    }
                    MainGUI.this.targetDims = null;
                }
            }
        });
        if (MainMenu.Wizard.booleanValue()) {
            this.wizFrame = new JFrame();
            Wizard wizGui = new Wizard(this.mainMenu, this);
            this.wizFrame.getContentPane().add(wizGui);
            this.wizFrame.setSize(550, 140);
            this.wizFrame.setLocationRelativeTo(null);
            this.wizFrame.setVisible(true);
        }
    }

    public void setFocalPointVisible(boolean visible) {
        int curVis;
        int newVis = visible ? 1 : 0;
        if (newVis != (curVis = this.focalPointActor.GetVisibility())) {
            this.focalPointActor.SetVisibility(newVis);
            if (visible) {
                this.updateFocalPointLocation();
            }
            MainGUI.updateRenderWindow();
            ((GLJPanel)renderWindow.getComponent()).repaint();
        }
    }

    public void updateFocalPointLocation() {
        this.focalPointActor.SetPosition(renderWindow.getRenderer().GetActiveCamera().GetFocalPoint());
        this.focalPointActor.Modified();
    }

    public TimelineGUI getTimelineGUI() {
        return this.timelineGUI;
    }

    public Timeline getTimeline() {
        return this.timeline;
    }

    public static File getRootPluginDir() {
        return new File(String.valueOf(MainGUI.getCWD()) + File.separator + "data");
    }

    public static File getCWD() {
        if (getCWD == null) {
            getCWD = new File(System.getProperty("user.dir"));
        }
        return getCWD;
    }

    private void addDefaultActors() {
        vtkActor blankActor = new vtkActor();
        renderWindow.getRenderer().AddActor((vtkProp)blankActor);
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<PluginInfo> pluginInfo = new ArrayList<PluginInfo>();
        ids.add("org.scec.vdo.politicalBoundaries");
        pluginInfo.add(new PluginInfo());
        ((PluginInfo)pluginInfo.get(0)).setId((String)ids.get(0));
        ((PluginInfo)pluginInfo.get(0)).setName("Political Boundaries");
        ((PluginInfo)pluginInfo.get(0)).setShortName("Political Boundaries");
        ((PluginInfo)pluginInfo.get(0)).setPluginClass("org.scec.vtk.politicalBoundaries.PoliticalBoundariesPlugin");
        this.mainMenu.availablePlugins.put((String)ids.get(0), (PluginInfo)pluginInfo.get(0));
        this.mainMenu.activatePlugin((String)ids.get(0));
        ids.add("org.scec.vdo.graticulePlugin");
        pluginInfo.add(new PluginInfo());
        ((PluginInfo)pluginInfo.get(1)).setId((String)ids.get(1));
        ((PluginInfo)pluginInfo.get(1)).setName("Graticule");
        ((PluginInfo)pluginInfo.get(1)).setShortName("Graticule");
        ((PluginInfo)pluginInfo.get(1)).setPluginClass("org.scec.vtk.grid.GraticulePlugin");
        this.mainMenu.availablePlugins.put((String)ids.get(1), (PluginInfo)pluginInfo.get(1));
        this.mainMenu.activatePlugin((String)ids.get(1));
        ids.add("org.scec.vdo.drawingToolsPlugin");
        pluginInfo.add(new PluginInfo());
        ((PluginInfo)pluginInfo.get(2)).setId((String)ids.get(2));
        ((PluginInfo)pluginInfo.get(2)).setName("Drawing Tools");
        ((PluginInfo)pluginInfo.get(2)).setShortName("Drawing Tools");
        ((PluginInfo)pluginInfo.get(2)).setPluginClass("org.scec.vtk.drawingTools.DrawingToolsPlugin");
        this.mainMenu.availablePlugins.put((String)ids.get(2), (PluginInfo)pluginInfo.get(2));
        this.mainMenu.activatePlugin((String)ids.get(2));
        pluginTabPane.setSelectedIndex(0);
    }

    public boolean getGridDisplayBool() {
        return this.gridDisplay;
    }

    public vtkActor getGrid() {
        return this.tempGlobeScene;
    }

    private void setUpToolBar() {
        this.toolBar = new JToolBar();
        JButton centerImage = new JButton();
        try {
            centerImage.setToolTipText("Center Image");
            File file = new File("resources/Center.png");
            Image img = ImageIO.read(file);
            img = img.getScaledInstance(15, 15, 1);
            centerImage.setIcon(new ImageIcon(img));
        }
        catch (IOException ex) {
            System.out.println("centerImage: " + String.valueOf(ex));
        }
        centerImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                renderWindow.getRenderer().GetActiveCamera().SetPosition(camCord[0], camCord[1], camCord[2]);
                renderWindow.getRenderer().GetActiveCamera().SetFocalPoint(camCord[3], camCord[4], camCord[5]);
                renderWindow.getRenderer().GetActiveCamera().SetViewUp(camCord[6], camCord[7], camCord[8]);
                renderWindow.getRenderer().ResetCameraClippingRange();
                ((GLJPanel)renderWindow.getComponent()).repaint();
            }
        });
        centerImage.setOpaque(false);
        centerImage.setToolTipText("Center");
        JButton focalPoint = new JButton();
        try {
            focalPoint.setToolTipText("Focal Point");
            File file = new File("resources/FocalPointIcon.png");
            Image img = ImageIO.read(file);
            img = img.getScaledInstance(15, 15, 1);
            focalPoint.setIcon(new ImageIcon(img));
        }
        catch (IOException ex) {
            System.out.println("focal point: " + String.valueOf(ex));
        }
        focalPoint.addActionListener(new ActionListener(){
            boolean on = false;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!this.on) {
                    Info.getMainGUI().setFocalPointVisible(true);
                    this.on = true;
                } else if (this.on) {
                    Info.getMainGUI().setFocalPointVisible(false);
                    this.on = false;
                }
            }
        });
        focalPoint.setOpaque(false);
        focalPoint.setToolTipText("Focal Point");
        JButton zoomIn = new JButton();
        try {
            zoomIn.setToolTipText("Zoom In");
            zoomIn.setOpaque(false);
            File file = new File("resources/zoomIn.png");
            Image img = ImageIO.read(file);
            img = img.getScaledInstance(15, 15, 1);
            zoomIn.setIcon(new ImageIcon(img));
        }
        catch (IOException ex) {
            System.out.println("zoomIn: " + String.valueOf(ex));
        }
        zoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGUI.this.cam.Zoom(1.2);
                renderWindow.getRenderer().ResetCameraClippingRange();
                ((GLJPanel)renderWindow.getComponent()).repaint();
            }
        });
        zoomIn.setToolTipText("Zoom In");
        JButton zoomOut = new JButton();
        try {
            zoomOut.setToolTipText("Zoom Out");
            zoomOut.setOpaque(false);
            File file = new File("resources/zoomOut.png");
            Image img = ImageIO.read(file);
            img = img.getScaledInstance(15, 15, 1);
            zoomOut.setIcon(new ImageIcon(img));
        }
        catch (IOException ex) {
            System.out.println("zoomOut: " + String.valueOf(ex));
        }
        zoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGUI.this.cam.Zoom(0.8);
                renderWindow.getRenderer().ResetCameraClippingRange();
                ((GLJPanel)renderWindow.getComponent()).repaint();
            }
        });
        zoomOut.setToolTipText("Zoom Out");
        JButton save = new JButton();
        try {
            save.setToolTipText("Save file");
            save.setOpaque(false);
            File file = new File("resources/save.png");
            Image img = ImageIO.read(file);
            img = img.getScaledInstance(15, 15, 1);
            save.setIcon(new ImageIcon(img));
        }
        catch (IOException ex) {
            System.out.println("zoomOut: " + String.valueOf(ex));
        }
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainGUI.this.mainMenu.isSaved().booleanValue()) {
                    System.out.println("autoSave()");
                    MainGUI.this.mainMenu.autoSave();
                } else {
                    System.out.println("saveForToolbar");
                    MainGUI.this.mainMenu.saveForToolbar();
                }
            }
        });
        save.setToolTipText("Save");
        JButton open = new JButton();
        try {
            open.setToolTipText("Open a file");
            open.setOpaque(false);
            File file = new File("resources/open.png");
            Image img = ImageIO.read(file);
            img = img.getScaledInstance(15, 15, 1);
            open.setIcon(new ImageIcon(img));
        }
        catch (IOException ex) {
            System.out.println("zoomOut: " + String.valueOf(ex));
        }
        open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGUI.this.mainMenu.openForToolbar();
            }
        });
        open.setToolTipText("Open");
        this.toolBar.add(centerImage);
        this.toolBar.add(zoomIn);
        this.toolBar.add(zoomOut);
        this.toolBar.add(save);
        this.toolBar.add(open);
        this.toolBar.add(focalPoint);
        this.toolBar.setOpaque(false);
        this.toolBarGUI = new JPanel(new BorderLayout());
        this.toolBarGUI.add((Component)this.toolBar, "Center");
        this.toolBarGUI.setOpaque(false);
        this.toolBarGUI.setBorder(new EmptyBorder(5, 0, 1, 0));
        this.mainPanel.add((Component)this.toolBarGUI, "First");
    }

    private void setUpSearchBar() {
        this.searchBar = new JTextField();
        this.searchBarGUI = new JPanel(new BorderLayout());
        this.searchBarGUI.add((Component)this.searchBar, "Center");
        this.pluginGUIPanel.add((Component)this.searchBarGUI, "Last");
    }

    private void setUpPluginTabs() {
        this.pluginGUIPanel.add((Component)pluginTabPane, "First");
        pluginTabPane.addChangeListener(this);
        pluginTabPane.setBorder(BorderFactory.createEmptyBorder());
        this.pluginGUIScrollPane = new JScrollPane(this.pluginGUIPanel);
        this.pluginGUIScrollPane.setBorder(BorderFactory.createEmptyBorder());
    }

    private void setMainFrame() {
        this.setTitle("SCEC VDO VTK");
        this.setJMenuBar(this.mainMenu.getMenuBar());
        this.setDefaultCloseOperation(3);
        this.setSize(new Dimension(Prefs.getTotalWidth(), Prefs.getMainHeight()));
        this.setContentPane(this.pluginSplitPane);
        this.pluginSplitPane.setDividerSize(0);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public JPanel getmainFrame() {
        return this.mainPanel;
    }

    public void setViewRange(ViewRange viewRange) {
        this.viewRange = viewRange;
    }

    public ViewRange getViewRange() {
        return this.viewRange;
    }

    public void addPluginGUI(String id, String title, JComponent gui) {
        if (pluginTabPane.indexOfTab(title) != -1) {
            return;
        }
        if (!this.mainMenu.isPluginActive(id) && id != "org.scec.vdo.politicalBoundaries" && id != "org.scec.vdo.graticulePlugin" && id != "org.scec.vdo.drawingToolsPlugin" && id != "org.scec.vdo.landmarksPlugin") {
            log.debug((Object)("Cannot add gui for inactive plugin " + id));
            return;
        }
        this.tabMap.put(id, title);
        this.isPluginGuiShowing();
        JPanel allPanel = new JPanel();
        allPanel.setLayout(new BoxLayout(allPanel, 3));
        allPanel.setBorder(BorderFactory.createEmptyBorder());
        allPanel.add(gui);
        allPanel.setOpaque(true);
        allPanel.setFocusable(false);
        allPanel.add(Box.createVerticalGlue());
        JScrollPane pluginTab = new JScrollPane(allPanel);
        pluginTab.setVerticalScrollBarPolicy(21);
        pluginTab.setBorder(BorderFactory.createEmptyBorder());
        pluginTab.setName(id);
        pluginTab.setOpaque(true);
        pluginTab.setBackground(Color.black);
        pluginTabPane.addTab(title, pluginTab);
        if (id != "org.scec.vdo.politicalBoundaries" && id != "org.scec.vdo.graticulePlugin" && id != "org.scec.vdo.drawingToolsPlugin" && id != "org.scec.vdo.landmarksPlugin") {
            pluginTabPane.setTabComponentAt(pluginTabPane.getTabCount() - 1, new ButtonTabComponent(pluginTabPane, id));
        } else {
            pluginTabPane.setTabComponentAt(pluginTabPane.getTabCount() - 1, null);
        }
        pluginTabPane.setSelectedIndex(pluginTabPane.indexOfComponent(pluginTab));
        SwingUtilities.updateComponentTreeUI(this);
        pluginTabPane.setUI(this.tabbedPaneUI);
        pluginTabPane.repaint();
    }

    public boolean removePluginGUI(String id) {
        if (!this.mainMenu.isPluginActive(id)) {
            log.warn((Object)("Cannot remove GUI for inactive plugin " + id));
            return false;
        }
        boolean removed = false;
        this.isPluginGuiShowing();
        for (int j = 0; j < pluginTabPane.getTabCount(); ++j) {
            Component c = pluginTabPane.getComponentAt(j);
            if (c.getName() == null || !c.getName().equals(id)) continue;
            pluginTabPane.removeTabAt(j);
            if (pluginTabPane.getTabCount() == 0) {
                this.updateCanvasSize();
                SwingUtilities.updateComponentTreeUI(this);
            }
            removed = true;
        }
        return removed;
    }

    private boolean isPluginGuiShowing() {
        return pluginTabPane.getTabCount() > 0;
    }

    public static void updateRenderWindow(vtkActor actor) {
        renderWindow.Render();
        renderWindow.getRenderer().ResetCamera(actor.GetBounds());
    }

    public static void updateRenderWindow() {
        renderWindow.Render();
        ((GLJPanel)renderWindow.getComponent()).repaint();
    }

    public static vtkJoglPanelComponent getRenderWindow() {
        return renderWindow;
    }

    public void removeSplitPane() {
        this.remove(this.pluginSplitPane);
        this.pluginSplitPane = null;
        this.setContentPane(this.mainPanel);
        this.updateCanvasSize();
        SwingUtilities.updateComponentTreeUI(this);
    }

    public void updateCanvasSize() {
        this.canvasSize = this.getSize();
        this.xCenter = (int)this.canvasSize.getWidth() / 2;
        this.yCenter = (int)this.canvasSize.getHeight() / 2;
        this.xeBorder = (int)this.canvasSize.getWidth() - 10;
        this.ysBorder = (int)this.canvasSize.getHeight() - 10;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (!(source instanceof JTabbedPane)) {
            log.warn((Object)("Event source was not a JTabbedPane!: " + source.getClass().getName()));
            return;
        }
        JTabbedPane pane = (JTabbedPane)source;
        Component c = pane.getSelectedComponent();
        if (c == null) {
            return;
        }
        String selectedPlugin = c.getName();
    }

    @Override
    public void actorAdded(vtkProp actor) {
        renderWindow.getRenderer().AddActor(actor);
        for (PluginActorsChangeListener l : this.actorsChangeListeners) {
            l.actorAdded(actor);
        }
    }

    @Override
    public void actorRemoved(vtkProp actor) {
        renderWindow.getRenderer().RemoveActor(actor);
        for (PluginActorsChangeListener l : this.actorsChangeListeners) {
            l.actorRemoved(actor);
        }
    }

    @Override
    public void legendAdded(LegendItem legend) {
        renderWindow.getRenderer().AddActor((vtkProp)legend.getActor());
        for (PluginActorsChangeListener l : this.actorsChangeListeners) {
            l.legendAdded(legend);
        }
    }

    @Override
    public void legendRemoved(LegendItem legend) {
        renderWindow.getRenderer().RemoveActor((vtkProp)legend.getActor());
        for (PluginActorsChangeListener l : this.actorsChangeListeners) {
            l.legendRemoved(legend);
        }
    }

    public void addPluginActorsChangeListener(PluginActorsChangeListener listener) {
        this.actorsChangeListeners.add(listener);
    }

    public void removePluginActorsChangeListener(PluginActorsChangeListener listener) {
        this.actorsChangeListeners.remove(listener);
    }

    public List<LegendItem> getDisplayedLegends() {
        ArrayList<LegendItem> currentLegends = new ArrayList<LegendItem>();
        for (PluginActors actors : this.mainMenu.getActivatedPluginActors()) {
            currentLegends.addAll(actors.getLegends());
        }
        return currentLegends;
    }

    public void resizeViewer(int width, int height) {
        JComponent comp = (JComponent)renderWindow.getComponent();
        int curWindowWidth = this.getWidth();
        int curWindowHeight = this.getHeight();
        int curViewerWidth = comp.getWidth();
        int curViewerHeight = comp.getHeight();
        Preconditions.checkState((curWindowHeight > curViewerHeight ? 1 : 0) != 0);
        Preconditions.checkState((curWindowWidth > curViewerWidth ? 1 : 0) != 0);
        int widthBuffer = curWindowWidth - curViewerWidth;
        int heightBuffer = curWindowHeight - curViewerHeight;
        int newWindowWidth = width + widthBuffer;
        int newWindowHeight = height + heightBuffer;
        System.out.println("Resiging viewer to " + width + "x" + height + ". Current: " + curViewerWidth + "x" + curViewerHeight + ". Buffer: " + widthBuffer + "x" + heightBuffer);
        this.setSize(newWindowWidth, newWindowHeight);
        comp.setSize(width, height);
        MainGUI.updateRenderWindow();
        int newViewerWidth = comp.getWidth();
        int newViewerHeight = comp.getHeight();
        System.out.println("Resized. New dims: " + newViewerWidth + "x" + newViewerHeight);
        this.targetDims = new Dimension(newWindowWidth, newWindowHeight);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        UIManager.put("Menu.border", BorderFactory.createEmptyBorder(2, 4, 2, 4));
        UIManager.put("MenuBar.border", BorderFactory.createEmptyBorder(1, 3, 2, 3));
        UIManager.put("MenuItem.border", BorderFactory.createEmptyBorder(2, 4, 2, 4));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MainGUI();
            }
        });
    }

    static {
        log = Logger.getLogger(MainGUI.class);
        if (!vtkNativeLibrary.LoadAllNativeLibraries()) {
            for (vtkNativeLibrary lib : vtkNativeLibrary.values()) {
                if (lib.IsLoaded()) continue;
                System.out.println(lib.GetLibraryName() + " not loaded");
            }
        }
        vtkNativeLibrary.DisableOutputWindow(null);
        camCord = new double[]{7513.266063258975, -4588.568400980608, 6246.237592377226, 4375.8873291015625, -2496.9269409179688, 3859.8922119140625, -0.45792813113264974, 0.276911132961531, 0.8447615350850914};
    }

    private class MenuShiftDetector
    implements MenuKeyListener,
    MouseListener {
        private boolean shiftDown = false;

        @Override
        public void menuKeyTyped(MenuKeyEvent e) {
        }

        @Override
        public void menuKeyPressed(MenuKeyEvent e) {
            this.shiftDown = e.isShiftDown();
        }

        @Override
        public void menuKeyReleased(MenuKeyEvent e) {
            this.shiftDown = e.isShiftDown();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.shiftDown = e.isShiftDown();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.shiftDown = e.isShiftDown();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.shiftDown = e.isShiftDown();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.shiftDown = e.isShiftDown();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.shiftDown = e.isShiftDown();
        }
    }

    public class ButtonTabComponent
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final JTabbedPane pane;
        private String pluginID;
        private Icon icon;
        private Icon redIcon;
        private final MouseListener buttonMouseListener;

        public ButtonTabComponent(final JTabbedPane pane, String id) {
            super(new FlowLayout(2, 0, 0));
            this.icon = new ImageIcon("data/MiscImages/closeTabButton.png");
            this.redIcon = new ImageIcon("data/MiscImages/closeTabButtonRed_1.png");
            this.buttonMouseListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    Component component = e.getComponent();
                    if (component instanceof AbstractButton) {
                        AbstractButton button = (AbstractButton)component;
                        button.setIcon(ButtonTabComponent.this.redIcon);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    Component component = e.getComponent();
                    if (component instanceof AbstractButton) {
                        AbstractButton button = (AbstractButton)component;
                        button.setIcon(ButtonTabComponent.this.icon);
                    }
                }
            };
            if (pane == null) {
                throw new NullPointerException("TabbedPane is null");
            }
            this.pane = pane;
            this.setOpaque(false);
            this.pluginID = id;
            JLabel label = new JLabel(){

                @Override
                public String getText() {
                    int i = pane.indexOfTabComponent(ButtonTabComponent.this);
                    if (i != -1) {
                        return pane.getTitleAt(i);
                    }
                    return null;
                }
            };
            this.add(label);
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            TabButton button = new TabButton();
            this.add(button);
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }

        private class TabButton
        extends JButton
        implements ActionListener {
            private static final long serialVersionUID = 1L;

            public TabButton() {
                int size = 13;
                this.setPreferredSize(new Dimension(size, size));
                this.setToolTipText("close this tab");
                this.setUI(new BasicButtonUI());
                this.setContentAreaFilled(false);
                this.setFocusable(false);
                this.setBorder(BorderFactory.createEtchedBorder());
                this.setBorderPainted(false);
                this.setIcon(ButtonTabComponent.this.icon);
                this.setRolloverEnabled(true);
                this.addMouseListener(ButtonTabComponent.this.buttonMouseListener);
                this.addActionListener(this);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Map<String, Plugin> loadedPlugins = MainGUI.this.mainMenu.getLoadedPluginsAsMap();
                int i = ButtonTabComponent.this.pane.indexOfTabComponent(ButtonTabComponent.this);
                if (i != -1 && loadedPlugins.containsKey(ButtonTabComponent.this.pluginID)) {
                    MainGUI.this.timeline.removePlugin(loadedPlugins.get(ButtonTabComponent.this.pluginID));
                    ButtonTabComponent.this.pane.remove(i);
                    MainGUI.this.mainMenu.updateMenu(ButtonTabComponent.this.pluginID);
                }
            }
        }
    }

    public class StayOpenCheckBoxMenuItem
    extends CheckboxMenuItem {
        private static final long serialVersionUID = 1L;

        public StayOpenCheckBoxMenuItem() {
        }

        public StayOpenCheckBoxMenuItem(Action a) {
        }

        public StayOpenCheckBoxMenuItem(Icon icon) {
        }

        public StayOpenCheckBoxMenuItem(String text) {
            super(text);
        }

        public StayOpenCheckBoxMenuItem(String text, boolean selected) {
            super(text, selected);
        }

        public StayOpenCheckBoxMenuItem(String text, Icon icon) {
        }

        public StayOpenCheckBoxMenuItem(String text, Icon icon, boolean selected) {
        }
    }
}

