/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.main;

import com.google.common.base.Preconditions;
import com.jogamp.opengl.awt.GLJPanel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.main.Wizard;
import org.scec.vtk.main.pngRenderer;
import org.scec.vtk.plugins.Plugin;
import org.scec.vtk.plugins.PluginActors;
import org.scec.vtk.plugins.PluginInfo;
import org.scec.vtk.plugins.StatefulPlugin;
import org.scec.vtk.politicalBoundaries.PoliticalBoundariesGUI;
import org.scec.vtk.timeline.Timeline;
import org.scec.vtk.timeline.gui.TimelineGUI;
import org.scec.vtk.timeline.gui.ViewerSizePanel;
import org.scec.vtk.tools.Prefs;
import vtk.rendering.jogl.vtkJoglPanelComponent;
import vtk.vtkActor;
import vtk.vtkActorCollection;
import vtk.vtkAppendPolyData;
import vtk.vtkDoubleArray;
import vtk.vtkMapper;
import vtk.vtkOBJExporter;
import vtk.vtkObject;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkPolyDataReader;
import vtk.vtkPolyDataWriter;
import vtk.vtkProp;
import vtk.vtkXMLPolyDataWriter;

public class MainMenu
implements ActionListener,
ItemListener {
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenuItem fileOpen;
    private JMenuItem saveItem;
    private JMenuItem appExit;
    private JMenu windowMenu;
    private Timeline timeline;
    private TimelineGUI timelineGUI;
    private JFrame timelineFrame;
    private JFrame frame;
    private JCheckBoxMenuItem timelineItem;
    private JMenuItem saveItemVTK;
    private JMenuItem saveItemOBJ;
    private JMenuItem screenShot;
    private JMenuItem publishVTP;
    private JMenuItem resizeWindow;
    private JMenuItem tutorial;
    private JMenuItem wizardActivation;
    private JMenuItem escapeWindow;
    private ViewerSizePanel sizePanel;
    private JCheckBoxMenuItem focalPointItem;
    private String currFileName;
    public static Boolean Wizard = true;
    public static JMenu helpMenu;
    public static Boolean saved;
    public JFrame helpFrame;
    private JFrame wizFrame;
    private MainGUI main;
    Map<String, PluginInfo> availablePlugins = new HashMap<String, PluginInfo>();
    Map<String, Plugin> loadedPlugins = new HashMap<String, Plugin>();
    Map<Plugin, PluginActors> pluginActors = new HashMap<Plugin, PluginActors>();
    Map<String, Plugin> activePlugins = new HashMap<String, Plugin>();
    Map<String, JCheckBoxMenuItem> pluginMenuItems;
    private static Logger log;
    private static OutputFormat format;

    public MainMenu() {
        this.getState();
        this.currFileName = "";
        this.menuBar = new JMenuBar();
        this.setupFileMenu();
        this.pluginMenuItems = new HashMap<String, JCheckBoxMenuItem>();
        JMenu displayMenu = new JMenu();
        displayMenu.setLabel("Display");
        displayMenu.setName("Display");
        this.focalPointItem = new JCheckBoxMenuItem("Focal Point", false);
        JMenu trainingMenu = this.getCreateSubMenu(displayMenu, "Training");
        trainingMenu.add(this.focalPointItem);
        this.focalPointItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Info.getMainGUI().setFocalPointVisible(MainMenu.this.focalPointItem.getState());
            }
        });
        this.menuBar.add(displayMenu);
        this.setupWindowMenu();
    }

    private void setupWindowMenu() {
        this.windowMenu = new JMenu();
        this.windowMenu.setLabel("Window");
        this.windowMenu.setName("Window");
        this.resizeWindow = new JMenuItem("Resize render window");
        this.windowMenu.add(this.resizeWindow);
        this.menuBar.add(this.windowMenu);
        this.windowMenu.addActionListener(this);
        this.resizeWindow.addActionListener(this);
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    private void helpMenu() {
        helpMenu = new JMenu();
        helpMenu.setLabel("Help");
        helpMenu.setName("Help");
        this.tutorial = new JMenuItem("User Guide");
        helpMenu.add(this.tutorial);
        this.menuBar.add(helpMenu);
        helpMenu.addActionListener(this);
        this.tutorial.addActionListener(this);
        this.wizardActivation = new JMenuItem("Toggle Wizard");
        helpMenu.add(this.wizardActivation);
        this.wizardActivation.addActionListener(this);
    }

    public void setupTimeline(Timeline timeline, TimelineGUI timelineGUI) {
        Preconditions.checkState((this.timeline == null ? 1 : 0) != 0, (Object)"Timeline already initialized!");
        this.timeline = timeline;
        this.timelineGUI = timelineGUI;
        JMenu menu = this.getMenuByName("Render");
        if (menu == null) {
            menu = new JMenu();
            menu.setLabel("Render");
            menu.setName("Render");
            this.menuBar.add(menu);
        }
        this.timelineItem = new JCheckBoxMenuItem("Timeline");
        this.timelineItem.setName("Timeline");
        this.timelineItem.addItemListener(this);
        menu.add(this.timelineItem);
        this.helpMenu();
    }

    private void setupFileMenu() {
        this.fileMenu = new JMenu("File");
        this.fileOpen = new JMenuItem("Open...");
        this.saveItem = new JMenuItem("Save state...");
        this.saveItemVTK = new JMenuItem("Export as VTK...");
        this.saveItemOBJ = new JMenuItem("Export as OBJ...");
        this.screenShot = new JMenuItem("Save as image");
        this.publishVTP = new JMenuItem("Publish");
        this.appExit = new JMenuItem("Quit");
        this.fileMenu.addActionListener(this);
        this.saveItem.addActionListener(this);
        this.saveItemVTK.addActionListener(this);
        this.saveItemOBJ.addActionListener(this);
        this.screenShot.addActionListener(this);
        this.publishVTP.addActionListener(this);
        this.appExit.addActionListener(this);
        this.fileOpen.addActionListener(this);
        this.fileMenu.add(this.fileOpen);
        this.fileMenu.add(this.saveItem);
        this.fileMenu.add(this.saveItemVTK);
        this.fileMenu.add(this.saveItemOBJ);
        this.fileMenu.add(this.screenShot);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.publishVTP);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.appExit);
        this.menuBar.add(this.fileMenu);
    }

    public void quit() {
        System.exit(0);
    }

    public void save() {
        JFileChooser chooser = new JFileChooser();
        int ret = chooser.showSaveDialog(Info.getMainGUI());
        if (ret == 1) {
            Info.getMainGUI().wizFrame.setVisible(true);
        }
        if (ret == 0) {
            String destinationData;
            Document document = DocumentHelper.createDocument();
            org.dom4j.Element root = document.addElement("root");
            File file = chooser.getSelectedFile();
            this.currFileName = destinationData = file.getPath();
            saved = true;
            Vector<Plugin> pluginDescriptors = new Vector<Plugin>(this.loadedPlugins.values());
            for (Plugin pluginDescriptor : pluginDescriptors) {
                Plugin plugin = this.activePlugins.get(pluginDescriptor.getId());
                if (!(plugin instanceof StatefulPlugin)) continue;
                org.dom4j.Element pluginNameElement = root.addElement(pluginDescriptor.getMetadata().getName().replace(' ', '-'));
                ((StatefulPlugin)plugin).getState().toXML(pluginNameElement);
            }
            Info.getMainGUI().wizFrame.setVisible(false);
            org.dom4j.Element pluginNameElement = root.addElement("Timeline-Plugin");
            this.timeline.getState().toXML(pluginNameElement);
            this.saveXMLFile(document, root, destinationData);
        } else {
            System.out.println("Unhandled event");
        }
    }

    public void saveForToolbar() {
        this.saveCurrState();
    }

    public Boolean isSaved() {
        return saved;
    }

    public void autoSave() {
        Document document = DocumentHelper.createDocument();
        org.dom4j.Element root = document.addElement("root");
        Vector<Plugin> pluginDescriptors = new Vector<Plugin>(this.loadedPlugins.values());
        if (this.activePlugins.isEmpty()) {
            System.out.println("activePlugins is empty");
        }
        if (pluginDescriptors.isEmpty()) {
            System.out.println("pluginDescriptors.isEmpty");
        }
        for (Plugin pluginDescriptor : pluginDescriptors) {
            Plugin plugin = this.activePlugins.get(pluginDescriptor.getId());
            System.out.println("active plugins in autoSave: " + plugin.getId());
            System.out.println("pluginDescriptor: " + pluginDescriptor.getId());
            if (!(plugin instanceof StatefulPlugin)) continue;
            org.dom4j.Element pluginNameElement = root.addElement(pluginDescriptor.getMetadata().getName().replace(' ', '-'));
            ((StatefulPlugin)plugin).getState().toXML(pluginNameElement);
        }
        org.dom4j.Element pluginNameElement = root.addElement("Timeline-Plugin");
        this.timeline.getState().toXML(pluginNameElement);
        this.saveXMLFile(document, root, this.currFileName);
    }

    private static File getStatusFile() {
        File libDir = new File(Prefs.getLibLoc());
        Preconditions.checkState((libDir.exists() || libDir.mkdir() ? 1 : 0) != 0);
        return new File(libDir, "SCEC-VDO_STATUS.xml");
    }

    public boolean getState() {
        File statusFile = MainMenu.getStatusFile();
        try {
            SAXReader reader;
            Document document;
            org.dom4j.Element root;
            org.dom4j.Element wizardEl;
            String data;
            if (!statusFile.exists()) {
                this.initStatusFile(statusFile);
            }
            if ((data = (wizardEl = (root = (document = (reader = new SAXReader()).read(statusFile)).getRootElement()).element("Wizard")).getText().trim()).equalsIgnoreCase("true")) {
                Wizard = true;
                return true;
            }
            if (data.equalsIgnoreCase("false")) {
                Wizard = false;
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private void initStatusFile(File statusFile) throws IOException {
        System.out.println("Initializing status file: " + statusFile.getAbsolutePath());
        Document doc = DocumentHelper.createDocument();
        org.dom4j.Element root = doc.addElement("SCECVDO");
        org.dom4j.Element wizardEl = root.addElement("Wizard");
        wizardEl.setText("" + Wizard);
        MainMenu.writeXML(doc, statusFile);
    }

    private static void writeXML(Document document, File file) throws IOException {
        XMLWriter writer = new XMLWriter((Writer)new FileWriter(file), format);
        writer.write(document);
        writer.close();
    }

    public void updateWizard(Boolean wiz) {
        File statusFile = MainMenu.getStatusFile();
        try {
            if (!statusFile.exists()) {
                this.initStatusFile(statusFile);
            }
            SAXReader reader = new SAXReader();
            Document document = reader.read(statusFile);
            org.dom4j.Element root = document.getRootElement();
            org.dom4j.Element wizardEl = root.element("Wizard");
            wizardEl.setText("" + Wizard);
            MainMenu.writeXML(document, statusFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open() {
        JFileChooser chooser = new JFileChooser();
        MainGUI.class.getConstructors();
        int ret = chooser.showOpenDialog(Info.getMainGUI());
        if (ret == 1) {
            Info.getMainGUI().wizFrame.setVisible(true);
        }
        if (ret == 0) {
            if (this.isSaved().booleanValue()) {
                this.autoSave();
            }
            this.unloadAllPlugins();
            File file = chooser.getSelectedFile();
            this.currFileName = file.getPath();
            SAXReader reader = new SAXReader();
            try {
                Document document = reader.read(file.getPath());
                org.dom4j.Element root = document.getRootElement();
                saved = true;
                Vector<PluginInfo> pluginDescriptors = new Vector<PluginInfo>(this.availablePlugins.values());
                for (PluginInfo pluginDescriptor : pluginDescriptors) {
                    Iterator i = root.elementIterator(pluginDescriptor.getName().replace(' ', '-'));
                    while (i.hasNext()) {
                        org.dom4j.Element pluginNameElement = (org.dom4j.Element)i.next();
                        try {
                            Plugin plugin;
                            if (!this.activePlugins.containsKey(pluginDescriptor.getId())) {
                                this.activatePlugin(pluginDescriptor.getId());
                            }
                            if (!((plugin = this.activePlugins.get(pluginDescriptor.getId())) instanceof StatefulPlugin)) continue;
                            ((StatefulPlugin)plugin).getState().fromXML(pluginNameElement);
                            ((StatefulPlugin)plugin).getState().load();
                        }
                        catch (Exception e1) {
                            System.err.println("WARNING: Error loading plugin state from XML: " + pluginDescriptor.getName());
                            e1.printStackTrace();
                        }
                    }
                }
                Info.getMainGUI().wizFrame.setVisible(false);
                org.dom4j.Element pluginNameElement = root.element("Timeline-Plugin");
                this.timeline.getState().fromXML(pluginNameElement);
                this.timeline.getState().load();
                this.timelineGUI.getTimeLinePanel().timelinePluginsChanged();
            }
            catch (DocumentException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void openForToolbar() {
        JFileChooser chooser = new JFileChooser();
        MainGUI.class.getConstructors();
        int ret = chooser.showOpenDialog(Info.getMainGUI());
        if (ret == 0) {
            if (this.isSaved().booleanValue()) {
                this.autoSave();
            }
            this.unloadAllPlugins();
            File file = chooser.getSelectedFile();
            this.currFileName = file.getPath();
            SAXReader reader = new SAXReader();
            try {
                Document document = reader.read(file.getPath());
                org.dom4j.Element root = document.getRootElement();
                saved = true;
                Vector<PluginInfo> pluginDescriptors = new Vector<PluginInfo>(this.availablePlugins.values());
                for (PluginInfo pluginDescriptor : pluginDescriptors) {
                    Iterator i = root.elementIterator(pluginDescriptor.getName().replace(' ', '-'));
                    while (i.hasNext()) {
                        org.dom4j.Element pluginNameElement = (org.dom4j.Element)i.next();
                        try {
                            Plugin plugin;
                            if (!this.activePlugins.containsKey(pluginDescriptor.getId())) {
                                this.activatePlugin(pluginDescriptor.getId());
                            }
                            if (!((plugin = this.activePlugins.get(pluginDescriptor.getId())) instanceof StatefulPlugin)) continue;
                            ((StatefulPlugin)plugin).getState().fromXML(pluginNameElement);
                            ((StatefulPlugin)plugin).getState().load();
                        }
                        catch (Exception e1) {
                            System.err.println("WARNING: Error loading plugin state from XML: " + pluginDescriptor.getName());
                            e1.printStackTrace();
                        }
                    }
                }
                org.dom4j.Element pluginNameElement = root.element("Timeline-Plugin");
                this.timeline.getState().fromXML(pluginNameElement);
                this.timeline.getState().load();
                this.timelineGUI.getTimeLinePanel().timelinePluginsChanged();
            }
            catch (DocumentException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void saveObj(File file) {
        Info.getMainGUI();
        vtkActorCollection actorlist = MainGUI.getRenderWindow().getRenderer().GetActors();
        if (actorlist.GetNumberOfItems() > 0) {
            System.out.println(actorlist.GetNumberOfItems());
            vtkOBJExporter objExporter = new vtkOBJExporter();
            objExporter.SetFilePrefix(file.getPath() + ".obj");
            Info.getMainGUI();
            objExporter.SetRenderWindow(MainGUI.getRenderWindow().getRenderWindow());
            objExporter.Write();
            System.out.println("done");
        }
    }

    public void saveVTKObj(File file) {
        Info.getMainGUI();
        vtkJoglPanelComponent renderWindow = MainGUI.getRenderWindow();
        vtkActorCollection actorlist = renderWindow.getRenderer().GetActors();
        if (actorlist.GetNumberOfItems() > 0) {
            System.out.println(actorlist.GetNumberOfItems());
            vtkPolyDataWriter objExporter = new vtkPolyDataWriter();
            objExporter.SetFileName(file.getPath() + ".vtk");
            vtkAppendPolyData mainData = new vtkAppendPolyData();
            for (int i = 0; i < actorlist.GetNumberOfItems(); ++i) {
                vtkPolyDataMapper gmapper;
                vtkActor pbActor = (vtkActor)actorlist.GetItemAsObject(i);
                if (pbActor.GetVisibility() != 1 || (gmapper = (vtkPolyDataMapper)pbActor.GetMapper()) == null) continue;
                vtkPolyData pd = new vtkPolyData();
                pd.SetPoints(gmapper.GetInput().GetPoints());
                pd.SetLines(gmapper.GetInput().GetLines());
                pd.SetPolys(gmapper.GetInput().GetPolys());
                mainData.AddInputData(pd);
                mainData.Update();
            }
            objExporter.SetInputConnection(mainData.GetOutputPort());
            objExporter.Write();
            System.out.println("done");
        }
    }

    public void saveVTPObj(String title) {
        Info.getMainGUI();
        vtkJoglPanelComponent renderWindow = MainGUI.getRenderWindow();
        vtkActorCollection actorlist = renderWindow.getRenderer().GetActors();
        if (actorlist.GetNumberOfItems() > 0) {
            System.out.println(actorlist.GetNumberOfItems());
            vtkXMLPolyDataWriter objExporter = new vtkXMLPolyDataWriter();
            objExporter.SetFileName(System.getProperty("user.home") + File.separator + ".scec_vdo/tmp/" + title + ".vtp");
            vtkAppendPolyData mainData = new vtkAppendPolyData();
            for (int i = 0; i < actorlist.GetNumberOfItems(); ++i) {
                vtkPolyDataMapper gmapper;
                vtkActor pbActor = (vtkActor)actorlist.GetItemAsObject(i);
                if (pbActor.GetVisibility() != 1 || (gmapper = (vtkPolyDataMapper)pbActor.GetMapper()) == null) continue;
                vtkPolyData pd = new vtkPolyData();
                pd.SetPoints(gmapper.GetInput().GetPoints());
                pd.SetLines(gmapper.GetInput().GetLines());
                pd.SetPolys(gmapper.GetInput().GetPolys());
                mainData.AddInputData(pd);
                mainData.Update();
            }
            objExporter.SetInputConnection(mainData.GetOutputPort());
            objExporter.Write();
            System.out.println("done");
        }
    }

    public void openVTKObj() {
        vtkPolyDataReader reader = new vtkPolyDataReader();
        reader.SetFileName("testAll.vtk");
        reader.Update();
        vtkDoubleArray c1 = (vtkDoubleArray)reader.GetOutput().GetPointData().GetScalars("Colors");
        double[] c = c1.GetTuple3(0L);
        c[0] = c[0] / 255.0;
        c[1] = c[1] / 255.0;
        c[2] = c[2] / 255.0;
        vtkPolyData pd = new vtkPolyData();
        pd.SetPoints(reader.GetOutput().GetPoints());
        pd.SetLines(reader.GetOutput().GetLines());
        pd.SetPolys(reader.GetOutput().GetPolys());
        vtkPolyDataMapper mapper = new vtkPolyDataMapper();
        mapper.SetInputData(pd);
        vtkActor actor = new vtkActor();
        actor.SetMapper((vtkMapper)mapper);
        actor.GetProperty().SetColor(c);
        vtkJoglPanelComponent renderWindow = MainGUI.getRenderWindow();
        renderWindow.getRenderer().AddActor((vtkProp)actor);
        MainGUI.updateRenderWindow(actor);
    }

    public void savePNG(File file) throws IOException {
        pngRenderer.pngRender(file, Info.getMainGUI());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block50: {
            Object eventSource = e.getSource();
            if (eventSource == this.appExit) {
                this.quit();
            } else if (eventSource == this.fileOpen) {
                JFileChooser chooser = new JFileChooser();
                int ret = chooser.showOpenDialog(Info.getMainGUI());
                if (ret == 0) {
                    File file = chooser.getSelectedFile();
                    SAXReader reader = new SAXReader();
                    try {
                        Document document = reader.read(file.getPath());
                        org.dom4j.Element root = document.getRootElement();
                        Vector<PluginInfo> pluginDescriptors = new Vector<PluginInfo>(this.availablePlugins.values());
                        for (PluginInfo pluginDescriptor : pluginDescriptors) {
                            Iterator i = root.elementIterator(pluginDescriptor.getName().replace(' ', '-'));
                            while (i.hasNext()) {
                                org.dom4j.Element pluginNameElement = (org.dom4j.Element)i.next();
                                try {
                                    Plugin plugin;
                                    if (!this.activePlugins.containsKey(pluginDescriptor.getId())) {
                                        this.activatePlugin(pluginDescriptor.getId());
                                    }
                                    if (!((plugin = this.activePlugins.get(pluginDescriptor.getId())) instanceof StatefulPlugin)) continue;
                                    ((StatefulPlugin)plugin).getState().fromXML(pluginNameElement);
                                    ((StatefulPlugin)plugin).getState().load();
                                }
                                catch (Exception e1) {
                                    System.err.println("WARNING: Error loading plugin state from XML: " + pluginDescriptor.getName());
                                    e1.printStackTrace();
                                }
                            }
                        }
                        org.dom4j.Element pluginNameElement = root.element("Timeline-Plugin");
                        this.timeline.getState().fromXML(pluginNameElement);
                        this.timeline.getState().load();
                        this.timelineGUI.getTimeLinePanel().timelinePluginsChanged();
                    }
                    catch (DocumentException e1) {
                        e1.printStackTrace();
                    }
                }
            } else if (eventSource == this.saveItemVTK) {
                JFileChooser chooser = new JFileChooser();
                int ret = chooser.showSaveDialog(Info.getMainGUI());
                if (ret == 0) {
                    File file = chooser.getSelectedFile();
                    this.saveVTKObj(file);
                }
            } else if (eventSource == this.saveItemOBJ) {
                JFileChooser chooser = new JFileChooser();
                int ret = chooser.showSaveDialog(Info.getMainGUI());
                if (ret == 0) {
                    File file = chooser.getSelectedFile();
                    this.saveObj(file);
                }
            } else if (eventSource == this.saveItem) {
                this.saveCurrState();
            } else if (eventSource == this.resizeWindow) {
                int val;
                if (this.sizePanel == null) {
                    this.sizePanel = new ViewerSizePanel(null);
                }
                if ((val = JOptionPane.showConfirmDialog(Info.getMainGUI(), this.sizePanel, "Resize Viewer", 2)) == 0) {
                    Dimension dims = this.sizePanel.getCurDims();
                    Info.getMainGUI().resizeViewer(dims.width, dims.height);
                }
            } else if (eventSource == this.publishVTP) {
                UIManager.put("OptionPane.minimumSize", new Dimension(500, 300));
                JTextField title = new JTextField();
                title.setBorder(BorderFactory.createLineBorder(Color.black, 1));
                JTextField author = new JTextField();
                author.setBorder(BorderFactory.createLineBorder(Color.black, 1));
                JTextField server = new JTextField("http://scecvdo.usc.edu/viewer/publish.php");
                server.setBorder(BorderFactory.createLineBorder(Color.black, 1));
                server.setEnabled(false);
                JTextArea description = new JTextArea(20, 20);
                description.setBorder(BorderFactory.createLineBorder(Color.black, 1));
                description.setFont(title.getFont());
                Object[] message = new Object[]{"Title:", title, "Author:", author, "Server:", server, "Description", description};
                int val = JOptionPane.showConfirmDialog(null, message, "Publish To Web Server", 2);
                if (val != 0) {
                    return;
                }
                try {
                    String[] arr = title.getText().split("[~#@*+%{}<>\\[\\]|\"\\_^]", 2);
                    if (arr.length > 1) {
                        JLabel words = new JLabel("Invalid characters in Title");
                        Object[] confirmation = new Object[]{words};
                        JOptionPane.showMessageDialog(null, confirmation, "Error", 0);
                        return;
                    }
                    Element rootElement = new Element("model");
                    org.jdom.Document doc = new org.jdom.Document(rootElement);
                    Element xmlTitle = new Element("title");
                    xmlTitle.setText(title.getText());
                    Element xmlAuthor = new Element("author");
                    xmlAuthor.setText(author.getText());
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                    Date date = new Date();
                    Element xmlDate = new Element("date");
                    xmlDate.setText(dateFormat.format(date));
                    Element xmlRegion = new Element("region");
                    xmlRegion.setText("California");
                    Element xmlDescription = new Element("description");
                    xmlDescription.setText(description.getText());
                    doc.getRootElement().addContent(xmlTitle);
                    doc.getRootElement().addContent(xmlAuthor);
                    doc.getRootElement().addContent(xmlDate);
                    doc.getRootElement().addContent(xmlRegion);
                    doc.getRootElement().addContent(xmlDescription);
                    XMLOutputter outter = new XMLOutputter();
                    outter.setFormat(Format.getPrettyFormat());
                    final String projectTitle = title.getText().replaceAll("\\s", "");
                    File publishXml = new File(System.getProperty("user.home") + File.separator + ".scec_vdo/tmp/" + projectTitle + ".xml");
                    if (!publishXml.exists()) {
                        Files.createDirectories(Paths.get(System.getProperty("user.home") + File.separator + ".scec_vdo/tmp/", new String[0]), new FileAttribute[0]);
                    }
                    this.saveVTPObj(projectTitle);
                    FileWriter out = new FileWriter(publishXml);
                    outter.output(doc, (Writer)out);
                    UIManager.put("OptionPane.minimumSize", new Dimension(100, 100));
                    JLabel words = new JLabel("Project successfully published online!");
                    Object[] confirmation = new Object[]{words};
                    if (this.transferFile(new File(System.getProperty("user.home") + File.separator + ".scec_vdo" + File.separator + "tmp" + File.separator + projectTitle + ".vtp"), server.getText()) && this.transferFile(new File(System.getProperty("user.home") + File.separator + ".scec_vdo" + File.separator + "tmp" + File.separator + projectTitle + ".xml"), server.getText())) {
                        JLabel label = new JLabel();
                        label.setFont(label.getFont().deriveFont(16.0f));
                        Font font = label.getFont();
                        StringBuffer style = new StringBuffer("font-family:" + font.getFamily() + ";");
                        style.append("font-weight:" + (font.isBold() ? "bold" : "normal") + ";");
                        style.append("font-size:" + font.getSize() + "pt;");
                        JEditorPane ep = new JEditorPane("text/html", "<html><body style=\"" + String.valueOf(style) + "\">Project successfully published online! \n<a href=\"http://google.com/\">View Project Here</a></body></html>");
                        ep.addHyperlinkListener(new HyperlinkListener(){

                            @Override
                            public void hyperlinkUpdate(HyperlinkEvent e) {
                                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                                    String urlString = "http://scecvdo.usc.edu/viewer/?fileURL=objects/" + projectTitle + ".vtp&model=" + projectTitle;
                                    try {
                                        Desktop.getDesktop().browse(new URL(urlString).toURI());
                                    }
                                    catch (Exception er) {
                                        er.printStackTrace();
                                    }
                                }
                            }
                        });
                        ep.setEditable(false);
                        ep.setBackground(label.getBackground());
                        JOptionPane.showMessageDialog(null, ep, "", 1);
                        break block50;
                    }
                    words.setText("Error publishing project");
                    JOptionPane.showMessageDialog(null, confirmation, "Error", 0);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            } else if (eventSource == this.screenShot) {
                JFileChooser chooser = new JFileChooser();
                int ret = chooser.showSaveDialog(Info.getMainGUI());
                if (ret == 0) {
                    File file = chooser.getSelectedFile();
                    try {
                        String fName = file.getAbsolutePath();
                        if (!fName.endsWith(".png")) {
                            file = new File(fName + ".png");
                        }
                        this.savePNG(file);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        System.out.println("Error");
                    }
                }
            } else {
                if (eventSource == this.tutorial) {
                    block51: {
                        String url = "http://scecvdo.usc.edu/manual/UserGuide.html";
                        String os = System.getProperty("os.name").toLowerCase();
                        Runtime rt = Runtime.getRuntime();
                        try {
                            if (os.indexOf("win") >= 0) {
                                rt.exec("rundll32 url.dll,FileProtocolHandler " + url);
                                break block51;
                            }
                            if (os.indexOf("mac") >= 0) {
                                rt.exec("open " + url);
                                break block51;
                            }
                            if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0) {
                                String[] browsers = new String[]{"firefox", "mozilla", "epiphany", "konqueror", "netscape", "opera", "links", "seamonkey", "galeon", "kazehakase", "lynx"};
                                StringBuffer cmd = new StringBuffer();
                                for (int i = 0; i < browsers.length; ++i) {
                                    cmd.append((i == 0 ? "" : " || ") + browsers[i] + " \"" + url + "\" ");
                                }
                                rt.exec(new String[]{"sh", "-c", cmd.toString()});
                                break block51;
                            }
                            return;
                        }
                        catch (Exception e1) {
                            return;
                        }
                    }
                    return;
                }
                if (eventSource == this.wizardActivation) {
                    if (Wizard.booleanValue()) {
                        JOptionPane.showMessageDialog(this.frame, "You have disabled the Wizard.\nTo reactivate it, go to the 'Help' menu and click on 'Toggle Wizard'\n\nNote: AutoSave will also be disabled.");
                        Wizard = false;
                        this.updateWizard(true);
                    } else {
                        JOptionPane.showMessageDialog(this.frame, "You have re-enabled the Wizard.\n To deactivate it, go to the 'Help' menu and click on 'Toggle Wizard'");
                        this.wizFrame = new JFrame();
                        Wizard wizGui = new Wizard(this, this.main);
                        this.wizFrame.getContentPane().add(wizGui);
                        this.wizFrame.setSize(550, 140);
                        this.wizFrame.setLocationRelativeTo(null);
                        this.wizFrame.setVisible(true);
                        Wizard = true;
                        this.updateWizard(true);
                    }
                } else if (eventSource == this.escapeWindow && MainGUI.getRenderWindow().getRenderer().GetViewProps().IsItemPresent((vtkObject)PoliticalBoundariesGUI.mainFocusReginActor) != 0) {
                    MainGUI.getRenderWindow().getRenderer().GetActiveCamera().SetPosition(MainGUI.camCord[0], MainGUI.camCord[1], MainGUI.camCord[2]);
                    MainGUI.getRenderWindow().getRenderer().GetActiveCamera().SetFocalPoint(MainGUI.camCord[3], MainGUI.camCord[4], MainGUI.camCord[5]);
                    MainGUI.getRenderWindow().getRenderer().GetActiveCamera().SetViewUp(MainGUI.camCord[6], MainGUI.camCord[7], MainGUI.camCord[8]);
                    MainGUI.getRenderWindow().getRenderer().ResetCameraClippingRange();
                    ((GLJPanel)MainGUI.getRenderWindow().getComponent()).repaint();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean transferFile(File f, String urlText) {
        String CrLf = "\r\n";
        URLConnection conn = null;
        OutputStream os = null;
        InputStream is = null;
        try {
            URL url = new URL(urlText);
            conn = url.openConnection();
            conn.setDoOutput(true);
            FileInputStream imgIs = new FileInputStream(f.getAbsolutePath());
            byte[] imgData = new byte[((InputStream)imgIs).available()];
            ((InputStream)imgIs).read(imgData);
            Object message1 = "";
            message1 = (String)message1 + "-----------------------------4664151417711\r\n";
            message1 = (String)message1 + "Content-Disposition: form-data; name=\"uploadedfile\"; filename=\"" + f.getName() + "\"\r\n";
            message1 = (String)message1 + "Content-Type: text/plain\r\n";
            message1 = (String)message1 + "\r\n";
            Object message2 = "";
            message2 = (String)message2 + "\r\n-----------------------------4664151417711--\r\n";
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=---------------------------4664151417711");
            conn.setRequestProperty("Content-Length", String.valueOf(((String)message1).length() + ((String)message2).length() + imgData.length));
            os = conn.getOutputStream();
            os.write(((String)message1).getBytes());
            int index = 0;
            int size = 1024;
            do {
                if (index + size > imgData.length) {
                    size = imgData.length - index;
                }
                os.write(imgData, index, size);
            } while ((index += size) < imgData.length);
            System.out.println("written:" + index);
            os.write(((String)message2).getBytes());
            os.flush();
            is = conn.getInputStream();
            int buff = 512;
            int len = 0;
            byte[] data = new byte[buff];
            do {
                if ((len = is.read(data)) <= 0) continue;
                System.out.println(new String(data, 0, len));
            } while (len > 0);
            System.out.println("DONE");
        }
        catch (Exception ef) {
            ef.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            System.out.println("Close connection");
            try {
                os.close();
            }
            catch (Exception exception) {}
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    private void saveXMLFile(Document document, org.dom4j.Element root, String destinationData) {
        XMLWriter writer = null;
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            writer = new XMLWriter((Writer)new FileWriter(destinationData), format);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            writer.write(document);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object eventSource = e.getSource();
        if (eventSource == this.timelineItem) {
            this.setTimelineVisible(this.timelineItem.getState());
        } else if (eventSource instanceof JCheckBoxMenuItem) {
            JCheckBoxMenuItem jmi = (JCheckBoxMenuItem)eventSource;
            if (jmi.getState()) {
                this.activatePlugin(jmi.getName());
            } else {
                this.passivatePlugin(jmi.getName());
            }
        } else {
            System.out.println("Unhandled event");
        }
    }

    public void setTimelineVisible(boolean visible) {
        if (this.timelineFrame == null) {
            this.timelineFrame = new JFrame();
            this.timelineFrame.setTitle("Timeline");
            this.timelineFrame.setContentPane(this.timelineGUI);
            this.timelineFrame.setSize(1000, 300);
            this.timelineFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    MainMenu.this.timelineItem.setState(false);
                }
            });
        }
        this.timelineFrame.setVisible(visible);
    }

    public Map<String, Plugin> getActivePlugins() {
        return this.activePlugins;
    }

    public Map<String, Plugin> getLoadedPluginsAsMap() {
        for (Map.Entry<String, Plugin> entry : this.loadedPlugins.entrySet()) {
            System.out.println(entry.getKey() + "/" + String.valueOf(entry.getValue()));
        }
        return this.loadedPlugins;
    }

    public void setActivePlugins(Map<String, Plugin> activePlugins) {
        this.activePlugins = activePlugins;
    }

    public boolean isPluginActive(String id) {
        return this.getActivePlugins().containsKey(id);
    }

    void setupPluginMenus() {
        Vector<PluginInfo> pluginDescriptors = new Vector<PluginInfo>(this.availablePlugins.values());
        Collections.sort(pluginDescriptors);
        for (PluginInfo plugin : pluginDescriptors) {
            this.addPluginToMenu(plugin);
        }
    }

    private JMenu getMenuByName(String menuName) {
        for (int i = 0; i < this.menuBar.getMenuCount(); ++i) {
            JMenu candidate = this.menuBar.getMenu(i);
            if (candidate == null || candidate.getName() == null || !candidate.getName().equalsIgnoreCase(menuName)) continue;
            return candidate;
        }
        return null;
    }

    private void addPluginToMenu(PluginInfo info) {
        if (info.hasMenu()) {
            String submenuName;
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(info.getShortName());
            mi.setName(info.getId());
            mi.addItemListener(this);
            this.pluginMenuItems.put(info.getId(), mi);
            String menuName = info.getMenuName();
            JMenu menu = this.getMenuByName(menuName);
            if (menu == null) {
                menu = new JMenu();
                menu.setLabel(menuName);
                menu.setName(menuName);
                this.menuBar.add(menu);
            }
            if ((submenuName = info.getSubmenuName()) == null) {
                menu.add(mi);
            } else {
                JMenu submenu = this.getCreateSubMenu(menu, submenuName);
                submenu.add(mi);
            }
        }
    }

    private JMenu getCreateSubMenu(JMenu menu, String submenuName) {
        JMenu submenu = null;
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem candidate = menu.getItem(i);
            if (candidate == null || !(candidate instanceof JMenu)) continue;
            if (candidate.getName().equalsIgnoreCase("GIS Hazus Events")) {
                candidate.setVisible(false);
            }
            if (!((JMenu)candidate).getName().equalsIgnoreCase(submenuName)) continue;
            return (JMenu)candidate;
        }
        submenu = new JMenu();
        submenu.setLabel(submenuName);
        submenu.setName(submenuName);
        menu.add(submenu);
        return submenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activatePlugin(String id) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.loadedPlugins == null || !this.loadedPlugins.containsKey(id)) {
                this.loadPlugin(id);
            }
            log.debug((Object)("Activating plugin " + id));
            if (this.loadedPlugins.containsKey(id)) {
                JCheckBoxMenuItem mi = this.pluginMenuItems.get(id);
                if (mi != null) {
                    mi.setState(true);
                }
                Plugin plugin = this.loadedPlugins.get(id);
                this.getActivePlugins().put(id, plugin);
                plugin.activate();
                this.timeline.addPlugin(plugin, this.pluginActors.get(plugin));
            } else {
                log.warn((Object)("Unable to activate plugin: " + id));
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void setCursor(Cursor predefinedCursor) {
    }

    private void passivatePlugin(String id) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            log.debug((Object)("Passivating plugin " + id));
            if (this.loadedPlugins.containsKey(id)) {
                this.timeline.removePlugin(this.loadedPlugins.get(id));
                this.updateMenu(id);
            } else {
                log.warn((Object)("Unknown plugin: " + id));
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void loadPlugin(String id) {
        if (this.loadedPlugins != null && this.loadedPlugins.containsKey(id)) {
            log.warn((Object)("Plugin " + id + " already loaded"));
            return;
        }
        if (this.availablePlugins.containsKey(id)) {
            try {
                PluginInfo info = this.availablePlugins.get(id);
                log.debug((Object)("Loading plugin " + id));
                PluginActors actors = new PluginActors();
                actors.addActorsChangeListener(Info.getMainGUI());
                Plugin plugin = info.newInstance(actors);
                this.pluginActors.put(plugin, actors);
                this.loadedPlugins.put(id, plugin);
                plugin.load();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to load plugin: " + id, e);
            }
        } else {
            log.warn((Object)("Unknown plugin " + id));
        }
    }

    private void unloadPlugin(String id) {
        if (!this.loadedPlugins.containsKey(id)) {
            log.warn((Object)("Plugin " + id + " not loaded"));
            return;
        }
        log.debug((Object)("Unloading plugin " + id));
        Plugin plugin = this.loadedPlugins.remove(id);
        plugin.unload();
    }

    private void unloadAllPlugins() {
        ArrayList<String> plugIds = new ArrayList<String>();
        for (Plugin plug : this.loadedPlugins.values()) {
            if (plug.getId().equals("org.scec.vdo.graticulePlugin") || plug.getId().equals("org.scec.vdo.politicalBoundaries") || plug.getId().equals("org.scec.vdo.drawingToolsPlugin")) continue;
            plugIds.add(plug.getId());
        }
        for (int i = 0; i < plugIds.size(); ++i) {
            Info.getMainGUI().timeline.removePlugin(this.loadedPlugins.get(plugIds));
            String tabName = Info.getMainGUI().tabMap.get(plugIds.get(i));
            System.out.println("tabName: " + tabName);
            Info.getMainGUI();
            int tabIndex = MainGUI.pluginTabPane.indexOfTab(tabName);
            System.out.println("tabIndex: " + tabIndex);
            Info.getMainGUI();
            System.out.println("pluginTabPane.getTabCount(): " + MainGUI.pluginTabPane.getTabCount());
            this.loadedPlugins.remove(plugIds);
            if (tabIndex != -1) {
                Info.getMainGUI();
                MainGUI.pluginTabPane.remove(tabIndex);
            }
            this.updateMenu((String)plugIds.get(i));
        }
    }

    public void updateMenu(String id) {
        JCheckBoxMenuItem mi = this.pluginMenuItems.get(id);
        mi.setState(false);
        Plugin plugin = this.loadedPlugins.get(id);
        if (plugin != null) {
            plugin.unload();
            plugin.passivate();
        }
        this.getActivePlugins().remove(id);
        this.loadedPlugins.remove(id);
    }

    List<PluginActors> getActivatedPluginActors() {
        ArrayList<PluginActors> actorsList = new ArrayList<PluginActors>();
        for (Plugin plugin : this.getActivePlugins().values()) {
            PluginActors actors = this.pluginActors.get(plugin);
            actorsList.add(actors);
        }
        return actorsList;
    }

    public void saveCurrState() {
        System.out.println("Saving norm file");
        JFileChooser chooser = new JFileChooser();
        int ret = chooser.showSaveDialog(Info.getMainGUI());
        if (ret == 0) {
            Document document = DocumentHelper.createDocument();
            org.dom4j.Element root = document.addElement("root");
            File file = chooser.getSelectedFile();
            String destinationData = file.getPath();
            Vector<Plugin> pluginDescriptors = new Vector<Plugin>(this.loadedPlugins.values());
            int stateCntr = 0;
            this.getLoadedPluginsAsMap();
            for (Map.Entry<Plugin, PluginActors> entry : this.pluginActors.entrySet()) {
                System.out.println(String.valueOf(entry.getKey()) + "/" + String.valueOf(entry.getValue()));
            }
            for (Plugin pluginDescriptor : pluginDescriptors) {
                Plugin plugin = this.activePlugins.get(pluginDescriptor.getId());
                try {
                    if (!(plugin instanceof StatefulPlugin)) continue;
                    System.out.println("Stateful plug-in #" + stateCntr + ": " + plugin.toString());
                    ++stateCntr;
                    org.dom4j.Element pluginNameElement = root.addElement(pluginDescriptor.getMetadata().getName().replace(' ', '-'));
                    ((StatefulPlugin)plugin).getState().toXML(pluginNameElement);
                }
                catch (Exception e2) {
                    System.out.println("ERROR: " + plugin.toString());
                }
            }
            org.dom4j.Element pluginNameElement = root.addElement("Timeline-Plugin");
            this.timeline.getState().toXML(pluginNameElement);
            this.saveXMLFile(document, root, destinationData);
        } else {
            System.out.println("Unhandled event");
        }
        System.out.println("done saving");
    }

    static {
        saved = false;
        log = Logger.getLogger(MainGUI.class);
        format = OutputFormat.createPrettyPrint();
    }
}

