/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins;

import java.io.IOException;
import javax.swing.JComponent;
import org.scec.vtk.main.Info;
import org.scec.vtk.plugins.Plugin;
import org.scec.vtk.plugins.PluginActors;
import org.scec.vtk.plugins.PluginInfo;

public abstract class ActionPlugin
implements Plugin {
    private JComponent gui;
    protected PluginInfo metadata;
    private PluginActors pluginActors;

    @Override
    public void initialize(PluginInfo metadata, PluginActors pluginActors) {
        this.setMetadata(metadata);
        this.pluginActors = pluginActors;
    }

    @Override
    public PluginActors getPluginActors() {
        return this.pluginActors;
    }

    @Override
    public String getId() {
        return this.metadata.getId();
    }

    @Override
    public PluginInfo getMetadata() {
        return this.metadata;
    }

    public void setMetadata(PluginInfo metadata) {
        this.metadata = metadata;
    }

    protected abstract JComponent createGUI() throws IOException;

    @Override
    public final void load() throws IOException {
        this.gui = this.createGUI();
    }

    @Override
    public final void activate() {
        Info.getMainGUI().addPluginGUI(this.metadata.getId(), this.metadata.getShortName(), this.gui);
    }

    @Override
    public final void passivate() {
        Info.getMainGUI().removePluginGUI(this.metadata.getId());
    }

    @Override
    public void unload() {
        this.gui = null;
    }
}

