/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.CommunityfaultModelPlugin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.CommunityfaultModelPlugin.CommunityFaultModelPlugin;
import org.scec.vtk.plugins.CommunityfaultModelPlugin.components.Fault3D;
import org.scec.vtk.plugins.CommunityfaultModelPlugin.components.Fault3DPickBehavior;
import org.scec.vtk.plugins.CommunityfaultModelPlugin.components.FaultAccessor;
import org.scec.vtk.plugins.CommunityfaultModelPlugin.components.FaultTable;
import org.scec.vtk.plugins.CommunityfaultModelPlugin.components.FaultTableModel;
import org.scec.vtk.plugins.CommunityfaultModelPlugin.components.Group;
import org.scec.vtk.plugins.CommunityfaultModelPlugin.components.GroupList;
import org.scec.vtk.plugins.CommunityfaultModelPlugin.components.TSurfImport;
import org.scec.vtk.plugins.PluginActors;
import org.scec.vtk.plugins.utils.DataAccessor;
import org.scec.vtk.plugins.utils.components.AddButton;
import org.scec.vtk.plugins.utils.components.ColorButton;
import org.scec.vtk.plugins.utils.components.DataFileChooser;
import org.scec.vtk.plugins.utils.components.EditButton;
import org.scec.vtk.plugins.utils.components.MeshButton;
import org.scec.vtk.plugins.utils.components.ObjectInfoDialog;
import org.scec.vtk.plugins.utils.components.RemoveButton;
import org.scec.vtk.plugins.utils.components.ShowButton;
import org.scec.vtk.plugins.utils.components.SingleColorChooser;
import org.scec.vtk.tools.Prefs;
import org.scec.vtk.tools.picking.PickEnabledActor;
import org.scec.vtk.tools.picking.PickHandler;
import vtk.vtkActor;
import vtk.vtkProp;

public class CommunityFaultModelGUI
extends JPanel
implements ActionListener,
ListSelectionListener,
TableModelListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private JPanel faultLibraryPanel;
    protected FaultTable faultTable;
    protected ShowButton showFaultsButton;
    protected MeshButton meshFaultsButton;
    protected ColorButton colorFaultsButton;
    protected EditButton editFaultsButton;
    protected AddButton addFaultsButton;
    protected RemoveButton remFaultsButton;
    private JPanel groupsPanel;
    private GroupList groupList;
    private AddButton newGroupButton;
    private RemoveButton delGroupButton;
    private JPanel propsNotesPanel;
    private JTextArea faultNotes;
    private JProgressBar progbar;
    private Task task;
    private JTabbedPane propsTabbedPane;
    private DataFileChooser fileChooser;
    private SingleColorChooser colorChooser;
    private ObjectInfoDialog srcInfoDialog;
    private boolean ROIFilter = false;
    ArrayList<FaultAccessor> inlist;
    private JButton filterButton = new JButton("Filter through ROIs");
    private PluginActors pluginActors;
    private ArrayList<vtkActor> allFaultActors;
    private PickHandler<Fault3D> pickHandler;

    public CommunityFaultModelGUI(String cfmFilesDirectory, String groupName, PluginActors actors) {
        TSurfImport tsImport;
        ArrayList<Fault3D> newObjects;
        this.initialize(actors);
        File dir = new File(cfmFilesDirectory);
        File[] f = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dirName, String name) {
                return name.endsWith(".ts");
            }
        });
        if (f != null && (newObjects = (tsImport = new TSurfImport(this, f)).processFiles(false, groupName)).size() > 0) {
            this.faultTable.addFaults(newObjects);
        }
    }

    private void initialize(PluginActors actors) {
        this.pluginActors = actors;
        this.allFaultActors = new ArrayList();
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(Prefs.getPluginWidth(), Prefs.getPluginHeight()));
        this.add((Component)this.getFaultLibraryPanel(), "First");
        this.propsTabbedPane = new JTabbedPane();
        this.propsTabbedPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.propsTabbedPane.add(this.getGroupsPanel());
        this.propsTabbedPane.add(this.getNotesPanel());
        this.progbar = new JProgressBar(0, 100);
        this.progbar.setValue(0);
        this.progbar.setStringPainted(true);
        JPanel lowerPane = new JPanel();
        lowerPane.setLayout(new BoxLayout(lowerPane, 3));
        lowerPane.add(this.propsTabbedPane);
        JPanel progressPanel = new JPanel();
        progressPanel.setLayout(new BoxLayout(progressPanel, 2));
        progressPanel.add(this.progbar);
        this.add((Component)lowerPane, "Center");
        this.add((Component)progressPanel, "Last");
        this.pickHandler = new Fault3DPickBehavior();
    }

    public CommunityFaultModelGUI(PluginActors pluginActors) {
        this.initialize(pluginActors);
        this.faultTable.loadLibrary();
        this.groupList.loadGroups();
    }

    public PickHandler<Fault3D> getPickHandler() {
        return this.pickHandler;
    }

    public void processTableSelectionChange() {
        int[] selectedRows = this.faultTable.getSelectedRows();
        if (selectedRows.length > 0) {
            this.remFaultsButton.setEnabled(true);
            this.editFaultsButton.setEnabled(true);
            if (this.faultTable.getLibraryModel().allAreLoaded(selectedRows)) {
                this.enablePropertyEditButtons(true);
            } else if (this.faultTable.getLibraryModel().noneAreLoaded(selectedRows)) {
                this.enablePropertyEditButtons(true);
            } else {
                this.enablePropertyEditButtons(true);
            }
        } else {
            this.enablePropertyEditButtons(false);
            this.remFaultsButton.setEnabled(false);
            this.editFaultsButton.setEnabled(false);
        }
        if (selectedRows.length == 1) {
            this.setNotesPanel(this.faultTable.getLibraryModel().getObjectAtRow(this.faultTable.getSelectedRow()));
        } else {
            this.setNotesPanel(null);
        }
    }

    private JPanel getFaultLibraryPanel() {
        this.faultLibraryPanel = new JPanel(new BorderLayout());
        this.faultLibraryPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.faultLibraryPanel.setName("Library");
        this.faultLibraryPanel.setOpaque(false);
        JScrollPane scroller = new JScrollPane();
        scroller.setHorizontalScrollBarPolicy(31);
        scroller.setVerticalScrollBarPolicy(22);
        this.faultTable = new FaultTable(this);
        scroller.setViewportView(this.faultTable);
        scroller.getViewport().setBackground(this.faultTable.getBackground());
        this.faultLibraryPanel.add((Component)scroller, "Center");
        this.faultLibraryPanel.add((Component)this.getFaultLibraryBar(), "Last");
        return this.faultLibraryPanel;
    }

    private JPanel getFaultLibraryBar() {
        this.showFaultsButton = new ShowButton(this, "Toggle visibility of selected fault(s)");
        this.colorFaultsButton = new ColorButton(this, "Change color of selected fault(s)");
        this.meshFaultsButton = new MeshButton(this, "Toggle mesh state of selected fault(s)s");
        this.editFaultsButton = new EditButton(this, "Edit fault information");
        this.addFaultsButton = new AddButton(this, "Add/Import new faults");
        this.remFaultsButton = new RemoveButton(this, "Remove selected fault(s)");
        JPanel bar = new JPanel();
        bar.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        bar.setLayout(new BoxLayout(bar, 2));
        bar.setOpaque(true);
        int buttonSpace = 3;
        bar.add(this.showFaultsButton);
        bar.add(Box.createHorizontalStrut(buttonSpace));
        bar.add(this.colorFaultsButton);
        bar.add(Box.createHorizontalStrut(buttonSpace));
        bar.add(this.meshFaultsButton);
        bar.add(Box.createHorizontalStrut(buttonSpace));
        bar.add(Box.createHorizontalGlue());
        bar.add(Box.createHorizontalStrut(buttonSpace));
        bar.add(Box.createHorizontalGlue());
        bar.add(this.editFaultsButton);
        bar.add(Box.createHorizontalStrut(buttonSpace));
        bar.add(this.addFaultsButton);
        bar.add(Box.createHorizontalStrut(buttonSpace));
        bar.add(this.remFaultsButton);
        this.filterButton.addActionListener(this);
        bar.add(Box.createHorizontalStrut(buttonSpace));
        bar.add(this.filterButton);
        return bar;
    }

    private JPanel getGroupsPanel() {
        this.groupsPanel = new JPanel(new BorderLayout());
        this.groupsPanel.setName("Groups");
        this.groupsPanel.setOpaque(false);
        JScrollPane scroller = new JScrollPane();
        scroller.setHorizontalScrollBarPolicy(31);
        scroller.setVerticalScrollBarPolicy(22);
        this.groupList = new GroupList(this, this.faultTable);
        scroller.setViewportView(this.groupList);
        scroller.getViewport().setBackground(this.groupList.getBackground());
        this.groupsPanel.add((Component)scroller, "Center");
        this.groupsPanel.add((Component)this.getGroupBar(), "Last");
        return this.groupsPanel;
    }

    private JPanel getGroupBar() {
        this.newGroupButton = new AddButton(this, "Create a new group from visible faults");
        this.delGroupButton = new RemoveButton(this, "Delete selected group(s)");
        JPanel bar = new JPanel();
        bar.setLayout(new BoxLayout(bar, 2));
        bar.setOpaque(false);
        bar.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        bar.add(Box.createHorizontalGlue());
        bar.add(this.newGroupButton);
        bar.add(Box.createHorizontalStrut(3));
        bar.add(this.delGroupButton);
        return bar;
    }

    private JPanel getNotesPanel() {
        this.propsNotesPanel = new JPanel(new BorderLayout());
        this.propsNotesPanel.setOpaque(false);
        this.propsNotesPanel.setName("Notes");
        JScrollPane notesScrollPane = new JScrollPane();
        notesScrollPane.setHorizontalScrollBarPolicy(31);
        notesScrollPane.setVerticalScrollBarPolicy(22);
        this.faultNotes = new JTextArea();
        this.faultNotes.setEditable(false);
        this.faultNotes.setWrapStyleWord(true);
        this.faultNotes.setLineWrap(true);
        notesScrollPane.setViewportView(this.faultNotes);
        this.propsNotesPanel.add((Component)notesScrollPane, "Center");
        return this.propsNotesPanel;
    }

    private void setNotesPanel(DataAccessor fault) {
        if (fault != null) {
            this.faultNotes.setText(fault.getNotes());
        } else {
            this.faultNotes.setText("");
        }
    }

    public ObjectInfoDialog getSourceInfoDialog() {
        if (this.srcInfoDialog == null) {
            this.srcInfoDialog = new ObjectInfoDialog(this);
        }
        return this.srcInfoDialog;
    }

    private void runObjectInfoDialog(ArrayList objects) {
        ObjectInfoDialog oid = this.getSourceInfoDialog();
        if (objects.size() == 1) {
            DataAccessor obj = (DataAccessor)objects.get(0);
            oid.showInfo(obj, "Edit Fault Information");
            if (oid.windowWasCancelled()) {
                return;
            }
            this.setNotesPanel(obj);
            obj.writeAttributeFile();
        } else {
            oid.showInfo("Edit Fault Information");
            if (oid.windowWasCancelled()) {
                return;
            }
            for (int i = 0; i < objects.size(); ++i) {
                ((DataAccessor)objects.get(i)).setCitation(this.srcInfoDialog.getCitation());
                ((DataAccessor)objects.get(i)).setReference(this.srcInfoDialog.getReference());
                ((DataAccessor)objects.get(i)).setNotes(this.srcInfoDialog.getNotes());
                ((DataAccessor)objects.get(i)).writeAttributeFile();
            }
        }
    }

    private void enablePropertyEditButtons(boolean enable) {
        this.showFaultsButton.setEnabled(enable);
        this.meshFaultsButton.setEnabled(enable);
        this.colorFaultsButton.setEnabled(enable);
    }

    public boolean setROIFilter() {
        return this.ROIFilter;
    }

    private boolean isContained(float lat, float lon) {
        return false;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object src = e.getSource();
        this.faultTable.getLibraryModel();
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (src == this.faultTable.getSelectionModel()) {
            this.processTableSelectionChange();
        } else if (src == this.groupList.getSelectionModel()) {
            if (this.groupList.getSelectedIndices().length > 0) {
                this.delGroupButton.setEnabled(true);
            } else {
                this.delGroupButton.setEnabled(false);
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        FaultTableModel libModel = this.faultTable.getLibraryModel();
        if (libModel.anyAreVisible()) {
            this.newGroupButton.setEnabled(true);
        } else {
            this.newGroupButton.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FaultTableModel libModel = this.faultTable.getLibraryModel();
        Object src = e.getSource();
        if (src == this.showFaultsButton) {
            libModel.setLoadedStateForRows(true, this.faultTable.getSelectedRows());
            this.processTableSelectionChange();
            ArrayList<Fault3D> selectedFaults = this.faultTable.getSelected();
            for (Fault3D fault : selectedFaults) {
                if (fault.getFaultActor().GetVisibility() == 0) {
                    this.setVisibility(fault, 1);
                    continue;
                }
                this.setVisibility(fault, 0);
            }
            Info.getMainGUI();
            MainGUI.updateRenderWindow();
        } else if (src == this.meshFaultsButton) {
            libModel.toggleMeshStateForRows(this.faultTable.getSelectedRows());
            int[] selectedRows = this.faultTable.getSelectedRows();
            int row = 0;
            ArrayList<Fault3D> selectedFaults = this.faultTable.getSelected();
            for (Fault3D fault : selectedFaults) {
                int meshstate = libModel.getMeshStateForRow(selectedRows[row++]);
                this.setMeshState(fault, meshstate);
            }
            MainGUI.updateRenderWindow();
        } else if (src == this.colorFaultsButton) {
            Color newColor;
            if (this.colorChooser == null) {
                this.colorChooser = new SingleColorChooser(this);
            }
            if ((newColor = this.colorChooser.getColor()) != null) {
                libModel.setColorForRows(newColor, this.faultTable.getSelectedRows());
                this.faultTable.getSelectedRows();
                ArrayList<Fault3D> selectedFaults = this.faultTable.getSelected();
                for (Fault3D fault : selectedFaults) {
                    this.setColor(fault, newColor);
                }
                MainGUI.updateRenderWindow();
            }
        } else if (src == this.editFaultsButton) {
            this.runObjectInfoDialog(this.faultTable.getSelected());
        } else if (src == this.addFaultsButton) {
            if (this.fileChooser == null) {
                this.fileChooser = new DataFileChooser(this, "Import Fault Files", true, new File(MainGUI.getCWD(), "data"));
                if (new File(MainGUI.getCWD(), "data").exists()) {
                    this.fileChooser.setCurrentDirectory(new File(MainGUI.getCWD(), "data"));
                }
            }
            this.fileChooser.setCurrentFilter("ts", "GoCAD (*.ts)");
            File[] f = this.fileChooser.getFiles();
            this.addFaultsFromFile(f);
        } else if (src == this.remFaultsButton) {
            int[] selectedRows = this.faultTable.getSelectedRows();
            ArrayList<Fault3D> selectedFaults = this.faultTable.getSelected();
            new ArrayList();
            int delete = libModel.deleteObjects(this.faultTable, selectedRows);
            if (delete == 0) {
                for (Fault3D fault : selectedFaults) {
                    vtkActor actor = fault.getFaultActor();
                    this.pluginActors.removeActor((vtkProp)actor);
                }
            }
            MainGUI.updateRenderWindow();
        } else if (src == this.filterButton) {
            this.setROIFilter();
        } else if (src == this.newGroupButton) {
            this.groupList.createGroup();
        } else if (src == this.delGroupButton) {
            this.groupList.deleteGroup((Group)this.groupList.getSelectedValue());
        }
    }

    public void addFaultsFromFile(final File[] f) {
        final TSurfImport tsImport = new TSurfImport(this, f);
        this.task = new Task(){

            @Override
            public Void doInBackground() {
                ArrayList<Fault3D> newObjects;
                if (f != null && (newObjects = tsImport.processFiles()).size() > 0) {
                    CommunityFaultModelGUI.this.faultTable.addFaults(newObjects);
                    CommunityFaultModelGUI.this.faultTable.getRowCount();
                    ArrayList<DataAccessor> loadedRows = CommunityFaultModelGUI.this.faultTable.getLibraryModel().getAllObjects();
                    for (int i = 0; i < loadedRows.size(); ++i) {
                        Fault3D fault = (Fault3D)loadedRows.get(i);
                        System.out.println("Adding " + fault.getDisplayName());
                        PickEnabledActor<Fault3D> actor = new PickEnabledActor<Fault3D>(CommunityFaultModelGUI.this.getPickHandler(), fault);
                        actor.SetMapper(fault.getFaultMapper());
                        fault.setFaultActor(actor);
                        actor.GetProperty().SetRepresentationToWireframe();
                        CommunityFaultModelGUI.this.pluginActors.addActor((vtkProp)actor);
                        if (i % (loadedRows.size() / 20) != 0) continue;
                        this.setProgress((int)Math.ceil((float)i / (float)loadedRows.size() * 100.0f));
                    }
                    MainGUI.updateRenderWindow();
                }
                return null;
            }
        };
        this.task.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("progress" == evt.getPropertyName()) {
                    int progress = (Integer)evt.getNewValue();
                    CommunityFaultModelGUI.this.progbar.setValue(progress);
                    System.out.println("Progress: " + CommunityFaultModelGUI.this.progbar.getValue());
                    CommunityFaultModelGUI.this.repaint();
                }
            }
        });
        this.task.execute();
    }

    public void setColor(Fault3D fault, Color newColor) {
        vtkActor actor = fault.getFaultActor();
        double[] color = new double[]{(double)newColor.getRed() / 255.0, (double)newColor.getGreen() / 255.0, (double)newColor.getBlue() / 255.0};
        actor.GetProperty().SetColor(color);
    }

    public void setMeshState(Fault3D fault, Integer meshstate) {
        vtkActor actor = fault.getFaultActor();
        switch (meshstate) {
            case 0: {
                actor.GetProperty().SetRepresentationToSurface();
                actor.GetProperty().SetRepresentationToWireframe();
                break;
            }
            case 1: {
                actor.GetProperty().SetRepresentationToSurface();
                actor.GetProperty().EdgeVisibilityOn();
                break;
            }
            case 2: {
                actor.GetProperty().EdgeVisibilityOff();
                actor.GetProperty().SetRepresentationToSurface();
            }
        }
    }

    public void setVisibility(Fault3D fault, Integer visisble) {
        vtkActor actor = fault.getFaultActor();
        if (visisble == 0) {
            actor.VisibilityOff();
        } else {
            actor.VisibilityOn();
        }
    }

    public void unload() {
        System.out.println(this.pluginActors.getActors().size());
        for (int row = 0; row < this.faultTable.getRowCount(); ++row) {
            Fault3D fault = (Fault3D)this.faultTable.getModel().getValueAt(row, 0);
            vtkActor actor = fault.getFaultActor();
            this.pluginActors.removeActor((vtkProp)actor);
        }
        Info.getMainGUI();
        MainGUI.updateRenderWindow();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int progress = (Integer)evt.getNewValue();
        this.progbar.setValue(progress);
        System.out.println("Progress: " + this.progbar.getValue());
        this.repaint();
    }

    static {
        String dataStore = Prefs.getLibLoc() + File.separator + CommunityFaultModelPlugin.dataStoreDir + File.separator + "data";
        File f = new File(dataStore);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public class Task
    extends SwingWorker<Void, Void> {
        @Override
        public Void doInBackground() {
            return null;
        }

        @Override
        public void done() {
            this.setProgress(100);
        }
    }
}

