/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.CommunityfaultModelPlugin;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.dom4j.Element;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.CommunityfaultModelPlugin.CommunityFaultModelGUI;
import org.scec.vtk.plugins.CommunityfaultModelPlugin.components.Fault3D;
import org.scec.vtk.plugins.PluginState;

public class CommunityFaultModelPluginState
implements PluginState {
    private CommunityFaultModelGUI parent;
    private ArrayList<Fault3D> faults;
    private ArrayList<Color> color1;
    private ArrayList<Integer> meshState;
    ArrayList<Integer> visibility;
    private ArrayList<String> dispName;
    private ArrayList<String> filePath;
    private ArrayList<String> citation;
    private ArrayList<String> reference;
    private ArrayList<String> notes;

    CommunityFaultModelPluginState(CommunityFaultModelGUI parent) {
        this.parent = parent;
        this.faults = new ArrayList();
        this.dispName = new ArrayList();
        this.filePath = new ArrayList();
        this.color1 = new ArrayList();
        this.meshState = new ArrayList();
        this.visibility = new ArrayList();
        this.citation = new ArrayList();
        this.reference = new ArrayList();
        this.notes = new ArrayList();
    }

    void copyLatestCatalogDetials() {
        this.faults.clear();
        this.dispName.clear();
        this.filePath.clear();
        this.color1.clear();
        this.meshState.clear();
        this.visibility.clear();
        this.citation.clear();
        this.reference.clear();
        this.notes.clear();
        for (int row = 0; row < this.parent.faultTable.getRowCount(); ++row) {
            Fault3D fault = (Fault3D)this.parent.faultTable.getModel().getValueAt(row, 0);
            this.faults.add(fault);
            this.dispName.add(fault.getDisplayName());
            this.filePath.add(fault.getSourceFile());
            this.color1.add(fault.getColor());
            this.meshState.add(fault.getMeshState());
            this.visibility.add(fault.getFaultActor().GetVisibility());
            this.citation.add(fault.getCitation());
            this.reference.add(fault.getReference());
            this.notes.add(fault.getNotes());
        }
    }

    @Override
    public void load() {
        int i = 0;
        for (Fault3D fault : this.faults) {
            fault.setDisplayName(this.dispName.get(i));
            fault.setAttributeFile(this.filePath.get(i));
            fault.setCitation(this.citation.get(i));
            fault.setReference(this.reference.get(i));
            fault.setNotes(this.notes.get(i));
            this.parent.setColor(fault, this.color1.get(i));
            this.parent.faultTable.getLibraryModel().setColorForRow(this.color1.get(i), i);
            this.parent.setMeshState(fault, this.meshState.get(i));
            this.parent.faultTable.getLibraryModel().setMeshStateForRow(this.meshState.get(i), i);
            this.parent.setVisibility(fault, this.visibility.get(i));
            System.out.println(fault.getFaultActor().GetVisibility());
            ++i;
        }
        Info.getMainGUI();
        MainGUI.updateRenderWindow();
    }

    private void createElement(Element stateEl) {
        int i = 0;
        for (Fault3D eqc : this.faults) {
            Element propertyEl = stateEl.addElement("CFM");
            propertyEl.addElement("dispName").addText(this.dispName.get(i));
            propertyEl.addElement("filePath").addText(this.filePath.get(i));
            propertyEl.addElement("color1").addText(Integer.toString(this.color1.get(i).getRGB()));
            propertyEl.addElement("meshState").addText(Integer.toString(this.meshState.get(i)));
            propertyEl.addElement("citation").addText(this.citation.get(i));
            propertyEl.addElement("reference").addText(this.reference.get(i));
            propertyEl.addElement("notes").addText(this.notes.get(i));
            propertyEl.addElement("visibility").addText(this.visibility.get(i).toString());
            ++i;
        }
    }

    @Override
    public void toXML(Element stateEl) {
        this.copyLatestCatalogDetials();
        this.createElement(stateEl);
    }

    @Override
    public void fromXML(Element stateEl) {
        ArrayList<File> file = new ArrayList<File>();
        Iterator i = stateEl.elementIterator("CFM");
        while (i.hasNext()) {
            Element e = (Element)i.next();
            this.dispName.add(e.elementText("dispName"));
            this.filePath.add(e.elementText("filePath"));
            this.color1.add(Color.decode(e.elementText("color1")));
            this.visibility.add(Integer.parseInt(e.elementText("visibility")));
            this.meshState.add(Integer.parseInt(e.elementText("meshState")));
            this.citation.add(e.elementText("citation"));
            this.reference.add(e.elementText("reference"));
            this.notes.add(e.elementText("notes"));
            System.out.println(e.elementText("filePath"));
            file.add(new File(this.filePath.get(this.filePath.size() - 1)));
        }
        this.parent.addFaultsFromFile(file.toArray(new File[file.size()]));
        for (int row = 0; row < this.parent.faultTable.getRowCount(); ++row) {
            Fault3D fault = (Fault3D)this.parent.faultTable.getModel().getValueAt(row, 0);
            this.faults.add(fault);
        }
    }

    @Override
    public PluginState deepCopy() {
        CommunityFaultModelPluginState state = new CommunityFaultModelPluginState(this.parent);
        state.copyLatestCatalogDetials();
        return state;
    }
}

