/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.CommunityfaultModelPlugin.components;

import java.awt.Color;
import java.io.File;
import java.net.URL;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.scec.vtk.plugins.CommunityfaultModelPlugin.components.Fault3D;
import org.scec.vtk.plugins.utils.AbstractDataAccessor;
import org.scec.vtk.tools.picking.PickEnabledActor;
import vtk.vtkAbstractArray;
import vtk.vtkActor;
import vtk.vtkCellArray;
import vtk.vtkDataArray;
import vtk.vtkDataObject;
import vtk.vtkDoubleArray;
import vtk.vtkMapper;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkPolyDataReader;
import vtk.vtkPolyDataWriter;
import vtk.vtkStringArray;

public abstract class FaultAccessor
extends AbstractDataAccessor {
    private Logger log = Logger.getLogger(FaultAccessor.class);
    private Color color;
    private int meshState;
    protected Element objectAttributes;
    protected Element displayAttributes;
    protected vtkPoints vertices = null;
    protected vtkCellArray triangles = null;
    protected Color colors = null;
    protected vtkPolyData graphToPlyData = null;
    protected vtkDoubleArray lat = new vtkDoubleArray();
    protected vtkDoubleArray lon = new vtkDoubleArray();
    private vtkActor faultActor;
    private vtkPolyDataMapper faultRepresentation;
    private boolean objectInMemory = false;
    private static SAXBuilder parser = new SAXBuilder();
    private int selectedIndex;
    private vtkMapper faultMapper;
    private int visible;

    public FaultAccessor() {
        this.init();
    }

    @Override
    protected boolean newDocument() {
        if (super.newDocument()) {
            URL attsDoc = FaultAccessor.class.getResource("resources/xml/fault_template.xml");
            try {
                Document temp = parser.build(attsDoc);
                this.objectAttributes = (Element)temp.getRootElement().getChild("object_attributes").detach();
                this.displayAttributes = this.objectAttributes.getChild("display");
                this.objectDocument.getRootElement().addContent(this.objectAttributes);
            }
            catch (Exception e) {
                this.log.debug((Object)"problem parsing/reading XML");
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean readAttributeFile(File file) {
        if (!super.readAttributeFile(file)) {
            return false;
        }
        this.objectAttributes = this.objectDocument.getRootElement().getChild("object_attributes");
        this.displayAttributes = this.objectAttributes.getChild("display");
        try {
            this.meshState = this.displayAttributes.getChild("mesh_state").getAttribute("value").getIntValue();
            this.color = this.readColorElement(this.displayAttributes.getChild("color"));
        }
        catch (Exception e) {
            this.log.debug((Object)"problem reading XML");
            return false;
        }
        return true;
    }

    @Override
    public boolean readDataFile() {
        try {
            vtkPolyDataReader objIn = new vtkPolyDataReader();
            objIn.SetFileName(this.getDataFile().getAbsolutePath());
            objIn.Update();
            vtkStringArray infoArray = new vtkStringArray();
            infoArray.SetName("Info");
            infoArray.InsertNextValue(this.getDisplayName());
            vtkPolyData pd = new vtkPolyData();
            pd.SetPoints(objIn.GetOutput().GetPoints());
            pd.SetPolys(objIn.GetOutput().GetPolys());
            pd.GetPointData().AddArray((vtkAbstractArray)infoArray);
            vtkPolyDataMapper mapperassign1 = new vtkPolyDataMapper();
            mapperassign1.SetInputData(pd);
            this.faultMapper = mapperassign1;
            vtkDoubleArray c1 = (vtkDoubleArray)objIn.GetOutput().GetPointData().GetScalars("Colors");
            double[] c = c1.GetTuple3(0L);
            Color color = new Color((int)c[0], (int)c[1], (int)c[2]);
            this.setColor(color);
            c[0] = c[0] / 255.0;
            c[1] = c[1] / 255.0;
            c[2] = c[2] / 255.0;
            this.faultActor.GetProperty().SetColor(c);
        }
        catch (Exception e) {
            this.log.debug((Object)"problem reading binary data file");
            return false;
        }
        return true;
    }

    @Override
    public boolean writeDataFile() {
        try {
            vtkPolyDataWriter objOut = new vtkPolyDataWriter();
            objOut.SetFileName(this.getDataFile().getAbsolutePath());
            vtkPolyData polydata = new vtkPolyData();
            polydata.SetPoints(this.vertices);
            polydata.SetPolys(this.triangles);
            Color defaultColorFault = this.getColor();
            vtkDoubleArray colors = new vtkDoubleArray();
            colors.SetNumberOfComponents(3);
            colors.SetName("Colors");
            if (defaultColorFault == null && this.colors == null) {
                defaultColorFault = Color.lightGray;
            }
            if (this.colors != null) {
                defaultColorFault = this.colors;
            }
            colors.InsertNextTuple3((double)defaultColorFault.getRed(), (double)defaultColorFault.getGreen(), (double)defaultColorFault.getBlue());
            colors.InsertNextTuple3((double)defaultColorFault.getRed(), (double)defaultColorFault.getGreen(), (double)defaultColorFault.getBlue());
            colors.InsertNextTuple3((double)defaultColorFault.getRed(), (double)defaultColorFault.getGreen(), (double)defaultColorFault.getBlue());
            polydata.GetPointData().SetScalars((vtkDataArray)colors);
            objOut.SetInputData((vtkDataObject)polydata);
            objOut.Write();
        }
        catch (Exception e) {
            this.log.debug((Object)"problem writing binary data file");
            return false;
        }
        return true;
    }

    private void unload() {
        this.vertices = null;
        this.triangles = null;
        this.colors = null;
        this.faultRepresentation = null;
    }

    private void init() {
        this.faultActor = new vtkActor();
    }

    @Override
    public boolean isInMemory() {
        return this.objectInMemory;
    }

    @Override
    public void setInMemory(boolean load) {
        if (load) {
            this.readDataFile();
            this.setDisplayed(load);
        } else {
            this.setDisplayed(load);
            this.unload();
        }
        this.objectInMemory = load;
    }

    @Override
    public void setDisplayed(boolean show) {
        super.setDisplayed(show);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color newColor) {
        this.color = newColor;
        if (this.faultRepresentation != null) {
            this.faultActor.GetProperty().SetColor((double)newColor.getRed(), (double)newColor.getGreen(), (double)newColor.getBlue());
        }
        this.writeColorElement(this.displayAttributes.getChild("color"), this.color);
    }

    public void setColorNoLighting(Color newColor) {
        this.color = newColor;
    }

    public int getMeshState() {
        return this.meshState;
    }

    public void setMeshState(int meshValue) {
        this.meshState = meshValue;
        this.setColor(this.color);
    }

    public vtkPoints getVertices() {
        return this.vertices;
    }

    public vtkMapper getFaultMapper() {
        return this.faultMapper;
    }

    public void setFaultActor(PickEnabledActor<Fault3D> actor) {
        this.faultActor = actor;
    }

    public vtkActor getFaultActor() {
        return this.faultActor;
    }

    public void setIndex(int index) {
        this.selectedIndex = index;
    }

    public int getIndex() {
        return this.selectedIndex;
    }
}

