/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.CommunityfaultModelPlugin.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.colorchooser.DefaultColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.scec.vtk.plugins.CommunityfaultModelPlugin.CommunityFaultModelGUI;
import org.scec.vtk.plugins.CommunityfaultModelPlugin.CommunityFaultModelPlugin;
import org.scec.vtk.plugins.CommunityfaultModelPlugin.components.Fault3D;
import org.scec.vtk.plugins.CommunityfaultModelPlugin.components.FaultAccessor;
import org.scec.vtk.plugins.CommunityfaultModelPlugin.components.FaultTableModel;
import org.scec.vtk.plugins.CommunityfaultModelPlugin.components.MeshStateIcon;
import org.scec.vtk.plugins.utils.components.ColorWellIcon;
import org.scec.vtk.tools.Prefs;

public class FaultTable
extends JTable
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    Component tableOwner;
    private FaultTableModel tableModel;
    private ListSelectionModel selModel;

    public FaultTable(Component owner) {
        this.tableOwner = owner;
        this.init();
    }

    public void loadLibrary() {
        int i;
        this.tableModel.clear();
        File dataDir = new File(Prefs.getLibLoc() + File.separator + CommunityFaultModelPlugin.dataStoreDir);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".flt");
            }
        };
        File[] faultDirs = dataDir.listFiles();
        ArrayList<File> faultList = new ArrayList<File>();
        for (i = 0; i < faultDirs.length; ++i) {
            if (!faultDirs[i].isDirectory()) continue;
            List<File> files = Arrays.asList(faultDirs[i].listFiles(filter));
            if (files.size() == 0) {
                FaultTable.deleteDir(faultDirs[i]);
                continue;
            }
            faultList.addAll(files);
        }
        for (i = 0; i < faultList.size(); ++i) {
            Fault3D fault = new Fault3D((File)faultList.get(i));
            this.addFault(fault);
        }
    }

    public void addFaults(ArrayList faults) {
        this.tableModel.addObjects(faults);
    }

    public void addFault(Fault3D fault) {
        this.tableModel.addObject(fault);
    }

    public FaultTableModel getLibraryModel() {
        return this.tableModel;
    }

    public void setSelected(ArrayList objects) {
        this.clearSelection();
        this.selectionModel.setValueIsAdjusting(true);
        for (int i = 0; i < objects.size(); ++i) {
            FaultAccessor obj = (FaultAccessor)objects.get(i);
            if (!obj.isInMemory()) {
                obj.setIndex(i);
                obj.setInMemory(true);
            }
            int sel = this.tableModel.indexOf(obj);
            this.selectionModel.addSelectionInterval(sel, sel);
            this.loadSelection(objects);
        }
        this.selectionModel.setValueIsAdjusting(false);
    }

    public void loadSelection(ArrayList objects) {
        FaultAccessor obj;
        FaultTableModel libModel = this.getLibraryModel();
        for (int i = 0; i < libModel.getRowCount(); ++i) {
            obj = (FaultAccessor)this.tableModel.getObjectAtRow(i);
            obj.setDisplayed(false);
        }
        for (int j = 0; j < objects.size(); ++j) {
            obj = (FaultAccessor)objects.get(j);
            obj.setDisplayed(true);
        }
    }

    public ArrayList<Fault3D> getSelected() {
        FaultTableModel libModel = this.getLibraryModel();
        ArrayList<Fault3D> selectedObjects = new ArrayList<Fault3D>();
        int[] selectedRows = this.getSelectedRows();
        for (int i = 0; i < libModel.getRowCount(); ++i) {
            for (int j = 0; j < selectedRows.length; ++j) {
                if (i != selectedRows[j]) continue;
                selectedObjects.add((Fault3D)this.tableModel.getObjectAtRow(i));
            }
        }
        return selectedObjects;
    }

    private void init() {
        this.tableModel = new FaultTableModel();
        this.tableModel.addTableModelListener((TableModelListener)((Object)this.tableOwner));
        this.setModel(this.tableModel);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FaultTableModel libModel = FaultTable.this.getLibraryModel();
                CommunityFaultModelGUI gui = (CommunityFaultModelGUI)FaultTable.this.tableOwner;
                int col = FaultTable.this.getColumnModel().getColumnIndexAtX(e.getX());
                int row = e.getY() / FaultTable.this.getRowHeight();
                if (col == 0) {
                    if (!libModel.getLoadedStateForRow(row)) {
                        libModel.setLoadedStateForRow(true, row);
                        gui.processTableSelectionChange();
                    }
                } else if (col == 1 && libModel.getColorForRow(row) != null) {
                    Color newColor = null;
                    if (newColor != null) {
                        libModel.setColorForRows(newColor, FaultTable.this.getSelectedRows());
                    }
                } else if (col == 2) {
                    libModel.toggleMeshStateForRow(row);
                }
            }
        });
        this.selModel = this.getSelectionModel();
        this.selModel.setSelectionMode(2);
        this.selModel.addListSelectionListener((ListSelectionListener)((Object)this.tableOwner));
        this.setTableHeader(null);
        this.setRowHeight(this.getRowHeight() + 4);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setShowGrid(false);
        TableColumn col2 = this.getColumnModel().getColumn(1);
        col2.setCellRenderer(new ColorWellRenderer());
        col2.setPreferredWidth(20);
        col2.setMinWidth(20);
        col2.setMaxWidth(20);
        TableColumn col3 = this.getColumnModel().getColumn(2);
        col3.setCellRenderer(new MeshStateRenderer());
        col3.setPreferredWidth(20);
        col3.setMinWidth(20);
        col3.setMaxWidth(20);
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FaultTable.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int[] rows = this.getSelectedRows();
        if (rows.length > 0) {
            Color c = ((DefaultColorSelectionModel)e.getSource()).getSelectedColor();
            this.tableModel.setColorForRows(c, rows);
        }
    }

    private class ColorWellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private ColorWellIcon colorIcon = new ColorWellIcon(Color.WHITE, 11, 11, 2);

        ColorWellRenderer() {
            this.setHorizontalAlignment(2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object fault, boolean isSelected, boolean hasFocus, int row, int column) {
            FaultAccessor f = (FaultAccessor)fault;
            this.setEnabled(true);
            this.colorIcon.setColor(f.getColor());
            this.setIcon(this.colorIcon);
            this.setDisabledIcon(this.colorIcon);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else if (row % 2 == 0) {
                this.setBackground(Prefs.getStripingColor());
            } else {
                this.setBackground(table.getBackground());
            }
            return this;
        }
    }

    private class MeshStateRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        MeshStateIcon meshIcon = new MeshStateIcon(0);

        MeshStateRenderer() {
            this.setHorizontalAlignment(2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object fault, boolean isSelected, boolean hasFocus, int row, int column) {
            FaultAccessor f = (FaultAccessor)fault;
            this.setEnabled(true);
            this.meshIcon.setMeshState(f.getMeshState());
            this.setIcon(this.meshIcon);
            this.setDisabledIcon(this.meshIcon);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else if (row % 2 == 0) {
                this.setBackground(Prefs.getStripingColor());
            } else {
                this.setBackground(table.getBackground());
            }
            return this;
        }
    }
}

