/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.CommunityfaultModelPlugin.components;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.jdom.Element;
import org.scec.vtk.plugins.utils.AbstractLibraryModel;
import org.scec.vtk.plugins.utils.DataAccessor;
import org.scec.vtk.tools.Prefs;

public class Group {
    private String name;
    private ArrayList objList;
    private Element groupElement;

    public Group(String groupName, ArrayList groupFiles) {
        this.name = groupName;
        this.objList = groupFiles;
        this.groupElement = new Element("group");
        this.groupElement.setAttribute("name", this.name);
        ListIterator li = this.objList.listIterator();
        while (li.hasNext()) {
            Element e = new Element("object");
            e.addContent(((DataAccessor)li.next()).getAttributeFileLibPath());
            this.groupElement.addContent(e);
        }
    }

    public Group(Element element, AbstractLibraryModel objectLib) {
        this.groupElement = element;
        this.name = element.getAttributeValue("name");
        List faultList = element.getChildren("object");
        ListIterator li = faultList.listIterator();
        this.objList = new ArrayList();
        while (li.hasNext()) {
            DataAccessor obj = objectLib.findObject(new File(Prefs.getLibLoc() + ((Element)li.next()).getText()));
            if (obj == null) continue;
            this.objList.add(obj);
        }
    }

    public void setName(String groupName) {
        this.name = groupName;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public void setObjects(ArrayList objects) {
        this.objList = objects;
    }

    public ArrayList getObjects() {
        return this.objList;
    }

    public Element getGroupElement() {
        return this.groupElement;
    }
}

