/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.CommunityfaultModelPlugin.components;

import java.awt.Component;
import java.awt.Container;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.scec.vtk.plugins.CommunityfaultModelPlugin.CommunityFaultModelPlugin;
import org.scec.vtk.plugins.CommunityfaultModelPlugin.components.FaultTable;
import org.scec.vtk.plugins.CommunityfaultModelPlugin.components.Group;
import org.scec.vtk.plugins.utils.DataAccessor;
import org.scec.vtk.tools.Prefs;

public class GroupList
extends JList
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(GroupList.class);
    private Container listOwner;
    private FaultTable faultTable;
    private File groupFile;
    private ListSelectionModel selModel;
    private DefaultListModel listModel;
    private Document groupDoc;
    private Element groupDocRoot;

    public GroupList(Container owner, FaultTable dataTable) {
        this.listOwner = owner;
        this.faultTable = dataTable;
        this.init();
    }

    public void createGroup() {
        String groupName = JOptionPane.showInputDialog(this.listOwner, "Please provide a name for this group:", "Set Group ID", 3);
        if (groupName == null) {
            return;
        }
        Group existingGroup = this.groupNameExists(groupName);
        if (existingGroup != null) {
            int overwrite = JOptionPane.showConfirmDialog(this.listOwner, "Do you want to overwrite an existing group?", "Overwrite Group?", 1, 3);
            switch (overwrite) {
                case 2: {
                    return;
                }
                case -1: {
                    return;
                }
                case 1: {
                    this.createGroup();
                    return;
                }
                case 0: {
                    this.removeGroup(existingGroup);
                }
            }
        }
        ArrayList<DataAccessor> faultList = this.faultTable.getLibraryModel().getVisibleObjects();
        Group newGroup = new Group(groupName, faultList);
        this.groupDocRoot.addContent(newGroup.getGroupElement());
        this.writeGroupFile();
        this.listModel.addElement(newGroup);
    }

    public void loadGroups() {
        String groupFileName = Prefs.getLibLoc() + File.separator + CommunityFaultModelPlugin.dataStoreDir + File.separator + "groups.xml";
        this.groupFile = new File(groupFileName);
        SAXBuilder parser = new SAXBuilder();
        try {
            this.groupDoc = this.groupFile.exists() ? parser.build(this.groupFile) : parser.build(GroupList.class.getResource("resources/xml/groups.xml"));
            this.groupDocRoot = this.groupDoc.getRootElement();
            List list = this.groupDocRoot.getChildren("group");
            if (list.size() > 0) {
                ListIterator li = list.listIterator();
                while (li.hasNext()) {
                    Group g = new Group((Element)li.next(), this.faultTable.getLibraryModel());
                    this.listModel.addElement(g);
                }
            }
        }
        catch (Exception e) {
            this.log.debug((Object)"problem parsing XML");
        }
    }

    public void deleteGroup(Group group) {
        int delete = JOptionPane.showConfirmDialog(this.listOwner, "Are you sure you want to delete the selected group?\n(Actual data files are not deleted)", "Delete Group?", 0, 3);
        if (delete == 1) {
            return;
        }
        this.removeGroup(group);
        this.writeGroupFile();
    }

    private void init() {
        this.selModel = this.getSelectionModel();
        this.selModel.setSelectionMode(0);
        this.selModel.addListSelectionListener((ListSelectionListener)((Object)this.listOwner));
        this.selModel.addListSelectionListener(this);
        this.listModel = new DefaultListModel();
        this.setModel(this.listModel);
        this.setCellRenderer(new GroupListRenderer());
    }

    public void removeGroup(Group group) {
        this.listModel.removeElement(group);
        ListIterator li = this.groupDocRoot.getChildren("group").listIterator();
        while (li.hasNext()) {
            Element e = (Element)li.next();
            String name = e.getAttributeValue("name");
            if (!name.equals(group.getName())) continue;
            this.groupDocRoot.removeContent(e);
            break;
        }
        this.faultTable.clearSelection();
    }

    private void writeGroupFile() {
        try {
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            BufferedWriter xmlOut = new BufferedWriter(new FileWriter(this.groupFile));
            outputter.output(this.groupDoc, (Writer)xmlOut);
            xmlOut.close();
        }
        catch (IOException e) {
            this.log.debug((Object)"problem writing XML");
        }
    }

    private Group groupNameExists(String name) {
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            Group group = (Group)this.listModel.getElementAt(i);
            if (!group.getName().equals(name)) continue;
            return group;
        }
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.getSelectedValue() != null) {
            this.faultTable.setSelected(((Group)this.getSelectedValue()).getObjects());
        } else {
            this.faultTable.clearSelection();
        }
    }

    private class GroupListRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        GroupListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object group, int index, boolean isSelected, boolean hasFocus) {
            this.setText(((Group)group).getName());
            this.setBorder(BorderFactory.createEmptyBorder(3, 7, 3, 7));
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
            } else if (index % 2 == 0) {
                this.setBackground(Prefs.getStripingColor());
            } else {
                this.setBackground(list.getBackground());
            }
            return this;
        }
    }
}

