/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.CommunityfaultModelPlugin.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;

public class MeshStateIcon
implements Icon {
    private final int DEFAULT_ICON_SIZE = 11;
    private int width;
    private int height;
    public static final int MESH_NO_FILL = 0;
    public static final int MESH_SOLID_FILL = 1;
    public static final int NO_MESH_SOLID_FILL = 2;
    private int mesh;
    private static Color border = Color.GRAY;
    private static Color bgLight = new Color(230, 230, 230);
    private static Color bgMid = new Color(170, 170, 170);
    private static Color bgDark = new Color(110, 110, 110);
    private static Color meshLine = new Color(30, 30, 30);
    private static Color disabledColor = new Color(1.0f, 1.0f, 1.0f, 0.5f);

    public MeshStateIcon(int meshState) {
        this.width = this.DEFAULT_ICON_SIZE = 11;
        this.height = this.DEFAULT_ICON_SIZE;
        this.mesh = meshState;
    }

    public MeshStateIcon(int meshState, int iconSize) {
        this.width = this.DEFAULT_ICON_SIZE = 11;
        this.height = this.DEFAULT_ICON_SIZE;
        this.setIconDimensions(iconSize, iconSize);
        new MeshStateIcon(meshState);
    }

    public MeshStateIcon(int meshState, int iconWidth, int iconHeight) {
        this.width = this.DEFAULT_ICON_SIZE = 11;
        this.height = this.DEFAULT_ICON_SIZE;
        this.setIconDimensions(iconWidth, iconWidth);
        new MeshStateIcon(meshState);
    }

    public void setMeshState(int meshState) {
        this.mesh = meshState;
    }

    public void setIconDimensions(int iconWidth, int iconHeight) {
        this.width = iconWidth;
        this.height = iconHeight;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(border);
        g.drawRect(x, y, this.getIconWidth(), this.getIconHeight());
        if (this.mesh == 0) {
            g.setColor(bgLight);
        } else {
            g.setColor(bgDark);
        }
        g.fillRect(x + 1, y + 1, this.getIconWidth() - 1, this.getIconHeight() - 1);
        if (this.mesh == 0 || this.mesh == 1) {
            int evenWidth = 1;
            if (this.getIconWidth() % 2 == 1) {
                evenWidth = 1;
            }
            int middle = this.getIconWidth() / 2;
            int i = 1;
            int[] xs = new int[]{x + i, x + middle, x + middle + evenWidth, x + this.getIconWidth() - i};
            int[] ys = new int[]{y + this.getIconHeight() - i, y + i, y + this.getIconHeight() - i, y + i};
            g.setColor(meshLine);
            g.drawPolyline(xs, ys, 4);
        }
        if (!c.isEnabled()) {
            g.setColor(disabledColor);
            g.fillRect(x, y, this.width + 1, this.height + 1);
        }
    }
}

