/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.CommunityfaultModelPlugin.components;

import java.awt.Color;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.scec.vtk.plugins.CommunityfaultModelPlugin.CommunityFaultModelGUI;
import org.scec.vtk.plugins.CommunityfaultModelPlugin.CommunityFaultModelPlugin;
import org.scec.vtk.plugins.CommunityfaultModelPlugin.components.Fault3D;
import org.scec.vtk.plugins.utils.DataAccessor;
import org.scec.vtk.plugins.utils.DataImport;
import org.scec.vtk.plugins.utils.components.ChoiceDialog;
import org.scec.vtk.plugins.utils.components.ObjectInfoDialog;
import org.scec.vtk.tools.Prefs;
import org.scec.vtk.tools.Transform;
import org.scec.vtk.tools.convert;
import vtk.vtkActor;
import vtk.vtkCell;
import vtk.vtkCellArray;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkTriangle;

public class TSurfImport
implements DataImport {
    private Logger log = Logger.getLogger(TSurfImport.class);
    private File[] filesIn = null;
    private ArrayList<Fault3D> faultsOut = null;
    private Component owner = null;
    private Fault3D fault = null;
    private String importID = null;
    private String tmpDisplayName = null;
    private String tmpDatFile = null;
    private String tmpAttFile = null;
    private String tmpCitation;
    private String tmpReference;
    private String tmpNotes;
    private double spheroid = 20.0;
    private double zone = 11.0;

    public TSurfImport(Component parent, File[] files) {
        this.owner = parent;
        this.filesIn = files;
    }

    public ArrayList<Fault3D> processFiles() {
        return this.processFiles(true, null);
    }

    public ArrayList<Fault3D> processFiles(boolean showDialog, String groupName) {
        this.faultsOut = new ArrayList();
        File dataDir = new File(Prefs.getLibLoc() + File.separator + CommunityFaultModelPlugin.dataStoreDir);
        File[] existingImports = dataDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        String[] choices = existingImports != null ? new String[existingImports.length] : new String[]{};
        for (int i = 0; i < choices.length; ++i) {
            choices[i] = existingImports[i].getName();
        }
        this.importID = groupName;
        if (showDialog) {
            ChoiceDialog nameChooser = new ChoiceDialog(this.owner, "Create Import Name", true, "Please provide a group name for this import:", "[ e.g. CFMv1, USGS ]", choices, true);
            nameChooser.setVisible(true);
            this.importID = nameChooser.getInput();
        }
        if (this.importID == null) {
            return this.faultsOut;
        }
        File groupDir = new File(Prefs.getLibLoc() + File.separator + CommunityFaultModelPlugin.dataStoreDir + File.separator + this.importID + File.separator + "data");
        if (!groupDir.exists()) {
            groupDir.mkdirs();
        }
        if (showDialog) {
            ObjectInfoDialog objInfo = ((CommunityFaultModelGUI)this.owner).getSourceInfoDialog();
            objInfo.showInfo("Add import information");
            if (objInfo.windowWasCancelled()) {
                return this.faultsOut;
            }
            this.tmpCitation = objInfo.getCitation();
            this.tmpReference = objInfo.getReference();
            this.tmpNotes = objInfo.getNotes();
        }
        int numFiles = this.filesIn.length;
        int failureCount = 0;
        for (int i = 0; i < numFiles; ++i) {
            this.fault = null;
            File f = this.filesIn[i];
            this.fault = (Fault3D)this.processFile(f);
            if (this.fault != null) {
                this.faultsOut.add(this.fault);
                continue;
            }
            ++failureCount;
        }
        if (failureCount == 0) {
            // empty if block
        }
        return this.faultsOut;
    }

    public DataAccessor processFile(File file) {
        Fault3D newFault = new Fault3D();
        this.initNames(file);
        newFault.setObjectClass(newFault.getClass().getName());
        newFault.setSourceFile(file.getPath());
        newFault.setAttributeFile(this.tmpAttFile);
        newFault.setDataFile(this.tmpDatFile);
        newFault.setDisplayName(this.tmpDisplayName);
        newFault.setCitation(this.tmpCitation);
        newFault.setReference(this.tmpReference);
        newFault.setNotes(this.tmpNotes);
        this.readSourceFile(file, newFault);
        if (!newFault.writeAttributeFile() || !newFault.writeDataFile()) {
            return null;
        }
        newFault.setInMemory(true);
        return newFault;
    }

    private void initNames(File file) {
        String fileOutName;
        Object tempName = file.getName().substring(0, file.getName().lastIndexOf("."));
        StringTokenizer st = new StringTokenizer((String)tempName, "_");
        if (((String)tempName).startsWith("cfma")) {
            fileOutName = ((String)tempName).substring(5);
            st.nextToken();
        } else if (((String)tempName).startsWith("cfm")) {
            fileOutName = ((String)tempName).substring(4);
            st.nextToken();
        } else if (((String)tempName).startsWith("pre_cfma")) {
            fileOutName = ((String)tempName).substring(9);
            st.nextToken();
            st.nextToken();
        } else {
            fileOutName = tempName;
        }
        this.tmpDatFile = File.separator + CommunityFaultModelPlugin.dataStoreDir + File.separator + this.importID + File.separator + "data" + File.separator + fileOutName + ".dat";
        this.tmpAttFile = File.separator + CommunityFaultModelPlugin.dataStoreDir + File.separator + this.importID + File.separator + fileOutName + ".flt";
        tempName = "";
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            tempName = (String)tempName + s.substring(0, 1).toUpperCase() + s.substring(1) + " ";
        }
        this.tmpDisplayName = tempName = (String)tempName + "[" + this.importID + "] ";
    }

    private void readSourceFile(File file, Fault3D obj) {
        vtkPoints vertexArray = new vtkPoints();
        Color c = Color.BLUE;
        vtkActor actorassign = new vtkActor();
        vtkCellArray triangles = new vtkCellArray();
        try {
            String line;
            BufferedReader inStream = new BufferedReader(new FileReader(file));
            while ((line = inStream.readLine()) != null) {
                StringTokenizer data = new StringTokenizer(line);
                if (!data.hasMoreTokens()) continue;
                String temp = data.nextToken();
                if (temp.equals("VRTX") || temp.equals("PVRTX")) {
                    data.nextToken();
                    double[] latlon1 = this.getLatLon(Double.parseDouble(data.nextToken()), Double.parseDouble(data.nextToken()));
                    double zVal = Double.parseDouble(data.nextToken()) / 1000.0;
                    double[] x = new double[3];
                    x = Transform.transformLatLonHeight(latlon1[0], latlon1[1], zVal);
                    vertexArray.InsertNextPoint(x);
                    continue;
                }
                if (temp.equals("TRGL")) {
                    int[] triangle1 = new int[]{Integer.parseInt(data.nextToken()) - 1, Integer.parseInt(data.nextToken()) - 1, Integer.parseInt(data.nextToken()) - 1};
                    vtkTriangle triangle = new vtkTriangle();
                    triangle.GetPointIds().SetId(0L, (long)triangle1[0]);
                    triangle.GetPointIds().SetId(1L, (long)triangle1[1]);
                    triangle.GetPointIds().SetId(2L, (long)triangle1[2]);
                    triangles.InsertNextCell((vtkCell)triangle);
                    continue;
                }
                if (temp.equals("ATOM")) {
                    data.nextToken();
                    int alias = Integer.parseInt(data.nextToken());
                    vertexArray.InsertNextPoint(vertexArray.GetPoint((long)alias));
                }
                if (temp.startsWith("*solid*color:")) {
                    try {
                        c = new Color(Float.parseFloat(temp.substring(13, temp.length())), Float.parseFloat(data.nextToken()), Float.parseFloat(data.nextToken()));
                        actorassign.GetProperty().SetColor((double)c.getRed(), (double)c.getGreen(), (double)c.getBlue());
                    }
                    catch (NumberFormatException nfe) {
                        c = Color.lightGray;
                    }
                    continue;
                }
                c = Color.lightGray;
            }
            inStream.close();
        }
        catch (Exception e) {
            actorassign = null;
        }
        obj.vertices = vertexArray;
        obj.triangles = triangles;
        obj.colors = c;
        obj.graphToPlyData = new vtkPolyData();
        obj.graphToPlyData.SetPoints(obj.vertices);
        obj.graphToPlyData.SetPolys(obj.triangles);
    }

    public double[] getLatLon(double UTMx, double UTMy) {
        convert c = new convert();
        c.setAllValues(UTMx, UTMy, this.spheroid, this.zone);
        return c.UTMToLatLon(true);
    }
}

