/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.DummyPlugin;

import java.io.IOException;
import javax.swing.JPanel;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.ActionPlugin;
import org.scec.vtk.plugins.DummyPlugin.DummyPluginGUI;
import org.scec.vtk.plugins.DummyPlugin.DummyPluginState;
import org.scec.vtk.plugins.PluginState;
import org.scec.vtk.plugins.StatefulPlugin;
import org.scec.vtk.tools.Transform;
import vtk.vtkActor;
import vtk.vtkMapper;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;
import vtk.vtkSphereSource;

public class DummyPlugin
extends ActionPlugin
implements StatefulPlugin {
    private boolean sphereLoaded = false;
    private vtkSphereSource sphere = null;
    private vtkActor actor = null;
    DummyPluginGUI gratPanel;
    DummyPluginState state;

    private void createSphere() {
        this.sphere = new vtkSphereSource();
        this.sphere.SetRadius(20.0);
        double[] coords = new double[]{34.0192, -118.286};
        double[] xyzCoords = Transform.transformLatLon(coords[0], coords[1]);
        this.sphere.SetCenter(xyzCoords);
        vtkPolyDataMapper mapper = new vtkPolyDataMapper();
        mapper.SetInputConnection(this.sphere.GetOutputPort());
        this.actor = new vtkActor();
        this.actor.SetMapper((vtkMapper)mapper);
    }

    public void loadSphere() {
        if (this.sphereLoaded) {
            return;
        }
        if (this.sphere == null) {
            this.createSphere();
        }
        System.out.println("Loading sphere.");
        this.actor.SetVisibility(1);
        this.actor.Modified();
        this.getPluginActors().addActor((vtkProp)this.actor);
        MainGUI.updateRenderWindow();
        this.sphereLoaded = true;
    }

    public void unloadSphere() {
        if (!this.sphereLoaded) {
            return;
        }
        System.out.println("Unloading sphere.");
        this.getPluginActors().removeActor((vtkProp)this.actor);
        MainGUI.updateRenderWindow();
        this.sphereLoaded = false;
    }

    @Override
    public JPanel createGUI() throws IOException {
        this.gratPanel = new DummyPluginGUI(this);
        return this.gratPanel.getPanel();
    }

    public DummyPluginGUI getGraticuleGUI() {
        return this.gratPanel;
    }

    @Override
    public PluginState getState() {
        if (this.state == null) {
            this.state = new DummyPluginState(this.gratPanel);
        }
        return this.state;
    }
}

