/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.EarthquakeCatalogPlugin;
import org.scec.vtk.plugins.utils.AbstractDataAccessor;
import org.scec.vtk.tools.Prefs;

public abstract class CatalogAccessor
extends AbstractDataAccessor {
    private Logger log = Logger.getLogger(CatalogAccessor.class);
    public static final int DATA_SCOPE_NO_EXTRAS = 11;
    public static final int DATA_SCOPE_UNCERT = 13;
    public static final int DATA_SCOPE_FOCAL = 14;
    public static final int DATA_SCOPE_UNCERT_FOCAL = 16;
    public static final int DATA_SCOPE_FOCAL_PROB = 18;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MMMM dd, yyyy  (HH:mm:ss)");
    protected int numEvents;
    private int dataScope;
    private float minLatitude;
    private float maxLatitude;
    private float minLongitude;
    private float maxLongitude;
    private float minDepth;
    private float maxDepth;
    private float minMagnitude;
    private float maxMagnitude;
    private Date minDate;
    private Date maxDate;
    protected Component owner;
    protected Element objectAttributes;
    protected Element dataAttributes;
    protected int[] eq_id = null;
    protected Date[] eq_time = null;
    protected float[] eq_latitude = null;
    protected float[] eq_longitude = null;
    protected float[] eq_depth = null;
    protected float[] eq_magnitude = null;
    protected float[] eq_xy_error = null;
    protected float[] eq_z_error = null;
    protected int[] eq_strike = null;
    protected int[] eq_dip = null;
    protected int[] eq_rake = null;
    protected int[] eq_nodal = null;
    protected float[] eq_probability = null;
    private boolean objectInMemory = false;
    protected static SAXBuilder parser = new SAXBuilder();

    public CatalogAccessor(Component parent) {
        this.owner = parent;
    }

    @Override
    protected boolean newDocument() {
        if (super.newDocument()) {
            URL attsDoc = CatalogAccessor.class.getResource("resources/xml/catalog_template.xml");
            try {
                Document temp = parser.build(attsDoc);
                this.objectAttributes = (Element)temp.getRootElement().getChild("object_attributes").detach();
                this.dataAttributes = this.objectAttributes.getChild("data");
                this.objectDocument.getRootElement().addContent(this.objectAttributes);
            }
            catch (Exception e) {
                this.log.debug((Object)"problem parsing XML");
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean readAttributeFile(File file) {
        if (!super.readAttributeFile(file)) {
            return false;
        }
        this.objectAttributes = this.objectDocument.getRootElement().getChild("object_attributes");
        this.dataAttributes = this.objectAttributes.getChild("data");
        try {
            this.numEvents = this.dataAttributes.getAttribute("num_events").getIntValue();
            this.dataScope = this.dataAttributes.getAttribute("scope").getIntValue();
            this.minLatitude = this.dataAttributes.getChild("latitude").getAttribute("min").getFloatValue();
            this.maxLatitude = this.dataAttributes.getChild("latitude").getAttribute("max").getFloatValue();
            this.minLongitude = this.dataAttributes.getChild("longitude").getAttribute("min").getFloatValue();
            this.maxLongitude = this.dataAttributes.getChild("longitude").getAttribute("max").getFloatValue();
            this.minDepth = this.dataAttributes.getChild("depth").getAttribute("min").getFloatValue();
            this.maxDepth = this.dataAttributes.getChild("depth").getAttribute("max").getFloatValue();
            this.minMagnitude = this.dataAttributes.getChild("magnitude").getAttribute("min").getFloatValue();
            this.maxMagnitude = this.dataAttributes.getChild("magnitude").getAttribute("max").getFloatValue();
            this.minDate = DATE_FORMAT.parse(this.dataAttributes.getChild("date").getAttributeValue("min"));
            this.maxDate = DATE_FORMAT.parse(this.dataAttributes.getChild("date").getAttributeValue("max"));
        }
        catch (Exception e) {
            this.log.debug((Object)"problem reading XML");
            return false;
        }
        return true;
    }

    @Override
    public boolean readDataFile() {
        try {
            ObjectInputStream objIn = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.getDataFile())));
            this.eq_id = (int[])objIn.readObject();
            this.eq_time = (Date[])objIn.readObject();
            this.eq_latitude = (float[])objIn.readObject();
            this.eq_longitude = (float[])objIn.readObject();
            this.eq_depth = (float[])objIn.readObject();
            this.eq_magnitude = (float[])objIn.readObject();
            if (this.getDataScope() == 13 || this.getDataScope() == 16 || this.getDataScope() == 18) {
                this.eq_xy_error = (float[])objIn.readObject();
                this.eq_z_error = (float[])objIn.readObject();
            }
            if (this.getDataScope() == 14 || this.getDataScope() == 16 || this.getDataScope() == 18) {
                this.eq_strike = (int[])objIn.readObject();
                this.eq_dip = (int[])objIn.readObject();
                this.eq_rake = (int[])objIn.readObject();
            }
            if (this.getDataScope() == 18) {
                this.eq_nodal = (int[])objIn.readObject();
                this.eq_probability = (float[])objIn.readObject();
            }
            objIn.close();
        }
        catch (Exception e) {
            this.log.debug((Object)"problem reading binary data file");
            return false;
        }
        return true;
    }

    @Override
    public boolean writeDataFile() {
        try {
            ObjectOutputStream objOut = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.getDataFile())));
            objOut.writeObject(this.eq_id);
            objOut.writeObject(this.eq_time);
            objOut.writeObject(this.eq_latitude);
            objOut.writeObject(this.eq_longitude);
            objOut.writeObject(this.eq_depth);
            objOut.writeObject(this.eq_magnitude);
            if (this.getDataScope() == 13 || this.getDataScope() == 16 || this.getDataScope() == 18) {
                objOut.writeObject(this.eq_xy_error);
                objOut.writeObject(this.eq_z_error);
            }
            if (this.getDataScope() == 14 || this.getDataScope() == 16 || this.getDataScope() == 18) {
                objOut.writeObject(this.eq_strike);
                objOut.writeObject(this.eq_dip);
                objOut.writeObject(this.eq_rake);
            }
            if (this.getDataScope() == 18) {
                objOut.writeObject(this.eq_nodal);
                objOut.writeObject(this.eq_probability);
            }
            objOut.close();
        }
        catch (Exception e) {
            this.log.debug((Object)"problem writing binary data file");
            return false;
        }
        return true;
    }

    protected String confirmOutputFile(String name) {
        String filename = Prefs.getLibLoc() + File.separator + EarthquakeCatalogPlugin.dataStoreDir + File.separator + "source" + File.separator + name + ".cat";
        String newName = name;
        if (new File(filename).exists()) {
            JTextField textfield = new JTextField(20);
            textfield.setText(name);
            String message = "A catalog with this name already  \nexists. Change the name below or  \nclick OK to overwrite file.\n\n";
            int val = JOptionPane.showConfirmDialog(this.owner, new Object[]{message, textfield}, "Warning: Catalog Exists", 2, 2);
            if (val == -1 || val == 2) {
                return null;
            }
            newName = textfield.getText().trim().equals("") ? "source" : textfield.getText().trim();
        }
        return newName;
    }

    protected void initializeArrays(int length) {
        this.eq_id = new int[length];
        this.eq_time = new Date[length];
        this.eq_latitude = new float[length];
        this.eq_longitude = new float[length];
        this.eq_depth = new float[length];
        this.eq_magnitude = new float[length];
        if (this.getDataScope() == 13 || this.getDataScope() == 16 || this.getDataScope() == 18) {
            this.eq_xy_error = new float[length];
            this.eq_z_error = new float[length];
        }
        if (this.getDataScope() == 14 || this.getDataScope() == 16 || this.getDataScope() == 18) {
            this.eq_strike = new int[length];
            this.eq_dip = new int[length];
            this.eq_rake = new int[length];
        }
        if (this.getDataScope() == 18) {
            this.eq_nodal = new int[length];
            this.eq_probability = new float[length];
        }
    }

    protected void clearArrays() {
        this.eq_id = null;
        this.eq_time = null;
        this.eq_latitude = null;
        this.eq_longitude = null;
        this.eq_depth = null;
        this.eq_magnitude = null;
        this.eq_xy_error = null;
        this.eq_z_error = null;
        this.eq_strike = null;
        this.eq_dip = null;
        this.eq_rake = null;
        this.eq_nodal = null;
        this.eq_probability = null;
    }

    public void cloneEvents(CatalogAccessor src, int[] srcIndices) {
        int i;
        this.setDataScope(src.getDataScope());
        this.setNumEvents(srcIndices.length);
        this.initializeArrays(srcIndices.length);
        for (i = 0; i < srcIndices.length; ++i) {
            this.eq_id[i] = src.eq_id[srcIndices[i]];
            this.eq_time[i] = src.eq_time[srcIndices[i]];
            this.eq_latitude[i] = src.eq_latitude[srcIndices[i]];
            this.eq_longitude[i] = src.eq_longitude[srcIndices[i]];
            this.eq_depth[i] = src.eq_depth[srcIndices[i]];
            this.eq_magnitude[i] = src.eq_magnitude[srcIndices[i]];
        }
        if (src.getDataScope() == 13 || src.getDataScope() == 16 || src.getDataScope() == 18) {
            for (i = 0; i < srcIndices.length; ++i) {
                this.eq_xy_error[i] = src.eq_xy_error[srcIndices[i]];
                this.eq_z_error[i] = src.eq_z_error[srcIndices[i]];
            }
        }
        if (src.getDataScope() == 14 || src.getDataScope() == 16 || src.getDataScope() == 18) {
            for (i = 0; i < srcIndices.length; ++i) {
                this.eq_strike[i] = src.eq_strike[srcIndices[i]];
                this.eq_dip[i] = src.eq_dip[srcIndices[i]];
                this.eq_rake[i] = src.eq_rake[srcIndices[i]];
            }
        }
        if (src.getDataScope() == 18) {
            for (i = 0; i < srcIndices.length; ++i) {
                this.eq_nodal[i] = src.eq_nodal[srcIndices[i]];
                this.eq_probability[i] = src.eq_probability[srcIndices[i]];
            }
        }
    }

    public void runMinMax() {
        int i;
        float min_lat = 90.0f;
        float max_lat = -90.0f;
        float min_lon = 180.0f;
        float max_lon = -180.0f;
        float min_dep = 5.0f;
        float max_dep = -600.0f;
        float min_mag = 10.0f;
        float max_mag = 0.0f;
        int events = this.getNumEvents();
        for (i = 0; i < events; ++i) {
            if (this.eq_latitude[i] <= min_lat) {
                min_lat = this.eq_latitude[i];
            }
            if (!(this.eq_latitude[i] >= max_lat)) continue;
            max_lat = this.eq_latitude[i];
        }
        for (i = 0; i < events; ++i) {
            if (this.eq_longitude[i] <= min_lon) {
                min_lon = this.eq_longitude[i];
            }
            if (!(this.eq_longitude[i] >= max_lon)) continue;
            max_lon = this.eq_longitude[i];
        }
        for (i = 0; i < events; ++i) {
            if (this.eq_depth[i] <= min_dep) {
                min_dep = this.eq_depth[i];
            }
            if (!(this.eq_depth[i] >= max_dep)) continue;
            max_dep = this.eq_depth[i];
        }
        for (i = 0; i < events; ++i) {
            if (this.eq_magnitude[i] <= min_mag) {
                min_mag = this.eq_magnitude[i];
            }
            if (!(this.eq_magnitude[i] >= max_mag)) continue;
            max_mag = this.eq_magnitude[i];
        }
        this.setMinLatitude(min_lat);
        this.setMaxLatitude(max_lat);
        this.setMinLongitude(min_lon);
        this.setMaxLongitude(max_lon);
        this.setMinDepth(min_dep);
        this.setMaxDepth(max_dep);
        this.setMinMagnitude(min_mag);
        this.setMaxMagnitude(max_mag);
        this.setMinDate(this.eq_time[0]);
        this.setMaxDate(this.eq_time[events - 1]);
    }

    @Override
    public boolean isInMemory() {
        return this.objectInMemory;
    }

    @Override
    public void setInMemory(boolean load) {
        this.objectInMemory = load;
    }

    public int getDataScope() {
        return this.dataScope;
    }

    public void setDataScope(int scope) {
        this.dataScope = scope;
        this.dataAttributes.getAttribute("scope").setValue(String.valueOf(scope));
    }

    public Date getMaxDate() {
        return this.maxDate;
    }

    public void setMaxDate(Date date) {
        this.maxDate = date;
        String s = DATE_FORMAT.format(date);
    }

    public float getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(float depth) {
        this.maxDepth = depth;
    }

    public float getMaxLatitude() {
        return this.maxLatitude;
    }

    public void setMaxLatitude(float latitude) {
        this.maxLatitude = latitude;
    }

    public float getMaxLongitude() {
        return this.maxLongitude;
    }

    public void setMaxLongitude(float longitude) {
        this.maxLongitude = longitude;
    }

    public float getMaxMagnitude() {
        return this.maxMagnitude;
    }

    public void setMaxMagnitude(float magnitude) {
        this.maxMagnitude = magnitude;
    }

    public Date getMinDate() {
        return this.minDate;
    }

    public void setMinDate(Date date) {
        this.minDate = date;
        String s = DATE_FORMAT.format(date);
    }

    public float getMinDepth() {
        return this.minDepth;
    }

    public void setMinDepth(float depth) {
        this.minDepth = depth;
    }

    public float getMinLatitude() {
        return this.minLatitude;
    }

    public void setMinLatitude(float latitude) {
        this.minLatitude = latitude;
    }

    public float getMinLongitude() {
        return this.minLongitude;
    }

    public void setMinLongitude(float longitude) {
        this.minLongitude = longitude;
    }

    public float getMinMagnitude() {
        return this.minMagnitude;
    }

    public void setMinMagnitude(float magnitude) {
        this.minMagnitude = magnitude;
    }

    public float getAvgLat() {
        return (this.minLatitude + this.maxLatitude) / 2.0f;
    }

    public float getAvgLon() {
        return (this.minLongitude + this.maxLongitude) / 2.0f;
    }

    public int getNumEvents() {
        return this.numEvents;
    }

    public void setNumEvents(int events) {
        this.numEvents = events;
    }

    public void setEq_depth(int index, float depth) {
        this.eq_depth[index] = depth;
    }

    public float getEq_depth(int index) {
        return this.eq_depth[index];
    }

    public int getEq_dip(int index) {
        return this.eq_dip[index];
    }

    public int getEq_id(int index) {
        return this.eq_id[index];
    }

    public float getEq_latitude(int index) {
        return this.eq_latitude[index];
    }

    public float getEq_longitude(int index) {
        return this.eq_longitude[index];
    }

    public float getEq_magnitude(int index) {
        return this.eq_magnitude[index];
    }

    public int getEq_rake(int index) {
        return this.eq_rake[index];
    }

    public int getEq_strike(int index) {
        return this.eq_strike[index];
    }

    public Date getEq_time(int index) {
        return this.eq_time[index];
    }

    public float getEq_xy_error(int index) {
        return this.eq_xy_error[index];
    }

    public float getEq_z_error(int index) {
        return this.eq_z_error[index];
    }

    public int getEQ_nodal(int index) {
        return this.eq_nodal[index];
    }

    public float getEQ_probability(int index) {
        return this.eq_probability[index];
    }
}

