/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components.CatalogTableModel;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components.Copyfiles;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components.EQCatalog;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components.SourceList;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.EarthquakeCatalogPlugin;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.EarthquakeCatalogPluginGUI;
import org.scec.vtk.plugins.PluginActors;
import org.scec.vtk.plugins.utils.components.CheckBoxRenderer;
import org.scec.vtk.plugins.utils.components.ColorDiscIcon;
import org.scec.vtk.plugins.utils.components.ColorWellIcon;
import org.scec.vtk.plugins.utils.components.StringRenderer;
import org.scec.vtk.tools.Prefs;

public class CatalogTable
extends JTable {
    private static final String destinationData = Prefs.getLibLoc() + File.separator + EarthquakeCatalogPlugin.dataStoreDir + File.separator + "display" + File.separator + "data";
    private static final String destinationDisplay = Prefs.getLibLoc() + File.separator + EarthquakeCatalogPlugin.dataStoreDir + File.separator + "display";
    private static final long serialVersionUID = 1L;
    protected Component parent;
    public CatalogTableModel tableModel;
    private ListSelectionModel selModel;
    private PluginActors actors;

    public CatalogTable(Component owner, PluginActors actors) {
        this.actors = actors;
        this.parent = owner;
        this.init();
    }

    public void loadCatalogs() throws IOException {
        this.tableModel.clear();
        Info.getMainGUI();
        Copyfiles.copy(String.valueOf(MainGUI.getCWD()) + File.separator + "conf" + File.separator + "ScecVideoDefaults" + File.separator + "EQCatalogStore" + File.separator + "display" + File.separator + "data" + File.separator + "filteredCat_000000.dat", destinationData);
        Info.getMainGUI();
        Copyfiles.copy(String.valueOf(MainGUI.getCWD()) + File.separator + "conf" + File.separator + "ScecVideoDefaults" + File.separator + "EQCatalogStore" + File.separator + "display" + File.separator + "data" + File.separator + "filteredCat_314784.dat", destinationData);
        Info.getMainGUI();
        Copyfiles.copy(String.valueOf(MainGUI.getCWD()) + File.separator + "conf" + File.separator + "ScecVideoDefaults" + File.separator + "EQCatalogStore" + File.separator + "display" + File.separator + "data" + File.separator + "filteredCat_321964.dat", destinationData);
        Info.getMainGUI();
        Copyfiles.copy(String.valueOf(MainGUI.getCWD()) + File.separator + "conf" + File.separator + "ScecVideoDefaults" + File.separator + "EQCatalogStore" + File.separator + "display" + File.separator + "data" + File.separator + "filteredCat_343741.dat", destinationData);
        Info.getMainGUI();
        Copyfiles.copy(String.valueOf(MainGUI.getCWD()) + File.separator + "conf" + File.separator + "ScecVideoDefaults" + File.separator + "EQCatalogStore" + File.separator + "display" + File.separator + "data" + File.separator + "filteredCat_454569.dat", destinationData);
        Info.getMainGUI();
        Copyfiles.copy(String.valueOf(MainGUI.getCWD()) + File.separator + "conf" + File.separator + "ScecVideoDefaults" + File.separator + "EQCatalogStore" + File.separator + "display" + File.separator + "data" + File.separator + "filteredCat_482015.dat", destinationData);
        Info.getMainGUI();
        Copyfiles.copy(String.valueOf(MainGUI.getCWD()) + File.separator + "conf" + File.separator + "ScecVideoDefaults" + File.separator + "EQCatalogStore" + File.separator + "display" + File.separator + "data" + File.separator + "filteredCat_501171.dat", destinationData);
        Info.getMainGUI();
        Copyfiles.copy(String.valueOf(MainGUI.getCWD()) + File.separator + "conf" + File.separator + "ScecVideoDefaults" + File.separator + "EQCatalogStore" + File.separator + "display" + File.separator + "data" + File.separator + "filteredCat_266570.dat", destinationData);
        Info.getMainGUI();
        Copyfiles.copy(String.valueOf(MainGUI.getCWD()) + File.separator + "conf" + File.separator + "ScecVideoDefaults" + File.separator + "EQCatalogStore" + File.separator + "display" + File.separator + "filteredCat_000000.cat", destinationDisplay);
        Info.getMainGUI();
        Copyfiles.copy(String.valueOf(MainGUI.getCWD()) + File.separator + "conf" + File.separator + "ScecVideoDefaults" + File.separator + "EQCatalogStore" + File.separator + "display" + File.separator + "filteredCat_314784.cat", destinationDisplay);
        Info.getMainGUI();
        Copyfiles.copy(String.valueOf(MainGUI.getCWD()) + File.separator + "conf" + File.separator + "ScecVideoDefaults" + File.separator + "EQCatalogStore" + File.separator + "display" + File.separator + "filteredCat_321964.cat", destinationDisplay);
        Info.getMainGUI();
        Copyfiles.copy(String.valueOf(MainGUI.getCWD()) + File.separator + "conf" + File.separator + "ScecVideoDefaults" + File.separator + "EQCatalogStore" + File.separator + "display" + File.separator + "filteredCat_343741.cat", destinationDisplay);
        Info.getMainGUI();
        Copyfiles.copy(String.valueOf(MainGUI.getCWD()) + File.separator + "conf" + File.separator + "ScecVideoDefaults" + File.separator + "EQCatalogStore" + File.separator + "display" + File.separator + "filteredCat_454569.cat", destinationDisplay);
        Info.getMainGUI();
        Copyfiles.copy(String.valueOf(MainGUI.getCWD()) + File.separator + "conf" + File.separator + "ScecVideoDefaults" + File.separator + "EQCatalogStore" + File.separator + "display" + File.separator + "filteredCat_482015.cat", destinationDisplay);
        Info.getMainGUI();
        Copyfiles.copy(String.valueOf(MainGUI.getCWD()) + File.separator + "conf" + File.separator + "ScecVideoDefaults" + File.separator + "EQCatalogStore" + File.separator + "display" + File.separator + "filteredCat_501171.cat", destinationDisplay);
        Info.getMainGUI();
        Copyfiles.copy(String.valueOf(MainGUI.getCWD()) + File.separator + "conf" + File.separator + "ScecVideoDefaults" + File.separator + "EQCatalogStore" + File.separator + "display" + File.separator + "filteredCat_266570.cat", destinationDisplay);
        File file = new File(Prefs.getLibLoc() + File.separator + EarthquakeCatalogPlugin.dataStoreDir + File.separator + "display");
        File[] cats = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".cat");
            }
        });
        for (int i = 0; i < cats.length; ++i) {
            try {
                EQCatalog cat = new EQCatalog(this.parent, cats[i], this.actors);
                cat.setGeometry(1);
                this.addCatalog(cat);
                continue;
            }
            catch (Exception e) {
                System.out.println("Poorly formatted input");
            }
        }
    }

    public void addCatalog(EQCatalog catalog) {
        this.tableModel.addObject(catalog);
    }

    public CatalogTableModel getLibraryModel() {
        return this.tableModel;
    }

    public EQCatalog getSelectedValue() {
        if (this.getSelectedRow() != -1) {
            return (EQCatalog)this.tableModel.getObjectAtRow(this.getSelectedRow());
        }
        return null;
    }

    public void setSelected(EQCatalog object) {
        this.clearSelection();
        this.selectionModel.setValueIsAdjusting(true);
        int sel = this.tableModel.indexOf(object);
        this.selectionModel.addSelectionInterval(sel, sel);
        this.selectionModel.setValueIsAdjusting(false);
    }

    public void setVisibility(CatalogTableModel libModel, EQCatalog libCat, int row) {
        boolean show = false;
        if (libModel.getObjectAtRow(row).isDisplayed()) {
            if (libCat.getActors().get(0) != null) {
                libCat.getActors().get(0).SetVisibility(0);
                libCat.getActors().get(1).SetVisibility(0);
                Info.getMainGUI();
                MainGUI.updateRenderWindow();
                show = false;
            }
        } else if (libCat.getActors().get(0) != null) {
            libCat.getActors().get(0).SetVisibility(1);
            libCat.getActors().get(1).SetVisibility(1);
            Info.getMainGUI();
            MainGUI.updateRenderWindow();
            show = true;
        }
        libModel.setVisibilityForRow(show, row);
    }

    private void init() {
        this.tableModel = new CatalogTableModel(this.parent);
        this.tableModel.addTableModelListener((TableModelListener)((Object)this.parent));
        this.setModel(this.tableModel);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CatalogTableModel libModel = CatalogTable.this.getLibraryModel();
                int col = CatalogTable.this.getColumnModel().getColumnIndexAtX(e.getX());
                int row = e.getY() / CatalogTable.this.getRowHeight();
                if (e.getButton() == 1) {
                    if (col == 0) {
                        if (!libModel.getLoadedStateForRow(row)) {
                            libModel.setLoadedStateForRow(true, row);
                            EarthquakeCatalogPluginGUI gui = (EarthquakeCatalogPluginGUI)CatalogTable.this.parent;
                            gui.processTableSelectionChange();
                            EQCatalog libCat = CatalogTable.this.getSelectedValue();
                            gui.setAnimationColor(libCat.getColor1(), libCat.getColor2());
                        }
                        EQCatalog libCat = CatalogTable.this.getSelectedValue();
                        CatalogTable.this.setVisibility(libModel, libCat, row);
                    } else if (col == 1 || col == 2) {
                        EarthquakeCatalogPluginGUI gui = (EarthquakeCatalogPluginGUI)CatalogTable.this.parent;
                        gui.switchToDisplayPanel();
                    }
                }
            }
        });
        this.selModel = this.getSelectionModel();
        this.selModel.setSelectionMode(0);
        this.selModel.addListSelectionListener((ListSelectionListener)((Object)this.parent));
        this.setTableHeader(null);
        this.setRowHeight(this.getRowHeight() + 4);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setShowGrid(false);
        TableColumn col1 = this.getColumnModel().getColumn(0);
        if (this.parent instanceof EarthquakeCatalogPluginGUI) {
            TableColumn col2 = this.getColumnModel().getColumn(1);
            TableColumn col3 = this.getColumnModel().getColumn(2);
            TableColumn col4 = this.getColumnModel().getColumn(3);
            col1.setCellRenderer(new CheckBoxRenderer());
            col1.setPreferredWidth(26);
            col1.setMinWidth(26);
            col1.setMaxWidth(26);
            col2.setCellRenderer(new DisplayStateRenderer());
            col2.setPreferredWidth(34);
            col2.setMinWidth(34);
            col2.setMaxWidth(34);
            col3.setCellRenderer(new GeometryStateRenderer());
            col3.setPreferredWidth(16);
            col3.setMinWidth(16);
            col3.setMaxWidth(16);
            col4.setCellRenderer(new StringRenderer());
        } else {
            col1.setCellRenderer(new StringRenderer());
        }
    }

    public CatalogTableModel getTableModel() {
        return this.tableModel;
    }

    private class DisplayStateRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private ColorWellIcon colorIcon = new ColorWellIcon(Color.WHITE, 26, 9, 2);
        private int inscribedRectDimension = 15;
        private int inset = 2;
        private ColorDiscIcon colorDiscIcon = new ColorDiscIcon(Color.RED, Color.YELLOW, this.inscribedRectDimension, this.inscribedRectDimension, this.inset);

        DisplayStateRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object catalog, boolean isSelected, boolean hasFocus, int row, int column) {
            EQCatalog c = (EQCatalog)catalog;
            this.setEnabled(c.isInMemory());
            if (c.getGeometry() == 1 && c.getFocalDisplay() == 1) {
                this.colorDiscIcon.setColor(c.getDiscCompColor(), c.getDiscExtColor());
                this.setIcon(this.colorDiscIcon);
                this.setDisabledIcon(this.colorDiscIcon);
            } else {
                this.colorIcon.setColor(c.getColor1(), c.getColor2());
                this.setIcon(this.colorIcon);
                this.setDisabledIcon(this.colorIcon);
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else if (row % 2 == 0) {
                this.setBackground(Prefs.getStripingColor());
            } else {
                this.setBackground(table.getBackground());
            }
            return this;
        }
    }

    private class GeometryStateRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private ImageIcon sphereOn = new ImageIcon(SourceList.class.getResource("resources/img/sphereIcon.png"));
        private ImageIcon sphereOff = new ImageIcon(SourceList.class.getResource("resources/img/sphereIconDis.png"));
        private ImageIcon pointOn = new ImageIcon(SourceList.class.getResource("resources/img/pointIcon.png"));
        private ImageIcon pointOff = new ImageIcon(SourceList.class.getResource("resources/img/pointIconDis.png"));

        GeometryStateRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object catalog, boolean isSelected, boolean hasFocus, int row, int column) {
            EQCatalog c = (EQCatalog)catalog;
            this.setEnabled(c.isInMemory());
            if (c.getGeometry() == 1 && c.getFocalDisplay() == 2) {
                this.setIcon(this.sphereOn);
                this.setDisabledIcon(this.sphereOff);
            } else if (c.getGeometry() == 0) {
                this.setIcon(this.pointOn);
                this.setDisabledIcon(this.pointOff);
            } else {
                this.setIcon(null);
                this.setDisabledIcon(null);
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else if (row % 2 == 0) {
                this.setBackground(Prefs.getStripingColor());
            } else {
                this.setBackground(table.getBackground());
            }
            return this;
        }
    }
}

