/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components;

import gov.usgs.earthquake.event.EventQuery;
import gov.usgs.earthquake.event.EventWebService;
import gov.usgs.earthquake.event.Format;
import gov.usgs.earthquake.event.JsonEvent;
import gov.usgs.earthquake.event.OrderBy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components.EQCatalog;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components.Earthquake;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.EarthquakeCatalogPlugin;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.EarthquakeCatalogPluginGUI;
import org.scec.vtk.tools.Prefs;

public class ComcatResourcesDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private EarthquakeCatalogPluginGUI parent;
    private JLabel latLabel = new JLabel("Lat:");
    private JLabel lonLabel = new JLabel("Lon:");
    private JLabel depLabel = new JLabel("Dep:");
    private JLabel magLabel = new JLabel("Mag:");
    private JLabel minLabel1 = new JLabel("Min");
    private JLabel maxLabel1 = new JLabel("Max");
    private JLabel minLabel2 = new JLabel("Min");
    private JLabel maxLabel2 = new JLabel("Max");
    private JLabel dateStartLabel = new JLabel("Start Date:");
    private JLabel dateEndLabel = new JLabel("End Date:");
    private JLabel timeStartLabel = new JLabel("Start Time (UTC):");
    private JLabel timeEndLabel = new JLabel("End Time (UTC):");
    private JLabel maxEventsLabel = new JLabel("Max EQs:");
    private JTextField latMinField = new JTextField("32");
    private JTextField latMaxField = new JTextField("43");
    private JTextField lonMinField = new JTextField("-125");
    private JTextField lonMaxField = new JTextField("-114");
    private JTextField depMinField = new JTextField();
    private JTextField depMaxField = new JTextField();
    private JTextField magMinField = new JTextField("0.0");
    private JTextField magMaxField = new JTextField("9.0");
    private JTextField dateStartField = new JTextField("2019/07/01");
    private JTextField dateEndField = new JTextField("2019/07/01");
    private JTextField timeStartField = new JTextField("00:00:00");
    private JTextField timeEndField = new JTextField("23:59:59");
    private JTextField maxEventsField = new JTextField();
    private JButton importButton = new JButton("Import");
    private String defaultName = "";
    private int count = 1;
    private ArrayList<Earthquake> masterEarthquakeCatalogsList = new ArrayList();

    public ComcatResourcesDialog() {
    }

    public ComcatResourcesDialog(JPanel parent) {
        this.parent = (EarthquakeCatalogPluginGUI)parent;
        this.setName("Network Sources");
        this.setSize(550, 220);
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.latMinField.setPreferredSize(new Dimension(50, 20));
        this.latMinField.setMinimumSize(new Dimension(50, 20));
        this.latMaxField.setPreferredSize(new Dimension(50, 20));
        this.latMaxField.setMinimumSize(new Dimension(50, 20));
        this.magMinField.setPreferredSize(new Dimension(35, 20));
        this.magMinField.setMinimumSize(new Dimension(35, 20));
        this.magMaxField.setPreferredSize(new Dimension(35, 20));
        this.magMaxField.setMinimumSize(new Dimension(35, 20));
        this.dateStartField.setPreferredSize(new Dimension(75, 20));
        this.dateStartField.setMinimumSize(new Dimension(75, 20));
        this.timeStartField.setPreferredSize(new Dimension(75, 20));
        this.timeStartField.setMinimumSize(new Dimension(75, 20));
        this.lonMinField.setPreferredSize(new Dimension(50, 20));
        this.lonMinField.setMinimumSize(new Dimension(50, 20));
        this.lonMaxField.setPreferredSize(new Dimension(50, 20));
        this.lonMaxField.setMinimumSize(new Dimension(50, 20));
        this.depMinField.setPreferredSize(new Dimension(35, 20));
        this.depMinField.setMinimumSize(new Dimension(35, 20));
        this.depMaxField.setPreferredSize(new Dimension(35, 20));
        this.depMaxField.setMinimumSize(new Dimension(35, 20));
        this.dateEndField.setPreferredSize(new Dimension(75, 20));
        this.dateEndField.setMinimumSize(new Dimension(75, 20));
        this.timeEndField.setPreferredSize(new Dimension(75, 20));
        this.timeEndField.setMinimumSize(new Dimension(75, 20));
        this.maxEventsField.setMinimumSize(new Dimension(75, 20));
        this.maxEventsField.setMinimumSize(new Dimension(75, 20));
        this.importButton.addActionListener(this);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 15;
        c.insets = new Insets(2, 4, 0, 4);
        this.add((Component)this.minLabel1, c);
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 15;
        c.insets = new Insets(2, 4, 0, 4);
        this.add((Component)this.maxLabel1, c);
        c.gridx = 4;
        c.gridy = 0;
        c.anchor = 15;
        c.insets = new Insets(2, 4, 0, 4);
        this.add((Component)this.minLabel2, c);
        c.gridx = 5;
        c.gridy = 0;
        c.anchor = 15;
        c.insets = new Insets(2, 4, 0, 4);
        this.add((Component)this.maxLabel2, c);
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 13;
        c.insets = new Insets(0, 0, 0, 2);
        this.add((Component)this.latLabel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 10;
        c.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.latMinField, c);
        c.gridx = 2;
        c.gridy = 1;
        c.anchor = 10;
        c.insets = new Insets(2, 4, 2, 0);
        this.add((Component)this.latMaxField, c);
        c.gridx = 3;
        c.gridy = 1;
        c.anchor = 13;
        c.insets = new Insets(0, 4, 0, 2);
        this.add((Component)this.magLabel, c);
        c.gridx = 4;
        c.gridy = 1;
        c.anchor = 10;
        c.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.magMinField, c);
        c.gridx = 5;
        c.gridy = 1;
        c.anchor = 10;
        c.insets = new Insets(2, 4, 2, 0);
        this.add((Component)this.magMaxField, c);
        c.gridx = 6;
        c.gridy = 1;
        c.anchor = 13;
        c.insets = new Insets(0, 4, 0, 2);
        this.add((Component)this.dateStartLabel, c);
        c.gridx = 7;
        c.gridy = 1;
        c.anchor = 13;
        c.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.dateStartField, c);
        c.gridx = 8;
        c.gridy = 1;
        c.anchor = 13;
        c.insets = new Insets(2, 4, 2, 0);
        this.add((Component)this.timeStartLabel, c);
        c.gridx = 9;
        c.gridy = 1;
        c.anchor = 13;
        c.insets = new Insets(0, 4, 0, 2);
        this.add((Component)this.timeStartField, c);
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 13;
        c.insets = new Insets(0, 0, 0, 2);
        this.add((Component)this.lonLabel, c);
        c.gridx = 1;
        c.gridy = 2;
        c.anchor = 10;
        c.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.lonMinField, c);
        c.gridx = 2;
        c.gridy = 2;
        c.anchor = 10;
        c.insets = new Insets(2, 4, 2, 0);
        this.add((Component)this.lonMaxField, c);
        c.gridx = 3;
        c.gridy = 2;
        c.anchor = 13;
        c.insets = new Insets(0, 4, 0, 2);
        this.add((Component)this.depLabel, c);
        c.gridx = 4;
        c.gridy = 2;
        c.anchor = 10;
        c.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.depMinField, c);
        c.gridx = 5;
        c.gridy = 2;
        c.anchor = 10;
        c.insets = new Insets(2, 4, 2, 0);
        this.add((Component)this.depMaxField, c);
        c.gridx = 6;
        c.gridy = 2;
        c.anchor = 13;
        c.insets = new Insets(0, 4, 0, 2);
        this.add((Component)this.dateEndLabel, c);
        c.gridx = 7;
        c.gridy = 2;
        c.anchor = 13;
        c.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.dateEndField, c);
        c.gridx = 8;
        c.gridy = 2;
        c.anchor = 10;
        c.insets = new Insets(2, 4, 2, 0);
        this.add((Component)this.timeEndLabel, c);
        c.gridx = 9;
        c.gridy = 2;
        c.anchor = 13;
        c.insets = new Insets(0, 4, 0, 2);
        this.add((Component)this.timeEndField, c);
        c.gridx = 0;
        c.gridy = 3;
        c.anchor = 13;
        c.insets = new Insets(0, 0, 0, 2);
        this.add((Component)this.maxEventsLabel, c);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 2;
        c.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.maxEventsField, c);
        this.maxEventsField.setText("10000");
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 0;
        c.anchor = 18;
        this.add((Component)this.importButton, c);
    }

    public boolean processRequest() {
        Date end;
        Date start;
        SimpleDateFormat df;
        Object formatErrors = "";
        Object rangeErrors = "";
        Object otherErrors = "";
        double latMin = -90.0;
        double latMax = 90.0;
        double lonMin = -180.0;
        double lonMax = 180.0;
        double depMin = 0.0;
        double depMax = 0.0;
        double magMin = 0.0;
        double magMax = 0.0;
        boolean latMinSet = false;
        boolean latMaxSet = false;
        boolean lonMinSet = false;
        boolean lonMaxSet = false;
        boolean depMinSet = false;
        boolean depMaxSet = false;
        boolean magMinSet = false;
        boolean magMaxSet = false;
        boolean dateStartSet = false;
        boolean dateEndSet = false;
        boolean timeStartSet = false;
        boolean timeEndSet = false;
        if (this.latMinField.getText().length() > 0) {
            try {
                latMin = Double.parseDouble(this.latMinField.getText());
                if (latMin < -90.0 || latMin > 90.0) {
                    rangeErrors = (String)rangeErrors + "    Latitude minimum\n";
                } else {
                    latMinSet = true;
                }
            }
            catch (NumberFormatException e) {
                formatErrors = (String)formatErrors + "    Latitude minimum\n";
            }
        }
        if (this.latMaxField.getText().length() > 0) {
            try {
                latMax = Double.parseDouble(this.latMaxField.getText());
                if (latMax < -90.0 || latMax > 90.0) {
                    rangeErrors = (String)rangeErrors + "    Latitude maximum\n";
                } else {
                    latMaxSet = true;
                }
            }
            catch (NumberFormatException e) {
                formatErrors = (String)formatErrors + "    Latitude maximum\n";
            }
        }
        if (latMinSet && !latMaxSet || !latMinSet && latMaxSet) {
            otherErrors = (String)otherErrors + "    Latitude minimum and maximum must both be valid\n";
        }
        if (latMinSet && latMaxSet && latMin > latMax) {
            otherErrors = (String)otherErrors + "    Latitude minimum must be less than maximum\n";
        }
        if (this.lonMinField.getText().length() > 0) {
            try {
                lonMin = Double.parseDouble(this.lonMinField.getText());
                if (lonMin < -180.0 || lonMin > 180.0) {
                    rangeErrors = (String)rangeErrors + "    Longitude minimum\n";
                } else {
                    lonMinSet = true;
                }
            }
            catch (NumberFormatException e) {
                formatErrors = (String)formatErrors + "    Longitude minimum\n";
            }
        }
        if (this.lonMaxField.getText().length() > 0) {
            try {
                lonMax = Double.parseDouble(this.lonMaxField.getText());
                if (lonMax < -180.0 || lonMax > 180.0) {
                    rangeErrors = (String)rangeErrors + "    Longitude maximum\n";
                } else {
                    lonMaxSet = true;
                }
            }
            catch (NumberFormatException e) {
                formatErrors = (String)formatErrors + "    Longitude maximum\n";
            }
        }
        if (lonMinSet && !lonMaxSet || !lonMinSet && lonMaxSet) {
            otherErrors = (String)otherErrors + "    Longitude minimum and maximum must both be valid\n";
        }
        if (lonMinSet && lonMaxSet && lonMin > lonMax) {
            otherErrors = (String)otherErrors + "    Longitude minimum must be less than maximum\n";
        }
        if (this.depMinField.getText().length() > 0) {
            try {
                depMin = Double.parseDouble(this.depMinField.getText());
                if (depMin < 0.0) {
                    rangeErrors = (String)rangeErrors + "    Depth minimum\n";
                } else {
                    depMinSet = true;
                }
            }
            catch (NumberFormatException e) {
                formatErrors = (String)formatErrors + "    Depth minimum\n";
            }
        }
        if (this.depMaxField.getText().length() > 0) {
            try {
                depMax = Double.parseDouble(this.depMaxField.getText());
                if (depMax < 0.0) {
                    rangeErrors = (String)rangeErrors + "    Depth maximum\n";
                } else {
                    depMaxSet = true;
                }
            }
            catch (NumberFormatException e) {
                formatErrors = (String)formatErrors + "    Depth maximum\n";
            }
        }
        if (depMinSet && !depMaxSet || !depMinSet && depMaxSet) {
            otherErrors = (String)otherErrors + "    Depth minimum and maximum must both be valid\n";
        }
        if (depMinSet && depMaxSet && depMin > depMax) {
            otherErrors = (String)otherErrors + "    Depth minimum must be less than maximum\n";
        }
        if (this.magMinField.getText().length() > 0) {
            try {
                magMin = Double.parseDouble(this.magMinField.getText());
                if (magMin < -180.0 || magMin > 180.0) {
                    rangeErrors = (String)rangeErrors + "    Magnitude minimum\n";
                } else {
                    magMinSet = true;
                }
            }
            catch (NumberFormatException e) {
                formatErrors = (String)formatErrors + "    Magnitude minimum\n";
            }
        }
        if (this.magMaxField.getText().length() > 0) {
            try {
                magMax = Double.parseDouble(this.magMaxField.getText());
                if (magMax < -180.0 || magMax > 180.0) {
                    rangeErrors = (String)rangeErrors + "    Magnitude maximum\n";
                } else {
                    magMaxSet = true;
                }
            }
            catch (NumberFormatException e) {
                formatErrors = (String)formatErrors + "    Magnitude maximum\n";
            }
        }
        if (magMinSet && !magMaxSet || !magMinSet && magMaxSet) {
            otherErrors = (String)otherErrors + "    Magnitude minimum and maximum must both be valid\n";
        }
        if (magMinSet && magMaxSet && magMin > magMax) {
            otherErrors = (String)otherErrors + "    Magnitude minimum must be less than maximum\n";
        }
        String dateStart = this.dateStartField.getText();
        String dateEnd = this.dateEndField.getText();
        boolean sameDate = false;
        if (dateStart.length() > 0 && !dateStart.equals("YYYY/MM/DD")) {
            if (Pattern.matches("[0-9]{4}/[0-9]{2}/[0-9]{2}", dateStart) || Pattern.matches("\\-[0-9]+(s|m|h|d)", dateStart)) {
                dateStartSet = true;
            } else {
                formatErrors = (String)formatErrors + "    Start date\n        Absolute: YYYY/MM/DD\n        Relative: -#s, -#m, -#h, or -#d\n";
            }
        }
        if (dateEnd.length() > 0 && !dateEnd.equals("YYYY/MM/DD")) {
            if (Pattern.matches("[0-9]{4}/[0-9]{2}/[0-9]{2}", dateEnd) || Pattern.matches("\\+[0-9]+(s|m|h|d)", dateEnd)) {
                dateEndSet = true;
            } else {
                formatErrors = (String)formatErrors + "    End date\n        Absolute: YYYY/MM/DD\n        Relative: +#s, +#m, +#h, or +#d\n";
            }
        }
        if (dateStartSet && !dateEndSet || !dateStartSet && dateEndSet) {
            otherErrors = (String)otherErrors + "    Start and end dates must both be valid\n";
        }
        if (dateStartSet && dateEndSet) {
            if (Pattern.matches("[0-9]{4}:[0-9]{2}/[0-9]{2}", dateStart) && Pattern.matches("[0-9]{4}/[0-9]{2}/[0-9]{2}", dateEnd)) {
                df = new SimpleDateFormat("yyyy/MM/dd");
                try {
                    start = df.parse(dateStart);
                    end = df.parse(dateEnd);
                    if (start.compareTo(end) > 0) {
                        otherErrors = (String)otherErrors + "    Start date must be on or before end date\n";
                    } else if (start.compareTo(end) == 0) {
                        sameDate = true;
                    }
                }
                catch (java.text.ParseException e) {
                    formatErrors = (String)formatErrors + "    Start or end date formatted incorrectly\n";
                }
            }
        } else {
            otherErrors = (String)otherErrors + "    Start and end date must be set\n";
        }
        String timeStart = this.timeStartField.getText();
        String timeEnd = this.timeEndField.getText();
        if (timeStart.length() > 0) {
            if (Pattern.matches("[0-9]{2}:[0-9]{2}:[0-9]{2}", timeStart)) {
                timeStartSet = true;
            } else {
                formatErrors = (String)formatErrors + "    Start date\n        Absolute: YYYY/MM/DD\n        Relative: -#s, -#m, -#h, or -#d\n";
            }
        }
        if (timeEnd.length() > 0) {
            if (Pattern.matches("[0-9]{2}:[0-9]{2}:[0-9]{2}", timeEnd)) {
                timeEndSet = true;
            } else {
                formatErrors = (String)formatErrors + "    End date\n        Absolute: YYYY/MM/DD\n        Relative: +#s, +#m, +#h, or +#d\n";
            }
        }
        if (timeStartSet && !timeEndSet || !timeStartSet && timeEndSet) {
            otherErrors = (String)otherErrors + "    Start and end dates must both be valid\n";
        }
        if (timeStartSet && timeEndSet) {
            if (Pattern.matches("[0-9]{2}:[0-9]{2}:[0-9]{2}", timeStart) && Pattern.matches("[0-9]{2}:[0-9]{2}:[0-9]{2}", timeEnd)) {
                df = new SimpleDateFormat("HH:mm:ss");
                try {
                    start = df.parse(timeStart);
                    end = df.parse(timeEnd);
                    if (sameDate && start.compareTo(end) > 0) {
                        otherErrors = (String)otherErrors + "    Start time must be before or at end time\n";
                    }
                }
                catch (java.text.ParseException e) {
                    formatErrors = (String)formatErrors + "    Start or end time formatted incorrectly\n";
                }
            }
        } else {
            otherErrors = (String)otherErrors + "    Start and end time must be set\n";
        }
        int maxEvents = 1000;
        if (this.maxEventsField.getText().length() > 0) {
            try {
                int result;
                maxEvents = Integer.parseInt(this.maxEventsField.getText());
                if (maxEvents <= 0) {
                    otherErrors = (String)otherErrors + "    Invalid max number of events\n";
                } else if (maxEvents > 10000 && (result = JOptionPane.showConfirmDialog(this, "A maximum that is too large may result in a long wait.\nAre you sure you want to continue?", "Warning", 0)) == 1) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                formatErrors = (String)formatErrors + "    Maximum number of events\n";
            }
        } else {
            otherErrors = (String)otherErrors + "    Must specify maximum number of events\n";
        }
        Object errors = "";
        if (((String)formatErrors).length() > 0) {
            errors = (String)errors + "Incorrectly formatted:\n" + (String)formatErrors;
        }
        if (((String)rangeErrors).length() > 0) {
            errors = (String)errors + "Out of range:\n" + (String)rangeErrors;
        }
        if (((String)otherErrors).length() > 0) {
            errors = (String)errors + "Other errors:\n" + (String)otherErrors;
        }
        if (errors != "") {
            JOptionPane.showMessageDialog(this, errors, "Format Error", -1);
            return false;
        }
        Object requestString = "";
        if (!dateStartSet || !dateEndSet) {
            return false;
        }
        requestString = (String)requestString + " -t0 " + dateStart + " " + dateEnd;
        if (latMinSet && latMaxSet) {
            requestString = (String)requestString + " -lat " + latMin + " " + latMax;
        }
        if (lonMinSet && lonMaxSet) {
            requestString = (String)requestString + " -lon " + lonMin + " " + lonMax;
        }
        if (depMinSet && depMaxSet) {
            requestString = (String)requestString + " -depth " + depMin + " " + depMax;
        }
        if (magMinSet && magMaxSet) {
            requestString = (String)requestString + " -mag " + magMin + " " + magMax;
        }
        return true;
    }

    public void readFromComcatDataFile(EQCatalog cat, String filePath) {
        JSONParser parser = new JSONParser();
        JSONArray jsonArray = null;
        try {
            JSONObject jsonObj = (JSONObject)parser.parse(new FileReader(filePath));
            jsonArray = (JSONArray)jsonObj.get(cat.getDisplayName());
        }
        catch (IOException | ParseException e1) {
            e1.printStackTrace();
        }
        if (jsonArray != null) {
            float min_dep = 5.0f;
            float max_dep = -600.0f;
            float min_mag = 10.0f;
            float max_mag = 0.0f;
            int index = 0;
            cat.initializeArrays(jsonArray.size());
            this.masterEarthquakeCatalogsList.clear();
            JsonEvent je = new JsonEvent((JSONObject)jsonArray.get(0));
            Date startDate = je.getTime();
            Date endDate = je.getTime();
            double maxLat = je.getLatitude().doubleValue();
            double minLat = je.getLatitude().doubleValue();
            double maxLon = je.getLongitude().doubleValue();
            double minLon = je.getLongitude().doubleValue();
            for (Object o : jsonArray) {
                Earthquake eq;
                JsonEvent event = new JsonEvent((JSONObject)o);
                double depth = 0.0;
                double mag = 0.0;
                double lon = 0.0;
                double lat = 0.0;
                if (event.getMag() != null) {
                    mag = event.getMag().doubleValue();
                }
                if (event.getDepth() != null) {
                    depth = -event.getDepth().doubleValue();
                }
                if (event.getLatitude() != null) {
                    lat = event.getLatitude().doubleValue();
                }
                if (event.getLongitude() != null) {
                    lon = event.getLongitude().doubleValue();
                }
                if (event.getDepth() != null) {
                    if (depth <= (double)min_dep) {
                        min_dep = (float)depth;
                    }
                    if (depth >= (double)max_dep) {
                        max_dep = (float)depth;
                    }
                }
                if (event.getMag() != null) {
                    if (mag <= (double)min_mag) {
                        min_mag = (float)mag;
                    }
                    if (mag >= (double)max_mag) {
                        max_mag = (float)mag;
                    }
                }
                if (lat <= minLat) {
                    minLat = (float)lat;
                }
                if (lat >= maxLat) {
                    maxLat = (float)lat;
                }
                if (lon <= minLon) {
                    minLon = (float)lon;
                }
                if (lon >= maxLon) {
                    maxLon = (float)lon;
                }
                cat.setEq_depth(index++, (float)depth);
                if (event.getTime().before(startDate)) {
                    startDate = event.getTime();
                }
                if (event.getTime().after(endDate)) {
                    endDate = event.getTime();
                }
                if (this.masterEarthquakeCatalogsList.contains(eq = new Earthquake(-depth, mag, lat, lon, event.getTime(), jsonArray.size()))) continue;
                this.masterEarthquakeCatalogsList.add(eq);
            }
            if (jsonArray.size() != 0) {
                cat.setMaxMagnitude(max_mag);
                cat.setMinMagnitude(min_mag);
                cat.setMinDepth(-max_dep);
                cat.setMaxDepth(-min_dep);
                cat.setMinDate(startDate);
                cat.setMaxDate(endDate);
                cat.setNumEvents(jsonArray.size());
                cat.setMaxLatitude((float)maxLat);
                cat.setMinLatitude((float)minLat);
                cat.setMaxLongitude((float)maxLon);
                cat.setMinLongitude((float)minLon);
                cat.addComcatEqList();
            }
            System.out.println("no events found");
        } else {
            System.out.println("no events found");
        }
    }

    public void getComcatData(double minDepth, double maxDepth, double minMagnitude, double maxMagnitude, double minLat, double maxLat, double minLon, double maxLon, String startTime, String endTime, int limit) {
        List<JsonEvent> events;
        EventWebService service = null;
        try {
            service = new EventWebService(new URL("https://earthquake.usgs.gov/fdsnws/event/1/"));
        }
        catch (MalformedURLException e) {
            ExceptionUtils.throwAsRuntimeException((Throwable)e);
        }
        int queryLimit = Integer.min(20000, limit);
        EventQuery query = new EventQuery();
        if (minDepth > 0.0) {
            query.setMinDepth(new BigDecimal(minDepth));
        }
        if (maxDepth > 0.0) {
            query.setMaxDepth(new BigDecimal(maxDepth));
        }
        if (minMagnitude > 0.0) {
            query.setMinMagnitude(new BigDecimal(minMagnitude));
        }
        if (maxMagnitude > 0.0) {
            query.setMaxMagnitude(new BigDecimal(maxMagnitude));
        }
        query.setMinLatitude(new BigDecimal(minLat));
        query.setMaxLatitude(new BigDecimal(maxLat));
        query.setMinLongitude(new BigDecimal(minLon));
        query.setMaxLongitude(new BigDecimal(maxLon));
        query.setLimit(queryLimit);
        query.setOrderBy(OrderBy.TIME_ASC);
        Date startDate = null;
        Date endDate = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd'T'HH:mm:ss'Z'");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            startDate = sdf.parse(startTime);
            query.setStartTime(startDate);
            endDate = sdf.parse(endTime);
            query.setEndTime(endDate);
        }
        catch (java.text.ParseException e) {
            e.printStackTrace();
        }
        try {
            System.out.println(service.getUrl(query, Format.GEOJSON));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            events = service.getEvents(query);
        }
        catch (Exception e) {
            throw ExceptionUtils.asRuntimeException((Throwable)e);
        }
        System.out.println("Fetched " + events.size() + " events");
        if (events.size() == 0) {
            JOptionPane.showMessageDialog(this, "No events found. Please change your query.");
        } else {
            if (limit > queryLimit && events.size() >= queryLimit) {
                System.out.println("Stitching together multiple calls");
                while (events.size() < limit) {
                    query.setOffset(events.size() + 1);
                    try {
                        List<JsonEvent> subEvents = service.getEvents(query);
                        events.addAll(subEvents);
                        System.out.println("Fetched " + subEvents.size() + " events (" + events.size() + " in total)");
                        if (subEvents.size() >= queryLimit) continue;
                        break;
                    }
                    catch (Exception e) {
                        throw ExceptionUtils.asRuntimeException((Throwable)e);
                    }
                }
                System.out.println("Fetched " + events.size() + " total events");
            }
            JSONObject obj = new JSONObject();
            JSONArray catalogList = new JSONArray();
            this.masterEarthquakeCatalogsList.clear();
            float min_dep = 5.0f;
            float max_dep = -600.0f;
            float min_mag = 10.0f;
            float max_mag = 0.0f;
            EQCatalog cat = new EQCatalog(this.parent);
            int index = 0;
            cat.initializeArrays(events.size());
            cat.setDisplayName("_Imported_Catalog_" + this.count);
            ++this.count;
            for (JsonEvent event : events) {
                double depth = 0.0;
                double mag = 0.0;
                double lon = 0.0;
                double lat = 0.0;
                if (event.getMag() != null) {
                    mag = event.getMag().doubleValue();
                }
                if (event.getDepth() != null) {
                    depth = -event.getDepth().doubleValue();
                }
                if (event.getLatitude() != null) {
                    lat = event.getLatitude().doubleValue();
                }
                if (event.getLongitude() != null) {
                    lon = event.getLongitude().doubleValue();
                }
                if (event.getDepth() != null) {
                    if (depth <= (double)min_dep) {
                        min_dep = (float)depth;
                    }
                    if (depth >= (double)max_dep) {
                        max_dep = (float)depth;
                    }
                }
                if (event.getMag() != null) {
                    if (mag <= (double)min_mag) {
                        min_mag = (float)mag;
                    }
                    if (mag >= (double)max_mag) {
                        max_mag = (float)mag;
                    }
                }
                cat.setEq_depth(index++, (float)depth);
                Earthquake eq = new Earthquake(-depth, mag, lat, lon, event.getTime(), limit);
                if (!this.masterEarthquakeCatalogsList.contains(eq)) {
                    this.masterEarthquakeCatalogsList.add(eq);
                }
                catalogList.add(event);
            }
            obj.put(cat.getDisplayName(), catalogList);
            this.writeToJSONFile(cat, obj);
            this.parent.getCatalogTable().addCatalog(cat);
            if (events.size() != 0) {
                cat.setComcatQuery(query);
                cat.setMaxMagnitude(max_mag);
                cat.setMinMagnitude(min_mag);
                cat.setMinDepth(-max_dep);
                cat.setMaxDepth(-min_dep);
                cat.setMinDate(startDate);
                cat.setMaxDate(endDate);
                cat.setNumEvents(events.size());
                cat.setMaxLatitude((float)maxLat);
                cat.setMinLatitude((float)minLat);
                cat.setMaxLongitude((float)maxLon);
                cat.setMinLongitude((float)minLon);
                cat.addComcatEqList();
            }
        }
    }

    private void writeToJSONFile(EQCatalog cat, JSONObject obj) {
        String destinationData = Prefs.getLibLoc() + File.separator + EarthquakeCatalogPlugin.dataStoreDir + File.separator + "display" + File.separator + "data" + File.separator + cat.getDisplayName() + "-" + System.currentTimeMillis() + ".json";
        try (FileWriter file = new FileWriter(destinationData);){
            file.write(obj.toJSONString());
            System.out.println("Successfully Copied JSON Object to File...");
            cat.setComcatFilePathString(destinationData);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.importButton && this.processRequest()) {
            double depthMin = 0.0;
            double depthMax = 0.0;
            double magMin = 0.0;
            double magMax = 0.0;
            if (this.depMinField.getText().length() > 0) {
                depthMin = Double.parseDouble(this.depMinField.getText());
            }
            if (this.depMaxField.getText().length() > 0) {
                depthMin = Double.parseDouble(this.depMaxField.getText());
            }
            if (this.magMinField.getText().length() > 0) {
                magMin = Double.parseDouble(this.magMinField.getText());
            }
            if (this.magMaxField.getText().length() > 0) {
                magMax = Double.parseDouble(this.magMaxField.getText());
            }
            String startPeriod = this.dateStartField.getText() + "T" + this.timeStartField.getText() + "Z";
            String endPeriod = this.dateEndField.getText() + "T" + this.timeEndField.getText() + "Z";
            CalcProgressBar progress = new CalcProgressBar("Loading Catalog", "Please Wait");
            progress.setVisible(true);
            progress.setIndeterminate(true);
            progress.toFront();
            this.getComcatData(depthMin, depthMax, magMin, magMax, Double.parseDouble(this.latMinField.getText()), Double.parseDouble(this.latMaxField.getText()), Double.parseDouble(this.lonMinField.getText()), Double.parseDouble(this.lonMaxField.getText()), startPeriod, endPeriod, Integer.parseInt(this.maxEventsField.getText()));
            progress.setVisible(false);
            progress.dispose();
            super.dispose();
        }
    }

    public ArrayList<Earthquake> getAllEarthquakes() {
        return this.masterEarthquakeCatalogsList;
    }
}

