/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components;

import gov.usgs.earthquake.event.EventQuery;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components.CatalogAccessor;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components.ComcatResourcesDialog;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components.Earthquake;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.EarthquakeCatalogPlugin;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.EarthquakeCatalogPluginGUI;
import org.scec.vtk.plugins.PluginActors;
import org.scec.vtk.plugins.utils.components.ObjectInfoDialog;
import org.scec.vtk.tools.Prefs;
import org.scec.vtk.tools.Transform;
import org.scec.vtk.tools.picking.PickEnabledActor;
import vtk.vtkAbstractArray;
import vtk.vtkActor;
import vtk.vtkDataObject;
import vtk.vtkDoubleArray;
import vtk.vtkGlyph3D;
import vtk.vtkMapper;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;
import vtk.vtkSphereSource;
import vtk.vtkUnsignedCharArray;
import vtk.vtkVertexGlyphFilter;

public class EQCatalog
extends CatalogAccessor {
    private Logger log = Logger.getLogger(EQCatalog.class);
    public static final int GEOMETRY_POINT = 0;
    public static final int GEOMETRY_SPHERE = 1;
    public static final int GRADIENT_APPLY_MAGNITUDE = 0;
    public static final int GRADIENT_APPLY_DEPTH = 1;
    public static final int SCALING_NONE = 0;
    public static final int SCALING_FIFTIETH = 1;
    public static final int SCALING_TENTH = 2;
    public static final int SCALING_FIFTH = 3;
    public static final int SCALING_HALF = 4;
    public static final int SCALING_ONE = 5;
    public static final int SCALING_TWO = 6;
    public static final int SCALING_FOUR = 7;
    public static final int SCALING_TEN = 8;
    public static final int RECENT_EQ_COLOR_DISABLED = 0;
    public static final int RECENT_EQ_COLOR_ENABLED = 1;
    public static final int FOCAL_BALL = 0;
    public static final int FOCAL_DISC = 1;
    public static final int FOCAL_NONE = 2;
    public static final int CHANGE_NONE = 0;
    public static final int CHANGE_GEOMETRY = 1;
    public static final int CHANGE_SCALING = 2;
    public static final int CHANGE_FOCAL = 4;
    public static final int CHANGE_COLOR = 8;
    public static final int CHANGE_GRADIENT = 16;
    public static final int CHANGE_FOCAL_DISPLAY = 32;
    public static final int CHANGE_FOCAL_DISC_COMP_COLOR = 64;
    public static final int CHANGE_FOCAL_DISC_EXT_COLOR = 128;
    public static final int CHANGE_RECENT_EQ_COLOR = 256;
    public static final int CHANGE_FOCAL_NONE = 512;
    public static final int CHANGE_SIZE_SLIDER = 1024;
    public static final int CHANGE_TRANSPARENCY_SLIDER = 2048;
    public static final int CHANGE_DEPTH_DISPLAY = 4096;
    private int pointSize = 1;
    protected Element displayAttributes;
    protected Element queryStructure;
    private int geometry;
    private int scaling;
    private int focalMech;
    private int applyGradient;
    private static int transparency;
    private int focalDisplay = 2;
    private Color color1;
    private Color color2;
    private int recentEQcoloring;
    public int index;
    private boolean initialized = false;
    private Color focalDiscCompColor;
    private Color focalDiscExtColor;
    ArrayList<Earthquake> eqList = new ArrayList();
    private ArrayList<vtkActor> myActors = new ArrayList();
    Component parent;
    private PluginActors pluginActors;
    private double[][] eventCoords;
    public int gradientDivisions;
    public Color[] gradientColors;
    private boolean catalogTypeIsComcat = false;
    private EventQuery comcatQuery;
    private String comcatFilePathString;
    private ComcatResourcesDialog crd;
    private String valuesBy;

    public EQCatalog(Component parent, File sourcefile, PluginActors pluginActors) {
        super(parent);
        this.pluginActors = pluginActors;
        this.parent = parent;
        if (this.readAttributeFile(sourcefile)) {
            this.initialized = true;
        }
        this.valuesBy = "Magnitude";
    }

    public EQCatalog(EarthquakeCatalogPluginGUI parent) {
        super(parent);
        this.pluginActors = parent.getPluginActors();
        this.parent = parent;
        this.geometry = 1;
        this.scaling = 4;
        this.color1 = Color.BLUE;
        this.color2 = Color.RED;
        transparency = 100;
        this.setCrd(new ComcatResourcesDialog());
        this.valuesBy = "Magnitude";
    }

    protected boolean newDocument(CatalogAccessor parent) {
        if (this.newDocument()) {
            this.setObjectClass(this.getClass().getName());
            this.setSourceFile(parent.getAttributeFileLibPath());
            String catName = this.generateNewCatName();
            this.setAttributeFile(File.separator + EarthquakeCatalogPlugin.dataStoreDir + File.separator + "display" + File.separator + catName + ".cat");
            this.setDataFile(File.separator + EarthquakeCatalogPlugin.dataStoreDir + File.separator + "display" + File.separator + "data" + File.separator + catName + ".dat");
            this.setCitation(parent.getCitation());
            this.setReference(parent.getReference());
            this.setNotes(parent.getNotes());
            this.setDisplayName(parent.toString());
            if (!this.showInfoDialog()) {
                return false;
            }
            URL displayDoc = CatalogAccessor.class.getResource("resources/xml/display_template.xml");
            try {
                Document temp = parser.build(displayDoc);
                this.displayAttributes = (Element)temp.getRootElement().getChild("display").detach();
                this.objectAttributes.addContent(this.displayAttributes);
                if (!this.readDisplayAttributes()) {
                    return false;
                }
            }
            catch (Exception e) {
                this.log.debug((Object)"problem parsing XML");
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean showInfoDialog() {
        ObjectInfoDialog oid = ((EarthquakeCatalogPluginGUI)this.owner).getSourceInfoDialog();
        oid.showInfo(this, "Edit Catalog Information");
        return !oid.windowWasCancelled();
    }

    @Override
    public boolean readAttributeFile(File file) {
        if (!super.readAttributeFile(file)) {
            return false;
        }
        if (this.objectAttributes.getChild("display") != null) {
            this.displayAttributes = this.objectAttributes.getChild("display");
            if (!this.readDisplayAttributes()) {
                return false;
            }
        }
        if (this.objectAttributes.getChild("query_structure") != null) {
            this.queryStructure = this.objectAttributes.getChild("query_structure");
        }
        return true;
    }

    public void makePoints() {
        if (this.eventCoords == null) {
            this.eventCoords = new double[this.getNumEvents()][3];
            for (int i = 0; i < this.getNumEvents(); ++i) {
                this.eventCoords[i] = Transform.transformLatLonHeight(this.eq_latitude[i], this.eq_longitude[i], -this.eq_depth[i]);
            }
        }
    }

    private void load() {
        this.makePoints();
        if (this.parent instanceof EarthquakeCatalogPluginGUI) {
            this.addEqList();
        }
    }

    public ArrayList<Earthquake> getSelectedEqList() {
        return this.eqList;
    }

    public void addEqList() {
        if (!this.catalogTypeIsComcat) {
            this.catalogTypeIsComcat = false;
            this.eqList = EarthquakeCatalogPluginGUI.getEarthquakes();
            this.geometry = 0;
            this.addPointsToBranchGroup(false, this.eqList);
            this.geometry = 1;
            this.addPointsToBranchGroup(true, this.eqList);
            EarthquakeCatalogPluginGUI.eqCatalogs.add(this);
        }
    }

    public void addComcatEqList() {
        this.eqList = ((EarthquakeCatalogPluginGUI)this.parent).getComcatResourceDialog() != null ? ((EarthquakeCatalogPluginGUI)this.parent).getComcatResourceDialog().getAllEarthquakes() : this.getCrd().getAllEarthquakes();
        this.catalogTypeIsComcat = true;
        this.geometry = 0;
        this.addPointsToBranchGroup(false, this.eqList);
        this.geometry = 1;
        this.addPointsToBranchGroup(true, this.eqList);
        EarthquakeCatalogPluginGUI.eqCatalogs.add(this);
    }

    public void addPointsToBranchGroup(boolean sphere, ArrayList<Earthquake> eqList) {
        this.initGradientAppearance();
        vtkVertexGlyphFilter vertexGlyphFilter = new vtkVertexGlyphFilter();
        vtkPoints pts = new vtkPoints();
        vtkPolyDataMapper mapperEQCatalog = new vtkPolyDataMapper();
        vtkDoubleArray radi = new vtkDoubleArray();
        radi.SetName("radi");
        vtkUnsignedCharArray colors = new vtkUnsignedCharArray();
        colors.SetName("colors");
        colors.SetNumberOfComponents(4);
        colors.SetNumberOfTuples((long)eqList.size());
        double[] xForm = new double[3];
        for (int i = 0; i < eqList.size(); ++i) {
            Earthquake eq = eqList.get(i);
            xForm = Transform.transformLatLonHeight(eq.getEq_latitude(), eq.getEq_longitude(), -eq.getEq_depth());
            pts.InsertNextPoint(xForm);
            radi.InsertNextTuple1(eq.getEq_magnitude());
            int ind = (int)Math.floor(eq.getEq_magnitude()) - (int)this.getMinMagnitude();
            if (ind < 0) {
                ind = 0;
            }
            float[] grad = new float[3];
            this.gradientColors[ind].getRGBColorComponents(grad);
            colors.InsertTuple4((long)i, (double)this.gradientColors[ind].getRed(), (double)this.gradientColors[ind].getGreen(), (double)this.gradientColors[ind].getBlue(), 255.0);
        }
        vtkPolyData inputData = new vtkPolyData();
        inputData.SetPoints(pts);
        inputData.GetPointData().AddArray((vtkAbstractArray)radi);
        inputData.GetPointData().AddArray((vtkAbstractArray)colors);
        inputData.GetPointData().SetActiveScalars("radi");
        if (sphere) {
            vtkSphereSource balls = new vtkSphereSource();
            balls.SetRadius(1.0);
            balls.SetPhiResolution(10);
            balls.SetThetaResolution(10);
            vtkGlyph3D glyphPoints = new vtkGlyph3D();
            glyphPoints.SetInputData((vtkDataObject)inputData);
            glyphPoints.SetSourceConnection(balls.GetOutputPort());
            mapperEQCatalog.SetInputConnection(glyphPoints.GetOutputPort());
        } else {
            vertexGlyphFilter.AddInputData((vtkDataObject)inputData);
            vertexGlyphFilter.Update();
            mapperEQCatalog.SetInputConnection(vertexGlyphFilter.GetOutputPort());
        }
        mapperEQCatalog.ScalarVisibilityOn();
        mapperEQCatalog.SetScalarModeToUsePointFieldData();
        mapperEQCatalog.SelectColorArray("colors");
        PickEnabledActor<EQCatalog> actorEQCatalog = new PickEnabledActor<EQCatalog>(((EarthquakeCatalogPluginGUI)this.parent).getPickHandler(), this);
        actorEQCatalog.SetMapper((vtkMapper)mapperEQCatalog);
        actorEQCatalog.SetVisibility(0);
        this.myActors.add(actorEQCatalog);
        this.pluginActors.addActor((vtkProp)actorEQCatalog);
        Info.getMainGUI();
        MainGUI.updateRenderWindow();
    }

    public List<vtkActor> getActors() {
        return this.myActors;
    }

    private void unload() {
        this.pluginActors.removeActor((vtkProp)this.getActors().get(0));
        this.pluginActors.removeActor((vtkProp)this.getActors().get(1));
        Info.getMainGUI();
        MainGUI.updateRenderWindow();
    }

    public void initGradientAppearance() {
        int magDivs = this.valuesBy == "Magnitude" ? (int)Math.ceil(this.getMaxMagnitude()) - (int)Math.floor(this.getMinMagnitude()) + 1 : (int)Math.ceil(this.getMaxDepth()) - (int)Math.floor(this.getMinDepth()) + 1;
        this.gradientDivisions = this.getApplyGradientTo() == 1 ? 6 : magDivs;
        this.initGradientColors(this.gradientDivisions);
    }

    private void initGradientColors(int divisions) {
        float[] colorStart = this.getColor1().getColorComponents(null);
        float[] colorEnd = this.getColor2().getColorComponents(null);
        float[] colorIntervals = new float[3];
        for (int j = 0; j < 3; ++j) {
            colorIntervals[j] = (colorEnd[j] - colorStart[j]) / (float)(divisions - 1);
        }
        this.gradientColors = new Color[divisions];
        for (int i = 0; i < divisions; ++i) {
            this.gradientColors[i] = new Color(colorStart[0] + colorIntervals[0] * (float)i, colorStart[1] + colorIntervals[1] * (float)i, colorStart[2] + colorIntervals[2] * (float)i);
        }
    }

    private String generateNewCatName() {
        String dataLib = Prefs.getLibLoc() + File.separator + EarthquakeCatalogPlugin.dataStoreDir + File.separator + "display" + File.separator;
        String id = "000000";
        NumberFormat fmt = NumberFormat.getIntegerInstance();
        fmt.setMaximumIntegerDigits(6);
        fmt.setMinimumIntegerDigits(6);
        fmt.setGroupingUsed(false);
        File f = new File(dataLib + "filteredCat_" + id + ".cat");
        while (f.exists()) {
            id = fmt.format(1000000.0 * Math.random());
            f = new File(dataLib + "filteredCat_" + id + ".cat");
        }
        return "filteredCat_" + id;
    }

    private boolean readDisplayAttributes() {
        try {
            this.geometry = this.displayAttributes.getChild("geometry").getAttribute("value").getIntValue();
            this.scaling = 4;
            try {
                this.recentEQcoloring = this.displayAttributes.getChild("recentEQcoloring").getAttribute("value").getIntValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.focalMech = this.displayAttributes.getChild("focal_mech").getAttribute("value").getIntValue();
            this.applyGradient = this.displayAttributes.getChild("colors").getAttribute("apply_gradient").getIntValue();
            this.color1 = this.readColorElement(this.displayAttributes.getChild("colors").getChild("color_1"));
            this.color2 = this.readColorElement(this.displayAttributes.getChild("colors").getChild("color_2"));
            transparency = this.displayAttributes.getChild("transparency") != null ? this.displayAttributes.getChild("transparency").getAttribute("value").getIntValue() : 100;
        }
        catch (Exception e) {
            this.log.debug((Object)"problem reading XML");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void updateDisplay() {
        this.load();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setDisplayed(boolean show) {
        super.setDisplayed(show);
    }

    @Override
    public void setInMemory(boolean load) {
        if (load) {
            if (this.eq_id == null) {
                this.readDataFile();
            }
            this.load();
        } else if (this.isDisplayed()) {
            this.unload();
            this.setDisplayed(false);
        }
        super.setInMemory(load);
    }

    public JProgressBar getProgressBar() {
        return EarthquakeCatalogPluginGUI.progbar;
    }

    public JLabel getProgessLabel() {
        return EarthquakeCatalogPluginGUI.progLabel;
    }

    public int getApplyGradientTo() {
        return this.applyGradient;
    }

    public void setApplyGradientTo(int value) {
        this.applyGradient = value;
        this.displayAttributes.getChild("colors").getAttribute("apply_gradient").setValue(String.valueOf(value));
    }

    public Color getColor1() {
        return this.color1;
    }

    public void setGradColor1(Color color) {
        this.color1 = color;
    }

    public void setGradColor2(Color color) {
        this.color2 = color;
    }

    public void setColor1(Color color) {
        this.color1 = color;
        this.writeColorElement(this.displayAttributes.getChild("colors").getChild("color_1"), color);
    }

    public Color getColor2() {
        return this.color2;
    }

    public void setColor2(Color color) {
        this.color2 = color;
        this.writeColorElement(this.displayAttributes.getChild("colors").getChild("color_2"), color);
    }

    public void setColor() {
    }

    public int getRecentEQColoring() {
        return this.recentEQcoloring;
    }

    public void setRecentEQColoring(int recentEQcoloring) {
        this.recentEQcoloring = recentEQcoloring;
        try {
            this.displayAttributes.getChild("recentEQcoloring").getAttribute("value").setValue(String.valueOf(recentEQcoloring));
        }
        catch (Exception e) {
            System.out.println("Error writing RecentEQColor property");
        }
    }

    public int getFocalMech() {
        return this.focalMech;
    }

    public void setFocalMech(int pattern) {
        this.focalMech = pattern;
        this.displayAttributes.getChild("focal_mech").getAttribute("value").setValue(String.valueOf(pattern));
    }

    public void setFocalDisplay(int display) {
        this.focalDisplay = display;
    }

    public int getGeometry() {
        return this.geometry;
    }

    public void setGeometry(int value) {
        this.geometry = value;
    }

    public int getScaling() {
        return this.scaling;
    }

    public boolean setScaling(int scale) {
        if (scale >= 0) {
            this.scaling = scale;
            return true;
        }
        return false;
    }

    public int getPointSize() {
        return this.pointSize;
    }

    public void setPointSize(int pointSize) {
        if (pointSize <= 0) {
            throw new IllegalArgumentException("Point size must be > 0");
        }
        this.pointSize = pointSize;
    }

    public int getFocalDisplay() {
        return this.focalDisplay;
    }

    public void setFocalDiscCompColor(Color compColor) {
        this.focalDiscCompColor = compColor;
    }

    public void setFocalDiscExtColor(Color extColor) {
        this.focalDiscExtColor = extColor;
    }

    public Color getDiscCompColor() {
        if (this.focalDiscCompColor != null) {
            return this.focalDiscCompColor;
        }
        return Color.RED;
    }

    public Color getDiscExtColor() {
        if (this.focalDiscExtColor != null) {
            return this.focalDiscExtColor;
        }
        return Color.YELLOW;
    }

    public static int getTransparency() {
        return transparency;
    }

    public void setTransparency(int trans) {
        transparency = trans;
    }

    @Override
    public void setDisplayName(String name) {
        super.setDisplayName(name);
        this.writeAttributeFile();
    }

    public void setComcatQuery(EventQuery query) {
        this.comcatQuery = query;
    }

    public EventQuery getComcatQuery() {
        return this.comcatQuery;
    }

    public boolean getCatalogTypeIsComcat() {
        return this.catalogTypeIsComcat;
    }

    public boolean isSphere() {
        return true;
    }

    public String getComcatFilePathString() {
        return this.comcatFilePathString;
    }

    public void setComcatFilePathString(String comcatFilePathString) {
        this.comcatFilePathString = comcatFilePathString;
    }

    public ComcatResourcesDialog getCrd() {
        return this.crd;
    }

    public void setCrd(ComcatResourcesDialog crd) {
        this.crd = crd;
    }

    public void setValuesBy(String string) {
        this.valuesBy = string;
    }

    public String getValuesBy() {
        return this.valuesBy;
    }
}

