/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components.CatalogAccessor;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.EarthquakeCatalogPlugin;
import org.scec.vtk.plugins.utils.DataImport;
import org.scec.vtk.plugins.utils.components.ObjectInfoDialog;

public class SourceCatalog
extends CatalogAccessor
implements DataImport {
    private Logger log = Logger.getLogger(SourceCatalog.class);
    private GregorianCalendar cal = new GregorianCalendar();
    private String name;

    public SourceCatalog(Component parent) {
        super(parent);
    }

    public SourceCatalog(Component parent, File catalog) {
        super(parent);
        this.readAttributeFile(catalog);
    }

    @Override
    public void setInMemory(boolean load) {
        if (load) {
            if (this.eq_id == null) {
                this.readDataFile();
            }
        } else {
            this.clearArrays();
        }
        super.setInMemory(load);
    }

    public boolean processFile(File datafile) {
        return this.processFile(datafile, true);
    }

    public boolean processFile(File datafile, boolean displayAddCatInfo) {
        if (!this.newDocument()) {
            return false;
        }
        try {
            BufferedReader inStream = new BufferedReader(new FileReader(datafile));
            String line = inStream.readLine();
            StringTokenizer data = new StringTokenizer(line);
            int columns = data.countTokens();
            if (columns != 11 && columns != 13 && columns != 14 && columns != 16 && columns != 18) {
                return false;
            }
            this.setDataScope(columns);
            int count = 0;
            BufferedReader countReader = new BufferedReader(new FileReader(datafile));
            while (countReader.ready()) {
                countReader.readLine();
                if (line == "") continue;
                ++count;
            }
            int num_eqs = count;
            this.setNumEvents(num_eqs);
            this.initializeArrays(num_eqs);
            int index = 0;
            while (line != null) {
                this.loadArrays(index, line);
                ++index;
                line = inStream.readLine();
            }
        }
        catch (Exception e) {
            this.log.debug((Object)"problem reading binary data file");
            return false;
        }
        String filename = this.confirmOutputFile(datafile.getName().substring(0, datafile.getName().lastIndexOf(".")));
        if (filename == null) {
            return false;
        }
        this.setObjectClass(this.getClass().toString());
        this.setSourceFile(datafile.getPath());
        this.setAttributeFile(File.separator + EarthquakeCatalogPlugin.dataStoreDir + File.separator + "source" + File.separator + filename + ".cat");
        this.setDataFile(File.separator + EarthquakeCatalogPlugin.dataStoreDir + File.separator + "source" + File.separator + "data" + File.separator + filename + ".dat");
        this.runMinMax();
        if (!this.writeAttributeFile() || !this.writeDataFile()) {
            return false;
        }
        this.setInMemory(true);
        return true;
    }

    public void setNameCorrectly(ObjectInfoDialog oid) {
        this.name = oid.getDisplayName();
        this.setDisplayName(this.name);
        System.out.println("setting display name to: " + this.name);
        this.setCitation("");
        this.setReference("");
        this.setNotes("");
    }

    private void loadArrays(int idx, String eqdata) {
        StringTokenizer st = new StringTokenizer(eqdata);
        this.eq_id[idx] = Integer.parseInt(st.nextToken());
        this.cal.set(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()) - 1, Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
        this.eq_time[idx] = this.cal.getTime();
        this.eq_longitude[idx] = Float.parseFloat(st.nextToken());
        this.eq_latitude[idx] = Float.parseFloat(st.nextToken());
        this.eq_depth[idx] = Float.parseFloat(st.nextToken());
        if ((double)this.eq_depth[idx] >= 99.0) {
            this.eq_depth[idx] = 10.991234f;
        }
        this.eq_magnitude[idx] = Float.parseFloat(st.nextToken());
        if (this.getDataScope() == 13 || this.getDataScope() == 16 || this.getDataScope() == 18) {
            this.eq_xy_error[idx] = Float.parseFloat(st.nextToken());
            this.eq_z_error[idx] = Float.parseFloat(st.nextToken());
        }
        if (this.getDataScope() == 14 || this.getDataScope() == 16 || this.getDataScope() == 18) {
            this.eq_strike[idx] = Integer.parseInt(st.nextToken());
            this.eq_dip[idx] = Integer.parseInt(st.nextToken());
            this.eq_rake[idx] = Integer.parseInt(st.nextToken());
        }
        if (this.getDataScope() == 18) {
            this.eq_nodal[idx] = Integer.parseInt(st.nextToken());
            this.eq_probability[idx] = Float.parseFloat(st.nextToken());
        }
    }

    public void setName(String name) {
        this.name = name;
    }
}

