/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.FileFilter;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components.CatalogAccessor;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components.SourceCatalog;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.EarthquakeCatalogPlugin;
import org.scec.vtk.tools.Prefs;

public class SourceList
extends JList {
    private static final long serialVersionUID = 1L;
    private Component listOwner;
    private ListSelectionModel selModel;
    private DefaultListModel listModel;

    public SourceList(Container owner) {
        this.listOwner = owner;
        this.init();
    }

    public DefaultListModel getDefaultListModel() {
        return this.listModel;
    }

    public void loadSourceCatalogs() {
        this.listModel.clear();
        File dir = new File(Prefs.getLibLoc() + File.separator + EarthquakeCatalogPlugin.dataStoreDir + File.separator + "source");
        File[] cats = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".cat");
            }
        });
        for (int i = 0; i < cats.length; ++i) {
            SourceCatalog source = new SourceCatalog(this.listOwner, cats[i]);
            this.addCatalog(source);
        }
    }

    public void addCatalog(SourceCatalog catalog) {
        this.listModel.addElement(catalog);
    }

    public void deleteCatalog(CatalogAccessor catalog) {
        this.deleteCatalog(catalog, true);
    }

    public void deleteCatalog(CatalogAccessor catalog, boolean confirmDelete) {
        int delete;
        if (confirmDelete && ((delete = JOptionPane.showConfirmDialog(this.listOwner, "Are you sure you want to delete the selected source catalog?\n(All attribute and catalog data will be deleted)", "Delete Source Catalog", 0, 3)) == 1 || delete == -1)) {
            return;
        }
        catalog.getAttributeFile().delete();
        catalog.getDataFile().delete();
        this.listModel.removeElement(catalog);
    }

    private void init() {
        this.selModel = this.getSelectionModel();
        this.selModel.setSelectionMode(0);
        this.selModel.addListSelectionListener((ListSelectionListener)((Object)this.listOwner));
        this.listModel = new DefaultListModel();
        this.setModel(this.listModel);
        this.setCellRenderer(new SourceListRenderer());
    }

    private class SourceListRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;
        private ImageIcon catIcon_none = new ImageIcon(SourceList.class.getResource("resources/img/sourceIcon_none.png"));
        private ImageIcon catIcon_err = new ImageIcon(SourceList.class.getResource("resources/img/sourceIcon_err.png"));
        private ImageIcon catIcon_fm = new ImageIcon(SourceList.class.getResource("resources/img/sourceIcon_fm.png"));
        private ImageIcon catIcon_err_fm = new ImageIcon(SourceList.class.getResource("resources/img/sourceIcon_fm_err.png"));

        SourceListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object catalog, int index, boolean isSelected, boolean hasFocus) {
            switch (((SourceCatalog)catalog).getDataScope()) {
                case 13: {
                    this.setIcon(this.catIcon_err);
                    break;
                }
                case 14: {
                    this.setIcon(this.catIcon_fm);
                    break;
                }
                case 16: {
                    this.setIcon(this.catIcon_err_fm);
                }
                case 18: {
                    this.setIcon(this.catIcon_err_fm);
                    break;
                }
                default: {
                    this.setIcon(this.catIcon_none);
                }
            }
            this.setIconTextGap(8);
            String catname = ((SourceCatalog)catalog).toString().trim();
            catname = catname.equals("") ? "-- no name --" : catname;
            this.setText(catname);
            this.setBorder(BorderFactory.createEmptyBorder(3, 7, 3, 7));
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
            } else if (index % 2 == 0) {
                this.setBackground(Prefs.getStripingColor());
            } else {
                this.setBackground(list.getBackground());
            }
            return this;
        }
    }
}

