/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components;

import gov.usgs.earthquake.event.EventQuery;
import gov.usgs.earthquake.event.EventWebService;
import gov.usgs.earthquake.event.Format;
import gov.usgs.earthquake.event.JsonEvent;
import gov.usgs.earthquake.event.OrderBy;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.opensha.commons.util.ExceptionUtils;

public class StitchedCatalogWriter {
    public static void main(String[] args) throws IOException {
        JSONObject obj = new JSONObject();
        JSONArray catalogList = new JSONArray();
        double minLon = -130.0;
        double maxLon = -110.0;
        double minLat = 30.0;
        double maxLat = 40.0;
        double minMag = 2.0;
        double maxMag = 10.0;
        String name = "stitched_catalog";
        File outputDir = new File("/home/kevin/.scec_vdo/EQCatalogStore/display/data/");
        File outputFile = new File(outputDir, name + "-" + System.currentTimeMillis() + ".json");
        int startYear = 1990;
        int endYear = 2023;
        for (int year = startYear; year < endYear; ++year) {
            List<JsonEvent> events;
            EventWebService service = null;
            try {
                service = new EventWebService(new URL("https://earthquake.usgs.gov/fdsnws/event/1/"));
            }
            catch (MalformedURLException e) {
                ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
            EventQuery query = new EventQuery();
            query.setMinMagnitude(new BigDecimal(minMag));
            query.setMaxMagnitude(new BigDecimal(maxMag));
            query.setMinLatitude(new BigDecimal(minLat));
            query.setMaxLatitude(new BigDecimal(maxLat));
            query.setMinLongitude(new BigDecimal(minLon));
            query.setMaxLongitude(new BigDecimal(maxLon));
            query.setLimit(20000);
            query.setOrderBy(OrderBy.TIME_ASC);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                Date startDate = sdf.parse("" + year);
                query.setStartTime(startDate);
                Date endDate = sdf.parse("" + (year + 1));
                query.setEndTime(endDate);
            }
            catch (ParseException e1) {
                throw ExceptionUtils.asRuntimeException((Throwable)e1);
            }
            try {
                System.out.println(service.getUrl(query, Format.GEOJSON));
            }
            catch (MalformedURLException e) {
                throw ExceptionUtils.asRuntimeException((Throwable)e);
            }
            try {
                events = service.getEvents(query);
            }
            catch (Exception e) {
                throw ExceptionUtils.asRuntimeException((Throwable)e);
            }
            System.out.println("Loaded " + events.size() + " events");
            for (JsonEvent event : events) {
                catalogList.add(event);
            }
        }
        System.out.println("TOTAL: " + catalogList.size() + " events");
        obj.put(name, catalogList);
        FileWriter fw = new FileWriter(outputFile);
        fw.write(obj.toJSONString());
        System.out.println("Successfully Copied JSON Object to File...");
        fw.close();
    }
}

