/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.EarthquakeCatalogPlugin;

import java.util.ArrayList;
import java.util.Date;
import javax.swing.JPanel;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.ActionPlugin;
import org.scec.vtk.plugins.AnimatableChangeListener;
import org.scec.vtk.plugins.AnimatablePlugin;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components.EQCatalog;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components.Earthquake;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.EarthquakeCatalogPluginGUI;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.EarthquakeCatalogPluginState;
import org.scec.vtk.plugins.PluginState;
import org.scec.vtk.plugins.StatefulPlugin;
import vtk.vtkActor;
import vtk.vtkProp;
import vtk.vtkTextActor;

public class EarthquakeCatalogPlugin
extends ActionPlugin
implements StatefulPlugin,
AnimatablePlugin {
    EarthquakeCatalogPluginGUI eQGui;
    private PluginState state;
    private Earthquake starteq;
    private Earthquake endeq;
    private long diff;
    vtkTextActor screenTextDate = new vtkTextActor();
    public static String dataStoreDir = "EQCatalogStore";

    public EarthquakeCatalogPlugin() {
        this.screenTextDate.SetPosition(0.05, 0.05);
        this.screenTextDate.GetTextProperty().SetFontSize(21);
        Info.getMainGUI();
        MainGUI.getRenderWindow().getRenderer().AddActor((vtkProp)this.screenTextDate);
    }

    @Override
    public JPanel createGUI() {
        this.eQGui = new EarthquakeCatalogPluginGUI(this);
        return this.eQGui;
    }

    @Override
    public void unload() {
        for (EQCatalog eqc : this.eQGui.getCatalogs()) {
            for (vtkActor actor : eqc.getActors()) {
                this.getPluginActors().removeActor((vtkProp)actor);
            }
        }
        super.unload();
        Info.getMainGUI();
        MainGUI.updateRenderWindow();
        this.eQGui = null;
    }

    @Override
    public PluginState getState() {
        if (this.state == null) {
            this.state = new EarthquakeCatalogPluginState(this.eQGui);
        }
        return this.state;
    }

    private void aniamtiondStartedHideShowEarthquake(int opacity, double t) {
        int index = 0;
        ArrayList<EQCatalog> catalogs = this.eQGui.getCatalogs();
        for (int j = 0; j < catalogs.size(); ++j) {
            EQCatalog cat;
            if (!catalogs.get(j).isDisplayed() || (index = t == -1.0 ? cat.getSelectedEqList().size() : (int)((1.0 - t) * 1.0 + t * (double)(cat.getSelectedEqList().size() - 1))) > (cat = catalogs.get(j)).getSelectedEqList().size()) continue;
            for (int i = 0; i < index; ++i) {
                Earthquake eq = cat.getSelectedEqList().get(i);
                this.eQGui.animateEarthquakeOpacity(i, eq, cat, opacity);
            }
        }
    }

    @Override
    public void animationStarted() {
        this.aniamtiondStartedHideShowEarthquake(0, -1.0);
    }

    @Override
    public void animationEnded() {
        this.aniamtiondStartedHideShowEarthquake(255, -1.0);
    }

    @Override
    public void animationTimeChanged(double fractionalTime) {
        boolean realTime = this.eQGui.isTrueTimeSelected();
        if (realTime) {
            ArrayList<EQCatalog> catalogs = this.eQGui.getCatalogs();
            block0: for (int j = 0; j < catalogs.size(); ++j) {
                if (!catalogs.get(j).isDisplayed()) continue;
                EQCatalog cat = catalogs.get(j);
                Earthquake starteq = cat.getSelectedEqList().get(0);
                Earthquake endeq = cat.getSelectedEqList().get(cat.getSelectedEqList().size() - 1);
                double t = fractionalTime;
                long time = (long)((1.0 - t) * (double)starteq.getEq_time().getTime() + t * (double)endeq.getEq_time().getTime());
                Date date = new Date(time);
                this.screenTextDate.SetInput("Date: " + String.valueOf(date));
                System.out.print("Date: " + String.valueOf(date));
                System.out.println("\tt:" + fractionalTime);
                for (int i = 0; i < cat.getSelectedEqList().size(); ++i) {
                    Earthquake eq = cat.getSelectedEqList().get(i);
                    if (date.compareTo(eq.getEq_time()) > 0) continue;
                    this.eQGui.animateEarthquakeOpacity(i, eq, cat, 255);
                    continue block0;
                }
            }
        } else {
            this.screenTextDate.SetInput("");
            this.aniamtiondStartedHideShowEarthquake(255, fractionalTime);
        }
    }

    @Override
    public boolean isAnimatable() {
        return true;
    }

    @Override
    public void addAnimatableChangeListener(AnimatableChangeListener l) {
    }

    @Override
    public void removeAnimatableChangeListener(AnimatableChangeListener l) {
    }
}

