/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.EarthquakeCatalogPlugin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.scec.vtk.commons.legend.LegendItem;
import org.scec.vtk.commons.legend.LegendUtils;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components.CatalogAccessor;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components.CatalogTable;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components.ComcatResourcesDialog;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components.EQCatalog;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components.EQPickBehavior;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components.Earthquake;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components.SourceCatalog;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.EarthquakeCatalogPlugin;
import org.scec.vtk.plugins.PluginActors;
import org.scec.vtk.plugins.utils.components.AddButton;
import org.scec.vtk.plugins.utils.components.ColorWellButton;
import org.scec.vtk.plugins.utils.components.GradientColorChooser;
import org.scec.vtk.plugins.utils.components.HelpButton;
import org.scec.vtk.plugins.utils.components.ObjectInfoDialog;
import org.scec.vtk.tools.Prefs;
import org.scec.vtk.tools.picking.PickHandler;
import vtk.vtkAbstractArray;
import vtk.vtkActor;
import vtk.vtkAnimationScene;
import vtk.vtkCellArray;
import vtk.vtkDataObject;
import vtk.vtkDoubleArray;
import vtk.vtkGlyph3D;
import vtk.vtkMapper;
import vtk.vtkPolyData;
import vtk.vtkProp;
import vtk.vtkUnsignedCharArray;
import vtk.vtkVertexGlyphFilter;

public class EarthquakeCatalogPluginGUI
extends JPanel
implements ActionListener,
ChangeListener,
ListSelectionListener,
TableModelListener,
MouseListener {
    private EarthquakeCatalogPlugin plugin;
    private PluginActors pluginActors;
    private static ArrayList<Earthquake> earthquakes = new ArrayList();
    private static final long serialVersionUID = 1L;
    private static final String NO_VALUE = " -- ";
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("##0.0");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MMMM dd, yyyy");
    private static int a_l = 21;
    private static int a_c = 10;
    private static int a_r = 22;
    private static int f = 0;
    private JPanel libraryPanel;
    private AddButton newInternetSourceButton;
    private HelpButton helpButton;
    private JPanel propsExtentsPanel;
    private JLabel catProp_dateFromVal;
    private JLabel catProp_dateToVal;
    private JLabel catProp_extentsNval;
    private JLabel catProp_extentsWval;
    private JLabel catProp_extentsEval;
    private JLabel catProp_extentsSval;
    private JLabel catProp_minDepthVal;
    private JLabel catProp_maxDepthVal;
    private JLabel catProp_minMagVal;
    private JLabel catProp_maxMagVal;
    private JLabel catProp_numEventsVal;
    private JLabel catProp_sourceVal;
    public static JProgressBar progbar;
    private JPanel propsDisplayPanel;
    private JLabel dispProp_geometry;
    private JRadioButton dispProp_geomPoint;
    private JRadioButton dispProp_geomSphere;
    private JLabel dispProp_scaling;
    private JSlider dispProp_slider;
    private JLabel dispProp_color;
    private ColorWellButton dispProp_colGradientButton;
    private JLabel lowerGradientLabel;
    private JLabel higherGradientLabel;
    private JCheckBox legendCheckbox;
    private ButtonGroup timeChooser;
    private JRadioButton trueTime;
    private JRadioButton eqTime;
    private JLabel dispProp_gradient;
    private JRadioButton dispProp_gradDepth;
    private JRadioButton dispProp_gradMag;
    private JSlider transparencySlider;
    private JLabel transLabel;
    private GradientColorChooser colorChooser;
    protected ObjectInfoDialog srcInfoDialog;
    public static JLabel progLabel;
    private CatalogTable catalogTable;
    private ComcatResourcesDialog netSourceDialog;
    ArrayList<vtkActor> earthquakePointActorList = new ArrayList();
    public CatalogAccessor catalogAcc;
    private EQPickBehavior pickHandler;
    private JTabbedPane propsTabbedPane;
    private Date minDate;
    private Date maxDate;
    private long maxDateMill;
    private long minDateMill;
    private long timeDifference;
    private Object depthSlider;
    private Object depthSliderValue;
    public static ArrayList<EQCatalog> eqCatalogs;
    private LegendItem scalarBar;

    public static ArrayList<Earthquake> getEarthquakes() {
        return earthquakes;
    }

    public EarthquakeCatalogPluginGUI(EarthquakeCatalogPlugin plugin) {
        progbar = new JProgressBar(0, 100);
        progbar.setValue(0);
        progbar.setStringPainted(true);
        this.plugin = plugin;
        this.pluginActors = plugin.getPluginActors();
        this.pickHandler = new EQPickBehavior();
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(Prefs.getPluginWidth(), Prefs.getPluginHeight()));
        this.setName("Earthquake Catalog Plugin");
        JPanel upperPane = this.getLibraryPanel();
        upperPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.propsTabbedPane = new JTabbedPane();
        this.propsTabbedPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.propsTabbedPane.add(this.getPropsExtentsPanel());
        this.propsTabbedPane.add(this.getPropsDisplayPanel());
        JPanel lowerPane = new JPanel();
        lowerPane.setLayout(new BoxLayout(lowerPane, 3));
        lowerPane.add(this.propsTabbedPane);
        this.add((Component)upperPane, "Center");
        this.add((Component)lowerPane, "Last");
        try {
            this.catalogTable.loadCatalogs();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public PluginActors getPluginActors() {
        return this.pluginActors;
    }

    public void setPluginActors(PluginActors p) {
        this.pluginActors = p;
    }

    public ObjectInfoDialog getSourceInfoDialog() {
        if (this.srcInfoDialog == null) {
            this.srcInfoDialog = new ObjectInfoDialog(this);
        }
        return this.srcInfoDialog;
    }

    public ObjectInfoDialog getSourceInfoDialogSC(SourceCatalog sc) {
        if (this.srcInfoDialog == null) {
            this.srcInfoDialog = new ObjectInfoDialog(this);
        }
        return this.srcInfoDialog;
    }

    public void switchToDisplayPanel() {
        this.propsTabbedPane.setSelectedComponent(this.propsDisplayPanel);
    }

    public void setDisplayPanel(EQCatalog catalog) {
        this.dispProp_colGradientButton.setColor(catalog.getColor1(), catalog.getColor2());
        if (catalog.getApplyGradientTo() == 1) {
            this.dispProp_gradDepth.setSelected(true);
        } else {
            this.dispProp_gradMag.setSelected(true);
        }
        this.setGeometryEnabled(true);
        if (catalog.getGeometry() == 1) {
            this.dispProp_geomSphere.doClick();
        }
    }

    public void processTableSelectionChange() {
        this.setAttributePanels();
    }

    private JPanel getLibraryPanel() {
        this.libraryPanel = new JPanel(new BorderLayout());
        this.libraryPanel.setName("Library");
        this.libraryPanel.setOpaque(false);
        JScrollPane scroller = new JScrollPane();
        scroller.setHorizontalScrollBarPolicy(31);
        scroller.setVerticalScrollBarPolicy(22);
        this.catalogTable = new CatalogTable(this, this.getPluginActors());
        scroller.setViewportView(this.catalogTable);
        scroller.getViewport().setBackground(this.catalogTable.getBackground());
        this.libraryPanel.add((Component)scroller, "Center");
        this.libraryPanel.add((Component)this.getLibraryBar(), "Last");
        return this.libraryPanel;
    }

    private JPanel getLibraryBar() {
        this.newInternetSourceButton = new AddButton(this, "Import new catalog from Internet", "Earth");
        this.helpButton = new HelpButton(this, "Help");
        JPanel bar = new JPanel();
        bar.setLayout(new BoxLayout(bar, 2));
        bar.setOpaque(false);
        bar.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        bar.add(this.newInternetSourceButton);
        bar.add(Box.createHorizontalStrut(5));
        bar.add(this.helpButton);
        return bar;
    }

    private JPanel getPropsExtentsPanel() {
        this.propsExtentsPanel = new JPanel(new GridBagLayout());
        this.propsExtentsPanel.setName("Extents");
        this.propsExtentsPanel.setOpaque(false);
        Font boldFont = UIManager.getFont("Label.font").deriveFont(1);
        Dimension latDim = new Dimension(40, 16);
        Dimension lonDim = new Dimension(48, 16);
        Dimension valDim = new Dimension(120, 16);
        this.catProp_extentsNval = new JLabel(NO_VALUE);
        this.catProp_extentsNval.setFont(boldFont);
        this.catProp_extentsNval.setPreferredSize(latDim);
        this.catProp_extentsNval.setHorizontalAlignment(4);
        this.catProp_extentsWval = new JLabel(NO_VALUE);
        this.catProp_extentsWval.setFont(boldFont);
        this.catProp_extentsWval.setPreferredSize(lonDim);
        this.catProp_extentsWval.setHorizontalAlignment(4);
        this.catProp_extentsEval = new JLabel(NO_VALUE);
        this.catProp_extentsEval.setFont(boldFont);
        this.catProp_extentsEval.setPreferredSize(lonDim);
        this.catProp_extentsEval.setHorizontalAlignment(4);
        this.catProp_extentsSval = new JLabel(NO_VALUE);
        this.catProp_extentsSval.setFont(boldFont);
        this.catProp_extentsSval.setPreferredSize(latDim);
        this.catProp_extentsSval.setHorizontalAlignment(4);
        this.catProp_minDepthVal = new JLabel(NO_VALUE);
        this.catProp_minDepthVal.setFont(boldFont);
        this.catProp_minDepthVal.setPreferredSize(valDim);
        this.catProp_maxDepthVal = new JLabel(NO_VALUE);
        this.catProp_maxDepthVal.setFont(boldFont);
        this.catProp_maxDepthVal.setPreferredSize(valDim);
        this.catProp_minMagVal = new JLabel(NO_VALUE);
        this.catProp_minMagVal.setFont(boldFont);
        this.catProp_minMagVal.setPreferredSize(valDim);
        this.catProp_maxMagVal = new JLabel(NO_VALUE);
        this.catProp_maxMagVal.setFont(boldFont);
        this.catProp_maxMagVal.setPreferredSize(valDim);
        this.catProp_numEventsVal = new JLabel(NO_VALUE);
        this.catProp_numEventsVal.setFont(boldFont);
        this.catProp_numEventsVal.setPreferredSize(valDim);
        this.catProp_dateFromVal = new JLabel(NO_VALUE);
        this.catProp_dateFromVal.setFont(boldFont);
        this.catProp_dateFromVal.setPreferredSize(valDim);
        this.catProp_dateToVal = new JLabel(NO_VALUE);
        this.catProp_dateToVal.setFont(boldFont);
        this.catProp_dateToVal.setPreferredSize(valDim);
        this.catProp_sourceVal = new JLabel(NO_VALUE);
        this.catProp_sourceVal.setFont(boldFont);
        this.catProp_sourceVal.setPreferredSize(valDim);
        boolean borders = false;
        if (borders) {
            this.catProp_extentsNval.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            this.catProp_extentsWval.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            this.catProp_extentsEval.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            this.catProp_extentsSval.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            this.catProp_minDepthVal.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            this.catProp_maxDepthVal.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            this.catProp_minMagVal.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            this.catProp_maxMagVal.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            this.catProp_numEventsVal.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            this.catProp_dateFromVal.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            this.catProp_dateToVal.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            this.catProp_sourceVal.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        }
        JLabel catProp_extentsN = new JLabel("(\u00b0N)");
        catProp_extentsN.setForeground(Color.GRAY);
        JLabel catProp_extentsW = new JLabel("(\u00b0W)");
        catProp_extentsW.setForeground(Color.GRAY);
        JLabel catProp_extentsE = new JLabel("(\u00b0E)");
        catProp_extentsE.setForeground(Color.GRAY);
        JLabel catProp_extentsS = new JLabel("(\u00b0S)");
        catProp_extentsS.setForeground(Color.GRAY);
        JLabel catProp_extents_to = new JLabel("to");
        JLabel catProp_minDepth = new JLabel("Depth (km) Min:");
        JLabel catProp_maxDepth = new JLabel("Max:");
        JLabel catProp_minMag = new JLabel("Magnitude Min:");
        JLabel catProp_maxMag = new JLabel("Max:");
        JLabel catProp_dateFrom = new JLabel("From:");
        JLabel catProp_dateTo = new JLabel("To:");
        JLabel catProp_numEvents = new JLabel("Total EQ's:");
        JLabel catProp_citation = new JLabel("Citation:");
        JPanel catProp_latLonPanel = new JPanel(new GridBagLayout());
        catProp_latLonPanel.setOpaque(false);
        catProp_latLonPanel.add((Component)this.catProp_extentsNval, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, a_r, f, new Insets(4, 0, 0, 0), 0, 0));
        catProp_latLonPanel.add((Component)catProp_extentsN, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, a_l, f, new Insets(4, 3, 0, 0), 0, 0));
        catProp_latLonPanel.add((Component)this.catProp_extentsWval, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, a_r, f, new Insets(4, 0, 0, 0), 0, 0));
        catProp_latLonPanel.add((Component)catProp_extentsW, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, a_l, f, new Insets(4, 3, 0, 0), 0, 0));
        catProp_latLonPanel.add((Component)catProp_extents_to, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, a_r, f, new Insets(4, 0, 0, 0), 0, 0));
        catProp_latLonPanel.add((Component)this.catProp_extentsEval, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, a_r, f, new Insets(4, 0, 0, 0), 0, 0));
        catProp_latLonPanel.add((Component)catProp_extentsE, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, a_l, f, new Insets(4, 3, 0, 0), 0, 0));
        catProp_latLonPanel.add((Component)this.catProp_extentsSval, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, a_r, f, new Insets(4, 0, 0, 0), 0, 0));
        catProp_latLonPanel.add((Component)catProp_extentsS, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, a_l, f, new Insets(4, 3, 0, 0), 0, 0));
        this.propsExtentsPanel.add((Component)catProp_latLonPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, a_c, f, new Insets(0, 0, 0, 0), 0, 0));
        this.propsExtentsPanel.add((Component)catProp_minDepth, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, a_r, f, new Insets(10, 0, 0, 0), 0, 0));
        this.propsExtentsPanel.add((Component)this.catProp_minDepthVal, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, a_l, f, new Insets(10, 10, 0, 0), 0, 0));
        this.propsExtentsPanel.add((Component)catProp_maxDepth, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, a_r, f, new Insets(0, 0, 0, 0), 0, 0));
        this.propsExtentsPanel.add((Component)this.catProp_maxDepthVal, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, a_l, f, new Insets(0, 10, 0, 0), 0, 0));
        this.propsExtentsPanel.add((Component)catProp_minMag, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, a_r, f, new Insets(8, 0, 0, 0), 0, 0));
        this.propsExtentsPanel.add((Component)this.catProp_minMagVal, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, a_l, f, new Insets(8, 10, 0, 0), 0, 0));
        this.propsExtentsPanel.add((Component)catProp_maxMag, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, a_r, f, new Insets(0, 0, 0, 0), 0, 0));
        this.propsExtentsPanel.add((Component)this.catProp_maxMagVal, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, a_l, f, new Insets(0, 10, 0, 0), 0, 0));
        this.propsExtentsPanel.add((Component)catProp_dateFrom, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, a_r, f, new Insets(8, 0, 0, 0), 0, 0));
        this.propsExtentsPanel.add((Component)this.catProp_dateFromVal, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, a_l, f, new Insets(8, 10, 0, 0), 0, 0));
        this.propsExtentsPanel.add((Component)catProp_dateTo, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, a_r, f, new Insets(0, 0, 0, 0), 0, 0));
        this.propsExtentsPanel.add((Component)this.catProp_dateToVal, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, a_l, f, new Insets(0, 10, 0, 0), 0, 0));
        this.propsExtentsPanel.add((Component)catProp_numEvents, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, a_r, f, new Insets(8, 0, 0, 0), 0, 0));
        this.propsExtentsPanel.add((Component)this.catProp_numEventsVal, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, a_l, f, new Insets(8, 10, 0, 0), 0, 0));
        this.propsExtentsPanel.add((Component)catProp_citation, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, a_r, f, new Insets(8, 0, 8, 0), 0, 0));
        this.propsExtentsPanel.add((Component)this.catProp_sourceVal, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, a_l, f, new Insets(8, 10, 8, 0), 0, 0));
        return this.propsExtentsPanel;
    }

    protected JPanel getPropsDisplayPanel() {
        this.propsDisplayPanel = new JPanel(new GridBagLayout());
        this.propsDisplayPanel.setName("Display");
        this.propsDisplayPanel.setOpaque(false);
        this.dispProp_geometry = new JLabel("Geometry:");
        this.dispProp_geomPoint = new JRadioButton("Point");
        this.dispProp_geomPoint.addActionListener(this);
        this.dispProp_geomPoint.setOpaque(false);
        this.dispProp_geomSphere = new JRadioButton("Sphere");
        this.dispProp_geomSphere.addActionListener(this);
        this.dispProp_geomSphere.setSelected(true);
        this.dispProp_geomSphere.setOpaque(false);
        ButtonGroup dispProp_geomButGrp = new ButtonGroup();
        dispProp_geomButGrp.add(this.dispProp_geomPoint);
        dispProp_geomButGrp.add(this.dispProp_geomSphere);
        this.dispProp_scaling = new JLabel("Scaling:");
        this.dispProp_slider = new JSlider(1, 10, 2);
        this.dispProp_slider.setMajorTickSpacing(2);
        this.dispProp_slider.setMinorTickSpacing(1);
        this.dispProp_slider.setPaintTicks(true);
        this.dispProp_slider.addChangeListener(this);
        this.dispProp_slider.setSnapToTicks(true);
        this.transparencySlider = new JSlider(0, 100, 100);
        this.transparencySlider.setMajorTickSpacing(20);
        this.transparencySlider.setMinorTickSpacing(10);
        this.transparencySlider.setPaintLabels(true);
        this.transparencySlider.setPaintTicks(true);
        this.transparencySlider.addChangeListener(this);
        this.transparencySlider.setSnapToTicks(true);
        this.transLabel = new JLabel("Earthquake Transparency: ");
        this.dispProp_color = new JLabel("Set Color or Gradient:");
        this.dispProp_colGradientButton = new ColorWellButton(Color.BLUE, Color.ORANGE, 74, 16);
        this.dispProp_colGradientButton.addActionListener(this);
        this.lowerGradientLabel = new JLabel("Smaller");
        this.higherGradientLabel = new JLabel("Bigger");
        this.higherGradientLabel.setVisible(false);
        this.lowerGradientLabel.setVisible(false);
        this.dispProp_gradient = new JLabel("Apply gradient/scale to:");
        this.dispProp_gradDepth = new JRadioButton("Depth");
        this.dispProp_gradDepth.addActionListener(this);
        this.dispProp_gradDepth.setOpaque(false);
        this.dispProp_gradMag = new JRadioButton("Magnitude");
        this.dispProp_gradMag.addActionListener(this);
        this.dispProp_gradMag.setSelected(true);
        this.dispProp_gradMag.setOpaque(false);
        ButtonGroup dispProp_gradButtonGroup = new ButtonGroup();
        dispProp_gradButtonGroup.add(this.dispProp_gradMag);
        dispProp_gradButtonGroup.add(this.dispProp_gradDepth);
        this.assemblePropsDispPanel(false);
        return this.propsDisplayPanel;
    }

    protected void assemblePropsDispPanel(boolean showCowOption) {
        this.propsDisplayPanel.setVisible(false);
        this.propsDisplayPanel.removeAll();
        this.propsDisplayPanel.add((Component)this.dispProp_geometry, new GridBagConstraints(0, 0, 1, 1, 0.3, 0.0, a_r, f, new Insets(0, 0, 0, 0), 0, 0));
        JPanel geometryPanel = new JPanel();
        geometryPanel.setLayout(new BoxLayout(geometryPanel, 0));
        geometryPanel.add(this.dispProp_geomPoint);
        geometryPanel.add(Box.createHorizontalStrut(10));
        geometryPanel.add(this.dispProp_geomSphere);
        this.propsDisplayPanel.add((Component)geometryPanel, new GridBagConstraints(1, 0, 1, 1, 0.7, 0.0, a_l, f, new Insets(0, 10, 0, 0), 0, 0));
        this.propsDisplayPanel.add((Component)this.dispProp_gradient, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, a_r, f, new Insets(10, 0, 0, 0), 0, 0));
        JPanel gradientPanel = new JPanel();
        gradientPanel.setLayout(new BoxLayout(gradientPanel, 0));
        gradientPanel.add(this.dispProp_gradMag);
        gradientPanel.add(Box.createHorizontalStrut(10));
        gradientPanel.add(this.dispProp_gradDepth);
        this.propsDisplayPanel.add((Component)gradientPanel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, a_l, f, new Insets(10, 10, 0, 0), 0, 0));
        this.propsDisplayPanel.add((Component)this.dispProp_scaling, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, a_r, f, new Insets(10, 0, 0, 0), 0, 0));
        this.propsDisplayPanel.add((Component)this.dispProp_slider, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, a_r, f, new Insets(10, 20, 0, 10), 0, 0));
        this.propsDisplayPanel.add((Component)this.transLabel, new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, a_c, f, new Insets(0, 0, 0, 0), 0, 0));
        this.propsDisplayPanel.add((Component)this.transparencySlider, new GridBagConstraints(1, 12, 2, 1, 0.0, 0.0, a_c, f, new Insets(0, 0, 0, 0), 0, 0));
        this.propsDisplayPanel.add((Component)this.dispProp_color, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, a_l, f, new Insets(10, 10, 0, 0), 0, 0));
        this.propsDisplayPanel.add((Component)this.dispProp_colGradientButton, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, a_l, f, new Insets(10, 0, 0, 0), 0, 0));
        this.propsDisplayPanel.add((Component)this.lowerGradientLabel, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, a_l, f, new Insets(0, 0, 0, 0), 0, 0));
        this.propsDisplayPanel.add((Component)this.higherGradientLabel, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, a_r, f, new Insets(0, 0, 0, 0), 103, 0));
        this.legendCheckbox = new JCheckBox("Add Legend");
        this.legendCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox cb = (JCheckBox)e.getSource();
                if (cb.isSelected()) {
                    EarthquakeCatalogPluginGUI.this.addLegendScalarBar();
                } else {
                    EarthquakeCatalogPluginGUI.this.removeLegend();
                }
            }
        });
        this.propsDisplayPanel.add(this.legendCheckbox);
        this.timeChooser = new ButtonGroup();
        this.trueTime = new JRadioButton("True Time");
        this.eqTime = new JRadioButton("Equal Event Time");
        this.timeChooser.add(this.trueTime);
        this.trueTime.setSelected(true);
        this.timeChooser.add(this.eqTime);
        this.propsExtentsPanel.add(this.trueTime);
        this.propsExtentsPanel.add(this.eqTime);
        this.propsDisplayPanel.repaint();
    }

    private void disableDisplayPanelComponents() {
        this.setGeometryEnabled(true);
        this.setMagScaleEnabled(true);
        this.setColorEnabled(true);
        this.setGradApplyEnabled(true);
    }

    private void setGeometryEnabled(boolean enable) {
        this.dispProp_geometry.setEnabled(enable);
        this.dispProp_geomPoint.setEnabled(enable);
        this.dispProp_geomSphere.setEnabled(enable);
    }

    private void setMagScaleEnabled(boolean enable) {
        this.dispProp_scaling.setEnabled(enable);
        this.dispProp_slider.setEnabled(enable);
    }

    private void setColorEnabled(boolean enable) {
        this.dispProp_color.setEnabled(enable);
        this.dispProp_colGradientButton.setEnabled(enable);
        this.propsDisplayPanel.add((Component)this.lowerGradientLabel, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, a_l, f, new Insets(0, 0, 0, 0), 0, 0));
        this.lowerGradientLabel.setEnabled(enable);
        this.higherGradientLabel.setEnabled(enable);
    }

    private void setGradApplyEnabled(boolean enable) {
        this.dispProp_gradient.setEnabled(enable);
        this.dispProp_gradDepth.setEnabled(enable);
        this.dispProp_gradMag.setEnabled(enable);
    }

    private void setExtentsPanel(CatalogAccessor catalog) {
        if (catalog != null) {
            this.catProp_dateFromVal.setText(DATE_FORMAT.format(catalog.getMinDate()));
            this.catProp_dateToVal.setText(DATE_FORMAT.format(catalog.getMaxDate()));
            this.catProp_extentsNval.setText(DECIMAL_FORMAT.format(catalog.getMaxLatitude()));
            this.catProp_extentsWval.setText(DECIMAL_FORMAT.format(catalog.getMinLongitude()));
            this.catProp_extentsEval.setText(DECIMAL_FORMAT.format(catalog.getMaxLongitude()));
            this.catProp_extentsSval.setText(DECIMAL_FORMAT.format(catalog.getMinLatitude()));
            this.catProp_minDepthVal.setText(DECIMAL_FORMAT.format(catalog.getMinDepth()));
            this.catProp_maxDepthVal.setText(DECIMAL_FORMAT.format(catalog.getMaxDepth()));
            this.catProp_minMagVal.setText(DECIMAL_FORMAT.format(catalog.getMinMagnitude()));
            this.catProp_maxMagVal.setText(DECIMAL_FORMAT.format(catalog.getMaxMagnitude()));
            this.catProp_numEventsVal.setText(String.valueOf(catalog.getNumEvents()));
            this.catProp_sourceVal.setText(catalog.getCitation());
            this.minDate = catalog.getMinDate();
            this.maxDate = catalog.getMaxDate();
            this.maxDateMill = this.maxDate.getTime();
            this.minDateMill = this.minDate.getTime();
            this.timeDifference = this.maxDate.getTime() - this.minDate.getTime();
        } else {
            this.catProp_dateFromVal.setText(NO_VALUE);
            this.catProp_dateToVal.setText(NO_VALUE);
            this.catProp_extentsNval.setText(NO_VALUE);
            this.catProp_extentsWval.setText(NO_VALUE);
            this.catProp_extentsEval.setText(NO_VALUE);
            this.catProp_extentsSval.setText(NO_VALUE);
            this.catProp_minDepthVal.setText(NO_VALUE);
            this.catProp_maxDepthVal.setText(NO_VALUE);
            this.catProp_minMagVal.setText(NO_VALUE);
            this.catProp_maxMagVal.setText(NO_VALUE);
            this.catProp_numEventsVal.setText(NO_VALUE);
            this.catProp_sourceVal.setText(NO_VALUE);
        }
    }

    private void clearAttributePanels() {
        this.setExtentsPanel(null);
        this.propsTabbedPane.setEnabledAt(1, false);
        this.disableDisplayPanelComponents();
    }

    public void getEarthquakes(CatalogAccessor cat) {
        this.catalogAcc = cat;
        ArrayList<Earthquake> eqList = new ArrayList<Earthquake>();
        cat.readDataFile();
        new vtkCellArray();
        for (int i = 0; i < cat.getNumEvents(); ++i) {
            Date time = cat.getEq_time(i) != null ? cat.getEq_time(i) : new Date();
            Earthquake eqs = new Earthquake(cat.getEq_depth(i), cat.getEq_magnitude(i), cat.getEq_latitude(i), cat.getEq_longitude(i), time);
            eqList.add(eqs);
        }
        EarthquakeCatalogPluginGUI.setEarthquakes(eqList);
    }

    private static void setEarthquakes(ArrayList<Earthquake> eqList) {
        earthquakes = eqList;
    }

    private void setAttributePanels() {
        EQCatalog catalog = null;
        this.catalogTable.getSelectedValue();
        catalog = this.catalogTable.getSelectedValue();
        if (catalog == null) {
            this.clearAttributePanels();
            return;
        }
        this.setExtentsPanel(catalog);
        this.getEarthquakes(catalog);
        if (catalog instanceof EQCatalog) {
            if (catalog.isInMemory()) {
                this.setDisplayPanel(catalog);
                this.propsTabbedPane.setEnabledAt(1, true);
            } else {
                this.disableDisplayPanelComponents();
                this.propsTabbedPane.setEnabledAt(1, false);
                this.propsTabbedPane.setSelectedIndex(0);
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object src = e.getSource();
        if (src == this.catalogTable.getSelectionModel()) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.processTableSelectionChange();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src == this.dispProp_slider) {
            int scale = this.dispProp_slider.getValue();
            EQCatalog cat = this.catalogTable.getSelectedValue();
            cat.setScaling(scale);
            this.setMagnitudeScale(cat, scale);
        }
        if (src == this.transparencySlider) {
            EQCatalog cat = this.catalogTable.getSelectedValue();
            int transparencyVal = this.transparencySlider.getValue();
            cat.setTransparency(transparencyVal);
            this.setTransparency(cat, transparencyVal);
        }
        if (src == this.depthSlider) {
            this.depthSliderValue = ((JOptionPane)this.depthSlider).getValue();
        }
    }

    public void setTransparency(EQCatalog cat, int transparencyVal) {
        double transparency = transparencyVal * 255 / 100;
        ArrayList<Earthquake> eqList = cat.getSelectedEqList();
        for (int i = 0; i < eqList.size(); ++i) {
            Earthquake eq = eqList.get(i);
            this.animateEarthquakeOpacity(i, eq, cat, (int)transparency);
        }
        Info.getMainGUI();
        MainGUI.updateRenderWindow();
    }

    public void setMagnitudeScale(EQCatalog cat, int scale) {
        double[] scaleMenuItems = new double[]{0.05, 0.1, 0.2, 0.5, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
        double scaleSet = 0.05;
        switch (scale) {
            case 1: {
                scaleSet = scaleMenuItems[0];
                break;
            }
            case 2: {
                scaleSet = scaleMenuItems[1];
                break;
            }
            case 3: {
                scaleSet = scaleMenuItems[2];
                break;
            }
            case 4: {
                scaleSet = scaleMenuItems[3];
                break;
            }
            case 5: {
                scaleSet = scaleMenuItems[4];
                break;
            }
            case 6: {
                scaleSet = scaleMenuItems[5];
                break;
            }
            case 7: {
                scaleSet = scaleMenuItems[6];
                break;
            }
            case 8: {
                scaleSet = scaleMenuItems[7];
                break;
            }
            case 9: {
                scaleSet = scaleMenuItems[8];
                break;
            }
            case 10: {
                scaleSet = scaleMenuItems[9];
            }
        }
        ArrayList<Earthquake> eqList = cat.getSelectedEqList();
        vtkActor actorPointsOld = cat.getActors().get(0);
        vtkActor actorSpheresOld = cat.getActors().get(1);
        vtkDoubleArray radi = new vtkDoubleArray();
        radi.SetName("radi");
        vtkMapper mapperPoints = actorPointsOld.GetMapper();
        vtkMapper mapperSphere = actorSpheresOld.GetMapper();
        vtkVertexGlyphFilter vertexGlyphFilter = new vtkVertexGlyphFilter();
        vertexGlyphFilter = (vtkVertexGlyphFilter)actorPointsOld.GetMapper().GetInputAlgorithm();
        vtkGlyph3D glyphPoints = new vtkGlyph3D();
        glyphPoints = (vtkGlyph3D)actorSpheresOld.GetMapper().GetInputAlgorithm();
        vtkPolyData inputData = new vtkPolyData();
        inputData = (vtkPolyData)vertexGlyphFilter.GetInput();
        radi = (vtkDoubleArray)inputData.GetPointData().GetArray("radi");
        for (int i = 0; i < eqList.size(); ++i) {
            Earthquake eq = eqList.get(i);
            if (cat.getValuesBy() == "Magnitude") {
                radi.SetTuple1((long)i, eq.getEq_magnitude() * scaleSet);
                continue;
            }
            radi.SetTuple1((long)i, eq.getEq_depth() * scaleSet);
        }
        radi.Modified();
        inputData.GetPointData().AddArray((vtkAbstractArray)radi);
        vertexGlyphFilter.SetInputData((vtkDataObject)inputData);
        vertexGlyphFilter.Update();
        mapperPoints.SetInputConnection(vertexGlyphFilter.GetOutputPort());
        glyphPoints.SetInputData((vtkDataObject)inputData);
        mapperSphere.SetInputConnection(glyphPoints.GetOutputPort());
        actorPointsOld.SetMapper(mapperPoints);
        actorSpheresOld.SetMapper(mapperSphere);
        cat.getActors().set(0, actorPointsOld);
        cat.getActors().set(1, actorSpheresOld);
        this.updateActorsAndRender(cat);
    }

    private void updateActorsAndRender(EQCatalog cat) {
        for (vtkActor actor : cat.getActors()) {
            this.pluginActors.addActor((vtkProp)actor);
        }
        MainGUI.updateRenderWindow();
    }

    public void setAnimationColor(Color c1, Color c2) {
    }

    private void setAnimationScaling(int size) {
    }

    public ComcatResourcesDialog getComcatResourceDialog() {
        return this.netSourceDialog;
    }

    public List<vtkActor> animateEarthquakeOpacity(int lastIndex, Earthquake eq, EQCatalog cat, int opacity) {
        ArrayList<Earthquake> eqList = cat.getSelectedEqList();
        vtkActor actorPointsOld = cat.getActors().get(0);
        vtkActor actorSpheresOld = cat.getActors().get(1);
        vtkActor actorPointsNew = new vtkActor();
        vtkActor actorSpheresNew = new vtkActor();
        vtkUnsignedCharArray colors = new vtkUnsignedCharArray();
        colors.SetName("colors");
        colors.SetNumberOfComponents(4);
        colors.SetNumberOfTuples((long)eqList.size());
        vtkMapper mapperPoints = actorPointsOld.GetMapper();
        vtkMapper mapperSphere = actorSpheresOld.GetMapper();
        vtkVertexGlyphFilter vertexGlyphFilter = new vtkVertexGlyphFilter();
        vertexGlyphFilter = (vtkVertexGlyphFilter)actorPointsOld.GetMapper().GetInputAlgorithm();
        vtkGlyph3D glyphPoints = new vtkGlyph3D();
        glyphPoints = (vtkGlyph3D)actorSpheresOld.GetMapper().GetInputAlgorithm();
        vtkPolyData inputData = new vtkPolyData();
        inputData = (vtkPolyData)vertexGlyphFilter.GetInput();
        colors = (vtkUnsignedCharArray)inputData.GetPointData().GetArray("colors");
        double[] val = colors.GetTuple4((long)lastIndex);
        colors.SetTuple4((long)lastIndex, val[0], val[1], val[2], (double)opacity);
        colors.Modified();
        inputData.GetPointData().AddArray((vtkAbstractArray)colors);
        vertexGlyphFilter.SetInputData((vtkDataObject)inputData);
        vertexGlyphFilter.Update();
        mapperPoints.SetInputConnection(vertexGlyphFilter.GetOutputPort());
        glyphPoints.SetInputData((vtkDataObject)inputData);
        mapperSphere.SetInputConnection(glyphPoints.GetOutputPort());
        actorPointsNew.SetMapper(mapperPoints);
        actorSpheresNew.SetMapper(mapperSphere);
        return cat.getActors();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        EQCatalog cat;
        Object src = e.getSource();
        new vtkAnimationScene();
        if (src == this.newInternetSourceButton) {
            if (this.netSourceDialog == null) {
                this.netSourceDialog = new ComcatResourcesDialog(this);
            }
            ComcatResourcesDialog dialog = this.netSourceDialog;
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
        }
        if (src == this.helpButton) {
            JOptionPane.showMessageDialog(this, "Click on any catalog to highlight it. \nOnce it is highlighted, click the checkbox \nto display your catalog. \n \nTo import an earthquake catalog from file on \nyour computer, acquire one from an online \nnetwork, or filter one out of an existing catalog,\nclick the appropriate button on the left.\n \n", "Need Help?", -1);
        }
        if (src == this.dispProp_geomPoint) {
            cat = this.catalogTable.getSelectedValue();
            cat.setGeometry(0);
            this.setCatalogVisible(cat, cat.getGeometry(), true);
        } else if (src == this.dispProp_geomSphere) {
            cat = this.catalogTable.getSelectedValue();
            cat.setGeometry(1);
            this.setCatalogVisible(cat, cat.getGeometry(), true);
        }
        if (src == this.dispProp_gradMag) {
            cat = this.catalogTable.getSelectedValue();
            cat.setValuesBy("Magnitude");
            Color[] newColor = new Color[]{cat.getColor1(), cat.getColor2()};
            this.setColGradient(cat, newColor);
            this.setMagnitudeScale(cat, cat.getScaling());
        } else if (src == this.dispProp_gradDepth) {
            cat = this.catalogTable.getSelectedValue();
            cat.setValuesBy("Depth");
            Color[] newColor = new Color[]{cat.getColor1(), cat.getColor2()};
            this.setColGradient(cat, newColor);
            this.setMagnitudeScale(cat, cat.getScaling());
        } else if (src == this.dispProp_colGradientButton) {
            Color[] newColor;
            if (this.colorChooser == null) {
                this.colorChooser = new GradientColorChooser(this);
            }
            if ((newColor = this.colorChooser.getColors(this.dispProp_colGradientButton.getColor1(), this.dispProp_colGradientButton.getColor2())) != null) {
                this.dispProp_colGradientButton.setColor(newColor[0], newColor[1]);
                if (newColor[0].equals(newColor[1])) {
                    this.setGradApplyEnabled(false);
                    this.higherGradientLabel.setVisible(false);
                    this.lowerGradientLabel.setVisible(false);
                } else {
                    this.setGradApplyEnabled(true);
                    this.higherGradientLabel.setVisible(true);
                    this.lowerGradientLabel.setVisible(true);
                }
            }
            EQCatalog cat2 = this.catalogTable.getSelectedValue();
            this.setColGradient(cat2, newColor);
            this.addLegendScalarBar();
        }
    }

    public void setCatalogVisible(EQCatalog cat, int geometry, boolean visible) {
        vtkActor actorPoints = cat.getActors().get(0);
        vtkActor actorSpheres = cat.getActors().get(1);
        if (geometry == 0) {
            if (visible) {
                actorPoints.VisibilityOn();
                actorSpheres.VisibilityOff();
            } else {
                actorPoints.VisibilityOff();
                actorSpheres.VisibilityOff();
            }
        } else if (geometry == 1) {
            if (visible) {
                actorPoints.VisibilityOff();
                actorSpheres.VisibilityOn();
            } else {
                actorPoints.VisibilityOff();
                actorSpheres.VisibilityOff();
            }
        }
        this.updateActorsAndRender(cat);
    }

    public void setColGradient(EQCatalog cat, Color[] newColor) {
        if (newColor != null) {
            cat.setGradColor1(newColor[0]);
            cat.setGradColor2(newColor[1]);
            cat.initGradientAppearance();
            ArrayList<Earthquake> eqList = cat.getSelectedEqList();
            vtkActor actorPointsOld = cat.getActors().get(0);
            vtkActor actorSpheresOld = cat.getActors().get(1);
            vtkUnsignedCharArray colors = new vtkUnsignedCharArray();
            colors.SetName("colors");
            colors.SetNumberOfComponents(4);
            colors.SetNumberOfTuples((long)eqList.size());
            vtkMapper mapperPoints = actorPointsOld.GetMapper();
            vtkMapper mapperSphere = actorSpheresOld.GetMapper();
            vtkVertexGlyphFilter vertexGlyphFilter = new vtkVertexGlyphFilter();
            vertexGlyphFilter = (vtkVertexGlyphFilter)actorPointsOld.GetMapper().GetInputAlgorithm();
            vtkGlyph3D glyphPoints = new vtkGlyph3D();
            glyphPoints = (vtkGlyph3D)actorSpheresOld.GetMapper().GetInputAlgorithm();
            vtkPolyData inputData = new vtkPolyData();
            inputData = (vtkPolyData)vertexGlyphFilter.GetInput();
            colors = (vtkUnsignedCharArray)inputData.GetPointData().GetArray("colors");
            for (int i = 0; i < eqList.size(); ++i) {
                Earthquake eq = eqList.get(i);
                int ind = cat.getValuesBy() == "Magnitude" ? (int)(Math.floor(Math.floor(eq.getEq_magnitude())) - (double)cat.getMinMagnitude()) : (int)(Math.floor(Math.floor(eq.getEq_depth())) - (double)cat.getMinDepth()) - 1;
                if (ind < 0) {
                    ind = 0;
                }
                colors.SetTuple4((long)i, (double)cat.gradientColors[ind].getRed(), (double)cat.gradientColors[ind].getGreen(), (double)cat.gradientColors[ind].getBlue(), 255.0);
            }
            colors.Modified();
            inputData.GetPointData().AddArray((vtkAbstractArray)colors);
            vertexGlyphFilter.SetInputData((vtkDataObject)inputData);
            vertexGlyphFilter.Update();
            mapperPoints.SetInputConnection(vertexGlyphFilter.GetOutputPort());
            glyphPoints.SetInputData((vtkDataObject)inputData);
            mapperSphere.SetInputConnection(glyphPoints.GetOutputPort());
            actorPointsOld.SetMapper(mapperPoints);
            actorSpheresOld.SetMapper(mapperSphere);
            cat.getActors().set(0, actorPointsOld);
            cat.getActors().set(1, actorSpheresOld);
            this.updateActorsAndRender(cat);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    public CatalogTable getCatalogTable() {
        return this.catalogTable;
    }

    public ArrayList<EQCatalog> getCatalogs() {
        return eqCatalogs;
    }

    public PickHandler<EQCatalog> getPickHandler() {
        return this.pickHandler;
    }

    public void addLegendScalarBar() {
        Color minColor = this.dispProp_colGradientButton.getColor1();
        Color maxColor = this.dispProp_colGradientButton.getColor2();
        EQCatalog cat = this.catalogTable.getSelectedValue();
        this.scalarBar = LegendUtils.buildColorBarLegend(this.plugin, "Magnitude", 0.05, 0.05, minColor, cat.getMinMagnitude(), maxColor, cat.getMaxMagnitude());
        this.pluginActors.addLegend(this.scalarBar);
        MainGUI.updateRenderWindow();
    }

    public void removeLegend() {
        this.pluginActors.removeLegend(this.scalarBar);
        MainGUI.updateRenderWindow();
    }

    public boolean isTrueTimeSelected() {
        return this.trueTime.isSelected();
    }

    static {
        eqCatalogs = new ArrayList();
        String sourceStore = Prefs.getLibLoc() + File.separator + EarthquakeCatalogPlugin.dataStoreDir + File.separator + "source" + File.separator + "data";
        String displayStore = Prefs.getLibLoc() + File.separator + EarthquakeCatalogPlugin.dataStoreDir + File.separator + "display" + File.separator + "data";
        File file = new File(sourceStore);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(file = new File(displayStore)).exists()) {
            file.mkdirs();
        }
    }
}

