/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.EarthquakeCatalogPlugin;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.dom4j.Element;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components.EQCatalog;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.EarthquakeCatalogPluginGUI;
import org.scec.vtk.plugins.PluginState;

public class EarthquakeCatalogPluginState
implements PluginState {
    private EarthquakeCatalogPluginGUI parent;
    private ArrayList<EQCatalog> catalogs;
    private ArrayList<Color> color1;
    private ArrayList<Color> color2;
    private ArrayList<Integer> scaling;
    private ArrayList<Integer> transparency;
    ArrayList<Boolean> visibility;
    ArrayList<Integer> geometry;
    private ArrayList<String> dispName;
    private ArrayList<String> filePath;
    private ArrayList<Boolean> catalogTypeIsComcat;
    private ArrayList<String> valuesBy;

    EarthquakeCatalogPluginState(EarthquakeCatalogPluginGUI parent) {
        this.parent = parent;
        this.catalogs = new ArrayList();
        this.dispName = new ArrayList();
        this.filePath = new ArrayList();
        this.color1 = new ArrayList();
        this.color2 = new ArrayList();
        this.scaling = new ArrayList();
        this.transparency = new ArrayList();
        this.visibility = new ArrayList();
        this.geometry = new ArrayList();
        this.valuesBy = new ArrayList();
        this.catalogTypeIsComcat = new ArrayList();
    }

    void copyLatestCatalogDetials() {
        this.catalogs.clear();
        this.dispName.clear();
        this.filePath.clear();
        this.color1.clear();
        this.color2.clear();
        this.scaling.clear();
        this.transparency.clear();
        this.visibility.clear();
        this.geometry.clear();
        this.catalogTypeIsComcat.clear();
        Iterator<EQCatalog> iterator = this.parent.getCatalogs().iterator();
        while (iterator.hasNext()) {
            EQCatalog eqc;
            EQCatalog cat = eqc = iterator.next();
            this.dispName.add(eqc.getDisplayName());
            if (!eqc.getCatalogTypeIsComcat()) {
                this.filePath.add(eqc.getAttributeFile().getPath());
                this.catalogTypeIsComcat.add(false);
            } else {
                this.filePath.add(eqc.getComcatFilePathString());
                this.catalogTypeIsComcat.add(true);
            }
            this.color1.add(cat.getColor1());
            this.color2.add(cat.getColor2());
            this.scaling.add(cat.getScaling());
            System.out.println("scaling:" + cat.getScaling());
            this.transparency.add(cat.getTransparency());
            this.visibility.add(eqc.isDisplayed());
            System.out.println("cat.isDisplayed: " + cat.isDisplayed());
            this.geometry.add(eqc.getGeometry());
            System.out.println("cat.getGeometry() " + cat.getGeometry());
            this.valuesBy.add(eqc.getValuesBy());
            System.out.println("cat.getValuesBy() " + cat.getValuesBy());
            this.catalogs.add(cat);
        }
    }

    @Override
    public void load() {
        int i = 0;
        for (EQCatalog eqc : this.catalogs) {
            eqc.setValuesBy(this.valuesBy.get(i));
            Color[] newColor = new Color[]{this.color1.get(i), this.color2.get(i)};
            this.parent.setColGradient(eqc, newColor);
            this.parent.setMagnitudeScale(eqc, this.scaling.get(i));
            this.parent.setTransparency(eqc, this.transparency.get(i));
            eqc.setDisplayed(this.visibility.get(i));
            this.parent.setCatalogVisible(eqc, this.geometry.get(i), this.visibility.get(i));
            Info.getMainGUI();
            MainGUI.updateRenderWindow();
            ++i;
        }
    }

    private void createElement(Element stateEl) {
        int i = 0;
        for (EQCatalog eqc : this.catalogs) {
            Element propertyEl = stateEl.addElement("EarthquakeCatalog");
            propertyEl.addElement("dispName").addText(this.dispName.get(i));
            propertyEl.addElement("filePath").addText(this.filePath.get(i));
            propertyEl.addElement("color1").addText(Integer.toString(this.color1.get(i).getRGB()));
            propertyEl.addElement("color2").addText(Integer.toString(this.color2.get(i).getRGB()));
            propertyEl.addElement("scaling").addText(Integer.toString(this.scaling.get(i)));
            propertyEl.addElement("transparency").addText(Integer.toString(this.transparency.get(i)));
            propertyEl.addElement("geometry").addText(Integer.toString(this.geometry.get(i)));
            propertyEl.addElement("comcat").addText(this.catalogTypeIsComcat.get(i).toString());
            propertyEl.addElement("valuesBy").addText(this.valuesBy.get(i));
            propertyEl.addElement("visibility").addText(this.visibility.get(i).toString());
            System.out.println(eqc.getColor1());
            System.out.println(eqc.getColor2());
            ++i;
        }
    }

    @Override
    public void toXML(Element stateEl) {
        this.copyLatestCatalogDetials();
        this.createElement(stateEl);
    }

    @Override
    public void fromXML(Element stateEl) {
        Iterator i = stateEl.elementIterator("EarthquakeCatalog");
        while (i.hasNext()) {
            EQCatalog eq;
            Element e = (Element)i.next();
            this.dispName.add(e.elementText("dispName"));
            this.filePath.add(e.elementText("filePath"));
            this.color1.add(Color.decode(e.elementText("color1")));
            this.color2.add(Color.decode(e.elementText("color2")));
            this.scaling.add(Integer.parseInt(e.elementText("scaling")));
            this.transparency.add(Integer.parseInt(e.elementText("transparency")));
            this.geometry.add(Integer.parseInt(e.elementText("geometry")));
            this.visibility.add(Boolean.parseBoolean(e.elementText("visibility")));
            this.valuesBy.add(e.elementText("valuesBy"));
            this.catalogTypeIsComcat.add(Boolean.parseBoolean(e.elementText("comcat")));
            System.out.println(e.elementText("filePath"));
            File file = new File(this.filePath.get(this.filePath.size() - 1));
            if (!this.catalogTypeIsComcat.get(this.catalogTypeIsComcat.size() - 1).booleanValue()) {
                eq = new EQCatalog(this.parent, file, this.parent.getPluginActors());
            } else {
                eq = new EQCatalog(this.parent);
                eq.setDisplayName(this.dispName.get(this.dispName.size() - 1));
                System.out.println(file.getPath());
                System.out.println(eq.getDisplayName());
                eq.getCrd().readFromComcatDataFile(eq, file.getPath());
            }
            this.parent.getCatalogTable().addCatalog(eq);
            this.parent.getCatalogTable().setSelected(eq);
            int row = this.parent.getCatalogTable().tableModel.indexOf(eq);
            if (!this.parent.getCatalogTable().tableModel.getLoadedStateForRow(row)) {
                this.parent.getCatalogTable().tableModel.setLoadedStateForRow(true, row);
                this.parent.processTableSelectionChange();
            }
            eq = (EQCatalog)this.parent.getCatalogTable().tableModel.getObjectAtRow(row);
            this.catalogs.add(eq);
            eq.setDisplayed(false);
            this.parent.getCatalogTable().setVisibility(this.parent.getCatalogTable().tableModel, eq, row);
        }
    }

    @Override
    public PluginState deepCopy() {
        EarthquakeCatalogPluginState state = new EarthquakeCatalogPluginState(this.parent);
        state.copyLatestCatalogDetials();
        return state;
    }
}

