/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.EarthquakeCatalogPlugin.RelativeIntensity;

public class ConfidenceInterval {
    public static double[] computeInterval(int N) {
        double[] tauArray = new double[N];
        for (int n = 1; n <= N; ++n) {
            double total = 0.0;
            double lowerTau = 0.0;
            double upperTau = 1.0;
            double tau = 0.5;
            while (Math.abs(total - 0.02) > 1.0E-6) {
                total = 0.0;
                for (int i = n; i <= N; ++i) {
                    double constant = 1.0;
                    for (int j = 0; j < i; ++j) {
                        constant *= (double)(N - j) / (double)(i - j);
                    }
                    total += constant * Math.pow(tau, i) * Math.pow(1.0 - tau, N - i);
                }
                if (total > 0.02) {
                    upperTau = tau;
                    tau = (tau + lowerTau) / 2.0;
                    continue;
                }
                lowerTau = tau;
                tau = (tau + upperTau) / 2.0;
            }
            tauArray[n - 1] = tau;
        }
        return tauArray;
    }
}

