/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.EarthquakeCatalogPlugin.RelativeIntensity;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.RelativeIntensity.ConfidenceInterval;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.RelativeIntensity.RelativeIntensityGUI;

public class Mocho {
    private RelativeIntensityGUI owner;

    public Mocho(RelativeIntensityGUI owner) {
        this.owner = owner;
    }

    public JPanel createGraph(float[][] data, String title, boolean weighted) {
        JFreeChart chart = this.createChart(this.createXYDataSet(data, weighted), weighted, title);
        return new ChartPanel(chart);
    }

    private XYDataset createXYDataSet(float[][] data, boolean weighted) {
        XYSeries series = new XYSeries((Comparable)((Object)"Molchan Trajectory"));
        int rows = data.length;
        if (!weighted) {
            for (int i = 0; i < rows; ++i) {
                series.add((double)data[i][1], (double)data[i][0]);
            }
        } else {
            for (int i = 0; i < rows; ++i) {
                series.add((double)data[i][2], (double)data[i][0]);
            }
        }
        XYSeries series2 = this.getConfident();
        XYSeries seriesDiag = this.makeDiagonal();
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        dataset.addSeries(series2);
        dataset.addSeries(seriesDiag);
        return dataset;
    }

    private XYSeries getConfident() {
        XYSeries series = new XYSeries((Comparable)((Object)"98% Confidence Interval"));
        int rows = this.owner.getTargetCatalog().getNumEvents();
        double[] nuForCI = new double[rows];
        for (int i = 1; i <= rows; ++i) {
            nuForCI[i - 1] = ((double)rows - (double)i) / (double)rows;
        }
        double[] tauArray = ConfidenceInterval.computeInterval(rows);
        for (int a = 0; a < rows; ++a) {
            series.add(tauArray[a], nuForCI[a]);
        }
        return series;
    }

    private XYSeries makeDiagonal() {
        XYSeries series = new XYSeries((Comparable)((Object)"Null Hypothesis"));
        int rows = this.owner.getTargetCatalog().getNumEvents();
        for (int i = 1; i <= rows; ++i) {
            series.add((double)i / (double)rows, 1.0 - (double)i / (double)rows);
        }
        return series;
    }

    private JFreeChart createChart(XYDataset dataset, boolean weighted, String title) {
        JFreeChart chart = !weighted ? ChartFactory.createScatterPlot((String)title, (String)"Map-area fraction of space covered by alarm", (String)"Miss rate", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false) : ChartFactory.createScatterPlot((String)title, (String)"Intensity-weighted-area fraction of space covered by alarm", (String)"Miss rate", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        chart.getXYPlot().getDomainAxis().setRange(0.0, 1.0);
        chart.getXYPlot().getRangeAxis().setRange(0.0, 1.0);
        chart.getTitle().setFont(new Font("Arial", 0, 13));
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        Ellipse2D.Float circle = new Ellipse2D.Float(-5.0f, -5.0f, 10.0f, 10.0f);
        XYItemRenderer r = plot.getRenderer();
        if (r instanceof XYLineAndShapeRenderer) {
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)r;
            renderer.setSeriesShape(0, (Shape)circle);
            renderer.setSeriesShapesVisible(0, true);
            renderer.setSeriesLinesVisible(0, true);
            renderer.setSeriesShapesFilled(0, false);
            r.setSeriesVisibleInLegend(0, Boolean.valueOf(true));
        }
        return chart;
    }
}

