/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.EarthquakeCatalogPlugin.RelativeIntensity;

public class MolchanTools {
    public float[][] getMolchanTrajectoryFromRIMap(int[][] riMap, int[][] targetEqks, boolean useMarginOfError, int rows, int columns) {
        int minThreshold = 0;
        int maxThreshold = 0;
        int thresholdStep = 1;
        int numberOfRows = rows;
        int numberOfCols = columns;
        for (int rowCounter = 0; rowCounter < numberOfRows; ++rowCounter) {
            for (int colCounter = 0; colCounter < numberOfCols; ++colCounter) {
                if (riMap[rowCounter][colCounter] <= maxThreshold) continue;
                maxThreshold = riMap[rowCounter][colCounter];
            }
        }
        int numberOfTargetEqks = 0;
        for (int rowCounter = 0; rowCounter < numberOfRows; ++rowCounter) {
            for (int colCounter = 0; colCounter < numberOfCols; ++colCounter) {
                numberOfTargetEqks += targetEqks[rowCounter][colCounter];
            }
        }
        float[][] nu_tau_weightedTau = new float[maxThreshold + 1][3];
        for (int threshold = minThreshold; threshold <= maxThreshold; threshold += thresholdStep) {
            boolean[][] alarmMap = this.getAlarmMapFromRIMap(riMap, threshold, useMarginOfError, numberOfRows, numberOfCols);
            nu_tau_weightedTau[threshold][0] = this.getNuFromAlarmMap(alarmMap, targetEqks, numberOfTargetEqks, numberOfRows, numberOfCols);
            nu_tau_weightedTau[threshold][1] = this.getTauFromAlarmMap(alarmMap, riMap, false, numberOfRows, numberOfCols);
            nu_tau_weightedTau[threshold][2] = this.getTauFromAlarmMap(alarmMap, riMap, true, numberOfRows, numberOfCols);
        }
        return nu_tau_weightedTau;
    }

    private boolean[][] getAlarmMapFromRIMap(int[][] riMap, float threshold, boolean useMarginOfError, int rows, int columns) {
        int colCounter;
        int rowCounter;
        int numberOfRows = rows;
        int numberOfCols = columns;
        boolean[][] alarmMap = new boolean[numberOfRows][numberOfCols];
        for (rowCounter = 0; rowCounter < numberOfRows; ++rowCounter) {
            for (colCounter = 0; colCounter < numberOfCols; ++colCounter) {
                alarmMap[rowCounter][colCounter] = false;
            }
        }
        for (rowCounter = 0; rowCounter < numberOfRows; ++rowCounter) {
            for (colCounter = 0; colCounter < numberOfCols; ++colCounter) {
                if (!((float)riMap[rowCounter][colCounter] > threshold)) continue;
                alarmMap[rowCounter][colCounter] = true;
                if (!useMarginOfError) continue;
                try {
                    alarmMap[rowCounter + 1][colCounter + 1] = true;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                try {
                    alarmMap[rowCounter + 1][colCounter - 1] = true;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                try {
                    alarmMap[rowCounter + 1][colCounter] = true;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                try {
                    alarmMap[rowCounter - 1][colCounter + 1] = true;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                try {
                    alarmMap[rowCounter - 1][colCounter - 1] = true;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                try {
                    alarmMap[rowCounter - 1][colCounter] = true;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                try {
                    alarmMap[rowCounter][colCounter + 1] = true;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                try {
                    alarmMap[rowCounter][colCounter - 1] = true;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        return alarmMap;
    }

    private float getTauFromAlarmMap(boolean[][] alarmMap, int[][] riMap, boolean useWeightedTau, int rows, int columns) {
        int numberOfRows = rows;
        int numberOfCols = columns;
        if (!useWeightedTau) {
            int numberOfAlarms = 0;
            int numberOfBoxes = 0;
            for (int rowCounter = 0; rowCounter < numberOfRows; ++rowCounter) {
                for (int colCounter = 0; colCounter < numberOfCols; ++colCounter) {
                    ++numberOfBoxes;
                    if (!alarmMap[rowCounter][colCounter]) continue;
                    ++numberOfAlarms;
                }
            }
            float tau = (float)numberOfAlarms / (float)numberOfBoxes;
            return tau;
        }
        int numberOfAlarms = 0;
        int numberOfBoxes = 0;
        for (int rowCounter = 0; rowCounter < numberOfRows; ++rowCounter) {
            for (int colCounter = 0; colCounter < numberOfCols; ++colCounter) {
                numberOfBoxes += riMap[rowCounter][colCounter];
                if (!alarmMap[rowCounter][colCounter]) continue;
                numberOfAlarms += riMap[rowCounter][colCounter];
            }
        }
        float tau = (float)numberOfAlarms / (float)numberOfBoxes;
        return tau;
    }

    private float getNuFromAlarmMap(boolean[][] alarmMap, int[][] targetEqks, int numberOfTargetEqks, int rows, int columns) {
        int numberOfRows = rows;
        int numberOfCols = columns;
        int numberOfMisses = 0;
        for (int rowCounter = 0; rowCounter < numberOfRows; ++rowCounter) {
            for (int colCounter = 0; colCounter < numberOfCols; ++colCounter) {
                if (alarmMap[rowCounter][colCounter]) continue;
                numberOfMisses += targetEqks[rowCounter][colCounter];
            }
        }
        float nu = (float)numberOfMisses / (float)numberOfTargetEqks;
        return nu;
    }
}

