/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.EarthquakeCatalogPlugin.RelativeIntensity;

import java.awt.Component;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components.EQCatalog;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.RelativeIntensity.MolchanTools;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.RelativeIntensity.RelativeIntensityGUI;

public class RelativeIntensity {
    private double maxLat;
    private double minLat;
    private double maxLon;
    private double minLon;
    private int[][] riGrid;
    private int[][] targetGrid;
    private double sizeOfBin;
    private int numOfBinsLat;
    private int numOfBinsLon;
    private EQCatalog sourceCatalog;
    private EQCatalog targetCatalog;
    private RelativeIntensityGUI gui;
    private MolchanTools mt;
    private boolean useMarginOfError;
    private boolean gridExists = false;
    private boolean gridIsOn = false;

    public RelativeIntensity(Component parent) {
        this.gui = new RelativeIntensityGUI(this, parent);
        this.mt = new MolchanTools();
        this.useMarginOfError = false;
    }

    public RelativeIntensityGUI getGUI() {
        return this.gui;
    }

    public void plotEQs() {
        this.maxLat = Double.parseDouble(this.gui.getMaxLat());
        this.minLat = Double.parseDouble(this.gui.getMinLat());
        this.maxLon = Double.parseDouble(this.gui.getMaxLon());
        this.minLon = Double.parseDouble(this.gui.getMinLon());
        this.sizeOfBin = Double.parseDouble(this.gui.getBinDimension());
        this.sourceCatalog = this.gui.getSourceCatalog();
        this.targetCatalog = this.gui.getTargetCatalog();
        this.numOfBinsLat = (int)Math.round((this.maxLat - this.minLat) / this.sizeOfBin);
        this.numOfBinsLon = (int)Math.round((this.maxLon - this.minLon) / this.sizeOfBin);
        this.riGrid = this.binEQs(this.sourceCatalog);
        this.targetGrid = this.binEQs(this.targetCatalog);
        this.displayGrid();
    }

    public int[][] binEQs(EQCatalog catalog) {
        int[][] grid = new int[this.numOfBinsLat + 1][this.numOfBinsLon + 1];
        for (int i = 0; i < catalog.getNumEvents(); ++i) {
            if ((double)catalog.getEq_latitude(i) < this.minLat || (double)catalog.getEq_longitude(i) < this.minLon || (double)catalog.getEq_latitude(i) > this.maxLat || (double)catalog.getEq_longitude(i) > this.maxLon) continue;
            int lat_translated = (int)Math.floor((double)catalog.getEq_latitude(i) * (1.0 / this.sizeOfBin));
            int lon_translated = (int)Math.floor((double)catalog.getEq_longitude(i) * (1.0 / this.sizeOfBin));
            int minLat_translated = (int)(this.minLat * 1.0 / this.sizeOfBin);
            int minLon_translated = (int)(this.minLon * 1.0 / this.sizeOfBin);
            int binNumLat = lat_translated - minLat_translated;
            int binNumLon = lon_translated - minLon_translated;
            int[] nArray = grid[binNumLat];
            int n = binNumLon;
            nArray[n] = nArray[n] + 1;
        }
        return grid;
    }

    public float[][] getMolchanTrajectory() {
        float[][] results = this.mt.getMolchanTrajectoryFromRIMap(this.riGrid, this.targetGrid, this.useMarginOfError, this.numOfBinsLat, this.numOfBinsLon);
        return results;
    }

    public int[][] getRiGrid() {
        return this.riGrid;
    }

    public int[][] getTargetGrid() {
        return this.targetGrid;
    }

    public void printGrid() {
        for (int i = 0; i < this.numOfBinsLat; ++i) {
            for (int j = 0; j < this.numOfBinsLon; ++j) {
                System.out.print(this.riGrid[i][j] + " ");
            }
            System.out.println("");
        }
    }

    public void displayGrid() {
        this.gridExists = true;
        this.gridIsOn = true;
        this.gui.binningOnBox.setSelected(true);
    }

    public void showGrid() {
        if (!this.gridExists || !this.gridIsOn) {
            // empty if block
        }
        this.gridIsOn = true;
    }

    public void showGrid(int maxAlt) {
        if (!this.gridExists || !this.gridIsOn) {
            // empty if block
        }
        this.gridIsOn = true;
    }

    public void hideGrid() {
        if (this.gridExists && this.gridIsOn) {
            this.gridIsOn = false;
        }
    }

    public void setUseMarginOfError(boolean selected) {
        this.useMarginOfError = selected;
    }

    public void showTargetEQs() {
        int len = this.targetCatalog.getNumEvents();
        double[] lat = new double[len];
        double[] lon = new double[len];
        for (int i = 0; i < len; ++i) {
            lat[i] = this.targetCatalog.getEq_latitude(i);
            lon[i] = this.targetCatalog.getEq_longitude(i);
        }
    }

    public void hideTargetEQs() {
        System.out.println("Error! Trying to hide taret EQs but they're not displayed!");
    }
}

