/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.EarthquakeCatalogPlugin.RelativeIntensity;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DateFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components.CatalogTable;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components.CatalogTableModel;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.Components.EQCatalog;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.EarthquakeCatalogPluginGUI;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.RelativeIntensity.Mocho;
import org.scec.vtk.plugins.EarthquakeCatalogPlugin.RelativeIntensity.RelativeIntensity;

public class RelativeIntensityGUI
extends JPanel
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    private RelativeIntensity parent;
    private EarthquakeCatalogPluginGUI eqGUI;
    private JTextField northLatField = new JTextField("38.3", 5);
    private JTextField southLatField = new JTextField("32", 5);
    private JTextField westLonField = new JTextField("-123", 5);
    private JTextField eastLonField = new JTextField("-115", 5);
    private JTextField binDimField = new JTextField("0.1", 1);
    public JCheckBox binningOnBox = new JCheckBox("Turn Binning On");
    private JCheckBox marginErrorBox = new JCheckBox("Use Margin of Error");
    private JComboBox inputEqMenu = new JComboBox();
    private JComboBox targetEqMenu = new JComboBox();
    private JCheckBox epicenterBox = new JCheckBox("Display Target Epicenter");
    private JCheckBox exagerationBox = new JCheckBox("Turn Vertical Exaggeration On");
    private JButton applyButton = new JButton("Apply");
    private JButton weightedButton = new JButton("Weighted Molchan");
    private JButton unweightedButton = new JButton("Unweighted Molchan");
    private String margErrorTitle = "Without Margin of Error";

    public RelativeIntensityGUI(RelativeIntensity newParent, Component parent) {
        this.parent = newParent;
        this.eqGUI = (EarthquakeCatalogPluginGUI)parent;
        this.setName("Relative Intensity");
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setMaximumSize(new Dimension(350, 350));
        this.add(this.getTitlePanel());
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.add(this.getExtentsPanel());
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(this.getBinDimPanel());
        this.add(this.makebottomPanel());
        this.add(this.getCheckboxPanel());
        this.add(this.getButtonPanel());
    }

    private JPanel makebottomPanel() {
        JPanel bottomPanel = new JPanel();
        CatalogTableModel ctm = this.eqGUI.getCatalogTable().getLibraryModel();
        for (int i = 0; i < ctm.getRowCount(); ++i) {
            EQCatalog eqCat = (EQCatalog)ctm.getObjectAtRow(i);
            this.inputEqMenu.addItem(eqCat.toString());
            this.targetEqMenu.addItem(eqCat.toString());
        }
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new BoxLayout(inputPanel, 2));
        inputPanel.add(new JLabel("Select Input EQ Catalog:"));
        inputPanel.add(Box.createRigidArea(new Dimension(40, 0)));
        inputPanel.add(this.inputEqMenu);
        inputPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        JPanel targetPanel = new JPanel();
        targetPanel.setLayout(new BoxLayout(targetPanel, 2));
        targetPanel.add(new JLabel("Select Target EQ Epicenter:"));
        targetPanel.add(Box.createRigidArea(new Dimension(26, 0)));
        targetPanel.add(this.targetEqMenu);
        targetPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 3));
        bottomPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        bottomPanel.add(inputPanel);
        bottomPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        bottomPanel.add(targetPanel);
        bottomPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        bottomPanel.setMaximumSize(new Dimension(350, 300));
        this.inputEqMenu.addActionListener(this);
        this.targetEqMenu.addActionListener(this);
        return bottomPanel;
    }

    private JPanel getExtentsPanel() {
        JPanel extentsPanel = new JPanel();
        JPanel nsPanel = new JPanel();
        nsPanel.setLayout(new BoxLayout(nsPanel, 2));
        nsPanel.add(new JLabel("Min Lat:"));
        nsPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        nsPanel.add(this.southLatField);
        nsPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        nsPanel.add(new JLabel("Max Lat:"));
        nsPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        nsPanel.add(this.northLatField);
        nsPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        JPanel ewPanel = new JPanel();
        ewPanel.setLayout(new BoxLayout(ewPanel, 2));
        ewPanel.add(new JLabel("Min Lon:"));
        ewPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        ewPanel.add(this.westLonField);
        ewPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        ewPanel.add(new JLabel("Max Lon:"));
        ewPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        ewPanel.add(this.eastLonField);
        ewPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        extentsPanel.setLayout(new BoxLayout(extentsPanel, 1));
        extentsPanel.add(nsPanel);
        extentsPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        extentsPanel.add(ewPanel);
        extentsPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        extentsPanel.setMaximumSize(new Dimension(300, 100));
        this.southLatField.addFocusListener(this);
        this.northLatField.addFocusListener(this);
        this.westLonField.addFocusListener(this);
        this.eastLonField.addFocusListener(this);
        return extentsPanel;
    }

    private JPanel getTitlePanel() {
        JPanel titlePanel = new JPanel(new GridLayout(1, 1, 10, 10));
        titlePanel.add(new JLabel("Bin Extents:"));
        return titlePanel;
    }

    private JPanel getBinDimPanel() {
        JPanel binDimPanel = new JPanel();
        binDimPanel.setLayout(new BoxLayout(binDimPanel, 2));
        binDimPanel.add(new JLabel("Bin Dimension(degs):"));
        binDimPanel.add(Box.createRigidArea(new Dimension(5, 10)));
        binDimPanel.add(this.binDimField);
        binDimPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        binDimPanel.add(this.binningOnBox);
        binDimPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        binDimPanel.add(this.marginErrorBox);
        binDimPanel.setMaximumSize(new Dimension(400, 15));
        this.binDimField.addFocusListener(this);
        this.marginErrorBox.addActionListener(this);
        this.binningOnBox.addActionListener(this);
        this.binningOnBox.setEnabled(false);
        return binDimPanel;
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        buttonPanel.add(this.applyButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        buttonPanel.add(this.weightedButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        buttonPanel.add(this.unweightedButton);
        this.applyButton.addActionListener(this);
        this.weightedButton.addActionListener(this);
        this.unweightedButton.addActionListener(this);
        this.weightedButton.setEnabled(true);
        this.unweightedButton.setEnabled(true);
        return buttonPanel;
    }

    private JPanel getCheckboxPanel() {
        JPanel checkboxPanel = new JPanel();
        checkboxPanel.add(this.epicenterBox);
        checkboxPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        checkboxPanel.add(this.exagerationBox);
        checkboxPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.epicenterBox.addActionListener(this);
        this.exagerationBox.addActionListener(this);
        this.epicenterBox.setEnabled(false);
        this.exagerationBox.setEnabled(false);
        return checkboxPanel;
    }

    public void updateCombo() {
        CatalogTableModel ctm = this.eqGUI.getCatalogTable().getLibraryModel();
        if (ctm != null && this.inputEqMenu != null) {
            this.inputEqMenu.removeAllItems();
            this.targetEqMenu.removeAllItems();
            for (int i = 0; i < ctm.getRowCount(); ++i) {
                EQCatalog eqCat = (EQCatalog)ctm.getObjectAtRow(i);
                this.inputEqMenu.addItem(eqCat.toString());
                this.targetEqMenu.addItem(eqCat.toString());
            }
        }
    }

    public String getMaxLat() {
        return this.northLatField.getText();
    }

    public String getMinLat() {
        return this.southLatField.getText();
    }

    public String getMaxLon() {
        return this.eastLonField.getText();
    }

    public String getMinLon() {
        return this.westLonField.getText();
    }

    public String getBinDimension() {
        return this.binDimField.getText();
    }

    public EQCatalog getSourceCatalog() {
        int selectedIndex = this.inputEqMenu.getSelectedIndex();
        CatalogTableModel ctm = this.eqGUI.getCatalogTable().getLibraryModel();
        EQCatalog eqCat = (EQCatalog)ctm.getObjectAtRow(selectedIndex);
        return eqCat;
    }

    public EQCatalog getTargetCatalog() {
        int selectedIndex = this.targetEqMenu.getSelectedIndex();
        CatalogTableModel ctm = this.eqGUI.getCatalogTable().getLibraryModel();
        EQCatalog eqCat = (EQCatalog)ctm.getObjectAtRow(selectedIndex);
        return eqCat;
    }

    private void displayRIMap() {
        this.makeRIMap();
        if (this.exagerationBox.isSelected()) {
            this.parent.hideGrid();
            this.parent.showGrid(100);
        }
        if (this.epicenterBox.isSelected()) {
            this.parent.showTargetEQs();
        }
        this.binningOnBox.setEnabled(true);
        this.exagerationBox.setEnabled(true);
        this.epicenterBox.setEnabled(true);
        this.applyButton.setEnabled(false);
    }

    private void makeRIMap() {
        CatalogTable ct;
        EQCatalog source = this.getSourceCatalog();
        EQCatalog target = this.getTargetCatalog();
        if (!source.isInMemory()) {
            source.setInMemory(true);
            ct = this.eqGUI.getCatalogTable();
            ct.getLibraryModel().setLoadedStateForRow(true, ct.getLibraryModel().indexOf(source));
        }
        if (!target.isInMemory()) {
            target.setInMemory(true);
            ct = this.eqGUI.getCatalogTable();
            ct.getLibraryModel().setLoadedStateForRow(true, ct.getLibraryModel().indexOf(target));
        }
        this.parent.plotEQs();
    }

    private void displayMolchanGraph(boolean weighted) {
        this.displayRIMap();
        float[][] data = this.parent.getMolchanTrajectory();
        Mocho molchanGraph = new Mocho(this);
        String title = "Latitude: " + this.getMinLat() + " to " + this.getMaxLat() + ";Longitude: " + this.getMinLon() + " to " + this.getMaxLon() + ";\nSource Min Mag: " + this.getSourceCatalog().getMinMagnitude() + ";Target Min Mag: " + this.getTargetCatalog().getMinMagnitude() + ";\nInput Dates: " + DateFormat.getDateInstance(2).format(this.getSourceCatalog().getMinDate()) + " to " + DateFormat.getDateInstance(2).format(this.getSourceCatalog().getMaxDate()) + ";\nTarget Dates: " + DateFormat.getDateInstance(2).format(this.getTargetCatalog().getMinDate()) + " to " + DateFormat.getDateInstance(2).format(this.getTargetCatalog().getMaxDate()) + ";";
        JPanel mochoPanel = new JPanel();
        JFrame dialog = new JFrame((weighted ? "Weighted" : "Unweighted") + " Molchan Diagram " + this.margErrorTitle);
        mochoPanel.setLayout(new BoxLayout(mochoPanel, 3));
        mochoPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mochoPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        mochoPanel.add(molchanGraph.createGraph(data, title, weighted));
        mochoPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        JPanel mButtonPanel = new JPanel();
        mButtonPanel.setLayout(new BoxLayout(mButtonPanel, 2));
        mButtonPanel.setMaximumSize(new Dimension(600, 100));
        dialog.add(mochoPanel);
        dialog.pack();
        dialog.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.applyButton) {
            this.displayRIMap();
        } else if (src == this.weightedButton) {
            this.displayMolchanGraph(true);
        } else if (src == this.unweightedButton) {
            this.displayMolchanGraph(false);
        } else if (src == this.binningOnBox) {
            if (this.binningOnBox.isSelected()) {
                this.parent.showGrid();
                if (this.epicenterBox.isSelected()) {
                    this.parent.showTargetEQs();
                }
                this.exagerationBox.setEnabled(true);
                this.epicenterBox.setEnabled(true);
            } else {
                this.parent.hideGrid();
                if (this.epicenterBox.isSelected()) {
                    this.parent.hideTargetEQs();
                }
                this.exagerationBox.setEnabled(false);
                this.epicenterBox.setEnabled(false);
            }
        } else if (src == this.epicenterBox) {
            if (this.epicenterBox.isSelected()) {
                this.parent.showTargetEQs();
            } else {
                this.parent.hideTargetEQs();
            }
        } else if (src == this.exagerationBox) {
            if (this.binningOnBox.isSelected()) {
                if (this.exagerationBox.isSelected()) {
                    this.parent.hideGrid();
                    this.parent.showGrid(100);
                } else {
                    this.parent.hideGrid();
                    this.parent.showGrid(0);
                }
            }
        } else if (src == this.marginErrorBox) {
            if (this.marginErrorBox.isSelected()) {
                this.parent.setUseMarginOfError(true);
                this.margErrorTitle = "With Margin of Error";
            } else {
                this.parent.setUseMarginOfError(false);
                this.margErrorTitle = "Without Margin of Error";
            }
        } else if (src == this.targetEqMenu || src == this.inputEqMenu) {
            this.applyButton.setEnabled(true);
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        this.applyButton.setEnabled(true);
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.applyButton.setEnabled(true);
    }
}

