/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.GISHazusEventsPlugin;

import java.awt.Color;
import java.util.ArrayList;
import org.scec.vtk.plugins.GISHazusEventsPlugin.GISHazusEventsPluginGUI;
import org.scec.vtk.plugins.utils.AbstractLibraryModel;

public class BoundSectionsTableModel
extends AbstractLibraryModel {
    private static final String[] columnNames = new String[]{"Show/Hide", "Color", "Region"};
    private boolean[] isSelectedRow;
    private Color[] traceColor;
    private static Color DEFAULT_COLOR = new Color(255, 255, 255);
    private ArrayList continentsList;
    private boolean[] inMem = null;
    private GISHazusEventsPluginGUI eventsGUI;
    private static final long serialVersionUID = 1L;

    public BoundSectionsTableModel(ArrayList continentsList, GISHazusEventsPluginGUI eventsGUI) {
        this.continentsList = continentsList;
        this.eventsGUI = eventsGUI;
        this.isSelectedRow = new boolean[continentsList.size()];
        this.inMem = new boolean[continentsList.size()];
        this.traceColor = new Color[continentsList.size()];
        for (int i = 0; i < this.isSelectedRow.length; ++i) {
            this.isSelectedRow[i] = false;
            this.inMem[i] = false;
            this.traceColor[i] = DEFAULT_COLOR;
        }
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    public Class getColumnClass(int col) {
        if (col == 0) {
            return Boolean.class;
        }
        if (col == 1) {
            return Color.class;
        }
        return String.class;
    }

    @Override
    public int getRowCount() {
        return this.continentsList.size();
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return this.isSelectedRow[row];
        }
        if (col == 1) {
            return this.traceColor[row];
        }
        if (col == 3) {
            return this.inMem[row];
        }
        return this.continentsList.get(row);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 2;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 1) {
            this.traceColor[row] = (Color)value;
            this.eventsGUI.setColor(row, this.traceColor[row], this.eventsGUI.groupsTabbedPane.getSelectedIndex());
            return;
        }
        if (col == 0) {
            boolean currVal = (Boolean)value;
            boolean prevVal = this.isSelectedRow[row];
            this.isSelectedRow[row] = currVal;
            if (prevVal && !currVal) {
                System.out.println("Set value at called");
                this.eventsGUI.predefinedSubGroup(row, currVal);
            }
            if (!prevVal && currVal) {
                this.eventsGUI.predefinedSubGroup(row, currVal);
            }
        }
        if (col == 3) {
            this.inMem[row] = (Boolean)value;
        }
        this.fireTableCellUpdated(row, col);
    }
}

