/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.GISHazusEventsPlugin;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.colorchooser.DefaultColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.scec.vtk.plugins.GISHazusEventsPlugin.BoundaryTableModel;
import org.scec.vtk.plugins.GISHazusEventsPlugin.GISHazusEventsPluginGUI;
import org.scec.vtk.plugins.utils.components.SingleColorChooser;
import org.scec.vtk.tools.Prefs;

public class BoundaryTable
extends JTable
implements ChangeListener,
MouseListener {
    protected BoundaryTableModel model;
    private static final long serialVersionUID = 1L;

    public BoundaryTable(GISHazusEventsPluginGUI pbg, BoundaryTableModel boundaryTableModel) {
        super(boundaryTableModel);
        this.model = boundaryTableModel;
        this.addMouseListener(this);
        this.setTableHeader(null);
        this.getColumnModel().getColumn(0).setPreferredWidth(35);
        this.getColumnModel().getColumn(0).setMaxWidth(35);
        this.getColumnModel().getColumn(0).setCellRenderer(new BoundaryCheckBoxRenderer());
        this.getColumnModel().getColumn(1).setPreferredWidth(35);
        this.getColumnModel().getColumn(1).setMaxWidth(35);
        this.getColumnModel().getColumn(2).setCellRenderer(new BoundaryStringRenderer());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int[] rows = this.getSelectedRows();
        if (rows.length > 0) {
            Color c = ((DefaultColorSelectionModel)e.getSource()).getSelectedColor();
            this.model.setColorForRows(c, rows);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Color newColor;
        Color tempColor;
        int col = this.getColumnModel().getColumnIndexAtX(e.getX());
        int row = e.getY() / this.getRowHeight();
        if (col == 1 && this.model.getColorForRow(row) != null && (tempColor = new SingleColorChooser(this).getColor()) != null && (newColor = tempColor) != null) {
            this.model.setColorForRows(newColor, this.getSelectedRows());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public class BoundaryCheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object object, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else if (row % 2 == 0) {
                this.setBackground(Prefs.getStripingColor());
            } else {
                this.setBackground(table.getBackground());
            }
            BoundaryTable hwtb = (BoundaryTable)table;
            boolean displayed = hwtb.model.isDisplayed(row);
            this.setSelected(displayed);
            return this;
        }
    }

    private class BoundaryStringRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        public BoundaryStringRenderer() {
            this.setHorizontalAlignment(2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object object, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(((String)BoundaryTable.this.model.getValueAt(row, column)).replace('_', ' '));
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else if (row % 2 == 0) {
                this.setBackground(Prefs.getStripingColor());
            } else {
                this.setBackground(table.getBackground());
            }
            return this;
        }
    }
}

