/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.GISHazusEventsPlugin;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.DBFReaderJGeom;
import oracle.spatial.util.ShapefileReaderJGeom;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.GISHazusEventsPlugin.EventAttributes;
import org.scec.vtk.plugins.GISHazusEventsPlugin.FilledBoundary;
import org.scec.vtk.plugins.GISHazusEventsPlugin.FilledBoundaryCluster;
import org.scec.vtk.tools.actors.AppendActors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import vtk.vtkActor;

public class Events {
    FilledBoundaryCluster currentBoundary;
    static final int NUM_POP_CATEGORY = 12;
    boolean bIsImport = false;
    boolean bIsImport1 = false;
    boolean bIsImport2 = false;
    boolean bIsImport3 = false;
    JFileChooser OpenShapeFile = new JFileChooser();
    ArrayList<Float> populationCategory;
    File ralph;
    EventAttributes event;
    ArrayList<Float> legendMaxList;
    ArrayList<EventAttributes> eventList;
    int numLines = 0;
    int numFiles = 0;
    String sImportedFilePath;
    String sImportedFilePath1;
    String sImportedFilePath2;
    String sImportedFilePath3;
    String sImportedFilePath4;
    public static float maxPop = 0.0f;
    int groupCount = 0;
    int numBounds = 0;
    public String[] names;
    public int[] groupSize;
    private ArrayList<vtkActor> allSegmentActors = new ArrayList();
    Color[] purpleGradient = new Color[12];
    ArrayList<FilledBoundaryCluster> allBounds = new ArrayList();
    AppendActors segmentActors;
    NodeList nodeList;

    public Events() {
        this.populationCategory = new ArrayList();
        this.purpleGradient[0] = new Color(0.219f, 0.659f, 0.0f);
        this.purpleGradient[0] = new Color(0.455f, 0.78f, 0.0f);
        this.purpleGradient[1] = new Color(0.588f, 0.839f, 0.0f);
        this.purpleGradient[2] = new Color(0.749f, 0.902f, 0.0f);
        this.purpleGradient[3] = new Color(0.914f, 0.961f, 0.0f);
        this.purpleGradient[4] = new Color(1.0f, 0.918f, 0.0f);
        this.purpleGradient[5] = new Color(1.0f, 0.733f, 0.0f);
        this.purpleGradient[6] = new Color(1.0f, 0.549f, 0.0f);
        this.purpleGradient[7] = new Color(1.0f, 0.369f, 0.0f);
        this.purpleGradient[8] = new Color(1.0f, 0.184f, 0.0f);
        this.purpleGradient[9] = new Color(1.0f, 0.0f, 0.0f);
        this.legendMaxList = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            this.legendMaxList.add(Float.valueOf(-1.0f));
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Info.getMainGUI();
            Document document = builder.parse(new File(String.valueOf(MainGUI.getRootPluginDir()) + File.separator + "GISHazusEventsPlugin" + File.separator + "QuakeEvents.xml"));
            this.eventList = new ArrayList();
            this.nodeList = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < this.nodeList.getLength(); ++i) {
                Node node = this.nodeList.item(i);
                if (!(node instanceof Element)) continue;
                this.event = new EventAttributes();
                this.event.setID(node.getAttributes().getNamedItem("id").getNodeValue());
                NodeList childNodes = node.getChildNodes();
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    Node childNode = childNodes.item(j);
                    if (!(childNode instanceof Element)) continue;
                    String content = childNode.getLastChild().getTextContent().trim();
                    if (childNode.getNodeName() == "event_name") {
                        this.event.setEventName(content);
                        continue;
                    }
                    if (childNode.getNodeName() == "shape_file") {
                        this.event.setSHPFile(content);
                        continue;
                    }
                    if (childNode.getNodeName() == "data_file") {
                        this.event.setDBFFile(content);
                        continue;
                    }
                    if (childNode.getNodeName() == "column") {
                        this.event.setColumn(content);
                        continue;
                    }
                    if (childNode.getNodeName() == "like_earthquake") {
                        this.event.setLikeEarthquake(content);
                        continue;
                    }
                    if (childNode.getNodeName() != "time_or_type") continue;
                    this.event.setLegendTitle(content);
                }
                this.eventList.add(this.event);
                ++this.numLines;
                ++this.numFiles;
            }
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ArrayList<FilledBoundary> getAllBoundaries() {
        ArrayList<FilledBoundary> allBoundaries = new ArrayList<FilledBoundary>();
        for (FilledBoundaryCluster c : this.allBounds) {
            ArrayList<FilledBoundary> temp = c.getBoundaries();
            for (FilledBoundary b : temp) {
                allBoundaries.add(b);
            }
        }
        return allBoundaries;
    }

    public String getName(int row) {
        String name = "";
        name = this.eventList.get(row).getEventName();
        return name;
    }

    public ArrayList<String> buildBoundaryNames() {
        File filename;
        if (this.bIsImport) {
            filename = new File(this.sImportedFilePath);
        } else if (this.bIsImport1) {
            filename = new File(this.sImportedFilePath);
        } else if (this.bIsImport2) {
            filename = new File(this.sImportedFilePath);
        } else if (this.bIsImport3) {
            filename = new File(this.sImportedFilePath);
        } else {
            Info.getMainGUI();
            filename = new File(String.valueOf(MainGUI.getRootPluginDir()) + File.separator + "GISHazusEventsPlugin" + File.separator + "sourcefiles" + File.separator);
        }
        ArrayList<Object> files = new ArrayList<Object>();
        int i = 0;
        if (filename.exists() && filename.isDirectory()) {
            File[] filelist = filename.listFiles();
            for (i = 0; i < filelist.length; ++i) {
                if (!filelist[i].isFile()) continue;
                Object line = filelist[i].getName();
                if (((String)line).contains("/")) {
                    line = ((String)line).substring(((String)line).lastIndexOf(47));
                }
                if (((String)line).substring(0, 3).equals("CVS")) continue;
                line = "sourcefiles/" + (String)line;
                files.add(line);
            }
        }
        this.names = new String[files.size()];
        this.groupSize = new int[files.size()];
        for (i = 0; i < files.size(); ++i) {
            this.getBoundaryName((String)files.get(i));
            this.groupSize[this.groupCount] = this.numBounds;
            ++this.groupCount;
            this.numBounds = 0;
            this.currentBoundary = new FilledBoundaryCluster(this.segmentActors);
        }
        ArrayList<String> quakeList = new ArrayList<String>();
        for (i = 0; i < this.eventList.size(); ++i) {
            quakeList.add(this.eventList.get(i).getEventName());
        }
        return quakeList;
    }

    private void getBoundaryName(String file) {
        File filename;
        if (this.bIsImport) {
            filename = new File(this.sImportedFilePath);
        } else if (this.bIsImport1) {
            filename = new File(this.sImportedFilePath);
        } else if (this.bIsImport2) {
            filename = new File(this.sImportedFilePath);
        } else if (this.bIsImport3) {
            filename = new File(this.sImportedFilePath);
        } else {
            Info.getMainGUI();
            filename = new File(String.valueOf(MainGUI.getRootPluginDir()) + File.separator + "GISHazusEventsPlugin" + File.separator + file);
        }
        String[] temp = new String[2];
        try {
            String line;
            BufferedReader inStream = new BufferedReader(new FileReader(filename));
            this.names[this.groupCount] = line = inStream.readLine();
            line = inStream.readLine();
            StringTokenizer dataLine = new StringTokenizer(line);
            temp[0] = dataLine.nextToken();
            temp[1] = dataLine.nextToken();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public ArrayList<FilledBoundaryCluster> buildAllBoundaries() {
        File fileURL;
        if (this.bIsImport) {
            fileURL = new File(this.sImportedFilePath);
        } else if (this.bIsImport1) {
            fileURL = new File(this.sImportedFilePath);
        } else if (this.bIsImport2) {
            fileURL = new File(this.sImportedFilePath);
        } else if (this.bIsImport3) {
            fileURL = new File(this.sImportedFilePath);
        } else {
            Info.getMainGUI();
            fileURL = new File(String.valueOf(MainGUI.getRootPluginDir()) + File.separator + "GISHazusEventsPlugin" + File.separator + "sourcefiles");
        }
        ArrayList<Object> files = new ArrayList<Object>();
        int i = 0;
        try {
            BufferedReader inStream = new BufferedReader(new FileReader(fileURL));
            Object line = inStream.readLine();
            while (line != null) {
                line = "sourcefiles/" + (String)line;
                files.add(line);
                ++i;
                line = inStream.readLine();
            }
            this.currentBoundary = new FilledBoundaryCluster(this.segmentActors);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.names = new String[files.size()];
        this.groupSize = new int[files.size()];
        for (i = 0; i < files.size(); ++i) {
            this.buildBoundaries((String)files.get(i));
            this.groupSize[this.groupCount] = this.numBounds;
            ++this.groupCount;
            this.numBounds = 0;
            this.currentBoundary = new FilledBoundaryCluster(this.segmentActors);
        }
        return this.allBounds;
    }

    public ArrayList<FilledBoundaryCluster> buildSelectedBoundary(int row) {
        this.ralph = null;
        this.bIsImport = false;
        this.bIsImport1 = false;
        this.bIsImport2 = false;
        this.bIsImport3 = false;
        for (int i = 0; i < this.numLines; ++i) {
            if (i != row) continue;
            if (i == 0) {
                if (!this.importFiles()) continue;
                this.buildBoundaries(this.eventList.get(this.eventList.size() - 1).getSHPFile());
                continue;
            }
            this.buildBoundaries(this.eventList.get(i).getSHPFile());
        }
        this.currentBoundary = new FilledBoundaryCluster(this.segmentActors);
        return this.allBounds;
    }

    private boolean importFiles() {
        int returnValue;
        boolean worked = false;
        this.event = new EventAttributes();
        this.event.setID("" + (this.nodeList.getLength() + 1));
        String s = JOptionPane.showInputDialog(Info.getMainGUI(), "Enter name of event:", 3);
        this.event.setEventName(s);
        int n = JOptionPane.showConfirmDialog(Info.getMainGUI(), "Please enter location of the .shp file you wish to import:", "Import SHF File", 0);
        if (n == 0 && (returnValue = this.OpenShapeFile.showOpenDialog(null)) == 0) {
            String path = this.OpenShapeFile.getSelectedFile().getPath();
            this.event.setSHPFile(path);
            this.sImportedFilePath = path;
            int x = JOptionPane.showConfirmDialog(Info.getMainGUI(), "Please enter location of the .dbf file you wish to import:", "Import DBF File", 0);
            if (x == 0) {
                returnValue = this.OpenShapeFile.showOpenDialog(null);
                String dbfFilename = null;
                if (returnValue == 0) {
                    dbfFilename = this.OpenShapeFile.getSelectedFile().getPath();
                    this.event.setDBFFile(dbfFilename);
                }
                Object columns = "";
                try {
                    DBFReaderJGeom dbfFile = new DBFReaderJGeom(dbfFilename);
                    int fieldsCount = dbfFile.numFields();
                    String fieldName = "poop";
                    for (int i = 0; i < fieldsCount; ++i) {
                        fieldName = dbfFile.getFieldName(i);
                        System.out.println("Column Name: " + fieldName);
                        columns = (String)columns + fieldName + " , ";
                        if (i % 3 != 0) continue;
                        columns = (String)columns + "\n";
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                String z = JOptionPane.showInputDialog(Info.getMainGUI(), "Enter name of column:\nPossible Columns\n" + (String)columns, 3);
                this.event.setColumn(z);
                this.event.setLikeEarthquake("Northridge");
                String timeOrType = JOptionPane.showInputDialog(Info.getMainGUI(), "Enter legend time or type i.e, 3pm or Buildings Damaged:", 3);
                this.event.setLegendTitle(timeOrType);
                this.eventList.add(this.event);
                ++this.numLines;
                ++this.numFiles;
                this.bIsImport2 = true;
                worked = true;
            }
        }
        return worked;
    }

    void buildBoundaries(String file) {
        this.allBounds = null;
        this.allBounds = new ArrayList();
        try {
            int shapeCount;
            ShapefileReaderJGeom shpFile;
            String dbfFilename;
            int fileEnum = 0;
            String file2 = file.replace("shp", "dbf");
            if (this.bIsImport) {
                dbfFilename = new String(file2);
            } else if (this.bIsImport1) {
                dbfFilename = new String(file2);
            } else if (this.bIsImport2) {
                dbfFilename = new String(file2);
            } else if (this.bIsImport3) {
                dbfFilename = new String(file2);
            } else {
                Info.getMainGUI();
                dbfFilename = new String(String.valueOf(MainGUI.getRootPluginDir()) + File.separator + "GISHazusEventsPlugin" + File.separator + file2);
            }
            DBFReaderJGeom dbfFile = new DBFReaderJGeom(dbfFilename);
            int columnIndex = 0;
            for (fileEnum = 0; fileEnum < this.numFiles; ++fileEnum) {
                if (!file2.equals(this.eventList.get(fileEnum).getDBFFile())) continue;
                columnIndex = fileEnum;
                break;
            }
            ++fileEnum;
            int nameColumn = 0;
            int popColumn = 1;
            int fieldsCount = dbfFile.numFields();
            String fieldName = "poop";
            for (int i = 0; i < fieldsCount; ++i) {
                fieldName = dbfFile.getFieldName(i);
                if (fieldName.equalsIgnoreCase("tract")) {
                    nameColumn = i;
                }
                if (!this.eventList.get(columnIndex).getColumn().equalsIgnoreCase(fieldName)) continue;
                popColumn = i;
            }
            int[] populationAscendingIndices = new int[dbfFile.numRecords()];
            for (int a = 0; a < populationAscendingIndices.length; ++a) {
                populationAscendingIndices[a] = a;
            }
            DecimalFormat twoDec = new DecimalFormat("#.##");
            float[] populationRecord = new float[dbfFile.numRecords()];
            for (int b = 0; b < populationRecord.length; ++b) {
                byte[] record = dbfFile.getRecord(b);
                String temp = dbfFile.getFieldData(popColumn, record).replace("$", "");
                String floatToParse = temp.replace(",", "");
                float populationDensity = Float.parseFloat(floatToParse);
                populationRecord[b] = populationDensity = Float.valueOf(twoDec.format(populationDensity)).floatValue();
            }
            this.sortDescending(populationAscendingIndices, populationRecord);
            for (int i = 0; i < populationRecord.length; ++i) {
                if (this.populationCategory.contains(Float.valueOf(populationRecord[i]))) continue;
                this.populationCategory.add(Float.valueOf(populationRecord[i]));
            }
            if (this.bIsImport) {
                shpFile = new ShapefileReaderJGeom(this.sImportedFilePath);
            } else if (this.bIsImport1) {
                shpFile = new ShapefileReaderJGeom(this.sImportedFilePath);
            } else if (this.bIsImport2) {
                shpFile = new ShapefileReaderJGeom(this.sImportedFilePath);
            } else if (this.bIsImport3) {
                shpFile = new ShapefileReaderJGeom(this.sImportedFilePath);
            } else {
                Info.getMainGUI();
                shpFile = new ShapefileReaderJGeom(String.valueOf(MainGUI.getRootPluginDir()) + File.separator + "GISHazusEventsPlugin" + File.separator + file);
            }
            ArrayList<Double> latitude = new ArrayList<Double>();
            ArrayList<Double> longitude = new ArrayList<Double>();
            this.numBounds = shapeCount = shpFile.numRecords();
            for (int i = 0; i < shapeCount; ++i) {
                int index = populationAscendingIndices[i];
                byte[] geometryBytes = shpFile.getGeometryBytes(index);
                JGeometry shape = ShapefileReaderJGeom.getGeometry((byte[])geometryBytes, (int)index);
                double[] coordinates = shape.getOrdinatesArray();
                int verticeCount = shape.getNumPoints();
                double[] initialCoord = new double[]{coordinates[0], coordinates[1]};
                int initialCoordIndex = 0;
                for (int coordIndex = 0; coordIndex < coordinates.length; coordIndex += 2) {
                    longitude.add(coordinates[coordIndex]);
                    latitude.add(coordinates[coordIndex + 1]);
                    if (initialCoord[0] != coordinates[coordIndex] || initialCoord[1] != coordinates[coordIndex + 1] || coordIndex == initialCoordIndex) continue;
                    this.addBoundarySegment(verticeCount, latitude, longitude);
                    longitude.clear();
                    latitude.clear();
                    if (coordIndex == coordinates.length - 2) continue;
                    initialCoord[0] = coordinates[coordIndex + 2];
                    initialCoord[1] = coordinates[coordIndex + 3];
                    initialCoordIndex = coordIndex + 2;
                }
                this.addBoundarySegment(verticeCount, latitude, longitude);
                longitude.clear();
                latitude.clear();
                byte[] record = dbfFile.getRecord(index);
                this.currentBoundary.setName(dbfFile.getFieldData(nameColumn, record) + " ----- " + populationRecord[i]);
                float denominatorConstant = 0.0f;
                denominatorConstant = 2000.0f;
                for (int j = 0; j < this.populationCategory.size(); ++j) {
                    if (!(populationRecord[i] >= this.populationCategory.get(j).floatValue())) continue;
                    this.currentBoundary.setCategory(i);
                    if (this.eventList.get(columnIndex).getLegendTitle().equals("Direct Building Economic Loss") || this.eventList.get(columnIndex).getLegendTitle().equals("Building Count")) {
                        if (this.legendMaxList.get(0).floatValue() == -1.0f || (double)this.legendMaxList.get(0).floatValue() > 0.0 && populationRecord[i] < this.legendMaxList.get(0).floatValue() && (double)populationRecord[i] > 0.0) {
                            this.legendMaxList.set(0, Float.valueOf(populationRecord[i]));
                        }
                        if ((double)(populationRecord[i] / denominatorConstant) == 0.0) {
                            this.currentBoundary.setColor(this.purpleGradient[0]);
                            if (!(this.legendMaxList.get(0).floatValue() < populationRecord[i])) break;
                            this.legendMaxList.set(0, Float.valueOf(populationRecord[i]));
                            break;
                        }
                        if ((double)populationRecord[i] >= 360.0 && (double)populationRecord[i] < 286780.0) {
                            this.currentBoundary.setColor(this.purpleGradient[1]);
                            if (!(this.legendMaxList.get(1).floatValue() < populationRecord[i])) break;
                            this.legendMaxList.set(1, Float.valueOf(populationRecord[i]));
                            break;
                        }
                        if ((double)populationRecord[i] >= 286780.0 && (double)populationRecord[i] < 1015290.0) {
                            this.currentBoundary.setColor(this.purpleGradient[2]);
                            if (!(this.legendMaxList.get(2).floatValue() < populationRecord[i])) break;
                            this.legendMaxList.set(2, Float.valueOf(populationRecord[i]));
                            break;
                        }
                        if ((double)populationRecord[i] >= 1015290.0 && (double)populationRecord[i] < 2659870.0) {
                            this.currentBoundary.setColor(this.purpleGradient[3]);
                            if (!(this.legendMaxList.get(3).floatValue() < populationRecord[i])) break;
                            this.legendMaxList.set(3, Float.valueOf(populationRecord[i]));
                            break;
                        }
                        if ((double)populationRecord[i] >= 2659870.0 && (double)populationRecord[i] < 6415170.0) {
                            this.currentBoundary.setColor(this.purpleGradient[4]);
                            if (!(this.legendMaxList.get(4).floatValue() < populationRecord[i])) break;
                            this.legendMaxList.set(4, Float.valueOf(populationRecord[i]));
                            break;
                        }
                        if ((double)populationRecord[i] >= 6415170.0 && (double)populationRecord[i] < 1.301444E7) {
                            this.currentBoundary.setColor(this.purpleGradient[5]);
                            if (!(this.legendMaxList.get(5).floatValue() < populationRecord[i])) break;
                            this.legendMaxList.set(5, Float.valueOf(populationRecord[i]));
                            break;
                        }
                        if ((double)populationRecord[i] >= 1.301444E7 && (double)populationRecord[i] < 2.42178E7) {
                            this.currentBoundary.setColor(this.purpleGradient[6]);
                            if (!(this.legendMaxList.get(6).floatValue() < populationRecord[i])) break;
                            this.legendMaxList.set(6, Float.valueOf(populationRecord[i]));
                            break;
                        }
                        if ((double)populationRecord[i] >= 2.42178E7 && (double)populationRecord[i] < 4.584698E7) {
                            this.currentBoundary.setColor(this.purpleGradient[7]);
                            if (!(this.legendMaxList.get(7).floatValue() < populationRecord[i])) break;
                            this.legendMaxList.set(7, Float.valueOf(populationRecord[i]));
                            break;
                        }
                        if ((double)populationRecord[i] >= 4.584698E7 && (double)populationRecord[i] < 1.0481244E8) {
                            this.currentBoundary.setColor(this.purpleGradient[8]);
                            if (!(this.legendMaxList.get(8).floatValue() < populationRecord[i])) break;
                            this.legendMaxList.set(8, Float.valueOf(populationRecord[i]));
                            break;
                        }
                        if (!((double)populationRecord[i] >= 1.0481244E8) || !((double)populationRecord[i] <= 3.1E9)) continue;
                        this.currentBoundary.setColor(this.purpleGradient[9]);
                        if (!(this.legendMaxList.get(9).floatValue() < populationRecord[i])) break;
                        this.legendMaxList.set(9, Float.valueOf(populationRecord[i]));
                        break;
                    }
                    if ((double)populationRecord[i] < 1.0) {
                        this.currentBoundary.setColor(this.purpleGradient[0]);
                        if (!(this.legendMaxList.get(0).floatValue() < populationRecord[i])) break;
                        this.legendMaxList.set(0, Float.valueOf(populationRecord[i]));
                        break;
                    }
                    if ((double)populationRecord[i] >= 1.0 && (double)populationRecord[i] < 1.652) {
                        this.currentBoundary.setColor(this.purpleGradient[1]);
                        if (!(this.legendMaxList.get(1).floatValue() < populationRecord[i])) break;
                        this.legendMaxList.set(1, Float.valueOf(populationRecord[i]));
                        break;
                    }
                    if ((double)populationRecord[i] >= 1.652 && (double)populationRecord[i] < 2.676) {
                        this.currentBoundary.setColor(this.purpleGradient[2]);
                        if (!(this.legendMaxList.get(2).floatValue() < populationRecord[i])) break;
                        this.legendMaxList.set(2, Float.valueOf(populationRecord[i]));
                        break;
                    }
                    if ((double)populationRecord[i] >= 2.676 && (double)populationRecord[i] < 4.305) {
                        this.currentBoundary.setColor(this.purpleGradient[3]);
                        if (!(this.legendMaxList.get(3).floatValue() < populationRecord[i])) break;
                        this.legendMaxList.set(3, Float.valueOf(populationRecord[i]));
                        break;
                    }
                    if ((double)populationRecord[i] >= 4.305 && (double)populationRecord[i] < 6.886) {
                        this.currentBoundary.setColor(this.purpleGradient[4]);
                        if (!(this.legendMaxList.get(4).floatValue() < populationRecord[i])) break;
                        this.legendMaxList.set(4, Float.valueOf(populationRecord[i]));
                        break;
                    }
                    if ((double)populationRecord[i] >= 6.886 && (double)populationRecord[i] < 11.258) {
                        this.currentBoundary.setColor(this.purpleGradient[5]);
                        if (!(this.legendMaxList.get(5).floatValue() < populationRecord[i])) break;
                        this.legendMaxList.set(5, Float.valueOf(populationRecord[i]));
                        break;
                    }
                    if ((double)populationRecord[i] >= 11.258 && (double)populationRecord[i] < 19.363) {
                        this.currentBoundary.setColor(this.purpleGradient[6]);
                        if (!(this.legendMaxList.get(6).floatValue() < populationRecord[i])) break;
                        this.legendMaxList.set(6, Float.valueOf(populationRecord[i]));
                        break;
                    }
                    if ((double)populationRecord[i] >= 19.363 && (double)populationRecord[i] < 36.134) {
                        this.currentBoundary.setColor(this.purpleGradient[7]);
                        if (!(this.legendMaxList.get(7).floatValue() < populationRecord[i])) break;
                        this.legendMaxList.set(7, Float.valueOf(populationRecord[i]));
                        break;
                    }
                    if ((double)populationRecord[i] >= 36.134 && (double)populationRecord[i] < 82.693) {
                        this.currentBoundary.setColor(this.purpleGradient[8]);
                        if (!(this.legendMaxList.get(8).floatValue() < populationRecord[i])) break;
                        this.legendMaxList.set(8, Float.valueOf(populationRecord[i]));
                        break;
                    }
                    if (!((double)populationRecord[i] >= 82.693) || !((double)populationRecord[i] <= 5000.0)) continue;
                    this.currentBoundary.setColor(this.purpleGradient[9]);
                    if (!(this.legendMaxList.get(9).floatValue() < populationRecord[i])) break;
                    this.legendMaxList.set(9, Float.valueOf(populationRecord[i]));
                    break;
                }
                if (!this.allBounds.contains(this.currentBoundary)) {
                    this.allBounds.add(this.currentBoundary);
                }
                this.currentBoundary = new FilledBoundaryCluster(this.segmentActors);
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read shapefile.");
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Color[] setColorGradient(Color c1, Color c2) {
        Color[] gradient2 = new Color[12];
        for (int i = 0; i < 12; ++i) {
            Color c;
            Color cf;
            float ratio = (float)i / 12.0f;
            int red = (int)((float)c2.getRed() * ratio + (float)c1.getRed() * (1.0f - ratio));
            int green = (int)((float)c2.getGreen() * ratio + (float)c1.getGreen() * (1.0f - ratio));
            int blue = (int)((float)c2.getBlue() * ratio + (float)c1.getBlue() * (1.0f - ratio));
            gradient2[i] = cf = (c = new Color(red, green, blue));
            this.purpleGradient[i] = cf;
        }
        return gradient2;
    }

    public void sortDescending(int[] indices, float[] array) {
        for (int i = 0; i < array.length; ++i) {
            for (int j = i; j < array.length; ++j) {
                if (!(array[i] < array[j])) continue;
                float temp = array[i];
                array[i] = array[j];
                array[j] = temp;
                int temp2 = indices[i];
                indices[i] = indices[j];
                indices[j] = temp2;
            }
        }
    }

    public static void sortAscending(float[] array) {
        for (int i = 0; i < array.length; ++i) {
            for (int j = i; j < array.length; ++j) {
                if (!(array[i] > array[j])) continue;
                float temp = array[i];
                array[i] = array[j];
                array[j] = temp;
            }
        }
    }

    private void addBoundarySegment(int vertices, ArrayList<Double> x, ArrayList<Double> y) {
        if (x.size() > 0 && y.size() > 0) {
            float[] Latitude = new float[x.size()];
            float[] Longitude = new float[y.size()];
            for (int i = 0; i < x.size(); ++i) {
                Latitude[i] = x.get(i).floatValue();
                Longitude[i] = y.get(i).floatValue();
            }
            this.allSegmentActors.add(this.currentBoundary.addSegment(Latitude, Longitude));
        }
    }

    public ArrayList<vtkActor> getSegmentActors() {
        return this.allSegmentActors;
    }

    public ArrayList<Float> getLegendMax() {
        return this.legendMaxList;
    }

    public void resetLegendMax() {
        for (int i = 0; i < 10; ++i) {
            this.legendMaxList.set(i, Float.valueOf(-1.0f));
        }
    }

    public String getColumnAt(int index) {
        return this.eventList.get(index).getColumn();
    }

    public Color[] getPurpleGradient() {
        return this.purpleGradient;
    }

    public String getEventName(int index) {
        return this.eventList.get(index).getEventName();
    }

    public String getLikeEarthquake(int index) {
        return this.eventList.get(index).getLikeEarthquake();
    }

    public String getLegendTitle(int index) {
        return this.eventList.get(index).getLegendTitle();
    }

    public ArrayList<String> makeLikeList(String likeEarthquakeName) {
        ArrayList<String> likeList = new ArrayList<String>();
        int i = 0;
        for (EventAttributes event : this.eventList) {
            if (i == 0) {
                likeList.add(null);
            } else if (likeEarthquakeName.equalsIgnoreCase(event.getLikeEarthquake())) {
                likeList.add(event.getEventName());
            }
            ++i;
        }
        return likeList;
    }

    public int getIndexByEventName(String eventName) {
        int index = 0;
        for (EventAttributes event : this.eventList) {
            if (event.getEventName().equalsIgnoreCase(eventName)) {
                return index;
            }
            ++index;
        }
        return 0;
    }

    public void setAppendActors(AppendActors pluginActors) {
        this.segmentActors = pluginActors;
    }

    public AppendActors getAppendActor() {
        return this.currentBoundary.getAppendActor();
    }
}

