/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.GISHazusEventsPlugin;

import java.awt.Color;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.scec.vtk.tools.Transform;
import vtk.vtkActor;
import vtk.vtkCell;
import vtk.vtkCellArray;
import vtk.vtkMapper;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkPolygon;

public class FilledBoundary {
    private float[] latitude = new float[2];
    private float[] longitude = new float[2];
    private Color color = new Color(1.0f, 1.0f, 1.0f);
    protected String name = "";
    private boolean bDisplayed = false;
    public static int counter = 0;
    public static float lineWidth = 1.0f;
    vtkActor segmentActors;

    public FilledBoundary() {
    }

    public FilledBoundary(String name, Color color, float[] latitude, float[] longitude) {
        this();
        this.setName(name);
        this.setColor(color);
        this.setCoordinates(latitude, longitude);
    }

    public FilledBoundary(String name, Color color, float[] latitude, float[] longitude, float width) {
        this();
        this.setName(name);
        this.setColor(color);
        this.setCoordinates(latitude, longitude);
        this.setWidth(lineWidth);
    }

    public vtkActor getActor() {
        return this.segmentActors;
    }

    public void addSegment(LocationList locList) {
        this.addSegment(locList, false);
    }

    public void addSegment(LocationList locList, boolean close) {
        int size = locList.size();
        boolean addFirst = false;
        if (!((Location)locList.get(0)).equals(locList.get(locList.size() - 1)) && close) {
            addFirst = true;
            ++size;
        }
        float[] latitude = new float[size];
        float[] longitude = new float[size];
        for (int i = 0; i < locList.size(); ++i) {
            latitude[i] = (float)((Location)locList.get(i)).getLatitude();
            longitude[i] = (float)((Location)locList.get(i)).getLongitude();
        }
        if (addFirst) {
            latitude[size - 1] = (float)((Location)locList.get(0)).getLatitude();
            longitude[size - 1] = (float)((Location)locList.get(0)).getLongitude();
        }
        this.addSegment(latitude, longitude);
    }

    public void addSegment(float[] latitude, float[] longitude) {
        this.setCoordinates(latitude, longitude);
        this.addSegment();
    }

    public void addSegment() {
        int vertices = this.latitude.length;
        if (vertices != 1 && vertices != 2) {
            vtkPoints pts = new vtkPoints();
            vtkPolygon polygon = new vtkPolygon();
            polygon.GetPointIds().SetNumberOfIds((long)vertices);
            for (int i = 0; i < vertices; ++i) {
                pts.InsertNextPoint(Transform.transformLatLonHeight(this.latitude[i], this.longitude[i], 0.0));
                polygon.GetPointIds().SetId((long)i, (long)i);
            }
            vtkCellArray lines = new vtkCellArray();
            lines.InsertNextCell((vtkCell)polygon);
            vtkPolyData polydata = new vtkPolyData();
            polydata.SetPolys(lines);
            polydata.SetPoints(pts);
            vtkPolyDataMapper mapper = new vtkPolyDataMapper();
            mapper.SetInputData(polydata);
            vtkActor segmentActor = new vtkActor();
            segmentActor.SetMapper((vtkMapper)mapper);
            segmentActor.GetProperty().SetEdgeColor(1.0, 1.0, 1.0);
            segmentActor.GetProperty().SetEdgeVisibility(1);
            this.segmentActors = segmentActor;
        }
    }

    public void updateWidth(float newWidth) {
        lineWidth = newWidth;
    }

    private void draw() {
        this.bDisplayed = true;
    }

    private void hide() {
        this.bDisplayed = false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setColor(Color inColor) {
        this.color = inColor;
        if (this.segmentActors != null) {
            this.segmentActors.GetProperty().SetColor((double)this.color.getRed() / 255.0, (double)this.color.getGreen() / 255.0, (double)this.color.getBlue() / 255.0);
            this.segmentActors.Modified();
        }
    }

    public void setWidth(float width) {
        lineWidth = width;
    }

    public Color getColor() {
        return this.color;
    }

    public void setCoordinates(float[] latitude, float[] longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public float[] getLatitude() {
        return this.latitude;
    }

    public float[] getLongitude() {
        return this.longitude;
    }

    public boolean isDisplayed() {
        return this.bDisplayed;
    }

    public String getInfo() {
        String lines = "The " + this.name + " Plate:";
        return lines;
    }

    public void setDisplayed(boolean active) {
        this.bDisplayed = active;
        if (this.segmentActors != null) {
            if (active) {
                this.segmentActors.SetVisibility(1);
            } else {
                this.segmentActors.SetVisibility(0);
            }
        }
    }

    public void setTransparency(float transparency) {
        if (this.segmentActors != null) {
            this.segmentActors.GetProperty().SetOpacity((double)transparency);
        }
    }

    public void setLineApperance(Color color2, float value) {
    }
}

