/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.GISHazusEventsPlugin;

import java.awt.Color;
import java.util.ArrayList;
import org.scec.vtk.plugins.GISHazusEventsPlugin.Boundary;
import org.scec.vtk.plugins.GISHazusEventsPlugin.FilledBoundary;
import org.scec.vtk.tools.actors.AppendActors;
import vtk.vtkActor;
import vtk.vtkProp;

public class FilledBoundaryCluster {
    private String name;
    private int category = 0;
    private ArrayList<FilledBoundary> boundaries;
    private ArrayList<Boundary> boundaries2;
    private Color color = new Color(1.0f, 1.0f, 1.0f);
    private boolean bDisplayed = false;
    private AppendActors segmentActors;

    public FilledBoundaryCluster(AppendActors append) {
        this.init(append);
    }

    public FilledBoundaryCluster() {
        this.init(null);
    }

    public void init(AppendActors append) {
        this.boundaries = new ArrayList();
        this.boundaries2 = new ArrayList();
        this.name = "";
        this.segmentActors = append;
    }

    public vtkActor addSegment(float[] latitude, float[] longitude) {
        FilledBoundary currentBoundary = new FilledBoundary();
        currentBoundary.setCoordinates(latitude, longitude);
        currentBoundary.addSegment();
        this.boundaries.add(currentBoundary);
        if (currentBoundary.getActor() != null) {
            this.segmentActors.addToAppendedPolyData((vtkProp)currentBoundary.getActor());
            return currentBoundary.getActor();
        }
        return null;
    }

    public ArrayList<FilledBoundary> getBoundaries() {
        return this.boundaries;
    }

    public ArrayList<Boundary> getBoundaries2() {
        return this.boundaries2;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color inColor) {
        this.color = inColor;
        for (FilledBoundary b : this.boundaries) {
            b.setColor(inColor);
        }
    }

    public boolean isDisplayed() {
        return this.bDisplayed;
    }

    public void setDisplayed(boolean active) {
        this.bDisplayed = active;
        for (FilledBoundary b : this.boundaries) {
            b.setDisplayed(active);
        }
    }

    public void setName(String inName) {
        this.name = inName;
    }

    public String getName() {
        return this.name;
    }

    public int getCategory() {
        return this.category;
    }

    public void setCategory(int c) {
        this.category = c;
    }

    public AppendActors getAppendActor() {
        return this.segmentActors;
    }

    public void setBoundaries(ArrayList<FilledBoundary> arrayList) {
        this.boundaries = arrayList;
    }

    public void setBoundaries2(ArrayList<Boundary> arrayList) {
        this.boundaries2 = arrayList;
    }

    public void setAppendActor(AppendActors appendActors) {
        this.segmentActors = appendActors;
    }
}

