/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.GISHazusEventsPlugin;

import com.google.common.collect.Lists;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.GISHazusEventsPlugin.BoundSectionsTable;
import org.scec.vtk.plugins.GISHazusEventsPlugin.BoundSectionsTableModel;
import org.scec.vtk.plugins.GISHazusEventsPlugin.BoundaryTable;
import org.scec.vtk.plugins.GISHazusEventsPlugin.BoundaryTableModel;
import org.scec.vtk.plugins.GISHazusEventsPlugin.Events;
import org.scec.vtk.plugins.GISHazusEventsPlugin.FilledBoundary;
import org.scec.vtk.plugins.GISHazusEventsPlugin.FilledBoundaryCluster;
import org.scec.vtk.plugins.GISHazusEventsPlugin.SetUpNewHazusTab;
import org.scec.vtk.plugins.PluginActors;
import org.scec.vtk.plugins.utils.components.CheckAllTable;
import org.scec.vtk.plugins.utils.components.ColorWellButton;
import org.scec.vtk.plugins.utils.components.GradientColorChooser;
import org.scec.vtk.plugins.utils.components.TreeNode;
import org.scec.vtk.tools.Prefs;
import org.scec.vtk.tools.actors.AppendActors;
import vtk.vtkProp;

class GISHazusEventsPluginGUI
extends JPanel
implements TableModelListener,
ActionListener,
ChangeListener {
    static final int REGION_AMT = 200;
    static final int REGION_TAB = 3;
    private FilledBoundaryCluster currentBoundary;
    ArrayList<FilledBoundaryCluster> polArray;
    private int numOfBoundaries;
    private static final long serialVersionUID = 1L;
    private ArrayList<String> subgroupNames;
    protected ArrayList<JCheckBox> checkBoxes;
    Events bTrace;
    protected BoundSectionsTableModel tableModel;
    protected BoundSectionsTableModel tableModel2;
    private BoundSectionsTable table;
    protected int[][] boundaryGroupOrder = new int[3][200];
    protected int[][] boundaryRowSize = new int[3][200];
    protected int[][] boundaryStartIndex = new int[3][200];
    private int boundaryRowOrderCounter = 0;
    private JTabbedPane boundTabbedPane = new JTabbedPane();
    ColorWellButton colorButton;
    private GradientColorChooser gradientColor;
    private JButton legendButton;
    private JPanel legendDialog;
    private JDialog dialogLegend;
    private JButton apply;
    private JFileChooser saveFile;
    private BufferedImage myImage;
    private Graphics2D g2;
    private File file;
    private JPanel buttonPanel;
    private JButton save;
    private JButton info;
    private JSlider transparencySlider;
    private BoundSectionsTableModel btm;
    ArrayList<Integer> selected = new ArrayList();
    private String[] likeEarthquakes = new String[]{"Northridge", "Loma Prieta", "Next Like-Earthquake"};
    protected BoundaryTableModel[][] boundaryTableModel = new BoundaryTableModel[3][200];
    protected int[][] boundaryRowOrder = new int[3][200];
    BoundaryTable[][] boundaryTable = new BoundaryTable[3][200];
    private int rowClicked;
    JTabbedPane groupsTabbedPane;
    private ArrayList<SetUpNewHazusTab> tabList;
    private ArrayList<TableModel> tableModelList;
    private int selectedEventRow;
    private JLabel legendColor;
    private JLabel legendColor1;
    private JLabel legendColor2;
    private JLabel legendColor3;
    private JLabel legendColor4;
    private JLabel legendColor5;
    private JLabel legendColor6;
    private JLabel legendColor7;
    private JLabel legendColor8;
    private JLabel legendColor9;
    private ArrayList<JLabel> legendColorList;
    JLabel note;
    PluginActors hazusPluginActors;
    private AppendActors appendHazusActor;
    JPanel tablePanel;
    TreeNode<CheckAllTable> root;
    Map<String, Events> allEarthquakeEvents = new HashMap<String, Events>();
    MouseAdapter backClickListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            JTable target = ((JTableHeader)e.getSource()).getTable();
            JViewport vp = (JViewport)target.getParent();
            JScrollPane sp = (JScrollPane)vp.getParent();
            CheckAllTable targetTable = (CheckAllTable)sp.getParent();
            TreeNode<CheckAllTable> currentTableNode = GISHazusEventsPluginGUI.this.findTableNode(GISHazusEventsPluginGUI.this.root, targetTable);
            int col = target.columnAtPoint(e.getPoint());
            if (col == 0) {
                GISHazusEventsPluginGUI.this.tablePanel.remove(targetTable);
                ((CheckAllTable)currentTableNode.parent.data).renderTableHeader();
                GISHazusEventsPluginGUI.this.tablePanel.add((Component)currentTableNode.parent.data);
                GISHazusEventsPluginGUI.this.tablePanel.revalidate();
                GISHazusEventsPluginGUI.this.tablePanel.repaint();
            }
        }
    };
    MouseAdapter loadClickListener = new MouseAdapter(){

        /*
         * WARNING - void declaration
         */
        @Override
        public void mousePressed(MouseEvent e) {
            JTable target = (JTable)e.getSource();
            JViewport vp = (JViewport)target.getParent();
            JScrollPane sp = (JScrollPane)vp.getParent();
            CheckAllTable targetTable = (CheckAllTable)sp.getParent();
            TreeNode<CheckAllTable> currentTableNode = GISHazusEventsPluginGUI.this.findTableNode(GISHazusEventsPluginGUI.this.root, targetTable);
            int row = target.getSelectedRow();
            int col = target.columnAtPoint(e.getPoint());
            if (col != 0 && (e.getClickCount() == 2 || col == targetTable.getTable().getColumnCount() - 1)) {
                String subTableName = (String)target.getValueAt(row, 1);
                boolean foundTable = false;
                for (TreeNode<CheckAllTable> treeNode : currentTableNode) {
                    if (!((CheckAllTable)treeNode.data).getTitle().equals(subTableName)) continue;
                    GISHazusEventsPluginGUI.this.tablePanel.remove(targetTable);
                    GISHazusEventsPluginGUI.this.tablePanel.add((Component)treeNode.data);
                    ((CheckAllTable)treeNode.data).renderTableHeader();
                    foundTable = true;
                }
                if (!foundTable) {
                    void var12_17;
                    if (GISHazusEventsPluginGUI.this.polArray == null) {
                        GISHazusEventsPluginGUI.this.polArray = GISHazusEventsPluginGUI.this.bTrace.buildSelectedBoundary(GISHazusEventsPluginGUI.this.selectedEventRow);
                    } else {
                        int startIndex = GISHazusEventsPluginGUI.this.polArray.size();
                        ArrayList<FilledBoundaryCluster> arrayList = GISHazusEventsPluginGUI.this.bTrace.buildSelectedBoundary(GISHazusEventsPluginGUI.this.selectedEventRow);
                        for (int i = 0; i < arrayList.size(); ++i) {
                            GISHazusEventsPluginGUI.this.polArray.add(arrayList.get(i));
                        }
                    }
                    GISHazusEventsPluginGUI.this.allEarthquakeEvents.put(subTableName, GISHazusEventsPluginGUI.this.bTrace);
                    GISHazusEventsPluginGUI.this.numOfBoundaries = GISHazusEventsPluginGUI.this.polArray.size();
                    ArrayList<String> polArrayNames = new ArrayList<String>();
                    boolean bl = false;
                    while (var12_17 < GISHazusEventsPluginGUI.this.numOfBoundaries) {
                        GISHazusEventsPluginGUI.this.polArray.get((int)var12_17).setDisplayed(true);
                        polArrayNames.add(GISHazusEventsPluginGUI.this.polArray.get((int)var12_17).getName());
                        ++var12_17;
                    }
                    System.out.println(GISHazusEventsPluginGUI.this.polArray.get(0).getName());
                    CheckAllTable checkAllTable = new CheckAllTable(polArrayNames, subTableName, (TableModelListener)new BoundaryListener(GISHazusEventsPluginGUI.this.polArray, subTableName));
                    TreeNode<CheckAllTable> newTableNode = currentTableNode.addChild(checkAllTable);
                    checkAllTable.getTable().getTableHeader().addMouseListener(GISHazusEventsPluginGUI.this.backClickListener);
                    GISHazusEventsPluginGUI.this.tablePanel.remove(targetTable);
                    GISHazusEventsPluginGUI.this.tablePanel.add(checkAllTable);
                    checkAllTable.renderTableHeader();
                    GISHazusEventsPluginGUI.this.transparencySlider.setEnabled(true);
                }
            }
        }
    };
    MouseAdapter forwardClickListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            JTable target = (JTable)e.getSource();
            JViewport vp = (JViewport)target.getParent();
            JScrollPane sp = (JScrollPane)vp.getParent();
            CheckAllTable targetTable = (CheckAllTable)sp.getParent();
            TreeNode<CheckAllTable> currentTableNode = GISHazusEventsPluginGUI.this.findTableNode(GISHazusEventsPluginGUI.this.root, targetTable);
            int row = target.getSelectedRow();
            int col = target.columnAtPoint(e.getPoint());
            if (col != 0 && (e.getClickCount() == 2 || col == targetTable.getTable().getColumnCount() - 1)) {
                String subTableName = (String)target.getValueAt(row, 1);
                for (TreeNode<CheckAllTable> treeNode : currentTableNode) {
                    if (!((CheckAllTable)treeNode.data).getTitle().equals(subTableName)) continue;
                    GISHazusEventsPluginGUI.this.tablePanel.remove(targetTable);
                    GISHazusEventsPluginGUI.this.tablePanel.add((Component)treeNode.data);
                    ((CheckAllTable)treeNode.data).renderTableHeader();
                }
                GISHazusEventsPluginGUI.this.tablePanel.revalidate();
                GISHazusEventsPluginGUI.this.tablePanel.repaint();
            }
        }
    };

    public GISHazusEventsPluginGUI(PluginActors pluginActors) {
        this.hazusPluginActors = pluginActors;
        this.bTrace = new Events();
        this.appendHazusActor = new AppendActors();
        this.bTrace.setAppendActors(this.appendHazusActor);
        for (int i = 0; i < this.boundaryRowOrder.length; ++i) {
            for (int j = 0; j < this.boundaryRowOrder[0].length; ++j) {
                this.boundaryRowOrder[i][j] = -1;
                this.boundaryStartIndex[i][j] = -1;
                this.boundaryRowSize[i][j] = -1;
                this.boundaryGroupOrder[i][j] = -1;
            }
        }
        this.numOfBoundaries = 0;
        this.subgroupNames = this.bTrace.buildBoundaryNames();
        this.checkBoxes = new ArrayList(this.numOfBoundaries);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(Prefs.getPluginWidth(), Prefs.getPluginHeight()));
        this.tablePanel = new JPanel(new BorderLayout());
        ArrayList<String> likeEarthquakes = new ArrayList<String>();
        likeEarthquakes.add("Northridge");
        likeEarthquakes.add("Loma Prieta");
        likeEarthquakes.add("Next Like-Earthquake");
        CheckAllTable earthquakeTable = new CheckAllTable(likeEarthquakes, "Earthquakes");
        this.root = new TreeNode<CheckAllTable>(earthquakeTable);
        for (String quake : likeEarthquakes) {
            ArrayList<String> areaList = new ArrayList<String>();
            for (int i = 0; i < this.subgroupNames.size(); ++i) {
                if (quake.equalsIgnoreCase(this.bTrace.getLikeEarthquake(i))) {
                    areaList.add(this.subgroupNames.get(i));
                    continue;
                }
                if (!this.bTrace.getEventName(i).equalsIgnoreCase("Import")) continue;
                areaList.add(this.subgroupNames.get(i));
            }
            CheckAllTable areaTable = new CheckAllTable(areaList, quake);
            TreeNode<CheckAllTable> areaTableNode = this.root.addChild(areaTable);
            areaTable.getTable().getTableHeader().addMouseListener(this.backClickListener);
            areaTable.addControlColumn(this.loadClickListener, "Load", areaTableNode);
        }
        this.tablePanel.add(earthquakeTable);
        earthquakeTable.addControlColumn(this.forwardClickListener, ">", this.root);
        earthquakeTable.disableCheckboxes();
        this.groupsTabbedPane = new JTabbedPane();
        this.groupsTabbedPane.setBorder(BorderFactory.createEmptyBorder(15, 10, 10, 10));
        this.groupsTabbedPane.setPreferredSize(new Dimension(400, 240));
        this.tabList = new ArrayList();
        this.groupsTabbedPane.getSelectedIndex();
        this.tableModelList = new ArrayList();
        for (String quake : likeEarthquakes) {
            SetUpNewHazusTab newTab = new SetUpNewHazusTab();
            this.tabList.add(newTab);
            ArrayList<String> continentList = new ArrayList<String>();
            for (int i = 0; i < this.subgroupNames.size(); ++i) {
                if (quake.equalsIgnoreCase(this.bTrace.getLikeEarthquake(i))) {
                    continentList.add(this.subgroupNames.get(i));
                    continue;
                }
                if (!this.bTrace.getEventName(i).equalsIgnoreCase("Import")) continue;
                continentList.add(this.subgroupNames.get(i));
            }
            this.groupsTabbedPane.add((Component)newTab.getTab(), quake);
            this.tableModel = new BoundSectionsTableModel(continentList, this);
            this.table = new BoundSectionsTable(this, this.tableModel);
            this.table.getModel().addTableModelListener(this);
            newTab.getSubGroupPanel().add(this.table);
            this.tableModelList.add(this.tableModel);
        }
        this.add((Component)this.groupsTabbedPane, "First");
        this.gradientColor = new GradientColorChooser(this);
        Color[] purpleGradient = this.bTrace.getPurpleGradient();
        this.colorButton = new ColorWellButton(purpleGradient[0], purpleGradient[9], 74, 16);
        this.colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color[] purpleGradient = GISHazusEventsPluginGUI.this.bTrace.getPurpleGradient();
                Color[] newColor = GISHazusEventsPluginGUI.this.gradientColor.getColors(purpleGradient[0], purpleGradient[9]);
                if (newColor != null) {
                    GISHazusEventsPluginGUI.this.updateColorButton(newColor[0], newColor[1]);
                }
            }
        });
        JPanel colorHolder = new JPanel();
        colorHolder.add(new JLabel("Legend Gradient"));
        colorHolder.add(this.colorButton);
        this.add((Component)colorHolder, "South");
        this.legendButton = new JButton("Show Legend");
        this.legendButton.addActionListener(this);
        this.legendButton.setEnabled(false);
        this.legendColorList = new ArrayList();
        this.legendColorList.add(this.legendColor);
        this.legendColorList.add(this.legendColor1);
        this.legendColorList.add(this.legendColor2);
        this.legendColorList.add(this.legendColor3);
        this.legendColorList.add(this.legendColor4);
        this.legendColorList.add(this.legendColor5);
        this.legendColorList.add(this.legendColor6);
        this.legendColorList.add(this.legendColor7);
        this.legendColorList.add(this.legendColor8);
        this.legendColorList.add(this.legendColor9);
        colorHolder.add(this.legendButton);
        colorHolder.add(this.getTransparencyPanel());
    }

    private TreeNode<CheckAllTable> findTableNode(TreeNode<CheckAllTable> searchNode, final CheckAllTable targetTable) {
        Comparable<CheckAllTable> searchCriteria = new Comparable<CheckAllTable>(){

            @Override
            public int compareTo(CheckAllTable table) {
                if (table == null) {
                    return 1;
                }
                boolean nodeOk = table == targetTable;
                return nodeOk ? 0 : 1;
            }
        };
        return searchNode.findTreeNode(searchCriteria);
    }

    public void updateColorButton(Color c1, Color c2) {
        this.colorButton.setColor(c1, c2);
        Color[] newGradient = this.bTrace.setColorGradient(this.colorButton.getColor1(), this.colorButton.getColor2());
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 200; ++j) {
                this.setColor(j, newGradient, i);
            }
        }
        Info.getMainGUI();
        MainGUI.updateRenderWindow();
    }

    private JPanel getTransparencyPanel() {
        this.transparencySlider = new JSlider(0, 0, 100, 0);
        this.transparencySlider.addChangeListener(this);
        this.transparencySlider.setMajorTickSpacing(10);
        this.transparencySlider.setMinorTickSpacing(5);
        this.transparencySlider.setPaintLabels(true);
        this.transparencySlider.setPaintTicks(true);
        this.transparencySlider.setToolTipText("Set transparency level (0 = Transparent ; 100 = Opaque)");
        this.transparencySlider.setPreferredSize(new Dimension(350, 80));
        this.transparencySlider.setEnabled(false);
        this.transparencySlider.setValue(100);
        JPanel transparencyPanel = new JPanel();
        transparencyPanel.setBorder(BorderFactory.createTitledBorder("Transparency"));
        transparencyPanel.add(this.transparencySlider);
        return transparencyPanel;
    }

    private void createLowerPanel(String tabName, int row, int startIndex, int tabIndex) {
        int i;
        this.boundTabbedPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        FilledBoundaryCluster[] b = new FilledBoundaryCluster[this.numOfBoundaries - startIndex];
        for (i = startIndex; i < this.numOfBoundaries; ++i) {
            if (this.polArray.get(i) == null) {
                this.polArray.remove(i);
            }
            b[i - startIndex] = this.polArray.get(i);
        }
        this.boundaryTableModel[tabIndex][row] = new BoundaryTableModel(b);
        this.boundaryTable[tabIndex][row] = new BoundaryTable(this, this.boundaryTableModel[tabIndex][row]);
        this.boundaryTable[tabIndex][row].getModel().addTableModelListener(this);
        for (i = startIndex; i < this.numOfBoundaries; ++i) {
            JCheckBox chkBox = new JCheckBox(this.polArray.get(i).getName().replace('_', ' '));
            if (!this.checkBoxes.contains(chkBox)) {
                this.checkBoxes.add(chkBox);
                continue;
            }
            if (!this.checkBoxes.get(i).getText().equals(chkBox.getText())) continue;
            this.checkBoxes.set(i, chkBox);
        }
        System.out.println(this.checkBoxes.size());
        JPanel polLibraryPanel = new JPanel();
        polLibraryPanel.setLayout(new BoxLayout(polLibraryPanel, 1));
        polLibraryPanel.add(this.boundaryTable[tabIndex][row]);
        JScrollPane scroller = new JScrollPane(polLibraryPanel);
        scroller.setHorizontalScrollBarPolicy(31);
        scroller.setVerticalScrollBarPolicy(22);
        JScrollBar bar = scroller.getVerticalScrollBar();
        bar.setBlockIncrement(20);
        bar.setUnitIncrement(20);
        scroller.setVerticalScrollBar(bar);
        this.boundTabbedPane.add((Component)scroller, tabName);
        this.add((Component)this.boundTabbedPane, "Center");
    }

    public void unload() {
        System.out.println(this.hazusPluginActors.getActors().size());
        this.hazusPluginActors.clearActors();
        Info.getMainGUI();
        MainGUI.updateRenderWindow();
    }

    public ArrayList<TableModel> getTableModelList() {
        return this.tableModelList;
    }

    public int getNumContinents() {
        return this.tableModel.getRowCount();
    }

    public boolean isContinentSelected(int i) {
        return (Boolean)this.tableModel.getValueAt(i, 0);
    }

    public boolean isContinentLoaded(int i) {
        return (Boolean)this.tableModel.getValueAt(i, 3);
    }

    public void setContinentSelected(int i) {
        this.tableModel.setValueAt(true, i, 0);
    }

    public void setContinentLoaded(int i) {
        this.tableModel.setValueAt(true, i, 0);
        this.tableModel.setValueAt(false, i, 0);
    }

    public void predefinedSubGroup(int subgroupNum, boolean isSelected) {
        System.out.println("PredefinedSubGroup:" + subgroupNum);
        int tabIndex = this.groupsTabbedPane.getSelectedIndex();
        int index = this.boundaryRowOrder[tabIndex][subgroupNum];
        if (index != -1) {
            this.toggleSubGroup(isSelected, subgroupNum, tabIndex);
        }
    }

    public void setColor(int subgroupNum, Color color, int tabIndex) {
        int index = this.boundaryRowOrder[tabIndex][subgroupNum];
        Color color3f = color;
        if (index != -1) {
            for (int i = this.boundaryStartIndex[tabIndex][subgroupNum]; i < this.boundaryRowSize[tabIndex][this.boundaryRowOrder[tabIndex][subgroupNum]] + this.boundaryStartIndex[tabIndex][subgroupNum]; ++i) {
                this.polArray.get(i).setColor(color3f);
            }
            this.paintAll(this.getGraphics());
        }
    }

    public void setColor(int subgroupNum, Color[] color, int tabIndex) {
        int index = this.boundaryRowOrder[tabIndex][subgroupNum];
        if (index != -1) {
            for (int i = this.boundaryStartIndex[tabIndex][subgroupNum]; i < this.boundaryRowSize[tabIndex][this.boundaryRowOrder[tabIndex][subgroupNum]] + this.boundaryStartIndex[tabIndex][subgroupNum]; ++i) {
                if (this.polArray.get(i).getCategory() > color.length - 1) {
                    this.polArray.get(i).setColor(color[0]);
                    continue;
                }
                this.polArray.get(i).setColor(color[this.polArray.get(i).getCategory()]);
            }
            this.paintAll(this.getGraphics());
        }
    }

    public void setColorGradient() {
    }

    public void toggleSubGroup(boolean turnGroupOn, int subgroupNum, int tabIndex) {
        int size = this.boundaryRowSize[tabIndex][this.boundaryRowOrder[tabIndex][subgroupNum]];
        for (int i = this.boundaryStartIndex[tabIndex][subgroupNum]; i < size + this.boundaryStartIndex[tabIndex][subgroupNum]; ++i) {
            JCheckBox temp = this.checkBoxes.get(i);
            if (turnGroupOn) {
                if (temp.isSelected()) continue;
                temp.setSelected(true);
                this.refreshCheckbox(i);
                continue;
            }
            if (!temp.isSelected()) continue;
            temp.setSelected(false);
            this.refreshCheckbox(i);
        }
        this.boundTabbedPane.repaint();
        Info.getMainGUI();
        MainGUI.updateRenderWindow();
    }

    public boolean[] getBoundries() {
        boolean[] shown = new boolean[this.numOfBoundaries];
        for (int i = 0; i < this.numOfBoundaries; ++i) {
            shown[i] = this.polArray.get(i).isDisplayed();
        }
        return shown;
    }

    public int getPolSize() {
        return this.numOfBoundaries;
    }

    public String getBoundryName(int row) {
        FilledBoundaryCluster tempHighway = this.polArray.get(row);
        String hwyName = tempHighway.getName();
        return hwyName;
    }

    public ArrayList<FilledBoundaryCluster> getPolArray() {
        return this.polArray;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.rowClicked = e.getFirstRow();
        int column = e.getColumn();
        TableModel model = null;
        try {
            model = (BoundaryTableModel)e.getSource();
            BoundaryTableModel btm = (BoundaryTableModel)e.getSource();
            Object data = model.getValueAt(this.rowClicked, column);
            int tabIndex = this.groupsTabbedPane.getSelectedIndex();
            if (column == 0) {
                int i;
                int tabNumber = 0;
                for (i = 0; i < 200; ++i) {
                    if (this.boundaryTable[tabIndex][i] == null || !btm.equals(this.boundaryTable[tabIndex][i].model)) continue;
                    tabNumber = i;
                }
                for (i = 1; i < this.boundaryRowOrder[tabIndex][tabNumber]; ++i) {
                    this.rowClicked += this.boundaryRowSize[tabIndex][i - 1];
                }
                if (((Boolean)data).booleanValue()) {
                    this.checkBoxes.get(this.rowClicked).setSelected(true);
                } else {
                    this.checkBoxes.get(this.rowClicked).setSelected(false);
                }
                this.refreshCheckbox(this.rowClicked);
            }
        }
        catch (ClassCastException ex1) {
            int selectedPane = this.groupsTabbedPane.getSelectedIndex();
            String likeEarthquake = this.likeEarthquakes[selectedPane];
            ArrayList<Object> eventsLikeList = new ArrayList();
            eventsLikeList = this.bTrace.makeLikeList(likeEarthquake);
            String eventName = (String)eventsLikeList.get(this.rowClicked);
            this.selectedEventRow = this.bTrace.getIndexByEventName(eventName);
            try {
                model = this.tableModelList.get(selectedPane);
                this.btm = (BoundSectionsTableModel)e.getSource();
                Object data = model.getValueAt(this.rowClicked, column);
                if (column == 0 && ((Boolean)data).booleanValue()) {
                    if (((Boolean)this.btm.getValueAt(this.rowClicked, 3)).booleanValue()) {
                        this.transparencySlider.setEnabled(true);
                    } else {
                        System.out.println("ASDSA");
                        this.selected.add(this.selectedEventRow);
                    }
                    this.drawEvent(this.selectedEventRow, selectedPane);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.legendButton.setEnabled(true);
        this.paintAll(this.getGraphics());
    }

    public void drawEvent(int selectedEventRow, int tabIndex) {
        int startIndex = 0;
        int sizeIncrease = 0;
        int index = this.boundTabbedPane.indexOfTab(this.bTrace.getName(selectedEventRow));
        if (index != -1) {
            System.out.println(tabIndex);
            System.out.println(this.tableModelList.get(tabIndex).getValueAt(selectedEventRow, 0));
            if (((Boolean)this.tableModelList.get(tabIndex).getValueAt(selectedEventRow, 0)).booleanValue()) {
                for (int k = 0; k < this.boundaryTableModel[tabIndex][selectedEventRow].getRowCount(); ++k) {
                    if (((Boolean)this.boundaryTableModel[tabIndex][selectedEventRow].getValueAt(k, 0)).booleanValue()) {
                        this.boundaryTableModel[tabIndex][selectedEventRow].setValueAt(true, k, 0);
                        this.checkBoxes.get(this.boundaryStartIndex[tabIndex][selectedEventRow] + k).setSelected(true);
                        this.refreshCheckbox(this.boundaryStartIndex[tabIndex][selectedEventRow] + k);
                        continue;
                    }
                    this.boundaryTableModel[tabIndex][selectedEventRow].setValueAt(false, k, 0);
                    this.checkBoxes.get(this.boundaryStartIndex[tabIndex][selectedEventRow] + k).setSelected(false);
                    this.refreshCheckbox(this.boundaryStartIndex[tabIndex][selectedEventRow] + k);
                }
            }
        } else {
            if (this.polArray == null) {
                this.polArray = this.bTrace.buildSelectedBoundary(selectedEventRow);
            } else {
                startIndex = this.polArray.size();
                ArrayList<FilledBoundaryCluster> temp = this.bTrace.buildSelectedBoundary(selectedEventRow);
                for (int i = 0; i < temp.size(); ++i) {
                    this.polArray.add(temp.get(i));
                }
            }
            System.out.println(this.polArray.size());
            System.out.println(this.boundaryRowOrderCounter);
            this.transparencySlider.setEnabled(true);
            sizeIncrease = this.polArray.size() - startIndex;
            this.boundaryRowOrder[tabIndex][this.rowClicked] = this.boundaryRowOrderCounter;
            this.boundaryRowSize[tabIndex][this.boundaryRowOrderCounter] = sizeIncrease;
            this.boundaryGroupOrder[tabIndex][this.boundaryRowOrderCounter] = this.rowClicked;
            this.boundaryStartIndex[tabIndex][this.rowClicked] = startIndex;
            ++this.boundaryRowOrderCounter;
            this.numOfBoundaries = this.polArray.size();
            this.createLowerPanel(this.bTrace.getName(selectedEventRow), this.rowClicked, startIndex, tabIndex);
            this.predefinedSubGroup(this.rowClicked, true);
            this.dialogLegend = new JDialog();
            this.buttonPanel = new JPanel();
            this.legendDialog = new JPanel();
            this.buttonPanel.setSize(250, 320);
            this.dialogLegend.setSize(420, 340);
            this.dialogLegend.setLocationRelativeTo(this);
            this.legendDialog.setLayout(null);
            this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
            this.dialogLegend.setLayout(new BoxLayout(this.dialogLegend.getContentPane(), 1));
            this.save = new JButton("Save");
            this.save.addActionListener(this);
            this.info = new JButton("Info");
            this.info.addActionListener(this);
            this.buttonPanel.add(this.save);
            this.buttonPanel.add(this.info);
            System.out.println("here");
            this.hazusPluginActors.addActor((vtkProp)this.bTrace.getAppendActor().getAppendedActor());
        }
        Info.getMainGUI();
        MainGUI.updateRenderWindow();
    }

    protected void refreshCheckbox(int position) {
        this.currentBoundary = this.polArray.get(position);
        if (this.checkBoxes.get(position).isSelected()) {
            if (this.currentBoundary != null) {
                try {
                    this.polArray.get(position).setDisplayed(true);
                }
                catch (Exception e) {
                    System.out.println("Exception: " + String.valueOf(e));
                }
            } else {
                System.out.println("null boundary");
            }
        } else {
            this.polArray.get(position).setDisplayed(false);
        }
        this.currentBoundary = null;
    }

    @Override
    public void actionPerformed(ActionEvent btnEvt) {
        if (btnEvt.getSource() == this.legendButton) {
            this.legendDialog.removeAll();
            this.legendDialog.repaint();
            Color[] purpleGradient = this.bTrace.getPurpleGradient();
            ArrayList<Float> legendMaxList = this.bTrace.getLegendMax();
            this.legendDialog.updateUI();
            JLabel title = new JLabel();
            if (this.selectedEventRow == 0) {
                this.selectedEventRow = this.bTrace.getIndexByEventName(this.bTrace.eventList.get(this.bTrace.eventList.size() - 1).getEventName());
            }
            System.out.println("Selected Row" + this.selectedEventRow + "," + this.bTrace.event.getID());
            if (this.bTrace.getLegendTitle(this.selectedEventRow).equals("Direct Building Economic Loss")) {
                title.setText("Building Damage ($)");
            } else if (this.bTrace.getColumnAt(this.selectedEventRow).equalsIgnoreCase("TotalCount")) {
                title.setText("Total Buildings");
            } else {
                title.setText("Injuries & Fatalities at " + this.bTrace.getLegendTitle(this.selectedEventRow));
            }
            title.setFont(new Font("helvetica", 1, 20));
            title.setForeground(Color.WHITE);
            title.setBounds(10, 10, 250, 30);
            this.legendDialog.setBackground(Color.BLACK);
            this.legendDialog.add(title);
            int numMaxes = 0;
            for (int i = 0; i < 10; ++i) {
                if ((double)legendMaxList.get(i).floatValue() == -1.0) continue;
                ++numMaxes;
            }
            ArrayList labels = Lists.newArrayList();
            if (this.bTrace.getLegendTitle(this.selectedEventRow).equals("Direct Building Economic Loss") || this.bTrace.getLegendTitle(this.selectedEventRow).equals("Building Count")) {
                labels.add(new JLabel(" $0"));
                labels.add(new JLabel(" $360 to $286,780"));
                labels.add(new JLabel(" $286,780 to $1,015,290"));
                labels.add(new JLabel(" $1,015,290 to $2,659,870"));
                labels.add(new JLabel(" $2,659,870 to $6,415,170"));
                labels.add(new JLabel(" $6,415,170 to $13,014,440"));
                labels.add(new JLabel(" $13,014,440 to $24,217,800"));
                labels.add(new JLabel(" $24,217,800 to $45,846,980"));
                labels.add(new JLabel(" $45,846,980 to $104,812,440"));
                labels.add(new JLabel(" $104,812,440 to $3,063,048,200"));
            } else {
                labels.add(new JLabel(" < 1 Injury or Fatality"));
                labels.add(new JLabel(" 1 to 2"));
                labels.add(new JLabel(" 2 to 3"));
                labels.add(new JLabel(" 3 to 4"));
                labels.add(new JLabel(" 4 to 7"));
                labels.add(new JLabel(" 7 to 11"));
                labels.add(new JLabel(" 11 to 19"));
                labels.add(new JLabel(" 19 to 36"));
                labels.add(new JLabel(" 36 to 83"));
                labels.add(new JLabel(" 83 to 4900"));
            }
            int yPos = 45;
            int xRightExtent = 260;
            int i = labels.size();
            while (--i >= 0) {
                JLabel label = (JLabel)labels.get(i);
                label.setBackground(new Color(purpleGradient[i].getRed(), purpleGradient[i].getGreen(), purpleGradient[i].getBlue()));
                label.setForeground(Color.BLACK);
                label.setOpaque(true);
                label.setBounds(10, yPos, xRightExtent, 20);
                this.legendDialog.add(label);
                yPos += 20;
                xRightExtent -= 10;
            }
            this.bTrace.resetLegendMax();
        } else {
            this.legendColor = new JLabel(String.valueOf(this.bTrace.populationCategory.get(0)) + " to " + String.valueOf(this.bTrace.populationCategory.get(1)));
            this.legendColor1 = new JLabel(String.valueOf(this.bTrace.populationCategory.get(1)) + " to " + String.valueOf(this.bTrace.populationCategory.get(2)));
            this.legendColor2 = new JLabel(String.valueOf(this.bTrace.populationCategory.get(2)) + " to " + String.valueOf(this.bTrace.populationCategory.get(3)));
            this.legendColor3 = new JLabel(String.valueOf(this.bTrace.populationCategory.get(3)) + " to " + String.valueOf(this.bTrace.populationCategory.get(4)));
            this.legendColor4 = new JLabel(String.valueOf(this.bTrace.populationCategory.get(4)) + " to " + String.valueOf(this.bTrace.populationCategory.get(5)));
            this.legendColor5 = new JLabel(String.valueOf(this.bTrace.populationCategory.get(5)) + " to " + String.valueOf(this.bTrace.populationCategory.get(6)));
            this.legendColor6 = new JLabel(String.valueOf(this.bTrace.populationCategory.get(6)) + " to " + String.valueOf(this.bTrace.populationCategory.get(7)));
            this.legendColor7 = new JLabel(String.valueOf(this.bTrace.populationCategory.get(7)) + " to " + String.valueOf(this.bTrace.populationCategory.get(8)));
            this.legendColor8 = new JLabel(String.valueOf(this.bTrace.populationCategory.get(8)) + " to " + String.valueOf(this.bTrace.populationCategory.get(9)));
            this.legendColor9 = new JLabel(String.valueOf(this.bTrace.populationCategory.get(9)) + " to " + Events.maxPop);
        }
        this.dialogLegend.add(this.legendDialog);
        this.dialogLegend.add(this.buttonPanel);
        this.legendDialog.setVisible(true);
        this.dialogLegend.setVisible(true);
        if (btnEvt.getSource() == this.apply) {
            this.dialogLegend.dispose();
        }
        if (btnEvt.getSource() == this.save) {
            this.saveFile = new JFileChooser();
            int returnvalue = this.saveFile.showSaveDialog(this);
            if (returnvalue == 0) {
                this.file = this.saveFile.getSelectedFile();
                Object filename = this.file.toString().contains(".") ? this.file.toString() : this.file.toString() + ".PNG ";
                this.myImage = new BufferedImage(this.legendDialog.getWidth(), this.legendDialog.getHeight(), 1);
                this.g2 = this.myImage.createGraphics();
                this.legendDialog.setSize(this.legendDialog.getSize());
                this.legendDialog.paint(this.g2);
                File outputFile = new File((String)filename);
                try {
                    ImageIO.write((RenderedImage)this.myImage, "png", outputFile);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        if (btnEvt.getSource() == this.info) {
            this.createWindow();
        }
    }

    private void createWindow() {
        JFrame frame = new JFrame("Help");
        JLabel textLabel = new JLabel("<html><h1>How to add legend to the canvas</h1><br>1.Click Save button.<br>2.Open the <b>'Legend Plugin'</b> under Displays->Legends&Labels.<br>3.Click <i>ADD IMAGE</i> button.<br><br<br<br><br><br><br>Dev13 #ThoseBooleansThough", 0);
        textLabel.setPreferredSize(new Dimension(500, 300));
        frame.getContentPane().add((Component)textLabel, "Center");
        frame.setLocationRelativeTo(null);
        frame.pack();
        frame.setVisible(true);
    }

    public void setTransparency(float transparency) {
        for (int i = 0; i < this.numOfBoundaries; ++i) {
            if (!this.polArray.get(i).isDisplayed()) continue;
            for (FilledBoundary boundary : this.polArray.get(i).getBoundaries()) {
                boundary.setTransparency(transparency);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        ArrayList<FilledBoundary> boundaries = this.bTrace.getAllBoundaries();
        Object src = e.getSource();
        if (src == this.transparencySlider) {
            float transparency = (float)this.transparencySlider.getValue() / 100.0f;
            System.out.println("transparency: " + transparency);
            this.setTransparency(transparency);
        }
    }

    public JSlider getTransparencySlider() {
        return this.transparencySlider;
    }

    public class MyChangeAction
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent ce) {
            boolean value = false;
            ArrayList<FilledBoundary> boundaries = GISHazusEventsPluginGUI.this.bTrace.getAllBoundaries();
            for (FilledBoundary boundary : boundaries) {
                boundary.setLineApperance(GISHazusEventsPluginGUI.this.bTrace.getAllBoundaries().get(0).getColor(), (float)value);
            }
        }
    }

    class BoundaryListener
    implements TableModelListener {
        private ArrayList<FilledBoundaryCluster> boundaryArray;
        private String tableName;

        public BoundaryListener(ArrayList<FilledBoundaryCluster> boundaryArray, String tableName) {
            this.boundaryArray = boundaryArray;
            this.tableName = tableName;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            int row = e.getFirstRow();
            int column = e.getColumn();
            if (column == 0) {
                TableModel model = (TableModel)e.getSource();
                String boundaryName = (String)model.getValueAt(row, column + 1);
                Boolean checked = (Boolean)model.getValueAt(row, column);
                for (int k = 0; k < this.boundaryArray.size(); ++k) {
                    if (!this.boundaryArray.get(k).getName().equals(boundaryName)) continue;
                    System.out.println(this.tableName);
                    if (checked.booleanValue()) {
                        GISHazusEventsPluginGUI.this.hazusPluginActors.addActor((vtkProp)GISHazusEventsPluginGUI.this.allEarthquakeEvents.get(this.tableName).getSegmentActors().get(k));
                        continue;
                    }
                    GISHazusEventsPluginGUI.this.hazusPluginActors.removeActor((vtkProp)GISHazusEventsPluginGUI.this.allEarthquakeEvents.get(this.tableName).getSegmentActors().get(k));
                }
            }
            Info.getMainGUI();
            MainGUI.updateRenderWindow();
        }
    }
}

