/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.GISHazusEventsPlugin;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.table.TableModel;
import org.dom4j.Element;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.GISHazusEventsPlugin.BoundaryTableModel;
import org.scec.vtk.plugins.GISHazusEventsPlugin.EventAttributes;
import org.scec.vtk.plugins.GISHazusEventsPlugin.FilledBoundaryCluster;
import org.scec.vtk.plugins.GISHazusEventsPlugin.GISHazusEventsPluginGUI;
import org.scec.vtk.plugins.PluginState;
import org.scec.vtk.tools.actors.AppendActors;

public class GISHazusEventsPluginState
implements PluginState {
    private GISHazusEventsPluginGUI parent;
    private float transparency;
    private Color[] gradient;
    private boolean import1;
    private boolean import2;
    private boolean import3;
    private boolean import4;
    private FilledBoundaryCluster currentBoundary;
    private ArrayList<Float> populationCategory;
    private File ralph;
    private EventAttributes event;
    private int numLines = 0;
    private int numFiles = 0;
    String sImportedFilePath;
    String sImportedFilePath1;
    String sImportedFilePath2;
    String sImportedFilePath3;
    String sImportedFilePath4;
    private int groupCount = 0;
    private int numBounds = 0;
    public String[] names;
    public int[] groupSize;
    private ArrayList<FilledBoundaryCluster> allBounds;
    private AppendActors segmentActors;
    private ArrayList<Integer> selected;
    private ArrayList<TableModel> tableModelList;
    private BoundaryTableModel[][] boundaryTableModel;
    private BoundaryTableModel[][] boundaryTableModelOld;

    GISHazusEventsPluginState(GISHazusEventsPluginGUI parent) {
        this.parent = parent;
        this.transparency = 0.0f;
        this.gradient = new Color[2];
        this.boundaryTableModel = new BoundaryTableModel[3][200];
        this.boundaryTableModelOld = new BoundaryTableModel[3][200];
        this.selected = new ArrayList();
        this.tableModelList = new ArrayList();
        this.segmentActors = new AppendActors();
        this.currentBoundary = new FilledBoundaryCluster(this.segmentActors);
        this.populationCategory = new ArrayList();
        this.allBounds = new ArrayList();
    }

    public void copyDetails() {
        this.selected.clear();
        this.boundaryTableModel = new BoundaryTableModel[3][200];
        this.transparency = (float)this.parent.getTransparencySlider().getValue() / 100.0f;
        this.gradient[0] = this.parent.colorButton.getColor1();
        this.gradient[1] = this.parent.colorButton.getColor2();
        this.import1 = this.parent.bTrace.bIsImport;
        this.import2 = this.parent.bTrace.bIsImport1;
        this.import3 = this.parent.bTrace.bIsImport2;
        this.import4 = this.parent.bTrace.bIsImport3;
        this.boundaryTableModel = this.parent.boundaryTableModel;
        this.tableModelList = this.parent.getTableModelList();
        this.populationCategory = this.parent.bTrace.populationCategory;
        this.ralph = this.parent.bTrace.ralph;
        this.event = this.parent.bTrace.event;
        this.numLines = this.parent.bTrace.numLines;
        this.numFiles = this.parent.bTrace.numFiles;
        this.sImportedFilePath = this.parent.bTrace.sImportedFilePath;
        this.sImportedFilePath1 = this.parent.bTrace.sImportedFilePath1;
        this.sImportedFilePath2 = this.parent.bTrace.sImportedFilePath2;
        this.sImportedFilePath3 = this.parent.bTrace.sImportedFilePath3;
        this.sImportedFilePath4 = this.parent.bTrace.sImportedFilePath4;
        this.groupCount = this.parent.bTrace.groupCount;
        this.numBounds = this.parent.bTrace.numBounds;
        this.names = this.parent.bTrace.names;
        this.groupSize = this.parent.bTrace.groupSize;
        this.allBounds = this.parent.bTrace.allBounds;
        this.segmentActors = this.parent.bTrace.segmentActors;
        this.selected = this.parent.selected;
    }

    @Override
    public void load() {
        this.parent.bTrace.bIsImport = this.import1;
        this.parent.bTrace.bIsImport1 = this.import2;
        this.parent.bTrace.bIsImport2 = this.import3;
        this.parent.bTrace.bIsImport3 = this.import4;
        this.parent.bTrace.numLines = this.numLines;
        this.parent.bTrace.numFiles = this.numFiles;
        this.parent.bTrace.sImportedFilePath = this.sImportedFilePath;
        this.parent.bTrace.sImportedFilePath1 = this.sImportedFilePath1;
        this.parent.bTrace.sImportedFilePath2 = this.sImportedFilePath2;
        this.parent.bTrace.sImportedFilePath3 = this.sImportedFilePath3;
        this.parent.bTrace.sImportedFilePath4 = this.sImportedFilePath4;
        this.parent.boundaryTableModel = this.boundaryTableModel;
        for (int i = 0; i < this.boundaryTableModel.length; ++i) {
            for (int j = 0; j < this.boundaryTableModel[i].length; ++j) {
                if (this.boundaryTableModel[i][j] == null) continue;
                this.parent.groupsTabbedPane.setSelectedIndex(i);
                this.parent.getTableModelList().get(i).setValueAt(true, j, 0);
                if (this.boundaryTableModelOld[i][j] != null) {
                    this.parent.boundaryTableModel = this.boundaryTableModelOld;
                }
                this.parent.drawEvent(j, i);
            }
        }
        this.parent.setTransparency(this.transparency);
        this.parent.updateColorButton(this.gradient[0], this.gradient[1]);
        Info.getMainGUI();
        MainGUI.updateRenderWindow();
    }

    private void createElement(Element stateEl) {
        Element propertyEl = stateEl.addElement("HAZUS");
        propertyEl.addElement("color1").addText("" + this.gradient[0].getRGB());
        propertyEl.addElement("color2").addText("" + this.gradient[1].getRGB());
        propertyEl.addElement("transparency").addText("" + this.transparency);
        propertyEl.addElement("numLines").addText("" + this.numLines);
        propertyEl.addElement("numFiles").addText("" + this.numFiles);
        propertyEl.addElement("GroupTabs").addText("" + this.parent.groupsTabbedPane.getTabCount());
        for (int i = 0; i < this.boundaryTableModel.length; ++i) {
            Element tabEl = propertyEl.addElement("Tab").addText("" + i);
            for (int j = 0; j < this.boundaryTableModel[i].length; ++j) {
                Element boundsEl = tabEl.addElement("Bounds");
                if (this.boundaryTableModel[i][j] == null) continue;
                boundsEl.addElement("SubBoundSize").addText(Integer.toString(this.boundaryTableModel[i][j].getRowCount()));
                for (int k = 0; k < this.boundaryTableModel[i][j].getRowCount(); ++k) {
                    Element subBoundsEl = boundsEl.addElement("SubBounds");
                    subBoundsEl.addElement("Name").addText(this.boundaryTableModel[i][j].getValueAt(k, 2).toString());
                    subBoundsEl.addElement("IsDisplayed").addText(this.boundaryTableModel[i][j].getValueAt(k, 0).toString());
                    subBoundsEl.addElement("Color").addText(Integer.toString(((Color)this.boundaryTableModel[i][j].getValueAt(k, 1)).getRGB()));
                }
            }
        }
    }

    @Override
    public void toXML(Element stateEl) {
        this.copyDetails();
        this.createElement(stateEl);
    }

    @Override
    public void fromXML(Element stateEl) {
        int cti = 0;
        int ctj = 0;
        int ctk = 0;
        Iterator i = stateEl.elementIterator("HAZUS");
        while (i.hasNext()) {
            Element e = (Element)i.next();
            cti = 0;
            this.transparency = Float.parseFloat(e.elementText("transparency"));
            this.gradient[0] = Color.decode(e.elementText("color1"));
            this.gradient[1] = Color.decode(e.elementText("color2"));
            this.numFiles = Integer.parseInt(e.elementText("numFiles"));
            this.numLines = Integer.parseInt(e.elementText("numLines"));
            Iterator j = e.elementIterator("Tab");
            while (j.hasNext()) {
                Element eTab = (Element)j.next();
                ctj = 0;
                Iterator k = eTab.elementIterator("Bounds");
                while (k.hasNext()) {
                    Element eBounds = (Element)k.next();
                    if (eBounds.element("SubBoundSize") != null) {
                        int subBoundSize = Integer.parseInt(eBounds.element("SubBoundSize").getText());
                        FilledBoundaryCluster[] b = new FilledBoundaryCluster[subBoundSize];
                        ctk = 0;
                        Iterator l = eBounds.elementIterator("SubBounds");
                        while (l.hasNext()) {
                            Element eSubBounds = (Element)l.next();
                            b[ctk] = new FilledBoundaryCluster();
                            b[ctk].setName(eSubBounds.element("Name").getText());
                            b[ctk].setDisplayed(Boolean.parseBoolean(eSubBounds.element("IsDisplayed").getText()));
                            b[ctk].setColor(Color.decode(eSubBounds.element("Color").getText()));
                            ++ctk;
                        }
                        this.boundaryTableModel[cti][ctj] = new BoundaryTableModel(b);
                        this.boundaryTableModelOld[cti][ctj] = new BoundaryTableModel(b);
                        this.selected.add(ctj);
                    }
                    ++ctj;
                }
                ++cti;
            }
        }
    }

    @Override
    public PluginState deepCopy() {
        GISHazusEventsPluginState state = new GISHazusEventsPluginState(this.parent);
        state.copyDetails();
        return state;
    }
}

